/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateWithBoundDispatchReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateWithBoundDispatchReceiverImpl;
import org.jetbrains.kotlin.resolve.calls.tower.ErrorDescriptorDiagnostic;
import org.jetbrains.kotlin.resolve.calls.tower.ResolutionDiagnostic;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.SynthesizedDescriptorDiagnostic;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;
import org.jetbrains.kotlin.resolve.calls.tower.UsedSmartCastForDispatchReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.VisibilityError;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\"\u0002\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001A\u0001\u0005\u0007\u00013\u0005A\n!)\u0004\n\u0007!\tQ\"\u0001M\u0002#\u000e\t\u0001BAS$\t\tAY!\u0004\u0003\n\u0005%\tAU\u0002\r\u0007#\u0011!\u0001\u0001#\u0004\u0016\u0003a9\u0011d\u0001E\b\u001b\u0005!k!\u0007\u0003\t\u00115\u0011A\u0012\u0001M\t3\u0015!\u0011\u0001C\u0005\u000e\u00051\u0005\u00014C\r\u0006\t\u0005A!\"\u0004\u0002\r\u0002aU\u0011kA\u0001\t\u0017%RAA\u0011\u0005\t\u00065\t\u0001d\u0001\u000f##\u000e\u0019QB\u0001C\u0004\u0011\u0011I#\u0002\u0002\"\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\n!)\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/tower/AbstractScopeTowerLevel;", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerLevel;", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTower;", "(Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTower;)V", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getLocation", "()Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getScopeTower", "()Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTower;", "createCandidateDescriptor", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "descriptor", "dispatchReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "specialError", "Lorg/jetbrains/kotlin/resolve/calls/tower/ResolutionDiagnostic;", "dispatchReceiverSmartCastType", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;Lorg/jetbrains/kotlin/resolve/calls/tower/ResolutionDiagnostic;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;"}, moduleName="kotlin-compiler")
public abstract class AbstractScopeTowerLevel
implements ScopeTowerLevel {
    @NotNull
    private final ScopeTower scopeTower;

    @NotNull
    protected final LookupLocation getLocation() {
        return this.scopeTower.getLocation();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final <D extends CallableDescriptor> CandidateWithBoundDispatchReceiver<D> createCandidateDescriptor(@NotNull D descriptor2, @Nullable ReceiverValue dispatchReceiver, @Nullable ResolutionDiagnostic specialError, @Nullable KotlinType dispatchReceiverSmartCastType) {
        Boolean bl;
        ReceiverValue receiverValue;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        SmartList<ResolutionDiagnostic> diagnostics = new SmartList<ResolutionDiagnostic>();
        CollectionsKt.addIfNotNull((Collection)diagnostics, specialError);
        if (ErrorUtils.isError(descriptor2)) {
            diagnostics.add(ErrorDescriptorDiagnostic.INSTANCE);
        }
        if (TowerUtilsKt.isSynthesized(descriptor2)) {
            diagnostics.add(SynthesizedDescriptorDiagnostic.INSTANCE);
        }
        if (dispatchReceiverSmartCastType != null) {
            diagnostics.add(new UsedSmartCastForDispatchReceiver(dispatchReceiverSmartCastType));
        }
        if ((receiverValue = dispatchReceiver) == null) {
            receiverValue = ReceiverValue.NO_RECEIVER;
        }
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = Visibilities.findInvisibleMember(receiverValue, descriptor2, this.scopeTower.getLexicalScope().getOwnerDescriptor());
        if (declarationDescriptorWithVisibility != null) {
            void $receiver;
            DeclarationDescriptorWithVisibility it2;
            DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility2 = declarationDescriptorWithVisibility;
            DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility3 = it2 = (DeclarationDescriptorWithVisibility)$receiver;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptorWithVisibility3, "it");
            bl = diagnostics.add(new VisibilityError(declarationDescriptorWithVisibility3));
        } else {
            bl = null;
        }
        return new CandidateWithBoundDispatchReceiverImpl<D>(dispatchReceiver, descriptor2, (List<? extends ResolutionDiagnostic>)diagnostics);
    }

    @NotNull
    protected static /* bridge */ /* synthetic */ CandidateWithBoundDispatchReceiver createCandidateDescriptor$default(AbstractScopeTowerLevel abstractScopeTowerLevel, CallableDescriptor callableDescriptor, ReceiverValue receiverValue, ResolutionDiagnostic resolutionDiagnostic, KotlinType kotlinType, int n) {
        if ((n & 4) != 0) {
            resolutionDiagnostic = null;
        }
        if ((n & 8) != 0) {
            kotlinType = null;
        }
        return abstractScopeTowerLevel.createCandidateDescriptor(callableDescriptor, receiverValue, resolutionDiagnostic, kotlinType);
    }

    @NotNull
    protected final ScopeTower getScopeTower() {
        return this.scopeTower;
    }

    public AbstractScopeTowerLevel(@NotNull ScopeTower scopeTower) {
        Intrinsics.checkParameterIsNotNull(scopeTower, "scopeTower");
        this.scopeTower = scopeTower;
    }
}

