/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassifierQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.PackageQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ2\u0006\u0005\u0001\u001b\u0005A\n!G\u0002\t\u00035\t\u00014A\r\u0005\u0011\ti!\u0001$\u0001\u0019\u0002e\u0019\u0001RA\u0007\u00021\rI2\u0001c\u0002\u000e\u0003a!Ak!\u0003\u000e\"!)Q\"\u0001M\u00013\rA\u0011!D\u0001\u0019\u0004e\u0019\u0001RA\u0007\u00021\rI2\u0001c\u0002\u000e\u0003a!Ak!\u0003\u000e.\u0011\t\u00012B\u0007\u00021\u0003I2\u0001C\u0001\u000e\u0003a\r\u0011\u0004\u0002\u0005\u0003\u001b\ta\t\u0001'\u0001\u001a\u0007!\u0015Q\"\u0001\r\u00043\rA9!D\u0001\u0019\tQ\u001bI\u0001"}, strings={"resolveQualifierAsReceiverInExpression", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "qualifier", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "selector", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "symbolUsageValidator", "Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;", "QualifiedExpressionResolveUtilKt", "resolveQualifierAsStandaloneExpression", "resolveQualifierReferenceTarget"}, moduleName="kotlin-compiler")
public final class QualifiedExpressionResolveUtilKt {
    @NotNull
    public static final DeclarationDescriptor resolveQualifierAsReceiverInExpression(@NotNull Qualifier qualifier2, @Nullable DeclarationDescriptor selector, @NotNull ExpressionTypingContext context, @NotNull SymbolUsageValidator symbolUsageValidator) {
        Intrinsics.checkParameterIsNotNull(qualifier2, "qualifier");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(symbolUsageValidator, "symbolUsageValidator");
        DeclarationDescriptor referenceTarget = QualifiedExpressionResolveUtilKt.resolveQualifierReferenceTarget(qualifier2, selector, context, symbolUsageValidator);
        if (referenceTarget instanceof TypeParameterDescriptor) {
            context.trace.report(Errors.TYPE_PARAMETER_ON_LHS_OF_DOT.on((KtSimpleNameExpression)((PsiElement)qualifier2.getReferenceExpression()), (TypeParameterDescriptor)referenceTarget));
        }
        return referenceTarget;
    }

    @NotNull
    public static final DeclarationDescriptor resolveQualifierAsStandaloneExpression(@NotNull Qualifier qualifier2, @NotNull ExpressionTypingContext context, @NotNull SymbolUsageValidator symbolUsageValidator) {
        DeclarationDescriptor referenceTarget;
        Intrinsics.checkParameterIsNotNull(qualifier2, "qualifier");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(symbolUsageValidator, "symbolUsageValidator");
        DeclarationDescriptor declarationDescriptor = referenceTarget = QualifiedExpressionResolveUtilKt.resolveQualifierReferenceTarget(qualifier2, null, context, symbolUsageValidator);
        if (declarationDescriptor instanceof TypeParameterDescriptor) {
            context.trace.report(Errors.TYPE_PARAMETER_IS_NOT_AN_EXPRESSION.on((KtSimpleNameExpression)((PsiElement)qualifier2.getReferenceExpression()), (TypeParameterDescriptor)referenceTarget));
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            if (!((ClassDescriptor)referenceTarget).getKind().isSingleton()) {
                context.trace.report(Errors.NO_COMPANION_OBJECT.on((KtSimpleNameExpression)((PsiElement)qualifier2.getReferenceExpression()), (ClassifierDescriptor)referenceTarget));
            }
        } else if (declarationDescriptor instanceof PackageViewDescriptor) {
            context.trace.report(Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND.on((KtSimpleNameExpression)((PsiElement)qualifier2.getReferenceExpression())));
        }
        return referenceTarget;
    }

    private static final DeclarationDescriptor resolveQualifierReferenceTarget(Qualifier qualifier2, DeclarationDescriptor selector, ExpressionTypingContext context, SymbolUsageValidator symbolUsageValidator) {
        DeclarationDescriptor selectorContainer;
        DeclarationDescriptor declarationDescriptor;
        if (qualifier2 instanceof ClassifierQualifier && ((ClassifierQualifier)qualifier2).getClassifier() instanceof TypeParameterDescriptor) {
            return ((ClassifierQualifier)qualifier2).getClassifier();
        }
        DeclarationDescriptor declarationDescriptor2 = selector;
        if (declarationDescriptor2 instanceof ConstructorDescriptor) {
            declarationDescriptor = ((ConstructorDescriptor)selector).getContainingDeclaration().getContainingDeclaration();
        } else {
            DeclarationDescriptor declarationDescriptor3 = selector;
            declarationDescriptor = selectorContainer = declarationDescriptor3 != null ? declarationDescriptor3.getContainingDeclaration() : null;
        }
        if (qualifier2 instanceof PackageQualifier && (selectorContainer instanceof PackageFragmentDescriptor || selectorContainer instanceof PackageViewDescriptor) && Intrinsics.areEqual(DescriptorUtils.getFqName(((PackageQualifier)qualifier2).getPackageView()), DescriptorUtils.getFqName(selectorContainer))) {
            return ((PackageQualifier)qualifier2).getPackageView();
        }
        if (qualifier2 instanceof ClassQualifier) {
            ClassDescriptor classifier2 = ((ClassQualifier)qualifier2).getClassifier();
            boolean selectorIsCallable = selector instanceof CallableDescriptor && (((CallableDescriptor)selector).getDispatchReceiverParameter() != null || ((CallableDescriptor)selector).getExtensionReceiverParameter() != null);
            ClassDescriptor classValueDescriptor = DescriptorUtilsKt.getClassValueDescriptor(classifier2);
            if (selectorIsCallable && classValueDescriptor != null) {
                ClassDescriptor classDescriptor = DescriptorUtilsKt.getClassValueTypeDescriptor(classifier2);
                if (classDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                ClassDescriptor classValueTypeDescriptor = classDescriptor;
                context.trace.record(BindingContext.REFERENCE_TARGET, ((ClassQualifier)qualifier2).getReferenceExpression(), classValueDescriptor);
                context.trace.recordType(((ClassQualifier)qualifier2).getExpression(), classValueTypeDescriptor.getDefaultType());
                if (DescriptorUtilsKt.getHasCompanionObject(classifier2)) {
                    context.trace.record(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, ((ClassQualifier)qualifier2).getReferenceExpression(), classifier2);
                    ClassifierDescriptor classifierDescriptor = classValueDescriptor;
                    BindingTrace bindingTrace = context.trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
                    symbolUsageValidator.validateTypeUsage(classifierDescriptor, bindingTrace, ((ClassQualifier)qualifier2).getReferenceExpression());
                }
                return classValueTypeDescriptor;
            }
        }
        return qualifier2.getDescriptor();
    }
}

