/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsSwitchMember;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsVisitor;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.util.AstUtil;

public class JsSwitch
extends SourceInfoAwareJsNode
implements JsStatement {
    private final List<JsSwitchMember> cases;
    private JsExpression expression;

    public JsSwitch() {
        this.cases = new ArrayList<JsSwitchMember>();
    }

    public JsSwitch(JsExpression expression, List<JsSwitchMember> cases) {
        this.expression = expression;
        this.cases = cases;
    }

    public List<JsSwitchMember> getCases() {
        return this.cases;
    }

    public JsExpression getExpression() {
        return this.expression;
    }

    public void setExpression(JsExpression expression) {
        this.expression = expression;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visit(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.expression);
        visitor2.acceptWithInsertRemove(this.cases);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.expression = v.accept(this.expression);
            v.acceptList(this.cases);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsSwitch deepCopy() {
        JsExpression expressionCopy = AstUtil.deepCopy(this.expression);
        List<JsSwitchMember> casesCopy = AstUtil.deepCopy(this.cases);
        JsSwitch jsSwitch = new JsSwitch(expressionCopy, casesCopy).withMetadataFrom(this);
        if (jsSwitch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsSwitch", "deepCopy"));
        }
        return jsSwitch;
    }
}

