/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.VariableAccessInfo;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"G\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!1!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u0001bB\u0003\u0001\u000b\u0005AY!B\u0001\u0005\u00065=\u00022C\u0007\u00021))\u0012\u0001'\u0006\u001a\n!\u0001Q\"\u0001M\u0001!\u000e\u0005\u0011T\u0003\u0005\f\u001b\u001dI!!C\u0001\u0019\u0002%\u0011\u0011\"\u0001\r\u000b1/\u00016!\u0001+\u0004\u00065a\u0001\u0002D\u0007\u00021))\u0012\u0001'\u0004\u001a\n!eQ\"\u0001\r\u000b!\u000e\u0005Ak!\u0002\u000e\u000e!iQ\"\u0001M\u000e+\u0005Aj\u0001VB\u0003\u001b\u001bAa\"D\u0001\u0019\u001eU\t\u0001\u0004\u0002+\u0004\u000655\u0001bD\u0007\u00021;)\u0012\u0001G\u0001U\u0007\u000bii\u0001c\b\u000e\u0003auQ#\u0001M\u0007)\u000e\u0015QR\u0002\u0005\u0011\u001b\u0005Aj\"F\u0001\u0019\u0003Q\u001b)!$\u0004\t\"5\t\u0001TD\u000b\u00021\u0005!6QAG\u0007\u0011Ei\u0011\u0001'\b\u0016\u0003a\tAk!\u0002\u0012\u001c\u0011\u0019\u0005\u0002\u0003\u0001\u000e\u0003a\u0005Q#\u0001\r\u00029\r\n6aA\u0007\u0003\t\u0007A!\u0001VB\u0003#7!1\t\u0003\u0005\u0004\u001b\u0005A:!F\u0001\u0019\tq\u0019\u0013kA\u0002\u000e\u0005\u0011%\u0001\"\u0002+\u0004\u0006EmAa\u0011\u0005\t\f5\t\u0001DB\u000b\u00021\u001ba2%U\u0002\u0004\u001b\t!q\u0001c\u0004U\u0007\u000b\tZ\u0002B\"\t\u0011!i\u0011\u0001g\u0002\u0016\u0003a5AdI)\u0004\u00075\u0011A\u0011\u0003\u0005\n)\u000e\u0015\u0001"}, strings={"callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;", "getCallableDescriptor", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;)Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "CallInfoExtensionsKt", "functionName", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;", "getFunctionName", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;)Lcom/google/dart/compiler/backend/js/ast/JsName;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/VariableAccessInfo;", "getVariableDescriptor", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/VariableAccessInfo;)Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "variableName", "getVariableName", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/VariableAccessInfo;)Lcom/google/dart/compiler/backend/js/ast/JsName;", "aliasOrValue", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "value", "Lkotlin/Function1;", "constructAccessExpression", "ref", "getAccessFunctionName", "", "hasSpreadOperator", "", "isExtension", "isGetAccess", "isMemberCall", "isNative", "isSuperInvocation"}, moduleName="kotlin-compiler")
public final class CallInfoExtensionsKt {
    @NotNull
    public static final CallableDescriptor getCallableDescriptor(CallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        CallableDescriptor callableDescriptor = $receiver.getResolvedCall().getResultingDescriptor().getOriginal();
        Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "resolvedCall.getResultin\u2026escriptor().getOriginal()");
        return callableDescriptor;
    }

    public static final boolean isExtension(CallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getExtensionReceiver() != null;
    }

    public static final boolean isMemberCall(CallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getDispatchReceiver() != null;
    }

    public static final boolean isNative(CallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return AnnotationsUtils.isNativeObject(CallInfoExtensionsKt.getCallableDescriptor($receiver));
    }

    public static final boolean isSuperInvocation(CallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ReceiverValue dispatchReceiver = $receiver.getResolvedCall().getDispatchReceiver();
        return dispatchReceiver instanceof ExpressionReceiver && ((ExpressionReceiver)dispatchReceiver).getExpression() instanceof KtSuperExpression;
    }

    @NotNull
    public static final VariableDescriptor getVariableDescriptor(VariableAccessInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        CallableDescriptor callableDescriptor = CallInfoExtensionsKt.getCallableDescriptor($receiver);
        if (callableDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptor");
        }
        return (VariableDescriptor)callableDescriptor;
    }

    @NotNull
    public static final JsName getVariableName(VariableAccessInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        JsName jsName = $receiver.getContext().getNameForDescriptor(CallInfoExtensionsKt.getVariableDescriptor($receiver));
        Intrinsics.checkExpressionValueIsNotNull(jsName, "context.getNameForDescriptor(variableDescriptor)");
        return jsName;
    }

    public static final boolean isGetAccess(VariableAccessInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getValue() == null;
    }

    @NotNull
    public static final String getAccessFunctionName(VariableAccessInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        VariableDescriptor descriptor2 = CallInfoExtensionsKt.getVariableDescriptor($receiver);
        if (descriptor2 instanceof PropertyDescriptor && DescriptorUtilsKt.isExtension(descriptor2)) {
            PropertyAccessorDescriptor propertyAccessorDescriptor = CallInfoExtensionsKt.isGetAccess($receiver) ? (PropertyAccessorDescriptor)((PropertyDescriptor)descriptor2).getGetter() : (PropertyAccessorDescriptor)((PropertyDescriptor)descriptor2).getSetter();
            TranslationContext translationContext = $receiver.getContext();
            PropertyAccessorDescriptor propertyAccessorDescriptor2 = propertyAccessorDescriptor;
            if (propertyAccessorDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            String string = translationContext.getNameForDescriptor(propertyAccessorDescriptor2).getIdent();
            Intrinsics.checkExpressionValueIsNotNull(string, "context.getNameForDescri\u2026rDescriptor!!).getIdent()");
            return string;
        }
        String string = Namer.getNameForAccessor(CallInfoExtensionsKt.getVariableName($receiver).getIdent(), CallInfoExtensionsKt.isGetAccess($receiver), false);
        Intrinsics.checkExpressionValueIsNotNull(string, "Namer.getNameForAccessor\u2026(), isGetAccess(), false)");
        return string;
    }

    @NotNull
    public static final JsExpression constructAccessExpression(VariableAccessInfo $receiver, @NotNull JsExpression ref) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(ref, "ref");
        if (CallInfoExtensionsKt.isGetAccess($receiver)) {
            return ref;
        }
        JsExpression jsExpression = $receiver.getValue();
        if (jsExpression == null) {
            Intrinsics.throwNpe();
        }
        JsExpression jsExpression2 = JsAstUtils.assignment(ref, jsExpression);
        Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "JsAstUtils.assignment(ref, value!!)");
        return jsExpression2;
    }

    @NotNull
    public static final JsName getFunctionName(FunctionCallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        JsName jsName = $receiver.getContext().getNameForDescriptor(CallInfoExtensionsKt.getCallableDescriptor($receiver));
        Intrinsics.checkExpressionValueIsNotNull(jsName, "context.getNameForDescriptor(callableDescriptor)");
        return jsName;
    }

    public static final boolean hasSpreadOperator(FunctionCallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getArgumentsInfo().getHasSpreadOperator();
    }

    @NotNull
    public static final JsExpression aliasOrValue(TranslationContext $receiver, @NotNull CallableDescriptor callableDescriptor, @NotNull Function1<? super CallableDescriptor, ? extends JsExpression> value) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(callableDescriptor, "callableDescriptor");
        Intrinsics.checkParameterIsNotNull(value, "value");
        JsExpression alias = $receiver.getAliasForDescriptor(callableDescriptor);
        if (alias != null) {
            return alias;
        }
        return value.invoke(callableDescriptor);
    }
}

