/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.context;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsVars;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"Q\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u00012B\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\u000f\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0005!!\u0001\u0004\u0001\u001a\u0003a\u0005\u00115D\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001\n\r!\u0011Q\u0002B\u0005\u0003\u0013\u0005A2\u0001'\u0002R\u0007\u0005A9!J\u0004\t\u00125\t\u0001$C\r\u0004\u0011'i\u0011\u0001G\u0005&\u000f!QQ\"\u0001M\b3\rA)\"D\u0001\u0019\u0010\u0015:\u0001BC\u0007\u00021\u001fI2\u0001#\u0006\u000e\u0003aYQ%\u0004E\f\u001b\u0005AB\"G\u0002\t\u001a5\t\u0001tB\r\u0006\t\u0005AQ\"\u0004\u0002\r\u0002aAQe\u0003E\u000e\u001b\u0005AB\"G\u0002\t\u001a5\t\u0001tB\r\u0004\u00119i\u0011\u0001\u0007\u0005*\u000f\u0011\tE\u0004\u0003\u0003\u000e\u0003a%\u0011kA\u0001\u0006\u0001%RA!\u0011\u0005\t\u000b5!\u0011BA\u0005\u00021\u0019AZ!U\u0002\u0002\u000b\u0001IS\u0002B!\t\u0011\u001biq!\u0003\u0002\n\u0003a=\u0011BA\u0005\u00021!Ar!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005)\u0001!\u000b\u0006\u0005\u0003\"A!!\u0004\u0003\n\u0005%\t\u0001d\u0001M\u0003#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "", "scope", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope;", "statementContext", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsContext;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;", "(Lcom/google/dart/compiler/backend/js/ast/JsScope;Lcom/google/dart/compiler/backend/js/ast/JsContext;)V", "addedDeclarations", "", "declarations", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsVars;", "renamings", "Ljava/util/IdentityHashMap;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "applyRenameTo", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNode;", "target", "getFreshName", "candidate", "", "newVar", "", "name", "value", "replaceName", "replacement"}, moduleName="kotlin-compiler")
public final class NamingContext {
    private final IdentityHashMap<JsName, JsExpression> renamings;
    private final ArrayList<JsVars> declarations;
    private boolean addedDeclarations;
    private final JsScope scope;
    private final JsContext<JsStatement> statementContext;

    @NotNull
    public final JsNode applyRenameTo(@NotNull JsNode target) {
        Intrinsics.checkParameterIsNotNull(target, "target");
        if (!this.addedDeclarations) {
            this.statementContext.addPrevious((List)this.declarations);
            this.addedDeclarations = true;
        }
        return RewriteUtilsKt.replaceNames(target, this.renamings);
    }

    public final void replaceName(@NotNull JsName name, @NotNull JsExpression replacement) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(replacement, "replacement");
        boolean value = !this.renamings.containsKey(name);
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value) {
                String message = name + " has been renamed already";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        this.renamings.put(name, replacement);
    }

    @NotNull
    public final JsName getFreshName(@NotNull String candidate) {
        Intrinsics.checkParameterIsNotNull(candidate, "candidate");
        JsName jsName = this.scope.declareFreshName(candidate);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "scope.declareFreshName(candidate)");
        return jsName;
    }

    @NotNull
    public final JsName getFreshName(@NotNull JsName candidate) {
        Intrinsics.checkParameterIsNotNull(candidate, "candidate");
        String string = candidate.getIdent();
        Intrinsics.checkExpressionValueIsNotNull(string, "candidate.getIdent()");
        return this.getFreshName(string);
    }

    public final void newVar(@NotNull JsName name, @Nullable JsExpression value) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        JsVars vars = JsAstUtils.newVar(name, value);
        this.declarations.add(vars);
    }

    public static /* bridge */ /* synthetic */ void newVar$default(NamingContext namingContext, JsName jsName, JsExpression jsExpression, int n) {
        if ((n & 2) != 0) {
            jsExpression = null;
        }
        namingContext.newVar(jsName, jsExpression);
    }

    public NamingContext(@NotNull JsScope scope2, @NotNull JsContext<JsStatement> statementContext) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(statementContext, "statementContext");
        this.scope = scope2;
        this.statementContext = statementContext;
        this.renamings = new IdentityHashMap();
        this.declarations = new ArrayList();
    }
}

