/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import com.intellij.util.containers.SLRUCache;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.config.Config;
import org.jetbrains.kotlin.js.config.LibrarySourcesConfig;
import org.jetbrains.kotlin.js.inline.FunctionReader;
import org.jetbrains.kotlin.js.inline.FunctionReaderKt;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsRootScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import org.jetbrains.kotlin.relocated.com.google.gwt.dev.js.ThrowExceptionOnErrorReporter;
import org.jetbrains.kotlin.utils.LibraryUtils;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={":\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003!9Q!\u0001C\u0002\u000b\u0005AY!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0016\u0002\ra\u0001!G\u0001\u0019\u0002\u00056\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u0011\t)\u000b\u0002B\"\u0005\u0011\u001bi\u0011\u0001G\u0004\u001a\u0007!=Q\"\u0001\r\tK#!1\t\u0002E\t\u001b\u0005A\u0012\"G\u0002\t\u00105\t\u0001\u0004C\u0013\n\t\u0005A\u0019\"\u0004\u0002\r\u0002aI\u0011d\u0001E\b\u001b\u0005A\u0002\"J\u0007\u0005\u0003!QQB\u0001G\u00011%I2\u0001c\u0004\u000e\u0003aA\u0011d\u0001E\u000b\u001b\u0005AR!K\u0004\u0005\u0003\"A\u0011!D\u0001\u0019\u0004E\u001b\u0011!\u0002\u0001*\u0011\u0011\t\u0005\u0002#\u0002\u000e\u0003a\u0019\u0011k\u0001\u0002\u0006\u0003!\u001d\u0011&\u0004\u0003B\u0011!!QbB\u0005\u0003\u0013\u0005AR!\u0003\u0002\n\u0003a)\u0001\u0014B)\u0004\u0003\u0015\u0001\u0011&\u0004\u0003B\u0011!-QbB\u0005\u0003\u0013\u0005AR!\u0003\u0002\n\u0003a)\u0001\u0014B)\u0004\u0003\u0015\u0001\u0011&\u0004\u0003B\u0011!1QbB\u0005\u0003\u0013\u0005AR!\u0003\u0002\n\u0003a)\u0001\u0014B)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/js/inline/FunctionReader;", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "functionCache", "org/jetbrains/kotlin/js/inline/FunctionReader$functionCache$1", "Lorg/jetbrains/kotlin/js/inline/FunctionReader$functionCache$1;", "moduleJsDefinition", "Ljava/util/HashMap;", "", "moduleKotlinVariable", "moduleRootVariable", "contains", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "get", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunction;", "readFunction", "readFunctionFromSource", "source"}, moduleName="kotlin-compiler")
public final class FunctionReader {
    private final HashMap<String, String> moduleJsDefinition;
    private final HashMap<String, String> moduleRootVariable;
    private final HashMap<String, String> moduleKotlinVariable;
    private final functionCache.1 functionCache;
    private final TranslationContext context;

    public final boolean contains(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        String moduleName = JsDescriptorUtils.getExternalModuleName(descriptor2);
        String currentModuleName = this.context.getConfig().getModuleId();
        return Intrinsics.areEqual(currentModuleName, moduleName) ^ true && moduleName != null && MapsKt.contains((Map)this.moduleJsDefinition, moduleName);
    }

    @NotNull
    public final JsFunction get(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        JsFunction jsFunction = (JsFunction)this.functionCache.get(descriptor2);
        Intrinsics.checkExpressionValueIsNotNull(jsFunction, "functionCache.get(descriptor)");
        return jsFunction;
    }

    private final JsFunction readFunction(CallableDescriptor descriptor2) {
        Unit unit;
        JsFunction function;
        if (this.contains(descriptor2) ^ true) {
            return null;
        }
        String moduleName = JsDescriptorUtils.getExternalModuleName(descriptor2);
        Object $receiver = MapsKt.get((Map)this.moduleJsDefinition, moduleName);
        Object v = $receiver;
        if (v == null) {
            AssertionError assertionError;
            AssertionError assertionError2 = assertionError;
            AssertionError assertionError3 = assertionError;
            String string = "Module " + moduleName + " file have not been read";
            assertionError2((Object)string);
            throw (Throwable)((Object)assertionError3);
        }
        String file = (String)v;
        JsFunction jsFunction = function = this.readFunctionFromSource(descriptor2, file);
        if (jsFunction != null) {
            FunctionReaderKt.access$markInlineArguments(jsFunction, descriptor2);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return function;
    }

    private final JsFunction readFunctionFromSource(CallableDescriptor descriptor2, String source) {
        int offset;
        String tag = Namer.getFunctionTag(descriptor2);
        CharSequence charSequence = source;
        String string = tag;
        Intrinsics.checkExpressionValueIsNotNull(string, "tag");
        int index2 = StringsKt.indexOf$default(charSequence, string, 0, false, 6);
        if (index2 < 0) {
            return null;
        }
        for (offset = index2 + CollectionsKt.length(tag) + 1; offset < CollectionsKt.length(source) && FunctionReaderKt.access$isWhitespaceOrComma$p(CollectionsKt.charAt(source, offset)); ++offset) {
        }
        JsFunction function = ParserUtilsKt.parseFunction(source, offset, ThrowExceptionOnErrorReporter.INSTANCE, new JsRootScope(new JsProgram("<inline>")));
        String string2 = JsDescriptorUtils.getExternalModuleName(descriptor2);
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        String moduleName = string2;
        JsStringLiteral moduleNameLiteral = this.context.program().getStringLiteral(moduleName);
        JsExpression moduleReference = this.context.namer().getModuleReference(moduleNameLiteral);
        Pair[] pairArray = new Pair[2];
        String string3 = this.moduleRootVariable.get(moduleName);
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[0] = TuplesKt.to(string3, moduleReference);
        String string4 = this.moduleKotlinVariable.get(moduleName);
        if (string4 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[1] = TuplesKt.to(string4, Namer.KOTLIN_OBJECT_REF);
        HashMap replacements = MapsKt.hashMapOf(pairArray);
        FunctionReaderKt.access$replaceExternalNames(function, replacements);
        return function;
    }

    /*
     * WARNING - void declaration
     */
    public FunctionReader(@NotNull TranslationContext context) {
        void destination;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        this.moduleJsDefinition = MapsKt.hashMapOf(new Pair[0]);
        this.moduleRootVariable = MapsKt.hashMapOf(new Pair[0]);
        this.moduleKotlinVariable = MapsKt.hashMapOf(new Pair[0]);
        Config config = this.context.getConfig();
        if (config == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.config.LibrarySourcesConfig");
        }
        LibrarySourcesConfig config2 = (LibrarySourcesConfig)config;
        Iterable $receiver2 = config2.getLibraries();
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it2;
            String string = (String)item;
            void var9_9 = destination;
            File file = new File((String)it2);
            var9_9.add(file);
        }
        List libs = (List)destination;
        LibraryUtils.traverseJsLibraries(libs, (Function2<? super String, ? super String, ? extends Unit>)new Function2<String, String, Unit>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final void invoke(@NotNull String fileContent, @NotNull String path) {
                Intrinsics.checkParameterIsNotNull(fileContent, "fileContent");
                Intrinsics.checkParameterIsNotNull(path, "path");
                Matcher matcher = FunctionReaderKt.access$getDEFINE_MODULE_PATTERN$p().toPattern().matcher(fileContent);
                while (matcher.find()) {
                    Unit unit;
                    String moduleName = matcher.group(3);
                    String moduleVariable = matcher.group(4);
                    String kotlinVariable = matcher.group(1);
                    boolean bl = MapsKt.contains(moduleJsDefinition, moduleName) ^ true;
                    if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                        void value;
                        if (value == false) {
                            String message = "Module is defined in more, than one file";
                            throw (Throwable)((Object)new AssertionError((Object)message));
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = Unit.INSTANCE;
                    }
                    Map map2 = moduleJsDefinition;
                    String string = moduleName;
                    Intrinsics.checkExpressionValueIsNotNull(string, "moduleName");
                    MapsKt.set(map2, string, fileContent);
                    Map map3 = moduleRootVariable;
                    String string2 = moduleName;
                    Intrinsics.checkExpressionValueIsNotNull(string2, "moduleName");
                    String string3 = moduleVariable;
                    Intrinsics.checkExpressionValueIsNotNull(string3, "moduleVariable");
                    MapsKt.set(map3, string2, string3);
                    Map map4 = moduleKotlinVariable;
                    String string4 = moduleName;
                    Intrinsics.checkExpressionValueIsNotNull(string4, "moduleName");
                    String string5 = kotlinVariable;
                    Intrinsics.checkExpressionValueIsNotNull(string5, "kotlinVariable");
                    MapsKt.set(map4, string4, string5);
                }
            }
        });
        this.functionCache = new SLRUCache<CallableDescriptor, JsFunction>(this, 50, 50){
            final /* synthetic */ FunctionReader this$0;

            @NotNull
            public JsFunction createValue(@NotNull CallableDescriptor descriptor2) {
                Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
                JsFunction $receiver = FunctionReader.access$readFunction(this.this$0, descriptor2);
                JsFunction jsFunction = $receiver;
                if (jsFunction == null) {
                    AssertionError assertionError;
                    AssertionError assertionError2 = assertionError;
                    AssertionError assertionError3 = assertionError;
                    String string = "Could not read function: " + descriptor2;
                    assertionError2((Object)string);
                    throw (Throwable)((Object)assertionError3);
                }
                return jsFunction;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        };
    }

    @Nullable
    public static final /* synthetic */ JsFunction access$readFunction(FunctionReader $this, @NotNull CallableDescriptor descriptor2) {
        return $this.readFunction(descriptor2);
    }
}

