/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"E\u0003\u0001\u000b\u0005AY!\u0002\u0001\r\u0001e\t\u0001\u0014AQ\u0007\u0013\rA\u0011!D\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0002&\r!!Q\u0002B\u0005\u0003\u0013\u0005A:\u0001'\u0003&\u000f!)Q\"\u0001M\u00063\rAa!D\u0001\u0019\b%:A!\u0011\u0005\t\u00035\t\u00014A)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003B\u0011!\u0015Q\u0002B\u0005\u0003\u0013\u0005A:\u0001G\u0002R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/builtins/CompanionObjectMapping;", "", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "classes", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "allClassesWithIntrinsicCompanions", "", "hasMappingToObject", "", "classDescriptor"}, moduleName="kotlin-compiler")
public final class CompanionObjectMapping {
    private final LinkedHashSet<ClassDescriptor> classes;
    private final KotlinBuiltIns builtIns;

    @NotNull
    public final Set<ClassDescriptor> allClassesWithIntrinsicCompanions() {
        Set<ClassDescriptor> set = Collections.unmodifiableSet((Set)this.classes);
        Intrinsics.checkExpressionValueIsNotNull(set, "Collections.unmodifiableSet(classes)");
        return set;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasMappingToObject(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        if (!DescriptorUtils.isCompanionObject(classDescriptor)) return false;
        Iterable iterable = this.classes;
        DeclarationDescriptor declarationDescriptor = classDescriptor.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "classDescriptor.getContainingDeclaration()");
        if (!CollectionsKt.contains(iterable, declarationDescriptor)) return false;
        return true;
    }

    public CompanionObjectMapping(@NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        this.builtIns = builtIns;
        this.classes = SetsKt.linkedSetOf(new ClassDescriptor[0]);
        for (PrimitiveType type2 : PrimitiveType.NUMBER_TYPES) {
            ClassDescriptor classDescriptor = this.builtIns.getPrimitiveClassDescriptor(type2);
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "builtIns.getPrimitiveClassDescriptor(type)");
            this.classes.add(classDescriptor);
        }
        ClassDescriptor classDescriptor = this.builtIns.getString();
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "builtIns.getString()");
        this.classes.add(classDescriptor);
        ClassDescriptor classDescriptor2 = this.builtIns.getEnum();
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "builtIns.getEnum()");
        this.classes.add(classDescriptor2);
    }
}

