/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.relocated.com.google.common.collect.LinkedHashMultimap;
import org.jetbrains.kotlin.relocated.com.google.common.collect.SetMultimap;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"G\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u00012B\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u00031\tQ\u0001A\u0003\u0002\u0011G)\u0001!B\u0001\t#\u0011\u0019B\u0002A\r\u00021\u0003\t+!U\u0002\u0002\u0011\u0005)s\u0001\u0003\u0003\u000e\u0003a%\u0011d\u0001\u0005\u0006\u001b\u0005AZ!\n\u0005\u0005\u0017!1Q\"\u0001M\u00073\rAq!D\u0001\u0019\u0010\u0015BAa\u0003\u0005\t\u001b\u0005Aj!G\u0002\t\u00125\t\u0001dA\u0013\t\t-A\u0011\"D\u0001\u0019\u000ee\u0019\u00012C\u0007\u00021))C\u0003B\u0006\t\u00165i\u0011bA\u0005\u0003\u0019\u0003A2\u0001e\u0006\u0016\r%\u0019\u0011B\u0001G\u00011\ra\t\u0001\u0007\u0007\u0019\u0017e\u0019\u0001\"B\u0007\u00021\u0017Ic\u0002B!\t\u0011\u0007i\u0001\"\u0003\u0002\n\u0003a\u0015\u0011bA\u0005\u0003\u0019\u0003A2\u0001\u0007\u0002R\u0007\u0005)\u0001!\u000b\u0005\u0005\u0003rA9!\u0004\u0002\r\u0002a\u0019\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/types/expressions/AssignedVariablesSearcher;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "()V", "assignedNames", "Lorg/jetbrains/kotlin/relocated/com/google/common/collect/SetMultimap;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "currentDeclaration", "hasWriters", "", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "visitBinaryExpression", "", "binaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitDeclaration", "declaration", "visitFunctionLiteralExpression", "functionLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteralExpression;", "writers", "", "kotlin.jvm.PlatformType", ""}, moduleName="kotlin-compiler")
public abstract class AssignedVariablesSearcher
extends KtTreeVisitorVoid {
    private final SetMultimap<Name, KtDeclaration> assignedNames;
    private KtDeclaration currentDeclaration;

    public Set<KtDeclaration> writers(@NotNull VariableDescriptor variableDescriptor) {
        Intrinsics.checkParameterIsNotNull(variableDescriptor, "variableDescriptor");
        return this.assignedNames.get(variableDescriptor.getName());
    }

    public final boolean hasWriters(@NotNull VariableDescriptor variableDescriptor) {
        Intrinsics.checkParameterIsNotNull(variableDescriptor, "variableDescriptor");
        return CollectionsKt.isNotEmpty((Collection)this.writers(variableDescriptor));
    }

    @Override
    public void visitDeclaration(@NotNull KtDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        KtDeclaration previous = this.currentDeclaration;
        if (declaration instanceof KtDeclarationWithBody || declaration instanceof KtClassOrObject) {
            this.currentDeclaration = declaration;
        } else if (declaration instanceof KtAnonymousInitializer) {
            PsiElement psiElement2 = ((KtAnonymousInitializer)declaration).getParent().getParent();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
            }
            this.currentDeclaration = (KtDeclaration)psiElement2;
        }
        super.visitDeclaration(declaration);
        this.currentDeclaration = previous;
    }

    @Override
    public void visitFunctionLiteralExpression(@NotNull KtFunctionLiteralExpression functionLiteralExpression) {
        Intrinsics.checkParameterIsNotNull(functionLiteralExpression, "functionLiteralExpression");
        KtDeclaration previous = this.currentDeclaration;
        this.currentDeclaration = functionLiteralExpression.getFunctionLiteral();
        super.visitFunctionLiteralExpression(functionLiteralExpression);
        this.currentDeclaration = previous;
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression binaryExpression) {
        KtExpression left;
        Intrinsics.checkParameterIsNotNull(binaryExpression, "binaryExpression");
        if (binaryExpression.getOperationToken() == KtTokens.EQ && (left = KtPsiUtil.deparenthesize(binaryExpression.getLeft())) instanceof KtNameReferenceExpression) {
            this.assignedNames.put(((KtNameReferenceExpression)left).getReferencedNameAsName(), this.currentDeclaration);
        }
        super.visitBinaryExpression(binaryExpression);
    }

    public AssignedVariablesSearcher() {
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        Intrinsics.checkExpressionValueIsNotNull(linkedHashMultimap, "LinkedHashMultimap.create()");
        this.assignedNames = linkedHashMultimap;
    }
}

