/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinScriptStubImpl;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"?\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u001d)\u0011\u0001\u0002\u0002\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u0019\u0001Ir!\u0003\u0002\n\u0003a\t\u0011BA\u0005\u00021\u0007A\n!)\u0004\n\u0007!\u0011Q\"\u0001M\u0003#\u000e\t\u0001bA\u0013\u0010\t-A9!D\u0001\u0019\u0003e\u0019\u0001\u0002B\u0007\u00021\u0007Ib\u0001#\u0003\u000e\t%\u0011\u0011\"\u0001M\u00061\u0015)s\u0002B\u0006\t\r5\t\u0001$A\r\u0004\u0011\u001bi\u0011\u0001G\u0004\u001a\r!%Q\u0002B\u0005\u0003\u0013\u0005AZ\u0001G\u0003&\u0019\u0011Y\u0001rB\u0007\u00021!I2\u0001#\u0005\u000e\u0003a\t\u0011d\u0001\u0005\n\u001b\u0005A\u001a\"\n\u0007\u0005\u0017!QQ\"\u0001\r\t3\rA\t\"D\u0001\u0019\u0003e\u0019\u0001RB\u0007\u00021+\u0001"}, strings={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtScriptElementType;", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinScriptStub;", "Lorg/jetbrains/kotlin/psi/KtScript;", "debugName", "", "(Ljava/lang/String;)V", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "deserialize", "dataStream", "Lcom/intellij/psi/stubs/StubInputStream;", "indexStub", "", "stub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "serialize", "Lcom/intellij/psi/stubs/StubOutputStream;"}, moduleName="kotlin-compiler")
public final class KtScriptElementType
extends KtStubElementType<KotlinScriptStub, KtScript> {
    @Override
    @NotNull
    public KotlinScriptStub createStub(@NotNull KtScript psi, @NotNull StubElement<PsiElement> parentStub) {
        Intrinsics.checkParameterIsNotNull(psi, "psi");
        Intrinsics.checkParameterIsNotNull(parentStub, "parentStub");
        return new KotlinScriptStubImpl(parentStub, StringRef.fromString(psi.getFqName().asString()));
    }

    @Override
    public void serialize(@NotNull KotlinScriptStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(dataStream, "dataStream");
        dataStream.writeName(stub.getFqName().asString());
    }

    @Override
    @NotNull
    public KotlinScriptStub deserialize(@NotNull StubInputStream dataStream, @NotNull StubElement<PsiElement> parentStub) {
        Intrinsics.checkParameterIsNotNull(dataStream, "dataStream");
        Intrinsics.checkParameterIsNotNull(parentStub, "parentStub");
        StringRef fqName2 = dataStream.readName();
        return new KotlinScriptStubImpl(parentStub, fqName2);
    }

    @Override
    public void indexStub(@NotNull KotlinScriptStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
        StubIndexService.Companion.getInstance().indexScript(stub, sink);
    }

    public KtScriptElementType(@NotNull String debugName) {
        Intrinsics.checkParameterIsNotNull(debugName, "debugName");
        super(debugName, KtScript.class, KotlinScriptStub.class);
    }
}

