/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.general;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.kotlin.resolve.BindingContext;

public abstract class AbstractTranslator {
    @NotNull
    private final TranslationContext context;

    protected AbstractTranslator(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/general/AbstractTranslator", "<init>"));
        }
        this.context = context;
    }

    @NotNull
    protected JsProgram program() {
        JsProgram jsProgram = this.context.program();
        if (jsProgram == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/general/AbstractTranslator", "program"));
        }
        return jsProgram;
    }

    @NotNull
    protected TranslationContext context() {
        TranslationContext translationContext = this.context;
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/general/AbstractTranslator", "context"));
        }
        return translationContext;
    }

    @NotNull
    protected BindingContext bindingContext() {
        BindingContext bindingContext2 = this.context.bindingContext();
        if (bindingContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/general/AbstractTranslator", "bindingContext"));
        }
        return bindingContext2;
    }

    @NotNull
    protected Namer namer() {
        Namer namer = this.context.namer();
        if (namer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/general/AbstractTranslator", "namer"));
        }
        return namer;
    }
}

