/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression.loopTranslator;

import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.MultiDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.loopTranslator.LoopTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.CompositeFIF;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TemporariesUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtMultiDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtWhileExpressionBase;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBreak;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsDoWhile;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsEmpty;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFor;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsIf;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsWhile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"%\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\u0019\u0005i\t\u0003\u0003\u0001\u000e\u0003a\u0005\u0011d\u0001\u0005\u0002\u001b\u0005A\u001a!G\u0002\t\u00055\t\u0001TA\r\u0004\u0011\ri\u0011\u0001g\u0002U\u0007\u0011iI\u0002#\u0003\u000e\u0003a)\u0011d\u0001\u0005\u0003\u001b\u0005AZ!G\u0002\t\u00075\t\u0001t\u0001+\u0004\t\u0001"}, strings={"createWhile", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNode;", "doWhile", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhileExpressionBase;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "LoopTranslator", "translateForExpression", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;", "Lorg/jetbrains/kotlin/psi/KtForExpression;"}, moduleName="kotlin-compiler")
@JvmName(name="LoopTranslator")
public final class LoopTranslator {
    @NotNull
    public static final JsNode createWhile(boolean doWhile, @NotNull KtWhileExpressionBase expression, @NotNull TranslationContext context) {
        JsStatement bodyStatement;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KtExpression ktExpression = expression.getCondition();
        if (ktExpression == null) {
            throw (Throwable)new IllegalArgumentException("condition expression should not be null: " + expression.getText());
        }
        KtExpression conditionExpression = ktExpression;
        JsBlock conditionBlock = new JsBlock();
        JsExpression jsCondition = Translation.translateAsExpression(conditionExpression, context, conditionBlock);
        boolean isEmptyLoopCondition = JsAstUtils.isEmptyExpression(jsCondition);
        KtExpression body = expression.getBody();
        JsStatement jsStatement = bodyStatement = body != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(body, context) : (JsStatement)JsEmpty.INSTANCE;
        if (!conditionBlock.isEmpty()) {
            JsIf breakIfConditionIsFalseStatement = new JsIf(JsAstUtils.not(jsCondition), new JsBreak());
            JsBlock bodyBlock = JsAstUtils.convertToBlock(bodyStatement);
            jsCondition = JsLiteral.TRUE;
            if (doWhile) {
                TemporaryVariable secondRun = context.declareTemporary(JsLiteral.FALSE);
                context.addStatementToCurrentBlock(secondRun.assignmentExpression().makeStmt());
                if (!isEmptyLoopCondition) {
                    conditionBlock.getStatements().add(breakIfConditionIsFalseStatement);
                }
                JsIf ifStatement = new JsIf(secondRun.reference(), conditionBlock, JsAstUtils.assignment(secondRun.reference(), JsLiteral.TRUE).makeStmt());
                bodyBlock.getStatements().add(0, ifStatement);
            } else if (isEmptyLoopCondition) {
                bodyBlock.getStatements().clear();
                context.addStatementsToCurrentBlockFrom(conditionBlock);
            } else {
                conditionBlock.getStatements().add(breakIfConditionIsFalseStatement);
                List<JsStatement> list = bodyBlock.getStatements();
                Collection collection = conditionBlock.getStatements();
                Intrinsics.checkExpressionValueIsNotNull(collection, "conditionBlock.getStatements()");
                list.addAll(0, collection);
            }
            bodyStatement = bodyBlock;
        } else if (isEmptyLoopCondition) {
            jsCondition = JsLiteral.FALSE;
        }
        JsWhile result2 = doWhile ? (JsWhile)new JsDoWhile() : new JsWhile();
        result2.setCondition(jsCondition);
        result2.setBody(bodyStatement);
        JsNode jsNode = result2.source(expression);
        if (jsNode == null) {
            Intrinsics.throwNpe();
        }
        return jsNode;
    }

    @NotNull
    public static final JsStatement translateForExpression(@NotNull KtForExpression expression, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KtExpression loopRange = PsiUtils.getLoopRange(expression);
        KotlinType rangeType = BindingUtils.getTypeForExpression(context.bindingContext(), loopRange);
        Function0<Boolean> isForOverRange$ = new Function0<Boolean>(rangeType){
            final /* synthetic */ KotlinType $rangeType;

            public final boolean invoke() {
                return Intrinsics.areEqual(DescriptorUtils.getClassDescriptorForType(this.$rangeType).getName().asString(), "IntRange");
            }
            {
                this.$rangeType = kotlinType;
                super(0);
            }
        };
        Function0<Boolean> isForOverRangeLiteral$ = new Function0<Boolean>(loopRange, isForOverRange$){
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ translateForExpression.1 $isForOverRange;

            public final boolean invoke() {
                return this.$loopRange instanceof KtBinaryExpression && Intrinsics.areEqual(((KtBinaryExpression)this.$loopRange).getOperationToken(), KtTokens.RANGE) && this.$isForOverRange.invoke();
            }
            {
                this.$loopRange = ktExpression;
                this.$isForOverRange = var2_2;
                super(0);
            }
        };
        Function0<Boolean> isForOverArray$ = new Function0<Boolean>(rangeType){
            final /* synthetic */ KotlinType $rangeType;

            public final boolean invoke() {
                return Intrinsics.areEqual(DescriptorUtils.getClassDescriptorForType(this.$rangeType).getName().asString(), "Array") || Intrinsics.areEqual(DescriptorUtils.getClassDescriptorForType(this.$rangeType).getName().asString(), "IntArray");
            }
            {
                this.$rangeType = kotlinType;
                super(0);
            }
        };
        KtMultiDeclaration multiParameter = expression.getMultiParameter();
        Function0<JsName> declareParameter$ = new Function0<JsName>(expression, context, multiParameter){
            final /* synthetic */ KtForExpression $expression;
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtMultiDeclaration $multiParameter;

            @NotNull
            public final JsName invoke() {
                Unit unit;
                KtParameter loopParameter = PsiUtils.getLoopParameter(this.$expression);
                if (loopParameter != null) {
                    JsName jsName = this.$context.getNameForElement(loopParameter);
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "context.getNameForElement(loopParameter)");
                    return jsName;
                }
                boolean value = this.$multiParameter != null;
                if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                    if (!value) {
                        String message = "If loopParameter is null, multi parameter must be not null " + this.$expression.getText();
                        throw (Throwable)((Object)new AssertionError((Object)message));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                JsName jsName = this.$context.scope().declareTemporary();
                Intrinsics.checkExpressionValueIsNotNull(jsName, "context.scope().declareTemporary()");
                return jsName;
            }
            {
                this.$expression = ktForExpression;
                this.$context = translationContext;
                this.$multiParameter = ktMultiDeclaration;
                super(0);
            }
        };
        Object parameterName = declareParameter$.invoke();
        Function1<JsExpression, JsStatement> translateBody$ = new Function1<JsExpression, JsStatement>(expression, context, multiParameter, (JsName)parameterName){
            final /* synthetic */ KtForExpression $expression;
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtMultiDeclaration $multiParameter;
            final /* synthetic */ JsName $parameterName;

            @Nullable
            public final JsStatement invoke(@Nullable JsExpression itemValue) {
                JsVars currentVarInit;
                JsStatement realBody;
                JsStatement jsStatement;
                KtExpression ktExpression = this.$expression.getBody();
                if (ktExpression != null) {
                    KtExpression $receiver = ktExpression;
                    KtExpression it2 = $receiver;
                    jsStatement = Translation.translateAsStatementAndMergeInBlockIfNeeded(it2, this.$context);
                } else {
                    jsStatement = realBody = null;
                }
                if (itemValue == null && this.$multiParameter == null) {
                    return realBody;
                }
                JsVars jsVars = currentVarInit = this.$multiParameter == null ? JsAstUtils.newVar(this.$parameterName, itemValue) : MultiDeclarationTranslator.translate(this.$multiParameter, this.$parameterName, itemValue, this.$context);
                if (realBody == null) {
                    return new JsBlock(currentVarInit);
                }
                JsBlock block = JsAstUtils.convertToBlock(realBody);
                block.getStatements().add(0, currentVarInit);
                return block;
            }
            {
                this.$expression = ktForExpression;
                this.$context = translationContext;
                this.$multiParameter = ktMultiDeclaration;
                this.$parameterName = jsName;
                super(1);
            }
        };
        Function0<JsStatement> translateForOverLiteralRange$ = new Function0<JsStatement>(loopRange, context, translateBody$, (JsName)parameterName){
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ translateForExpression.5 $translateBody;
            final /* synthetic */ JsName $parameterName;

            @NotNull
            public final JsStatement invoke() {
                JsExpression jsExpression;
                if (!(this.$loopRange instanceof KtBinaryExpression)) {
                    throw (Throwable)new IllegalStateException("expected JetBinaryExpression, but " + this.$loopRange.getText());
                }
                JsBlock startBlock = new JsBlock();
                JsExpression leftExpression = TranslationUtils.translateLeftExpression(this.$context, (KtBinaryExpression)this.$loopRange, startBlock);
                JsBlock endBlock = new JsBlock();
                JsExpression rightExpression = TranslationUtils.translateRightExpression(this.$context, (KtBinaryExpression)this.$loopRange, endBlock);
                if (TranslationUtils.isCacheNeeded(leftExpression)) {
                    TemporaryVariable startVar = this.$context.declareTemporary(leftExpression);
                    this.$context.addStatementToCurrentBlock(startVar.assignmentExpression().makeStmt());
                    jsExpression = startVar.reference();
                } else {
                    jsExpression = leftExpression;
                }
                JsExpression rangeStart = jsExpression;
                this.$context.addStatementsToCurrentBlockFrom(startBlock);
                this.$context.addStatementsToCurrentBlockFrom(endBlock);
                TemporaryVariable rangeEnd = this.$context.declareTemporary(rightExpression);
                JsStatement body = this.$translateBody.invoke((JsExpression)null);
                JsVars initExpression = JsAstUtils.newVar(this.$parameterName, rangeStart);
                JsBinaryOperation conditionExpression = JsAstUtils.lessThanEq(this.$parameterName.makeRef(), rangeEnd.reference());
                JsPostfixOperation incrementExpression = new JsPostfixOperation(JsUnaryOperator.INC, this.$parameterName.makeRef());
                this.$context.addStatementToCurrentBlock(TemporariesUtils.temporariesInitialization(rangeEnd).makeStmt());
                return new JsFor(initExpression, (JsExpression)conditionExpression, (JsExpression)incrementExpression, body);
            }
            {
                this.$loopRange = ktExpression;
                this.$context = translationContext;
                this.$translateBody = var3_3;
                this.$parameterName = jsName;
                super(0);
            }
        };
        Function0<JsStatement> translateForOverRange$ = new Function0<JsStatement>(context, loopRange, translateBody$, (JsName)parameterName){
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ translateForExpression.5 $translateBody;
            final /* synthetic */ JsName $parameterName;

            @NotNull
            public final JsStatement invoke() {
                TemporaryVariable rangeExpression = this.$context.declareTemporary(Translation.translateAsExpression(this.$loopRange, this.$context));
                Function1<String, JsExpression> getProperty$ = new Function1<String, JsExpression>(rangeExpression){
                    final /* synthetic */ TemporaryVariable $rangeExpression;

                    @NotNull
                    public final JsExpression invoke(@NotNull String funName) {
                        Intrinsics.checkParameterIsNotNull(funName, "funName");
                        return new JsNameRef(funName, (JsExpression)this.$rangeExpression.reference());
                    }
                    {
                        this.$rangeExpression = temporaryVariable;
                        super(1);
                    }
                };
                TemporaryVariable start = this.$context.declareTemporary(getProperty$.invoke("start"));
                TemporaryVariable end = this.$context.declareTemporary(getProperty$.invoke("end"));
                TemporaryVariable increment = this.$context.declareTemporary(getProperty$.invoke("increment"));
                JsStatement body = this.$translateBody.invoke((JsExpression)null);
                JsVars initExpression = JsAstUtils.newVar(this.$parameterName, start.reference());
                JsBinaryOperation conditionExpression = JsAstUtils.lessThanEq(this.$parameterName.makeRef(), end.reference());
                JsBinaryOperation incrementExpression = JsAstUtils.addAssign(this.$parameterName.makeRef(), increment.reference());
                this.$context.addStatementToCurrentBlock(TemporariesUtils.temporariesInitialization(rangeExpression, start, end, increment).makeStmt());
                return new JsFor(initExpression, (JsExpression)conditionExpression, (JsExpression)incrementExpression, body);
            }
            {
                this.$context = translationContext;
                this.$loopRange = ktExpression;
                this.$translateBody = var3_3;
                this.$parameterName = jsName;
                super(0);
            }
        };
        Function0<JsStatement> translateForOverArray$ = new Function0<JsStatement>(context, loopRange, translateBody$){
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ translateForExpression.5 $translateBody;

            @NotNull
            public final JsStatement invoke() {
                TemporaryVariable rangeExpression = this.$context.declareTemporary(Translation.translateAsExpression(this.$loopRange, this.$context));
                JsExpression length = CompositeFIF.LENGTH_PROPERTY_INTRINSIC.apply(rangeExpression.reference(), CollectionsKt.<JsExpression>listOf(), this.$context);
                TemporaryVariable end = this.$context.declareTemporary(length);
                TemporaryVariable index2 = this.$context.declareTemporary(this.$context.program().getNumberLiteral(0));
                JsArrayAccess arrayAccess = new JsArrayAccess(rangeExpression.reference(), index2.reference());
                JsStatement body = this.$translateBody.invoke(arrayAccess);
                JsVars initExpression = JsAstUtils.newVar(index2.name(), this.$context.program().getNumberLiteral(0));
                JsBinaryOperation conditionExpression = JsAstUtils.inequality(index2.reference(), end.reference());
                JsPrefixOperation incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, index2.reference());
                this.$context.addStatementToCurrentBlock(TemporariesUtils.temporariesInitialization(rangeExpression, end).makeStmt());
                return new JsFor(initExpression, (JsExpression)conditionExpression, (JsExpression)incrementExpression, body);
            }
            {
                this.$context = translationContext;
                this.$loopRange = ktExpression;
                this.$translateBody = var3_3;
                super(0);
            }
        };
        Function0<JsStatement> translateForOverIterator$ = new Function0<JsStatement>(context, loopRange, translateBody$){
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ translateForExpression.5 $translateBody;

            @NotNull
            public final JsStatement invoke() {
                Function2<JsExpression, ResolvedCall<FunctionDescriptor>, JsExpression> translateMethodInvocation$ = new Function2<JsExpression, ResolvedCall<FunctionDescriptor>, JsExpression>(this){
                    final /* synthetic */ translateForExpression.9 this$0;

                    @NotNull
                    public final JsExpression invoke(@Nullable JsExpression receiver, @NotNull ResolvedCall<FunctionDescriptor> resolvedCall) {
                        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
                        return CallTranslator.translate(this.this$0.$context, resolvedCall, receiver);
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                };
                Function0<JsExpression> iteratorMethodInvocation$ = new Function0<JsExpression>(this, translateMethodInvocation$){
                    final /* synthetic */ translateForExpression.9 this$0;
                    final /* synthetic */ translateForExpression.1 $translateMethodInvocation;

                    @NotNull
                    public final JsExpression invoke() {
                        ResolvedCall<FunctionDescriptor> resolvedCall;
                        JsExpression range = Translation.translateAsExpression(this.this$0.$loopRange, this.this$0.$context);
                        ResolvedCall<FunctionDescriptor> resolvedCall2 = resolvedCall = BindingUtils.getIteratorFunction(this.this$0.$context.bindingContext(), this.this$0.$loopRange);
                        Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, "resolvedCall");
                        return this.$translateMethodInvocation.invoke(range, resolvedCall2);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$translateMethodInvocation = var2_2;
                        super(0);
                    }
                };
                TemporaryVariable temporaryVariable = this.$context.declareTemporary((JsExpression)iteratorMethodInvocation$.invoke());
                Intrinsics.checkExpressionValueIsNotNull(temporaryVariable, "context.declareTemporary\u2026eratorMethodInvocation())");
                TemporaryVariable iteratorVar = temporaryVariable;
                Function0<JsExpression> nextMethodInvocation$ = new Function0<JsExpression>(this, translateMethodInvocation$, iteratorVar){
                    final /* synthetic */ translateForExpression.9 this$0;
                    final /* synthetic */ translateForExpression.1 $translateMethodInvocation;
                    final /* synthetic */ TemporaryVariable $iteratorVar;

                    @NotNull
                    public final JsExpression invoke() {
                        JsExpression jsExpression = this.$iteratorVar.reference();
                        ResolvedCall<FunctionDescriptor> resolvedCall = BindingUtils.getNextFunction(this.this$0.$context.bindingContext(), this.this$0.$loopRange);
                        Intrinsics.checkExpressionValueIsNotNull(resolvedCall, "getNextFunction(context.\u2026dingContext(), loopRange)");
                        return this.$translateMethodInvocation.invoke(jsExpression, resolvedCall);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$translateMethodInvocation = var2_2;
                        this.$iteratorVar = temporaryVariable;
                        super(0);
                    }
                };
                Function0<JsExpression> hasNextMethodInvocation$ = new Function0<JsExpression>(this, translateMethodInvocation$, iteratorVar){
                    final /* synthetic */ translateForExpression.9 this$0;
                    final /* synthetic */ translateForExpression.1 $translateMethodInvocation;
                    final /* synthetic */ TemporaryVariable $iteratorVar;

                    @NotNull
                    public final JsExpression invoke() {
                        ResolvedCall<FunctionDescriptor> resolvedCall = BindingUtils.getHasNextCallable(this.this$0.$context.bindingContext(), this.this$0.$loopRange);
                        JsExpression jsExpression = this.$iteratorVar.reference();
                        ResolvedCall<FunctionDescriptor> resolvedCall2 = resolvedCall;
                        Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, "resolvedCall");
                        return this.$translateMethodInvocation.invoke(jsExpression, resolvedCall2);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$translateMethodInvocation = var2_2;
                        this.$iteratorVar = temporaryVariable;
                        super(0);
                    }
                };
                this.$context.addStatementToCurrentBlock(iteratorVar.assignmentExpression().makeStmt());
                Object nextInvoke = nextMethodInvocation$.invoke();
                JsStatement body = this.$translateBody.invoke((JsExpression)nextInvoke);
                Object object = hasNextMethodInvocation$.invoke();
                JsStatement jsStatement = body;
                if (jsStatement == null) {
                    jsStatement = nextInvoke.makeStmt();
                }
                return new JsWhile((JsExpression)object, jsStatement);
            }
            {
                this.$context = translationContext;
                this.$loopRange = ktExpression;
                this.$translateBody = var3_3;
                super(0);
            }
        };
        return isForOverRangeLiteral$.invoke() ? translateForOverLiteralRange$.invoke() : (isForOverRange$.invoke() ? translateForOverRange$.invoke() : (isForOverArray$.invoke() ? translateForOverArray$.invoke() : translateForOverIterator$.invoke()));
    }
}

