/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.LinkedHashMap;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.StringsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.RangeMapping;
import org.jetbrains.kotlin.codegen.inline.SMAP;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u001d)\u0011\u0001\u0002\u0002\u0006\u0003!!Q\u0001\u0001\u0003d\u00031\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)\u0003\u0002b\u0002\t\u00045\t\u0001DA\r\u0004\u0011\u000bi\u0011\u0001G\u0002&5\u0011\u001d\u0001rA\u0007\u00021\tIB\u0001#\u0002\u000e\u00051\u0005\u0001dA\r\u0005\u0011\u0011i!\u0001$\u0001\u0019\u0007e\u0019\u0001\u0012B\u0007\u00021\rI2\u0001C\u0003\u000e\u0003a-\u0011d\u0001\u0005\u0007\u001b\u0005AZ\u0001"}, strings={"Lorg/jetbrains/kotlin/codegen/inline/SMAPParser;", "", "()V", "parse", "Lorg/jetbrains/kotlin/codegen/inline/SMAP;", "mappingInfo", "", "parseOrCreateDefault", "source", "path", "methodStartLine", "", "methodEndLine"}, moduleName="kotlin-compiler")
public final class SMAPParser {
    public static final SMAPParser INSTANCE;
    public static final SMAPParser INSTANCE$;

    @JvmStatic
    @NotNull
    public static final SMAP parseOrCreateDefault(@Nullable String mappingInfo, @Nullable String source, @NotNull String path, int methodStartLine, int methodEndLine) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        if (mappingInfo == null || StringsKt.isEmpty((CharSequence)mappingInfo)) {
            FileMapping fm;
            if (source == null || StringsKt.isEmpty((CharSequence)source)) {
                fm = FileMapping.SKIP.INSTANCE;
            } else {
                fm = new FileMapping(source, path);
                if (methodStartLine <= methodEndLine) {
                    fm.addRangeMapping(new RangeMapping(methodStartLine, methodStartLine, methodEndLine - methodStartLine + 1));
                }
            }
            return new SMAP(CollectionsKt.listOf(fm));
        }
        return SMAPParser.parse(mappingInfo);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final SMAP parse(@NotNull String mappingInfo) {
        Intrinsics.checkParameterIsNotNull(mappingInfo, "mappingInfo");
        LinkedHashMap<Integer, FileMapping> fileMappings = MapsKt.linkedMapOf(new Pair[0]);
        int fileSectionStart = StringsKt.indexOf$default((CharSequence)mappingInfo, SMAP.Companion.getFILE_SECTION(), 0, false, 6) + CollectionsKt.length(SMAP.Companion.getFILE_SECTION());
        int lineSectionAnchor = StringsKt.indexOf$default((CharSequence)mappingInfo, SMAP.Companion.getLINE_SECTION(), 0, false, 6);
        String files = StringsKt.substring(mappingInfo, fileSectionStart, lineSectionAnchor);
        List fileEntries = StringsKt.split$default((CharSequence)StringsKt.trim(files), new char[]{'+'}, false, 0, 6);
        for (String fileDeclaration : fileEntries) {
            if (Intrinsics.areEqual(fileDeclaration, "")) continue;
            String fileInternalName = StringsKt.trim(fileDeclaration);
            int indexEnd = StringsKt.indexOf$default((CharSequence)fileInternalName, ' ', 0, false, 6);
            Integer fileIndex = Integer.valueOf(StringsKt.substring(fileInternalName, 0, indexEnd));
            int newLine = StringsKt.indexOf$default((CharSequence)fileInternalName, '\n', 0, false, 6);
            String fileName = StringsKt.substring(fileInternalName, indexEnd + 1, newLine);
            Integer n = fileIndex;
            Intrinsics.checkExpressionValueIsNotNull(n, "fileIndex");
            fileMappings.put(n, new FileMapping(fileName, StringsKt.trim(StringsKt.substring(fileInternalName, newLine + 1))));
        }
        List lines = StringsKt.split$default((CharSequence)StringsKt.trim(StringsKt.substring(mappingInfo, lineSectionAnchor + CollectionsKt.length(SMAP.Companion.getLINE_SECTION()), StringsKt.indexOf$default((CharSequence)mappingInfo, SMAP.Companion.getEND(), 0, false, 6))), new char[]{'\n'}, false, 0, 6);
        for (String lineMapping : lines) {
            void $receiver;
            int targetSplit = StringsKt.indexOf$default((CharSequence)lineMapping, ':', 0, false, 6);
            String originalPart = StringsKt.substring(lineMapping, 0, targetSplit);
            int fileName = StringsKt.indexOf$default((CharSequence)originalPart, ',', 0, false, 6);
            void it2 = $receiver;
            int rangeSeparator = it2 < false ? targetSplit : it2;
            int fileSeparator = StringsKt.indexOf$default((CharSequence)lineMapping, '#', 0, false, 6);
            Integer originalIndex = Integer.valueOf(StringsKt.substring(originalPart, 0, fileSeparator));
            Integer range = rangeSeparator == targetSplit ? Integer.valueOf(1) : Integer.valueOf(StringsKt.substring(originalPart, rangeSeparator + 1, targetSplit));
            Integer fileIndex = Integer.valueOf(StringsKt.substring(lineMapping, fileSeparator + 1, rangeSeparator));
            Integer targetIndex = Integer.valueOf(StringsKt.substring(lineMapping, targetSplit + 1));
            Object v = fileMappings.get(fileIndex);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            ((FileMapping)v).addRangeMapping(new RangeMapping(((Number)originalIndex).intValue(), ((Number)targetIndex).intValue(), ((Number)range).intValue()));
        }
        return new SMAP(CollectionsKt.toList(CollectionsKt.mutableValues(fileMappings)));
    }

    static {
        new SMAPParser();
    }

    private SMAPParser() {
        INSTANCE = this;
        INSTANCE$ = this;
    }
}

