/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.LibraryUtils;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"S\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!!Q!\u0001\u0003\u0003\u000b\u0005Aq!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\t\u0011)\u0011\u0001C\u0005\u0006\u0001\u0015\t\u00012B\u0003\u0002\t\u000b)\u0011\u0001\u0003\t\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0011C)\u0011\u0001B\u0001\u0005G\u0006a\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQe\u0003\u0005\u000b\u001b\u0005AJ!G\u0002\t\u00165\t\u0001\u0014B\r\u0004\u0011-i\u0011\u0001g\u0006&\u0011\u0011\u001d\u0001\u0002D\u0007\u000213I2\u0001C\u0007\u000e\u0003a%Qe\u0002E\u000e\u001b\u0005AJ\"G\u0002\t\u001b5\t\u0001\u0014B\u0013\t\t\u000fAa\"D\u0001\u0019\u001ae\u0019\u0001RD\u0007\u00021\t)3\u0002b\u0002\t\u001f5!\u0011BA\u0005\u00021AAz\"G\u0002\t\"5\t\u0001$E\u0013\f\t\u000fAq\"\u0004\u0003\n\u0005%\t\u0001\u0004\u0005M\u00103\rA\u0019#D\u0001\u0019\n\u0015zAq\u0001\u0005\u0013\u001b\u0005A*#G\u0002\t\u001b5\t\u0001\u0014B\r\u0007\u0011MiA!\u0003\u0002\n\u0003a\u0001\u0002tE\u0013\b\u0011Qi\u0011\u0001'\u0003\u001a\u0007!%R\"\u0001M\u0005S;!9\tS\u0001\t\u00045\t\u0001D\u0001\u000f\u0004#\u000e9Q\u0001A\u0005\u0003\t\u000bA\u0011!\u0004\u0002\u0005\u0007!\u001d\u0011V\u0003\u0003D\u0011\u0006AA!D\u0001\u0019\nE\u001bA!\u0002\u0001\u000e\u0005\u0011)\u00012BU\b\t\u0005C\u0015\u0001\u0003\u0004\u000e\u0003a%\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u000e5\t\u0001dB)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!=Q\"\u0001\r\b#\u000e\tQ\u0001AU\u000b\t\rC\u0015\u0001\u0003\u0005\u000e\u0003a%\u0011k\u0001\u0003\u0006\u00015\u0011A\u0011\u0003E\u0006S+!1\tS\u0001\t\u00135\t\u0001\u0014B)\u0004\t\u0015\u0001QB\u0001C\n\u0011\u0017\u0001"}, strings={"Lorg/jetbrains/kotlin/utils/KotlinJavascriptMetadataUtils;", "", "()V", "ABI_VERSION", "", "ABI_VERSION$annotations", "getABI_VERSION", "()I", "JS_EXT", "", "getJS_EXT", "()Ljava/lang/String;", "KOTLIN_JAVASCRIPT_METHOD_NAME", "KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN", "Ljava/util/regex/Pattern;", "METADATA_PATTERN", "META_JS_SUFFIX", "getMETA_JS_SUFFIX", "VFS_PROTOCOL", "getVFS_PROTOCOL", "formatMetadataAsString", "moduleName", "content", "", "hasMetadata", "", "text", "hasMetadataWithIncompatibleAbiVersion", "isAbiVersionCompatible", "abiVersion", "loadMetadata", "", "Lorg/jetbrains/kotlin/utils/KotlinJavascriptMetadata;", "file", "Ljava/io/File;", "path", "parseMetadata", "", "metadataList", "", "replaceSuffix", "filePath"}, moduleName="kotlin-compiler")
public final class KotlinJavascriptMetadataUtils {
    @NotNull
    public static final String JS_EXT = ".js";
    @NotNull
    public static final String META_JS_SUFFIX = ".meta.js";
    @NotNull
    public static final String VFS_PROTOCOL = "kotlin-js-meta";
    private static final String KOTLIN_JAVASCRIPT_METHOD_NAME = "kotlin_module_metadata";
    private static final Pattern KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN;
    private static final Pattern METADATA_PATTERN;
    public static final int ABI_VERSION = 3;
    public static final KotlinJavascriptMetadataUtils INSTANCE;
    public static final KotlinJavascriptMetadataUtils INSTANCE$;

    @NotNull
    public final String getJS_EXT() {
        return JS_EXT;
    }

    @NotNull
    public final String getMETA_JS_SUFFIX() {
        return META_JS_SUFFIX;
    }

    @NotNull
    public final String getVFS_PROTOCOL() {
        return VFS_PROTOCOL;
    }

    public static final int getABI_VERSION() {
        return ABI_VERSION;
    }

    @NotNull
    public final String replaceSuffix(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull(filePath, "filePath");
        return StringsKt.substringBeforeLast$default(filePath, JS_EXT, null, 2) + META_JS_SUFFIX;
    }

    @JvmStatic
    public static final boolean isAbiVersionCompatible(int abiVersion) {
        return abiVersion == ABI_VERSION;
    }

    @JvmStatic
    public static final boolean hasMetadata(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN.matcher(text).find() && METADATA_PATTERN.matcher(text).find();
    }

    public final boolean hasMetadataWithIncompatibleAbiVersion(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        Matcher matcher = METADATA_PATTERN.matcher(text);
        while (matcher.find()) {
            int abiVersion = StringsKt.toInt(matcher.group(1));
            if (abiVersion == ABI_VERSION) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final String formatMetadataAsString(@NotNull String moduleName, @NotNull byte[] content) {
        Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
        Intrinsics.checkParameterIsNotNull(content, "content");
        return "// Kotlin." + KOTLIN_JAVASCRIPT_METHOD_NAME + "(" + ABI_VERSION + ", " + "\"" + moduleName + "\"" + ", " + "\"" + DatatypeConverter.printBase64Binary((byte[])content) + "\"" + ");" + "\n";
    }

    @JvmStatic
    @NotNull
    public static final List<KotlinJavascriptMetadata> loadMetadata(@NotNull File file) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(file, "file");
        boolean value2 = file.exists();
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value2) {
                String message = "Library " + file + " not found";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        ArrayList<KotlinJavascriptMetadata> metadataList = CollectionsKt.arrayListOf(new KotlinJavascriptMetadata[0]);
        LibraryUtils.traverseJsLibrary(file, (Function2<? super String, ? super String, ? extends Unit>)new Function2<String, String, Unit>(file, metadataList){
            final /* synthetic */ File $file;
            final /* synthetic */ ArrayList $metadataList;

            public final void invoke(@NotNull String content, @NotNull String relativePath) {
                Intrinsics.checkParameterIsNotNull(content, "content");
                Intrinsics.checkParameterIsNotNull(relativePath, "relativePath");
                String path = this.$file.getPath();
                if (StringsKt.isNotBlank((CharSequence)relativePath)) {
                    path = path + ("/" + relativePath);
                }
                KotlinJavascriptMetadataUtils.parseMetadata(content, this.$metadataList);
            }
            {
                this.$file = file;
                this.$metadataList = arrayList;
                super(2);
            }
        });
        return metadataList;
    }

    @JvmStatic
    @NotNull
    public static final List<KotlinJavascriptMetadata> loadMetadata(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return KotlinJavascriptMetadataUtils.loadMetadata(new File(path));
    }

    @JvmStatic
    public static final void parseMetadata(@NotNull String text, @NotNull List<KotlinJavascriptMetadata> metadataList) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        Intrinsics.checkParameterIsNotNull(metadataList, "metadataList");
        if (!KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN.matcher(text).find()) {
            return;
        }
        Matcher matcher = METADATA_PATTERN.matcher(text);
        while (matcher.find()) {
            int abiVersion = StringsKt.toInt(matcher.group(1));
            String moduleName = matcher.group(3);
            String data = matcher.group(5);
            String string = moduleName;
            Intrinsics.checkExpressionValueIsNotNull(string, "moduleName");
            byte[] byArray = DatatypeConverter.parseBase64Binary((String)data);
            Intrinsics.checkExpressionValueIsNotNull(byArray, "parseBase64Binary(data)");
            metadataList.add(new KotlinJavascriptMetadata(abiVersion, string, byArray));
        }
    }

    static {
        new KotlinJavascriptMetadataUtils();
    }

    private KotlinJavascriptMetadataUtils() {
        INSTANCE = this;
        INSTANCE$ = this;
        JS_EXT = JS_EXT;
        META_JS_SUFFIX = META_JS_SUFFIX;
        VFS_PROTOCOL = VFS_PROTOCOL;
        KOTLIN_JAVASCRIPT_METHOD_NAME = KOTLIN_JAVASCRIPT_METHOD_NAME;
        KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN = StringsKt.toPattern$default("\\.kotlin_module_metadata\\(", 0, 1);
        METADATA_PATTERN = StringsKt.toPattern$default("(?m)" + "\\" + "w+" + "\\" + "." + KOTLIN_JAVASCRIPT_METHOD_NAME + "\\" + "((" + "\\" + "d+)," + "\\" + "s*(['" + "\"" + "])([^'" + "\"" + "]*)" + "\\" + "2," + "\\" + "s*(['" + "\"" + "])([^'" + "\"" + "]*)" + "\\" + "4" + "\\" + ")", 0, 1);
        ABI_VERSION = 3;
    }
}

