/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastManager;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class DataFlowAnalyzer {
    private final Iterable<AdditionalTypeChecker> additionalTypeCheckers;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final KotlinBuiltIns builtIns;
    private final SmartCastManager smartCastManager;
    private final ExpressionTypingFacade facade;

    public DataFlowAnalyzer(@NotNull Iterable<AdditionalTypeChecker> additionalTypeCheckers, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull KotlinBuiltIns builtIns, @NotNull SmartCastManager smartCastManager, @NotNull ExpressionTypingFacade facade) {
        if (additionalTypeCheckers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalTypeCheckers", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "<init>"));
        }
        if (constantExpressionEvaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constantExpressionEvaluator", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "<init>"));
        }
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "<init>"));
        }
        if (smartCastManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "smartCastManager", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "<init>"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "<init>"));
        }
        this.additionalTypeCheckers = additionalTypeCheckers;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.builtIns = builtIns;
        this.smartCastManager = smartCastManager;
        this.facade = facade;
    }

    @NotNull
    public DataFlowInfo extractDataFlowInfoFromCondition(@Nullable KtExpression condition, final boolean conditionValue, final ExpressionTypingContext context) {
        if (condition == null) {
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "extractDataFlowInfoFromCondition"));
            }
            return dataFlowInfo;
        }
        final Ref<Object> result2 = new Ref<Object>(null);
        condition.accept(new KtVisitorVoid(){

            @Override
            public void visitIsExpression(@NotNull KtIsExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer$1", "visitIsExpression"));
                }
                if (conditionValue && !expression.isNegated() || !conditionValue && expression.isNegated()) {
                    result2.set(context.trace.get(BindingContext.DATAFLOW_INFO_AFTER_CONDITION, expression));
                }
            }

            @Override
            public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer$1", "visitBinaryExpression"));
                }
                IElementType operationToken = expression.getOperationToken();
                if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationToken)) {
                    DataFlowInfo dataFlowInfo = DataFlowAnalyzer.this.extractDataFlowInfoFromCondition(expression.getLeft(), conditionValue, context);
                    KtExpression expressionRight = expression.getRight();
                    if (expressionRight != null) {
                        boolean and = operationToken == KtTokens.ANDAND;
                        DataFlowInfo rightInfo = DataFlowAnalyzer.this.extractDataFlowInfoFromCondition(expressionRight, conditionValue, and == conditionValue ? (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo) : context);
                        dataFlowInfo = and == conditionValue ? dataFlowInfo.and(rightInfo) : dataFlowInfo.or(rightInfo);
                    }
                    result2.set(dataFlowInfo);
                } else {
                    DataFlowInfo expressionFlowInfo = DataFlowAnalyzer.this.facade.getTypeInfo(expression, context).getDataFlowInfo();
                    KtExpression left = expression.getLeft();
                    if (left == null) {
                        return;
                    }
                    KtExpression right = expression.getRight();
                    if (right == null) {
                        return;
                    }
                    KotlinType lhsType = context.trace.getBindingContext().getType(left);
                    if (lhsType == null) {
                        return;
                    }
                    KotlinType rhsType = context.trace.getBindingContext().getType(right);
                    if (rhsType == null) {
                        return;
                    }
                    DataFlowValue leftValue = DataFlowValueFactory.createDataFlowValue(left, lhsType, context);
                    DataFlowValue rightValue = DataFlowValueFactory.createDataFlowValue(right, rhsType, context);
                    Boolean equals = null;
                    if (operationToken == KtTokens.EQEQ || operationToken == KtTokens.EQEQEQ) {
                        equals = true;
                    } else if (operationToken == KtTokens.EXCLEQ || operationToken == KtTokens.EXCLEQEQEQ) {
                        equals = false;
                    }
                    if (equals != null) {
                        if (equals == conditionValue) {
                            result2.set(context.dataFlowInfo.equate(leftValue, rightValue).and(expressionFlowInfo));
                        } else {
                            result2.set(context.dataFlowInfo.disequate(leftValue, rightValue).and(expressionFlowInfo));
                        }
                    } else {
                        result2.set(expressionFlowInfo);
                    }
                }
            }

            @Override
            public void visitUnaryExpression(@NotNull KtUnaryExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer$1", "visitUnaryExpression"));
                }
                IElementType operationTokenType = expression.getOperationReference().getReferencedNameElementType();
                if (operationTokenType == KtTokens.EXCL) {
                    KtExpression baseExpression = expression.getBaseExpression();
                    if (baseExpression != null) {
                        result2.set(DataFlowAnalyzer.this.extractDataFlowInfoFromCondition(baseExpression, !conditionValue, context));
                    }
                } else {
                    this.visitExpression(expression);
                }
            }

            @Override
            public void visitExpression(@NotNull KtExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer$1", "visitExpression"));
                }
                result2.set(DataFlowAnalyzer.this.facade.getTypeInfo(expression, context).getDataFlowInfo());
            }

            @Override
            public void visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer$1", "visitParenthesizedExpression"));
                }
                KtExpression body = expression.getExpression();
                if (body != null) {
                    body.accept(this);
                }
            }
        });
        if (result2.get() == null) {
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "extractDataFlowInfoFromCondition"));
            }
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = context.dataFlowInfo.and(result2.get());
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "extractDataFlowInfoFromCondition"));
        }
        return dataFlowInfo;
    }

    @Nullable
    public KotlinType checkType(@Nullable KotlinType expressionType, @NotNull KtExpression expression, @NotNull ResolutionContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkType"));
        }
        return this.checkType(expressionType, expression, context, null);
    }

    @NotNull
    public KotlinTypeInfo checkType(@NotNull KotlinTypeInfo typeInfo, @NotNull KtExpression expression, @NotNull ResolutionContext context) {
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkType"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkType"));
        }
        KotlinTypeInfo kotlinTypeInfo = typeInfo.replaceType(this.checkType(typeInfo.getType(), expression, context));
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkType"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinType checkTypeInternal(@NotNull KotlinType expressionType, @NotNull KtExpression expression, @NotNull ResolutionContext c, @NotNull Ref<Boolean> hasError) {
        if (expressionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionType", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
        }
        if (hasError == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hasError", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
        }
        if (TypeUtils.noExpectedType(c.expectedType) || !c.expectedType.getConstructor().isDenotable() || KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, c.expectedType)) {
            KotlinType kotlinType = expressionType;
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
            }
            return kotlinType;
        }
        if (expression instanceof KtConstantExpression) {
            ConstantValue<?> constantValue = this.constantExpressionEvaluator.evaluateToConstantValue(expression, c.trace, c.expectedType);
            boolean error = new CompileTimeConstantChecker(c.trace, this.builtIns, true).checkConstantExpressionType(constantValue, (KtConstantExpression)expression, c.expectedType);
            if (hasError != null) {
                hasError.set(error);
            }
            KotlinType kotlinType = expressionType;
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
            }
            return kotlinType;
        }
        if (expression instanceof KtWhenExpression) {
            KotlinType kotlinType = expressionType;
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
            }
            return kotlinType;
        }
        KotlinType possibleType = this.checkPossibleCast(expressionType, expression, c);
        if (possibleType != null) {
            KotlinType kotlinType = possibleType;
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
            }
            return kotlinType;
        }
        c.trace.report(Errors.TYPE_MISMATCH.on(expression, c.expectedType, expressionType));
        if (hasError != null) {
            hasError.set(true);
        }
        KotlinType kotlinType = expressionType;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
        }
        return kotlinType;
    }

    @Nullable
    public KotlinType checkType(@Nullable KotlinType expressionType, @NotNull KtExpression expressionToCheck, @NotNull ResolutionContext c, @Nullable Ref<Boolean> hasError) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkType"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkType"));
        }
        if (hasError == null) {
            hasError = Ref.create(false);
        } else {
            hasError.set(false);
        }
        KtExpression expression = KtPsiUtil.safeDeparenthesize(expressionToCheck);
        this.recordExpectedType(c.trace, expression, c.expectedType);
        if (expressionType == null) {
            return null;
        }
        KotlinType result2 = this.checkTypeInternal(expressionType, expression, c, hasError);
        if (Boolean.FALSE.equals(hasError.get())) {
            for (AdditionalTypeChecker checker : this.additionalTypeCheckers) {
                checker.checkType(expression, expressionType, result2, c);
            }
        }
        return result2;
    }

    @Nullable
    public KotlinType checkPossibleCast(@NotNull KotlinType expressionType, @NotNull KtExpression expression, @NotNull ResolutionContext c) {
        if (expressionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionType", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkPossibleCast"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkPossibleCast"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkPossibleCast"));
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, expressionType, c);
        SmartCastResult result2 = SmartCastManager.checkAndRecordPossibleCast(dataFlowValue, c.expectedType, expression, c, false);
        return result2 != null ? result2.getResultType() : null;
    }

    public void recordExpectedType(@NotNull BindingTrace trace, @NotNull KtExpression expression, @NotNull KotlinType expectedType) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "recordExpectedType"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "recordExpectedType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "recordExpectedType"));
        }
        if (expectedType != TypeUtils.NO_EXPECTED_TYPE) {
            KotlinType normalizeExpectedType = expectedType == TypeUtils.UNIT_EXPECTED_TYPE ? this.builtIns.getUnitType() : expectedType;
            trace.record(BindingContext.EXPECTED_EXPRESSION_TYPE, expression, normalizeExpectedType);
        }
    }

    @Nullable
    public KotlinType checkStatementType(@NotNull KtExpression expression, @NotNull ResolutionContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkStatementType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkStatementType"));
        }
        if (!(TypeUtils.noExpectedType(context.expectedType) || KotlinBuiltIns.isUnit(context.expectedType) || context.expectedType.isError())) {
            context.trace.report(Errors.EXPECTED_TYPE_MISMATCH.on(expression, context.expectedType));
            return null;
        }
        return this.builtIns.getUnitType();
    }

    @Nullable
    public KotlinType checkImplicitCast(@Nullable KotlinType expressionType, @NotNull KtExpression expression, @NotNull ResolutionContext context, boolean isStatement) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkImplicitCast"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkImplicitCast"));
        }
        boolean isIfExpression = expression instanceof KtIfExpression;
        if (!(expressionType == null || context.expectedType != TypeUtils.NO_EXPECTED_TYPE && !isIfExpression || context.contextDependency != ContextDependency.INDEPENDENT || isStatement || !KotlinBuiltIns.isUnit(expressionType) && !KotlinBuiltIns.isAnyOrNullableAny(expressionType) || DynamicTypesKt.isDynamic(expressionType))) {
            if (isIfExpression && KotlinBuiltIns.isUnit(expressionType)) {
                KtIfExpression ifExpression = (KtIfExpression)expression;
                if (ifExpression.getThen() == null || ifExpression.getElse() == null) {
                    context.trace.report(Errors.INVALID_IF_AS_EXPRESSION.on((KtIfExpression)expression));
                    return expressionType;
                }
            } else {
                if (isIfExpression && context.expectedType != TypeUtils.NO_EXPECTED_TYPE) {
                    return expressionType;
                }
                context.trace.report(Errors.IMPLICIT_CAST_TO_UNIT_OR_ANY.on(expression, expressionType));
            }
        }
        return expressionType;
    }

    @NotNull
    public KotlinTypeInfo checkImplicitCast(@NotNull KotlinTypeInfo typeInfo, @NotNull KtExpression expression, @NotNull ResolutionContext context, boolean isStatement) {
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkImplicitCast"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkImplicitCast"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkImplicitCast"));
        }
        KotlinTypeInfo kotlinTypeInfo = typeInfo.replaceType(this.checkImplicitCast(typeInfo.getType(), expression, context, isStatement));
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkImplicitCast"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo illegalStatementType(@NotNull KtExpression expression, @NotNull ExpressionTypingContext context, @NotNull ExpressionTypingInternals facade) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "illegalStatementType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "illegalStatementType"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "illegalStatementType"));
        }
        facade.checkStatementType(expression, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        context.trace.report(Errors.EXPRESSION_EXPECTED.on(expression, expression));
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "illegalStatementType"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public Collection<KotlinType> getAllPossibleTypes(@NotNull KtExpression expression, @NotNull DataFlowInfo dataFlowInfo, @NotNull KotlinType type2, @NotNull ResolutionContext c) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "getAllPossibleTypes"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "getAllPossibleTypes"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "getAllPossibleTypes"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "getAllPossibleTypes"));
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, type2, c);
        HashSet<KotlinType> possibleTypes = Sets.newHashSet(type2);
        if (dataFlowValue.isPredictable()) {
            possibleTypes.addAll(dataFlowInfo.getPossibleTypes(dataFlowValue));
        }
        HashSet<KotlinType> hashSet = possibleTypes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "getAllPossibleTypes"));
        }
        return hashSet;
    }

    @NotNull
    public KotlinTypeInfo createCheckedTypeInfo(@Nullable KotlinType type2, @NotNull ResolutionContext<?> context, @NotNull KtExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "createCheckedTypeInfo"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "createCheckedTypeInfo"));
        }
        KotlinTypeInfo kotlinTypeInfo = this.checkType(TypeInfoFactoryKt.createTypeInfo(type2, context), expression, context);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "createCheckedTypeInfo"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo createCompileTimeConstantTypeInfo(@NotNull CompileTimeConstant<?> value2, @NotNull KtExpression expression, @NotNull ExpressionTypingContext context) {
        KotlinType expressionType;
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "createCompileTimeConstantTypeInfo"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "createCompileTimeConstantTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "createCompileTimeConstantTypeInfo"));
        }
        if (value2 instanceof IntegerValueTypeConstant) {
            IntegerValueTypeConstant integerValueTypeConstant = (IntegerValueTypeConstant)value2;
            if (context.contextDependency == ContextDependency.INDEPENDENT) {
                expressionType = integerValueTypeConstant.getType(context.expectedType);
                this.constantExpressionEvaluator.updateNumberType(expressionType, expression, context.statementFilter, context.trace);
            } else {
                expressionType = integerValueTypeConstant.getUnknownIntegerType();
            }
        } else {
            expressionType = ((TypedCompileTimeConstant)value2).getType();
        }
        KotlinTypeInfo kotlinTypeInfo = this.createCheckedTypeInfo(expressionType, context, expression);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "createCompileTimeConstantTypeInfo"));
        }
        return kotlinTypeInfo;
    }
}

