/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\r\u0001e\t\u0001\u0014AQ\u0003#\u000e\t\u0001\"A\u0013\u0015\t-A\u0019!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\rI2\u0001c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!G\u0002\t\f5\t\u0001D\u0002"}, strings={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/TypeParameterBoundIsNotArrayChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;"}, moduleName="kotlin-compiler")
public final class TypeParameterBoundIsNotArrayChecker
implements DeclarationChecker {
    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        List<TypeParameterDescriptor> list;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        if ((list = (CallableDescriptor)declarationDescriptor) == null || (list = list.getTypeParameters()) == null) {
            Annotated annotated;
            DeclarationDescriptor declarationDescriptor2 = descriptor2;
            if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                declarationDescriptor2 = null;
            }
            list = (annotated = (ClassDescriptor)declarationDescriptor2) != null && (annotated = annotated.getTypeConstructor()) != null ? annotated.getParameters() : null;
        }
        if (list == null) {
            return;
        }
        List<TypeParameterDescriptor> typeParameters = list;
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            boolean bl;
            block7: {
                void $receiver;
                Iterable iterable = typeParameter.getUpperBounds();
                for (Object element : $receiver) {
                    KotlinType it2 = (KotlinType)element;
                    if (!(KotlinBuiltIns.isArray(it2) || KotlinBuiltIns.isPrimitiveArray(it2))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            if (!bl) continue;
            DeclarationDescriptor declarationDescriptor3 = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor3, "typeParameter");
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor3);
            if (psiElement2 == null) {
                psiElement2 = declaration;
            }
            PsiElement element = psiElement2;
            diagnosticHolder.report(ErrorsJvm.UPPER_BOUND_CANNOT_BE_ARRAY.on(element));
        }
    }
}

