/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u000f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\b\u0006\u00015]\u0001\u0002A\u0007\u00021\u0003Ib\u0001C\u0001\u000e\t%\u0011\u0011\"\u0001M\u00011\u0007!6A\u0001"}, strings={"findMemberWithMaxVisibility", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "descriptors", "", "VisibilityUtilKt"}, moduleName="kotlin-compiler")
public final class VisibilityUtilKt {
    @NotNull
    public static final CallableMemberDescriptor findMemberWithMaxVisibility(@NotNull Collection<? extends CallableMemberDescriptor> descriptors) {
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        PreconditionsKt.assert(CollectionsKt.isNotEmpty(descriptors));
        CallableMemberDescriptor descriptor2 = null;
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            if (descriptor2 == null) {
                descriptor2 = callableMemberDescriptor;
                continue;
            }
            Integer result2 = Visibilities.compare(descriptor2.getVisibility(), callableMemberDescriptor.getVisibility());
            if (result2 == null || ((Number)result2).intValue() >= 0) continue;
            descriptor2 = callableMemberDescriptor;
        }
        CallableMemberDescriptor callableMemberDescriptor = descriptor2;
        if (callableMemberDescriptor == null) {
            Intrinsics.throwNpe();
        }
        return callableMemberDescriptor;
    }
}

