/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import com.intellij.openapi.Disposable;
import java.io.PrintStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CompilerPlugin;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.Usage;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.relocated.com.sampullara.cli.Args;
import org.jetbrains.kotlin.relocated.org.fusesource.jansi.AnsiConsole;

public abstract class CLICompiler<A extends CommonCompilerArguments> {
    @NotNull
    private List<CompilerPlugin> compilerPlugins = Lists.newArrayList();

    @NotNull
    public List<CompilerPlugin> getCompilerPlugins() {
        List<CompilerPlugin> list = this.compilerPlugins;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "getCompilerPlugins"));
        }
        return list;
    }

    public void setCompilerPlugins(@NotNull List<CompilerPlugin> compilerPlugins) {
        if (compilerPlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerPlugins", "org/jetbrains/kotlin/cli/common/CLICompiler", "setCompilerPlugins"));
        }
        this.compilerPlugins = compilerPlugins;
    }

    @NotNull
    public ExitCode exec(@NotNull PrintStream errStream, String ... args) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
        }
        ExitCode exitCode = this.exec(errStream, Services.EMPTY, MessageRenderer.PLAIN_RELATIVE_PATHS, args);
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
        }
        return exitCode;
    }

    @NotNull
    public ExitCode execAndOutputXml(@NotNull PrintStream errStream, @NotNull Services services, String ... args) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/kotlin/cli/common/CLICompiler", "execAndOutputXml"));
        }
        if (services == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "services", "org/jetbrains/kotlin/cli/common/CLICompiler", "execAndOutputXml"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/cli/common/CLICompiler", "execAndOutputXml"));
        }
        ExitCode exitCode = this.exec(errStream, services, MessageRenderer.XML, args);
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "execAndOutputXml"));
        }
        return exitCode;
    }

    @NotNull
    public ExitCode execFullPathsInMessages(@NotNull PrintStream errStream, @NotNull String[] args) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/kotlin/cli/common/CLICompiler", "execFullPathsInMessages"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/cli/common/CLICompiler", "execFullPathsInMessages"));
        }
        ExitCode exitCode = this.exec(errStream, Services.EMPTY, MessageRenderer.PLAIN_FULL_PATHS, args);
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "execFullPathsInMessages"));
        }
        return exitCode;
    }

    @Nullable
    private A parseArguments(@NotNull PrintStream errStream, @NotNull MessageRenderer messageRenderer, @NotNull String[] args) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/kotlin/cli/common/CLICompiler", "parseArguments"));
        }
        if (messageRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageRenderer", "org/jetbrains/kotlin/cli/common/CLICompiler", "parseArguments"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/cli/common/CLICompiler", "parseArguments"));
        }
        try {
            A arguments2 = this.createArguments();
            ((CommonCompilerArguments)arguments2).freeArgs = Args.parse(arguments2, args);
            return arguments2;
        }
        catch (IllegalArgumentException e) {
            errStream.println(e.getMessage());
            this.usage(errStream, false);
        }
        catch (Throwable t) {
            errStream.println(messageRenderer.render(CompilerMessageSeverity.EXCEPTION, OutputMessageUtil.renderException(t), CompilerMessageLocation.NO_LOCATION));
        }
        return null;
    }

    protected void usage(@NotNull PrintStream target, boolean extraHelp) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/cli/common/CLICompiler", "usage"));
        }
        Usage.print(target, this.createArguments(), extraHelp);
    }

    protected void configureEnvironment(@NotNull CompilerConfiguration configuration, @NotNull A arguments2) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/common/CLICompiler", "configureEnvironment"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cli/common/CLICompiler", "configureEnvironment"));
        }
        configuration.addAll(CLIConfigurationKeys.COMPILER_PLUGINS, this.compilerPlugins);
    }

    @NotNull
    protected abstract A createArguments();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ExitCode exec(@NotNull PrintStream errStream, @NotNull Services services, @NotNull MessageRenderer messageRenderer, @NotNull String[] args) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
        }
        if (services == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "services", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
        }
        if (messageRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageRenderer", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
        }
        K2JVMCompiler.Companion.resetInitStartTime();
        A arguments2 = this.parseArguments(errStream, messageRenderer, args);
        if (arguments2 == null) {
            ExitCode exitCode = ExitCode.INTERNAL_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
            }
            return exitCode;
        }
        if (((CommonCompilerArguments)arguments2).help || ((CommonCompilerArguments)arguments2).extraHelp) {
            this.usage(errStream, ((CommonCompilerArguments)arguments2).extraHelp);
            ExitCode exitCode = ExitCode.OK;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
            }
            return exitCode;
        }
        PrintingMessageCollector collector2 = new PrintingMessageCollector(errStream, messageRenderer, ((CommonCompilerArguments)arguments2).verbose);
        AnsiConsole.systemInstall();
        errStream.print(messageRenderer.renderPreamble());
        ExitCode exitCode = this.exec(collector2, services, arguments2);
        ExitCode exitCode2 = exitCode;
        if (exitCode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
        }
        return exitCode2;
        finally {
            errStream.print(messageRenderer.renderConclusion());
            AnsiConsole.systemUninstall();
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public ExitCode exec(@NotNull MessageCollector messageCollector, @NotNull Services services, @NotNull A arguments) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    protected abstract ExitCode doExecute(@NotNull A var1, @NotNull Services var2, @NotNull MessageCollector var3, @NotNull Disposable var4);

    protected void printVersionIfNeeded(@NotNull MessageCollector messageCollector, @NotNull A arguments2) {
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/cli/common/CLICompiler", "printVersionIfNeeded"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cli/common/CLICompiler", "printVersionIfNeeded"));
        }
        if (!((CommonCompilerArguments)arguments2).version) {
            return;
        }
        messageCollector.report(CompilerMessageSeverity.INFO, "Kotlin Compiler version 1.0.0-beta-2423", CompilerMessageLocation.NO_LOCATION);
    }

    public static void doMain(@NotNull CLICompiler compiler, @NotNull String[] args) {
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "org/jetbrains/kotlin/cli/common/CLICompiler", "doMain"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/cli/common/CLICompiler", "doMain"));
        }
        System.setProperty("java.awt.headless", "true");
        ExitCode exitCode = CLICompiler.doMainNoExit(compiler, args);
        if (exitCode != ExitCode.OK) {
            System.exit(exitCode.getCode());
        }
    }

    @NotNull
    public static ExitCode doMainNoExit(@NotNull CLICompiler compiler, @NotNull String[] args) {
        ExitCode exitCode;
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "org/jetbrains/kotlin/cli/common/CLICompiler", "doMainNoExit"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/cli/common/CLICompiler", "doMainNoExit"));
        }
        try {
            exitCode = compiler.exec(System.err, args);
        }
        catch (CompileEnvironmentException e) {
            System.err.println(e.getMessage());
            ExitCode exitCode2 = ExitCode.INTERNAL_ERROR;
            if (exitCode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "doMainNoExit"));
            }
            return exitCode2;
        }
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "doMainNoExit"));
        }
        return exitCode;
    }
}

