/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.rmi;

import java.io.File;
import java.util.Iterator;
import kotlin.ArraysKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.rmi.FileSystem$WhenMappings;
import org.jetbrains.kotlin.rmi.FileSystemUtilsKt;
import org.jetbrains.kotlin.rmi.OSKind;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001b\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001\u0003\u0006\u000b\u0005A\t\"\u0002\u0001\u0005G\u0006a\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQu\u0004E\u0007\u001b\u0005A\"!G\u0005\t\u000f5)\u0011b\u0001C\u0001\u0013\u0005A\"\u0001g\u0004\u0012\u0003a\u0011\u0011kA\u0001\t\u0011%RAa\u0011\u0005\t\u00045\t\u0001D\u0001\u000f$#\u000e\u0019QB\u0001C\u0003\u0011\rI#\u0002B\"\t\u0011\u000fi\u0011\u0001\u0007\u0002\u001dGE\u001b1!\u0004\u0002\u0005\t!\u0019\u0011F\u0003\u0003D\u0011!%Q\"\u0001\r\u00039\r\n6aA\u0007\u0003\t\u0015A1!\u000b\u0006\u0005\u0007\"AY!D\u0001\u0019\u0005q\u0019\u0013kA\u0002\u000e\u0005\u00111\u0001b\u0001"}, strings={"Lorg/jetbrains/kotlin/rmi/FileSystem;", "", "()V", "logFilesPath", "", "getLogFilesPath", "()Ljava/lang/String;", "runtimeStateFilesBasePath", "getRuntimeStateFilesBasePath", "tempPath", "getTempPath", "userHomePath", "getUserHomePath", "getRuntimeStateFilesPath", "names", "", "([Ljava/lang/String;)Ljava/lang/String;"}, moduleName="kotlin-compiler")
public final class FileSystem {
    public static final FileSystem INSTANCE;
    public static final FileSystem INSTANCE$;

    @NotNull
    public final String getUserHomePath() {
        String string = System.getProperty("user.home");
        Intrinsics.checkExpressionValueIsNotNull(string, "System.getProperty(\"user.home\")");
        return string;
    }

    @NotNull
    public final String getTempPath() {
        String string = System.getProperty("java.io.tmpdir");
        Intrinsics.checkExpressionValueIsNotNull(string, "System.getProperty(\"java.io.tmpdir\")");
        return string;
    }

    @NotNull
    public final String getLogFilesPath() {
        return this.getTempPath();
    }

    @NotNull
    public final String getRuntimeStateFilesBasePath() {
        String string;
        switch (FileSystem$WhenMappings.$EnumSwitchMapping$0[OSKind.Companion.getCurrent().ordinal()]) {
            case 1: {
                string = FileSystemUtilsKt.access$orDefault(System.getenv("LOCALAPPDATA"), this.getTempPath());
                break;
            }
            case 2: {
                string = this.getUserHomePath() + "/Library/Application Support";
                break;
            }
            case 3: {
                string = FileSystemUtilsKt.access$orDefault(System.getenv("XDG_DATA_HOME"), this.getUserHomePath() + "/.local/share");
                break;
            }
            case 4: {
                string = this.getTempPath();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getRuntimeStateFilesPath(String ... names2) {
        File file;
        Object r;
        Object accumulator;
        Object $receiver;
        Intrinsics.checkParameterIsNotNull(names2, "names");
        PreconditionsKt.assert(ArraysKt.any((Object[])names2));
        File base = new File(this.getRuntimeStateFilesBasePath());
        if (base.exists() && base.isDirectory()) {
            $receiver = names2;
            accumulator = base;
            for (int i = 0; i < ((Object[])$receiver).length; ++i) {
                void v;
                Object element = $receiver[i];
                String string = (String)element;
                r = (File)accumulator;
                accumulator = new File((File)r, (String)v);
            }
            file = (File)accumulator;
        } else {
            void initial;
            File $receiver2;
            File file2;
            $receiver = ArraysKt.drop((Object[])names2, 1);
            accumulator = ArraysKt.first((Object[])names2);
            String string = this.getUserHomePath();
            File file3 = file2;
            File file4 = file2;
            String it2 = (String)((Object)$receiver2);
            String string2 = StringsKt.startsWith$default(it2, ".", false, 2) ? it2 : "." + it2;
            file3(string, string2);
            $receiver2 = file4;
            File accumulator2 = initial;
            Iterator iterator2 = $receiver.iterator();
            while (iterator2.hasNext()) {
                void v;
                Object element = iterator2.next();
                r = (String)element;
                File r2 = accumulator2;
                accumulator2 = new File(r2, (String)v);
            }
            file = accumulator2;
        }
        File dir = file;
        return dir.exists() && dir.isDirectory() || dir.mkdirs() ? dir.getAbsolutePath() : this.getTempPath();
    }

    static {
        new FileSystem();
    }

    private FileSystem() {
        INSTANCE = this;
        INSTANCE$ = this;
    }
}

