/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.relocated.javax.inject.Inject;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProviderImpl;
import org.jetbrains.kotlin.resolve.lazy.NoDescriptorForDeclarationException;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.storage.LockBasedLazyResolveStorageManager;

public class LazyDeclarationResolver {
    @NotNull
    private final TopLevelDescriptorProvider topLevelDescriptorProvider;
    @NotNull
    private final BindingTrace trace;
    protected DeclarationScopeProvider scopeProvider;

    @Inject
    public void setDeclarationScopeProvider(@NotNull DeclarationScopeProviderImpl scopeProvider) {
        if (scopeProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeProvider", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "setDeclarationScopeProvider"));
        }
        this.scopeProvider = scopeProvider;
    }

    @Deprecated
    public LazyDeclarationResolver(@NotNull GlobalContext globalContext, @NotNull BindingTrace delegationTrace, @NotNull TopLevelDescriptorProvider topLevelDescriptorProvider) {
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "<init>"));
        }
        if (delegationTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegationTrace", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "<init>"));
        }
        if (topLevelDescriptorProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelDescriptorProvider", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "<init>"));
        }
        this.topLevelDescriptorProvider = topLevelDescriptorProvider;
        LockBasedLazyResolveStorageManager lockBasedLazyResolveStorageManager = new LockBasedLazyResolveStorageManager(globalContext.getStorageManager());
        this.trace = lockBasedLazyResolveStorageManager.createSafeTrace(delegationTrace);
    }

    @NotNull
    public ClassDescriptor getClassDescriptor(@NotNull KtClassOrObject classOrObject, @NotNull LookupLocation location2) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "getClassDescriptor"));
        }
        if (location2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "getClassDescriptor"));
        }
        MemberScope scope2 = this.getMemberScopeDeclaredIn(classOrObject, location2);
        ClassifierDescriptor scopeDescriptor = scope2.getContributedClassifier(classOrObject.getNameAsSafeName(), location2);
        DeclarationDescriptor descriptor2 = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, classOrObject);
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Could not find a classifier for %s.\nFound descriptor: %s (%s).\n", PsiUtilsKt.getElementTextWithContext(classOrObject), scopeDescriptor != null ? DescriptorRenderer.DEBUG_TEXT.render(scopeDescriptor) : "null", scopeDescriptor != null ? scopeDescriptor.getContainingDeclaration().getClass() : null));
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "getClassDescriptor"));
        }
        return classDescriptor;
    }

    @NotNull
    private BindingContext getBindingContext() {
        BindingContext bindingContext2 = this.trace.getBindingContext();
        if (bindingContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "getBindingContext"));
        }
        return bindingContext2;
    }

    @NotNull
    public DeclarationDescriptor resolveToDescriptor(@NotNull KtDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "resolveToDescriptor"));
        }
        DeclarationDescriptor declarationDescriptor = this.resolveToDescriptor(declaration, true);
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "resolveToDescriptor"));
        }
        return declarationDescriptor;
    }

    @NotNull
    private DeclarationDescriptor resolveToDescriptor(@NotNull KtDeclaration declaration, final boolean track) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "resolveToDescriptor"));
        }
        DeclarationDescriptor result2 = declaration.accept(new KtVisitor<DeclarationDescriptor, Void>(){

            @NotNull
            private LookupLocation lookupLocationFor(@NotNull KtDeclaration declaration, boolean isTopLevel) {
                if (declaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "lookupLocationFor"));
                }
                LookupLocation lookupLocation = isTopLevel && track ? new KotlinLookupLocation(declaration) : NoLookupLocation.WHEN_RESOLVE_DECLARATION;
                if (lookupLocation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "lookupLocationFor"));
                }
                return lookupLocation;
            }

            @Override
            public DeclarationDescriptor visitClass(@NotNull KtClass klass, Void data) {
                if (klass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitClass"));
                }
                return LazyDeclarationResolver.this.getClassDescriptor(klass, this.lookupLocationFor(klass, klass.isTopLevel()));
            }

            @Override
            public DeclarationDescriptor visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, Void data) {
                if (declaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitObjectDeclaration"));
                }
                return LazyDeclarationResolver.this.getClassDescriptor(declaration, this.lookupLocationFor(declaration, declaration.isTopLevel()));
            }

            @Override
            public DeclarationDescriptor visitTypeParameter(@NotNull KtTypeParameter parameter, Void data) {
                List<TypeParameterDescriptor> typeParameters;
                if (parameter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitTypeParameter"));
                }
                KtTypeParameterListOwner ownerElement = PsiTreeUtil.getParentOfType((PsiElement)parameter, KtTypeParameterListOwner.class);
                assert (ownerElement != null) : "Owner not found for type parameter: " + parameter.getText();
                DeclarationDescriptor ownerDescriptor = LazyDeclarationResolver.this.resolveToDescriptor(ownerElement, false);
                if (ownerDescriptor instanceof CallableDescriptor) {
                    CallableDescriptor callableDescriptor = (CallableDescriptor)ownerDescriptor;
                    typeParameters = callableDescriptor.getTypeParameters();
                } else if (ownerDescriptor instanceof ClassDescriptor) {
                    ClassDescriptor classDescriptor = (ClassDescriptor)ownerDescriptor;
                    typeParameters = classDescriptor.getTypeConstructor().getParameters();
                } else {
                    throw new IllegalStateException("Unknown owner kind for a type parameter: " + ownerDescriptor);
                }
                Name name = parameter.getNameAsSafeName();
                for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
                    if (!typeParameterDescriptor.getName().equals(name)) continue;
                    return typeParameterDescriptor;
                }
                throw new IllegalStateException("Type parameter " + name + " not found for " + ownerDescriptor);
            }

            @Override
            public DeclarationDescriptor visitNamedFunction(@NotNull KtNamedFunction function, Void data) {
                if (function == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitNamedFunction"));
                }
                LookupLocation location2 = this.lookupLocationFor(function, function.isTopLevel());
                MemberScope scopeForDeclaration = LazyDeclarationResolver.this.getMemberScopeDeclaredIn(function, location2);
                scopeForDeclaration.getContributedFunctions(function.getNameAsSafeName(), location2);
                return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, function);
            }

            @Override
            public DeclarationDescriptor visitParameter(@NotNull KtParameter parameter, Void data) {
                if (parameter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitParameter"));
                }
                PsiElement grandFather = parameter.getParent().getParent();
                if (grandFather instanceof KtPrimaryConstructor) {
                    KtClassOrObject jetClass = ((KtPrimaryConstructor)grandFather).getContainingClassOrObject();
                    ClassDescriptor classDescriptor = LazyDeclarationResolver.this.getClassDescriptor(jetClass, this.lookupLocationFor(jetClass, false));
                    if (parameter.hasValOrVar()) {
                        classDescriptor.getDefaultType().getMemberScope().getContributedVariables(parameter.getNameAsSafeName(), this.lookupLocationFor(parameter, false));
                        return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
                    }
                    ConstructorDescriptor constructor = classDescriptor.getUnsubstitutedPrimaryConstructor();
                    assert (constructor != null) : "There are constructor parameters found, so a constructor should also exist";
                    constructor.getValueParameters();
                    return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
                }
                if (grandFather instanceof KtNamedFunction) {
                    FunctionDescriptor function = (FunctionDescriptor)this.visitNamedFunction((KtNamedFunction)grandFather, data);
                    function.getValueParameters();
                    return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
                }
                if (grandFather instanceof KtSecondaryConstructor) {
                    ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)this.visitSecondaryConstructor((KtSecondaryConstructor)grandFather, data);
                    constructorDescriptor.getValueParameters();
                    return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
                }
                return (DeclarationDescriptor)super.visitParameter(parameter, data);
            }

            @Override
            public DeclarationDescriptor visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor, Void data) {
                if (constructor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitSecondaryConstructor"));
                }
                LazyDeclarationResolver.this.getClassDescriptor((KtClassOrObject)constructor.getParent().getParent(), this.lookupLocationFor(constructor, false)).getConstructors();
                return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.CONSTRUCTOR, constructor);
            }

            @Override
            public DeclarationDescriptor visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor, Void data) {
                if (constructor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitPrimaryConstructor"));
                }
                LazyDeclarationResolver.this.getClassDescriptor(constructor.getContainingClassOrObject(), this.lookupLocationFor(constructor, false)).getConstructors();
                return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.CONSTRUCTOR, constructor);
            }

            @Override
            public DeclarationDescriptor visitProperty(@NotNull KtProperty property, Void data) {
                if (property == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitProperty"));
                }
                LookupLocation location2 = this.lookupLocationFor(property, property.isTopLevel());
                MemberScope scopeForDeclaration = LazyDeclarationResolver.this.getMemberScopeDeclaredIn(property, location2);
                scopeForDeclaration.getContributedVariables(property.getNameAsSafeName(), location2);
                return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, property);
            }

            @Override
            public DeclarationDescriptor visitScript(@NotNull KtScript script, Void data) {
                if (script == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitScript"));
                }
                return LazyDeclarationResolver.this.topLevelDescriptorProvider.getScriptDescriptor(script);
            }

            @Override
            public DeclarationDescriptor visitKtElement(@NotNull KtElement element, Void data) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitKtElement"));
                }
                throw new IllegalArgumentException("Unsupported declaration type: " + element + " " + PsiUtilsKt.getElementTextWithContext(element));
            }
        }, null);
        if (result2 == null) {
            throw new NoDescriptorForDeclarationException(declaration);
        }
        DeclarationDescriptor declarationDescriptor = result2;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "resolveToDescriptor"));
        }
        return declarationDescriptor;
    }

    @NotNull
    MemberScope getMemberScopeDeclaredIn(@NotNull KtDeclaration declaration, @NotNull LookupLocation location2) {
        boolean isTopLevel;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "getMemberScopeDeclaredIn"));
        }
        if (location2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "getMemberScopeDeclaredIn"));
        }
        KtDeclaration parentDeclaration = KtStubbedPsiUtil.getContainingDeclaration(declaration);
        boolean bl = isTopLevel = parentDeclaration == null;
        if (isTopLevel) {
            FqName fqName2 = ((KtFile)declaration.getContainingFile()).getPackageFqName();
            LazyPackageDescriptor packageDescriptor = this.topLevelDescriptorProvider.getPackageFragment(fqName2);
            assert (packageDescriptor != null);
            MemberScope memberScope2 = packageDescriptor.getMemberScope();
            if (memberScope2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "getMemberScopeDeclaredIn"));
            }
            return memberScope2;
        }
        if (parentDeclaration instanceof KtClassOrObject) {
            MemberScope memberScope3 = this.getClassDescriptor((KtClassOrObject)parentDeclaration, location2).getUnsubstitutedMemberScope();
            if (memberScope3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "getMemberScopeDeclaredIn"));
            }
            return memberScope3;
        }
        throw new IllegalStateException("Don't call this method for local declarations: " + declaration + "\n" + PsiUtilsKt.getElementTextWithContext(declaration));
    }
}

