/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.tree.IElementType;
import java.math.BigInteger;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.evaluate.BinaryOperationKey;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt$WhenMappings;
import org.jetbrains.kotlin.resolve.constants.evaluate.UnaryOperationKey;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001b\u0004)\u0001!B\u0001\r\u0003\u0015\t\u0001\u0002A\u0003\u0002\t\t)\u0011\u0001c\u0003\u0006\u0003\u0011\tQ!\u0001E\u0003\u000b\u0005!\u0011!B\u0001\t\r\u0015\tA!A\u0003\u0002\u0011\r)\u0011\u0001B\u0001\u0006\u0003!\u001dQ!\u0001\u0003\u0002\u000b\u0005AA!B\u0001\u0005\u0003\u0015\t\u0001\u0012B\u0003\u0002\t\u0005)\u0011\u0001C\u0003\u0006\u0003\u0011\tQ!\u0001\u0005\b\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0003\u0004\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u000e\u0015\tA\"A\u0003\u0002\u0019\u0005iY\u001c\u0001C\u0001\u0011Ciq%\u0003\u0005\n\u000f%\u0011\u0011\"\u0001\u0013\u0013\u0013\tI\u0011\u0001*\n\u0019$%a\u0012bG\u0005\u000e\u00131I1!\u0003\u0002\r\u0002a\t\u0011bA\u0005\u0003\u0019\u0003A\u0012!\u0003\u0002\n\u0003a\t\u0001dE\u0005\f\u0013)I!!C\u0001\u0019(%\u0011\u0011\"\u0001M\u0014\u0013\tI\u0011\u0001g\n\u0019'a\t\u0002$E\t\u0003\t\u0001A!#\u0005\u0002\u0005\u0002!\u0015\u0012D\u0002\u0005\u0015\u001b\u0011I!!C\u0001%%a\u0005\u0011D\u0002E\u0015\u001b\u0011I!!C\u0001%&a\u0005\u0011d\u0001\u0005\u0016\u001b\u0005Az\"\u0007\u0007\t,5Q\u0011BA\u0005\u0002III!!C\u0001%&%\u0011\u0011\"\u0001\r\u00021MIB\u0002\u0003\f\u000e\u0015%\u0011\u0011\"\u0001M\u0014\u0013\tI\u0011\u0001g\n\n\u0005%\t\u0001t\u0005\r\u0014)\u000e\u0015Q2\u0006\u0003\u0002\u0011[iA!C\u0001\u0005\u00041\u0005\u0001dF\r\u0005\u0011_i!\u0001$\u0001\u0019\u0003e\u0019\u0001\u0002G\u0007\u00021cI2\u0001C\r\u000e\u0003aMBk!\u0002\u000e,\u0011\t\u0001BG\u0007\u0005\u0013\u0005!\u0019\u0001$\u0001\u0019/e!\u0001rF\u0007\u0003\u0019\u0003A\u0012!G\u0002\t15\t\u0001\u0014G\r\u0004\u0011ei\u0011\u0001g\rU\u0007\u000biI\u0002B\u0001\t65\u0011A\u0012\u0001\r\u001c3\u0015A9$D\u0002\n\u0003\u0011\r\u0001\u0004\b+\u0004\u00065MA!\u0001E\u001d\u001b\u0005A:!G\u0002\t;5\t\u0001t\u0004+\u0004\u00065M\u00012H\u0007\u00021\u000fIB\u0001\u0003\u0010\u000e\u00051\u0005\u0001$\u0001+\u0004\u00065MA!\u0001E\u001f\u001b\u0005A:!G\u0002\t;5\t\u0001t\u0004+\u0004\u00065iA!\u0001\u0005 \u001b\ta\t\u0001\u0007\u0005\u001a\u0007!iR\"\u0001M\u0010#\u000e\t\u0001r\b+\u0004\u00065iA!\u0001\u0005!\u001b\ta\t\u0001g\u0005\u001a\u0007!iR\"\u0001M\u0010#\u000e\t\u0001\u0012\t+\u0004\u00065UA!\u0001\u0005\"\u001b\ta\t\u0001G\u0001\u001a\u0007!iR\"\u0001M\u0010)\u000e\u0015Q\u0002\u0004E\"\u001b\ta\t\u0001'\u0007\u001a\u0007!iR\"\u0001M\u0010#\u000e\t\u0001B\t+\u0004\u00065\u001d\r\u0001\"\u0001\tF5i\u0012\"B\u0005\u0005\u0013\tI\u0011\u0001\n\n\u0019G%)\u0012\u0002F\u0005\n\u0013!I1!\u0003\u0002\r\u0002a\t\u0011BA\u0005\u00021\u0005A:%\u0003\u0005\n\u000f%\u0011\u0011\"\u0001M\r\u0013\tI\u0011\u0001'\u0007\u0019Ha\t\u0002$E\t\u0003\t\u0001A!#\u0007\u0004\t)5!\u0011BA\u0005\u0002IIA\n!G\u0002\t+5\t\u0001tD\r\n\u0011Wiq!\u0003\u0002\n\u0003\u0011\u0012\u0012BA\u0005\u00021\u0005A:%G\u0005\t-59\u0011BA\u0005\u000213I!!C\u0001\u0019\u001aa\u001dCk!\u0002\u0012\u001e\u0011\u0001\u0005\u0002\u0003\u0001\u000e\t%\u0011\u0011\"\u0001\r\u00021\u0003\t6\u0001B\u0003\u0001\u001b\t!\u0019\u0001\u0003\u0002U\u0007\u000b\tj\u0002\u0002!\t\u0011\riA!\u0003\u0002\n\u0003a\u001d\u0001\u0014A)\u0004\t\u0015\u0001QB\u0001\u0003\u0005\u0011\t!6QAI\u000f\t\u0001C\u0001\u0012B\u0007\u0005\u0013\tI\u0011\u0001G\u0003\u0019\u0002E\u001bA!\u0002\u0001\u000e\u0005\u0011-\u0001B\u0001+\u0004\u0006EuA\u0001\u0011\u0005\t\r5!\u0011BA\u0005\u00021\u001bA\n!U\u0002\u0005\u000b\u0001i!\u0001B\u0004\t\u0005Q\u001b)!%\b\u0005\u0001\"Ay!\u0004\u0003\n\u0005%\t\u0001\u0004\u0003M\u0001#\u000e!Q\u0001A\u0007\u0003\t#A!\u0001VB\u0003#;!\u0001\t\u0003\u0005\n\u001b\u0011I!!C\u0001\u0019\u0014a\u0005\u0011k\u0001\u0003\u0006\u00015\u0011AA\u0003\u0005\u0003)\u000e\u0015\u0011S\u0004\u0003A\u0011!UQ\u0002B\u0005\u0003\u0013\u0005A2\u0002'\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0018!\u0011Ak!\u0002\u0012\u001e\u0011\u0001\u0005\u0002\u0003\u0007\u000e\t%\u0011\u0011\"\u0001M\r1\u0003\t6\u0001B\u0003\u0001\u001b\t!Q\u0002\u0003\u0002U\u0007\u000b\tj\u0002\u0002!\t\u00117iA!\u0003\u0002\n\u0003aq\u0001\u0014A)\u0004\t\u0015\u0001QB\u0001C\u000f\u0011\t!6QAI\u000f\t\u0001C\u0001bD\u0007\u0005\u0013\tI\u0011\u0001g\b\u0019\u0002E\u001bA!\u0002\u0001\u000e\u0005\u0011\u0001\u0002B\u0001+\u0004\u0006\u0001"}, strings={"ANY", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "", "getANY", "()Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "ConstantExpressionEvaluatorKt", "BOOLEAN", "", "getBOOLEAN", "BYTE", "", "getBYTE", "CHAR", "", "getCHAR", "DOUBLE", "", "getDOUBLE", "FLOAT", "", "getFLOAT", "INT", "", "getINT", "LONG", "", "getLONG", "SHORT", "", "getSHORT", "STRING", "", "getSTRING", "binaryOperation", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/BinaryOperationKey;", "A", "B", "Lkotlin/Function2;", "Ljava/math/BigInteger;", "a", "b", "functionName", "operation", "checker", "createCompileTimeConstantForCompareTo", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "result", "operationReference", "Lorg/jetbrains/kotlin/psi/KtExpression;", "factory", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "createCompileTimeConstantForEquals", "getReceiverExpressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "hasLongSuffix", "text", "isIntegerType", "value", "parseBoolean", "parseDouble", "(Ljava/lang/String;)Ljava/lang/Double;", "parseFloat", "(Ljava/lang/String;)Ljava/lang/Float;", "parseFloatingLiteral", "parseLong", "(Ljava/lang/String;)Ljava/lang/Long;", "unaryOperation", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/UnaryOperationKey;", "Lkotlin/Function1;"}, moduleName="kotlin-compiler")
public final class ConstantExpressionEvaluatorKt {
    @NotNull
    private static final CompileTimeType<Byte> BYTE = new CompileTimeType();
    @NotNull
    private static final CompileTimeType<Short> SHORT = new CompileTimeType();
    @NotNull
    private static final CompileTimeType<Integer> INT = new CompileTimeType();
    @NotNull
    private static final CompileTimeType<Long> LONG = new CompileTimeType();
    @NotNull
    private static final CompileTimeType<Double> DOUBLE = new CompileTimeType();
    @NotNull
    private static final CompileTimeType<Float> FLOAT = new CompileTimeType();
    @NotNull
    private static final CompileTimeType<Character> CHAR = new CompileTimeType();
    @NotNull
    private static final CompileTimeType<Boolean> BOOLEAN = new CompileTimeType();
    @NotNull
    private static final CompileTimeType<String> STRING = new CompileTimeType();
    @NotNull
    private static final CompileTimeType<Object> ANY = new CompileTimeType();

    private static final boolean hasLongSuffix(String text) {
        return StringsKt.endsWith$default((CharSequence)text, 'l', false, 2) || StringsKt.endsWith$default((CharSequence)text, 'L', false, 2);
    }

    @Nullable
    public static final Long parseLong(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        try {
            Function1<String, String> substringLongSuffix$ = new Function1<String, String>(text){
                final /* synthetic */ String $text;

                @NotNull
                public final String invoke(@NotNull String s) {
                    Intrinsics.checkParameterIsNotNull(s, "s");
                    return ConstantExpressionEvaluatorKt.access$hasLongSuffix(this.$text) ? StringsKt.substring(s, 0, CollectionsKt.length(s) - 1) : s;
                }
                {
                    this.$text = string;
                    super(1);
                }
            };
            Function2<String, Integer, Long> parseLong$ = new Function2<String, Integer, Long>(substringLongSuffix$){
                final /* synthetic */ parseLong.1 $substringLongSuffix;

                public final long invoke(@NotNull String text, int radix) {
                    Intrinsics.checkParameterIsNotNull(text, "text");
                    return Long.parseLong(this.$substringLongSuffix.invoke(text), radix);
                }
                {
                    this.$substringLongSuffix = var1_1;
                    super(2);
                }
            };
            return StringsKt.startsWith$default(text, "0x", false, 2) || StringsKt.startsWith$default(text, "0X", false, 2) ? parseLong$.invoke(StringsKt.substring(text, 2), 16) : (StringsKt.startsWith$default(text, "0b", false, 2) || StringsKt.startsWith$default(text, "0B", false, 2) ? parseLong$.invoke(StringsKt.substring(text, 2), 2) : parseLong$.invoke(text, 10));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static final Object parseFloatingLiteral(String text) {
        if (StringsKt.endsWith$default((CharSequence)StringsKt.toLowerCase(text), 'f', false, 2)) {
            return ConstantExpressionEvaluatorKt.parseFloat(text);
        }
        return ConstantExpressionEvaluatorKt.parseDouble(text);
    }

    private static final Double parseDouble(String text) {
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static final Float parseFloat(String text) {
        try {
            return Float.valueOf(Float.parseFloat(text));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static final boolean parseBoolean(String text) {
        if ("true".equals(text)) {
            return true;
        }
        if ("false".equals(text)) {
            return false;
        }
        throw (Throwable)new IllegalStateException("Must not happen. A boolean literal has text: " + text);
    }

    /*
     * WARNING - void declaration
     */
    private static final ConstantValue<?> createCompileTimeConstantForEquals(Object result2, KtExpression operationReference, ConstantValueFactory factory) {
        if (result2 instanceof Boolean) {
            boolean bl;
            Unit unit;
            boolean value2 = operationReference instanceof KtSimpleNameExpression;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                if (!value2) {
                    String message = "This method should be called only for equals operations";
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            KtExpression ktExpression = operationReference;
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
            }
            IElementType operationToken = ((KtSimpleNameExpression)ktExpression).getReferencedNameElementType();
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, KtTokens.EQEQ)) {
                bl = (Boolean)result2;
            } else if (Intrinsics.areEqual(iElementType, KtTokens.EXCLEQ)) {
                bl = !((Boolean)result2).booleanValue();
            } else if (Intrinsics.areEqual(iElementType, KtTokens.IDENTIFIER)) {
                Unit unit2;
                boolean bl2 = Intrinsics.areEqual(((KtSimpleNameExpression)operationReference).getReferencedNameAsName(), OperatorNameConventions.INSTANCE.getEQUALS());
                if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                    void value3;
                    if (value3 == false) {
                        String message = "This method should be called only for equals operations";
                        throw (Throwable)((Object)new AssertionError((Object)message));
                    }
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = Unit.INSTANCE;
                }
                bl = (Boolean)result2;
            } else {
                throw (Throwable)new IllegalStateException("Unknown equals operation token: " + operationToken + " " + ((KtSimpleNameExpression)operationReference).getText());
            }
            boolean value4 = bl;
            return factory.createBooleanValue(value4);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final ConstantValue<?> createCompileTimeConstantForCompareTo(Object result2, KtExpression operationReference, ConstantValueFactory factory) {
        if (result2 instanceof Integer) {
            BooleanValue booleanValue;
            Unit unit;
            boolean value2 = operationReference instanceof KtSimpleNameExpression;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                if (!value2) {
                    String message = "This method should be called only for compareTo operations";
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            KtExpression ktExpression = operationReference;
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
            }
            IElementType operationToken = ((KtSimpleNameExpression)ktExpression).getReferencedNameElementType();
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, KtTokens.LT)) {
                booleanValue = factory.createBooleanValue(((Number)result2).intValue() < 0);
            } else if (Intrinsics.areEqual(iElementType, KtTokens.LTEQ)) {
                booleanValue = factory.createBooleanValue(((Number)result2).intValue() <= 0);
            } else if (Intrinsics.areEqual(iElementType, KtTokens.GT)) {
                booleanValue = factory.createBooleanValue(((Number)result2).intValue() > 0);
            } else if (Intrinsics.areEqual(iElementType, KtTokens.GTEQ)) {
                booleanValue = factory.createBooleanValue(((Number)result2).intValue() >= 0);
            } else {
                if (Intrinsics.areEqual(iElementType, KtTokens.IDENTIFIER)) {
                    Unit unit2;
                    boolean $i$f$assert = Intrinsics.areEqual(((KtSimpleNameExpression)operationReference).getReferencedNameAsName(), OperatorNameConventions.INSTANCE.getCOMPARE_TO());
                    if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                        void value3;
                        if (value3 == false) {
                            String message = "This method should be called only for compareTo operations";
                            throw (Throwable)((Object)new AssertionError((Object)message));
                        }
                        unit2 = Unit.INSTANCE;
                    } else {
                        unit2 = Unit.INSTANCE;
                    }
                    return factory.createIntValue(((Number)result2).intValue());
                }
                throw (Throwable)new IllegalStateException("Unknown compareTo operation token: " + operationToken);
            }
            return booleanValue;
        }
        return null;
    }

    public static final boolean isIntegerType(@Nullable Object value2) {
        return value2 instanceof Byte || value2 instanceof Short || value2 instanceof Integer || value2 instanceof Long;
    }

    private static final KotlinType getReceiverExpressionType(ResolvedCall<?> resolvedCall) {
        KotlinType kotlinType;
        switch (ConstantExpressionEvaluatorKt$WhenMappings.$EnumSwitchMapping$0[resolvedCall.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                kotlinType = resolvedCall.getDispatchReceiver().getType();
                break;
            }
            case 2: {
                kotlinType = resolvedCall.getExtensionReceiver().getType();
                break;
            }
            case 3: {
                kotlinType = null;
                break;
            }
            case 4: {
                kotlinType = null;
                break;
            }
            default: {
                kotlinType = null;
            }
        }
        return kotlinType;
    }

    @NotNull
    public static final CompileTimeType<Byte> getBYTE() {
        return BYTE;
    }

    @NotNull
    public static final CompileTimeType<Short> getSHORT() {
        return SHORT;
    }

    @NotNull
    public static final CompileTimeType<Integer> getINT() {
        return INT;
    }

    @NotNull
    public static final CompileTimeType<Long> getLONG() {
        return LONG;
    }

    @NotNull
    public static final CompileTimeType<Double> getDOUBLE() {
        return DOUBLE;
    }

    @NotNull
    public static final CompileTimeType<Float> getFLOAT() {
        return FLOAT;
    }

    @NotNull
    public static final CompileTimeType<Character> getCHAR() {
        return CHAR;
    }

    @NotNull
    public static final CompileTimeType<Boolean> getBOOLEAN() {
        return BOOLEAN;
    }

    @NotNull
    public static final CompileTimeType<String> getSTRING() {
        return STRING;
    }

    @NotNull
    public static final CompileTimeType<Object> getANY() {
        return ANY;
    }

    @NotNull
    public static final <A, B> Pair<BinaryOperationKey<A, B>, Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>>> binaryOperation(@NotNull CompileTimeType<A> a, @NotNull CompileTimeType<B> b, @NotNull String functionName, @NotNull Function2<? super A, ? super B, ? extends Object> operation, @NotNull Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> checker) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(functionName, "functionName");
        Intrinsics.checkParameterIsNotNull(operation, "operation");
        Intrinsics.checkParameterIsNotNull(checker, "checker");
        return TuplesKt.to(new BinaryOperationKey<A, B>(a, b, functionName), new Pair<Function2<? super A, ? super B, ? extends Object>, Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>>(operation, checker));
    }

    @NotNull
    public static final <A> Pair<UnaryOperationKey<A>, Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>>> unaryOperation(@NotNull CompileTimeType<A> a, @NotNull String functionName, @NotNull Function1<? super A, ? extends Object> operation, @NotNull Function1<? super Long, ? extends Long> checker) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(functionName, "functionName");
        Intrinsics.checkParameterIsNotNull(operation, "operation");
        Intrinsics.checkParameterIsNotNull(checker, "checker");
        return TuplesKt.to(new UnaryOperationKey<A>(a, functionName), new Pair<Function1<? super A, ? extends Object>, Function1<? super Long, ? extends Long>>(operation, checker));
    }

    @Nullable
    public static final /* synthetic */ Object access$parseFloatingLiteral(@NotNull String text) {
        return ConstantExpressionEvaluatorKt.parseFloatingLiteral(text);
    }

    public static final /* synthetic */ boolean access$parseBoolean(@NotNull String text) {
        return ConstantExpressionEvaluatorKt.parseBoolean(text);
    }

    public static final /* synthetic */ boolean access$hasLongSuffix(@NotNull String text) {
        return ConstantExpressionEvaluatorKt.hasLongSuffix(text);
    }

    @Nullable
    public static final /* synthetic */ ConstantValue<?> access$createCompileTimeConstantForCompareTo(@Nullable Object result2, @NotNull KtExpression operationReference, @NotNull ConstantValueFactory factory) {
        return ConstantExpressionEvaluatorKt.createCompileTimeConstantForCompareTo(result2, operationReference, factory);
    }

    @Nullable
    public static final /* synthetic */ ConstantValue<?> access$createCompileTimeConstantForEquals(@Nullable Object result2, @NotNull KtExpression operationReference, @NotNull ConstantValueFactory factory) {
        return ConstantExpressionEvaluatorKt.createCompileTimeConstantForEquals(result2, operationReference, factory);
    }

    @Nullable
    public static final /* synthetic */ KotlinType access$getReceiverExpressionType(@NotNull ResolvedCall<?> resolvedCall) {
        return ConstantExpressionEvaluatorKt.getReceiverExpressionType(resolvedCall);
    }
}

