/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"A\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\t\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007!1-\u0001\u0007\u00013\u0005A\n!hA\u000b\u0017/\t;\u0001B\u0001R\u0007\u0005A\u0011!\n\t\u0005\b!\rQ\"\u0001\r\u00033\rA)!D\u0001\u0019\u0007e\u0019\u0001rA\u0007\u00021\u0011I2\u0001#\u0003\u000e\u0003a)Qe\u0006\u0003\u0002\u0011\u0017iA!\u0003\u0002\n\u0003\u00116\u0001DB\t\u0003\t\u0001Ai!\u0006\u0003\n\u0005%\tAU\u0002\r\b3\u0013Ay!D\u0001%\u000eA\u001b\t!U\u0002\u0002\u0011!)K\u0003B\u0001\t\u00125\t\u0001$C\t\u0003\t\u0001Ai!\u0006\u0003\n\u0005%\tAU\u0002\r\b3\u001fA\u0019\"\u0004\u0003\n\u0005%\tAU\u0002\r\u000b!\u000e\u0005\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker;", "", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtClass;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "collectReachable", "", "T", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$Graph;", "from", "(Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$Graph;Ljava/lang/Object;)Ljava/util/List;", "isEdgeInCycle", "", "edge", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "ExpansiveEdge", "Graph", "GraphBuilder"}, moduleName="kotlin-compiler")
public final class NonExpansiveInheritanceRestrictionChecker {
    public static final NonExpansiveInheritanceRestrictionChecker INSTANCE;
    public static final NonExpansiveInheritanceRestrictionChecker INSTANCE$;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void check(@NotNull KtClass declaration, @NotNull ClassDescriptor classDescriptor, @NotNull DiagnosticSink diagnosticHolder) {
        Object object;
        DeclarationDescriptor it2;
        Collection collection;
        Collection destination;
        Iterable $receiver;
        Iterable $receiver2;
        boolean bl;
        Object it3;
        TypeParameterDescriptor element42;
        List problemNodes;
        Iterable $receiver22;
        block10: {
            void destination2;
            Iterable destination3;
            Object element222;
            void $receiver4;
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
            Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
            TypeConstructor typeConstructor2 = classDescriptor.getTypeConstructor();
            if (typeConstructor2.getParameters().isEmpty()) {
                return;
            }
            TypeConstructor typeConstructor3 = typeConstructor2;
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "typeConstructor");
            GraphBuilder builder = new GraphBuilder(typeConstructor3);
            Graph<TypeParameterDescriptor> graph2 = builder.build();
            Iterable iterable = graph2.getExpansiveEdges();
            void var7_7 = $receiver4;
            Collection collection2 = new ArrayList();
            for (Object element222 : var7_7) {
                ExpansiveEdge it4 = (ExpansiveEdge)element222;
                if (!NonExpansiveInheritanceRestrictionChecker.INSTANCE.isEdgeInCycle(graph2, it4)) continue;
                destination3.add(element222);
            }
            List edgesInCycles = (List)destination3;
            if (edgesInCycles.isEmpty()) {
                return;
            }
            Iterable iterable2 = edgesInCycles;
            destination3 = iterable2;
            Collection collection3 = new ArrayList();
            element222 = $receiver22.iterator();
            while (element222.hasNext()) {
                Object element3 = element222.next();
                ExpansiveEdge it5 = (ExpansiveEdge)element3;
                Iterable list = SetsKt.setOf((TypeParameterDescriptor)it5.getFrom(), (TypeParameterDescriptor)it5.getTo());
                CollectionsKt.addAll(destination2, list);
            }
            problemNodes = (List)destination2;
            for (TypeParameterDescriptor typeParameterDescriptor : typeConstructor2.getParameters()) {
                if (!problemNodes.contains(typeParameterDescriptor)) continue;
                DeclarationDescriptor declarationDescriptor = typeParameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "typeParameter");
                PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
                if (psiElement2 == null) {
                    psiElement2 = declaration;
                }
                PsiElement element = psiElement2;
                diagnosticHolder.report(Errors.EXPANSIVE_INHERITANCE.on(element));
                return;
            }
            Iterable iterable3 = problemNodes;
            for (TypeParameterDescriptor element42 : iterable3) {
                it3 = element42;
                if (!(Intrinsics.areEqual(it3.getSource(), SourceElement.NO_SOURCE) ^ true)) continue;
                bl = true;
                break block10;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        $receiver22 = problemNodes;
        element42 = $receiver2;
        it3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            TypeParameterDescriptor $i$a$1 = (TypeParameterDescriptor)item;
            collection = destination;
            object = it2.getContainingDeclaration();
            collection.add(object);
        }
        $receiver2 = (List)destination;
        $receiver = $receiver2;
        destination = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it4;
            it2 = (DeclarationDescriptor)item;
            collection = destination;
            object = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)it4).asString();
            collection.add(object);
        }
        SortedSet sortedSet = CollectionsKt.toSortedSet((List)destination);
        diagnosticHolder.report(Errors.EXPANSIVE_INHERITANCE_IN_JAVA.on(declaration, CollectionsKt.joinToString$default((Iterable)sortedSet, (CharSequence)", ", null, null, 0, null, null, 62)));
    }

    private final <T> boolean isEdgeInCycle(Graph<T> $receiver, ExpansiveEdge<T> edge) {
        return this.collectReachable($receiver, edge.getTo()).contains(edge.getFrom());
    }

    private final <T> List<T> collectReachable(Graph<T> $receiver, T from) {
        DFS.NodeHandlerWithListResult handler2 = new DFS.NodeHandlerWithListResult<T, T>(){

            public void afterChildren(@Nullable T current) {
                ((LinkedList)this.result).add(current);
            }
        };
        DFS.Neighbors neighbors2 = new DFS.Neighbors<T>($receiver){
            final /* synthetic */ Graph receiver$0;

            @NotNull
            public Iterable<T> getNeighbors(T current) {
                return this.receiver$0.getNeighbors(current);
            }
            {
                this.receiver$0 = $receiver;
            }
        };
        DFS.dfs((Collection)CollectionsKt.listOf(from), neighbors2, handler2);
        List list = (List)handler2.result();
        Intrinsics.checkExpressionValueIsNotNull(list, "handler.result()");
        return list;
    }

    static {
        new NonExpansiveInheritanceRestrictionChecker();
    }

    private NonExpansiveInheritanceRestrictionChecker() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"A\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003!\rR\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0005\u0002\u000b\u0005!\u0019!B\u0001\t\f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001!\u0011\u0001\u0004\u0001\u001a\u0003a\u0005\u0011UB\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005A!!J\t\u0005\u0003!=Q\"\u0001\r\t3\rA\t\"D\u0001\u0019\be\u0019\u0001\"C\u0007\u00021\u000fIB\u0001B\u0001\t\u00145\t\u0001DC\u0013\u0007\u0011+iA!\u0003\u0002\n\u0003a\u001d\u0001dC\u0013\t\t\u0005A9\"D\u0001\u0019\u0011e\u0019\u0001\"A\u0007\u00021\u0007I\u0003\u0003B!\t\u0011\u000bi!\"\u0003\u0002\n\u0003a\u001d\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001g\u0002\u0019\ta\u0019\u0011kA\u0001\u0006\u0001%jA!\u0011\u0005\t\n59\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001g\u0002\u0019\fa)\u0011kA\u0001\u0006\u0001%RA!\u0011\u0005\t\r5!\u0011BA\u0005\u00021\u0007AR!U\u0002\u0002\u000b\u0001I#\u0002B\"\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\u000e!9\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$GraphBuilder;", "", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "(Lorg/jetbrains/kotlin/types/TypeConstructor;)V", "edgeLists", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "", "expansiveEdges", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "processedTypeConstructors", "getTypeConstructor", "()Lorg/jetbrains/kotlin/types/TypeConstructor;", "addEdge", "", "from", "to", "expansive", "", "build", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$Graph;", "doBuildGraph"}, moduleName="kotlin-compiler")
    private static final class GraphBuilder {
        private final HashSet<TypeConstructor> processedTypeConstructors;
        private final HashSet<ExpansiveEdge<TypeParameterDescriptor>> expansiveEdges;
        private final HashMap<TypeParameterDescriptor, Set<TypeParameterDescriptor>> edgeLists;
        @NotNull
        private final TypeConstructor typeConstructor;

        @NotNull
        public final Graph<TypeParameterDescriptor> build() {
            this.doBuildGraph(this.typeConstructor);
            return new Graph<TypeParameterDescriptor>(this){
                @NotNull
                private final HashSet<ExpansiveEdge<TypeParameterDescriptor>> expansiveEdges;
                final /* synthetic */ GraphBuilder this$0;

                @NotNull
                public Collection<TypeParameterDescriptor> getNeighbors(@NotNull TypeParameterDescriptor node) {
                    Intrinsics.checkParameterIsNotNull(node, "node");
                    Set<TypeParameterDescriptor> set = GraphBuilder.access$getEdgeLists$p(this.this$0).get(node);
                    return set != null ? (Collection)set : (Collection)CollectionsKt.emptyList();
                }

                @NotNull
                public HashSet<ExpansiveEdge<TypeParameterDescriptor>> getExpansiveEdges() {
                    return this.expansiveEdges;
                }
                {
                    this.this$0 = $outer;
                    this.expansiveEdges = GraphBuilder.access$getExpansiveEdges$p($outer);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        private final void addEdge(TypeParameterDescriptor from, TypeParameterDescriptor to, boolean expansive) {
            Object object;
            void $receiver;
            Map map2 = this.edgeLists;
            Object value2 = $receiver.get(from);
            if (value2 == null && !$receiver.containsKey(from)) {
                LinkedHashSet<TypeParameterDescriptor> answer = SetsKt.linkedSetOf(new TypeParameterDescriptor[0]);
                $receiver.put(from, answer);
                object = answer;
            } else {
                object = value2;
            }
            ((Set)object).add(to);
            if (expansive) {
                this.expansiveEdges.add(new ExpansiveEdge<TypeParameterDescriptor>(from, to));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void doBuildGraph(TypeConstructor typeConstructor2) {
            if (typeConstructor2.getParameters().isEmpty()) {
                return;
            }
            List<TypeParameterDescriptor> typeParameters = typeConstructor2.getParameters();
            Collection<KotlinType> collection = typeConstructor2.getSupertypes();
            Intrinsics.checkExpressionValueIsNotNull(collection, "typeConstructor.supertypes");
            for (KotlinType constituentType : TypeUtilsKt.constituentTypes(collection)) {
                void $receiver;
                TypeConstructor constituentTypeConstructor = constituentType.getConstructor();
                if (this.processedTypeConstructors.contains(constituentTypeConstructor) ^ true) {
                    this.processedTypeConstructors.add(constituentTypeConstructor);
                    TypeConstructor typeConstructor3 = constituentTypeConstructor;
                    Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "constituentTypeConstructor");
                    this.doBuildGraph(typeConstructor3);
                }
                if (constituentTypeConstructor.getParameters().size() != constituentType.getArguments().size()) continue;
                Iterable iterable = constituentType.getArguments();
                int index2 = 0;
                for (Object item : $receiver) {
                    void destination;
                    void $receiver2;
                    void $receiver3;
                    void typeProjection;
                    int n = index2++;
                    TypeProjection typeProjection2 = (TypeProjection)item;
                    int i = n;
                    if (Intrinsics.areEqual((Object)typeProjection.getProjectionKind(), (Object)Variance.INVARIANT)) {
                        Collection<KotlinType> constituents = TypeUtilsKt.constituentTypes((Collection<? extends KotlinType>)SetsKt.setOf(typeProjection.getType()));
                        for (TypeParameterDescriptor typeParameter : typeParameters) {
                            if (!constituents.contains(typeParameter.getDefaultType()) && !constituents.contains(TypeUtils.makeNullable(typeParameter.getDefaultType()))) continue;
                            TypeParameterDescriptor typeParameterDescriptor = typeParameter;
                            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
                            TypeParameterDescriptor typeParameterDescriptor2 = constituentTypeConstructor.getParameters().get(i);
                            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor2, "constituentTypeConstructor.parameters[i]");
                            this.addEdge(typeParameterDescriptor, typeParameterDescriptor2, !TypeUtils.isTypeParameter(typeProjection.getType()));
                        }
                        continue;
                    }
                    TypeParameterDescriptor originalTypeParameter = constituentTypeConstructor.getParameters().get(i);
                    HashSet<KotlinType> bounds = SetsKt.hashSetOf(new KotlinType[0]);
                    TypeSubstitutor substitutor2 = constituentType.getSubstitution().buildSubstitutor();
                    Iterable iterable2 = originalTypeParameter.getUpperBounds();
                    void var16_16 = $receiver3;
                    Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver3, 10));
                    for (Object item2 : $receiver2) {
                        void it2;
                        KotlinType kotlinType = (KotlinType)item2;
                        void var21_21 = destination;
                        KotlinType kotlinType2 = substitutor2.substitute((KotlinType)it2, Variance.INVARIANT);
                        var21_21.add(kotlinType2);
                    }
                    List adaptedUpperBounds = CollectionsKt.filterNotNull((List)destination);
                    bounds.addAll(adaptedUpperBounds);
                    if (!typeProjection.isStarProjection()) {
                        bounds.add(typeProjection.getType());
                    }
                    Collection<KotlinType> boundClosure2 = TypeUtilsKt.boundClosure((Collection<? extends KotlinType>)bounds);
                    Collection<KotlinType> constituentTypes = TypeUtilsKt.constituentTypes(boundClosure2);
                    for (TypeParameterDescriptor typeParameter : typeParameters) {
                        if (!constituentTypes.contains(typeParameter.getDefaultType()) && !constituentTypes.contains(TypeUtils.makeNullable(typeParameter.getDefaultType()))) continue;
                        TypeParameterDescriptor typeParameterDescriptor = typeParameter;
                        Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
                        TypeParameterDescriptor typeParameterDescriptor3 = originalTypeParameter;
                        Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor3, "originalTypeParameter");
                        this.addEdge(typeParameterDescriptor, typeParameterDescriptor3, true);
                    }
                }
            }
        }

        @NotNull
        public final TypeConstructor getTypeConstructor() {
            return this.typeConstructor;
        }

        public GraphBuilder(@NotNull TypeConstructor typeConstructor2) {
            Intrinsics.checkParameterIsNotNull(typeConstructor2, "typeConstructor");
            this.typeConstructor = typeConstructor2;
            this.processedTypeConstructors = SetsKt.hashSetOf(new TypeConstructor[0]);
            this.expansiveEdges = SetsKt.hashSetOf(new ExpansiveEdge[0]);
            this.edgeLists = MapsKt.hashMapOf(new Pair[0]);
        }

        @NotNull
        public static final /* synthetic */ HashSet<ExpansiveEdge<TypeParameterDescriptor>> access$getExpansiveEdges$p(GraphBuilder $this) {
            return $this.expansiveEdges;
        }

        @NotNull
        public static final /* synthetic */ HashMap<TypeParameterDescriptor, Set<TypeParameterDescriptor>> access$getEdgeLists$p(GraphBuilder $this) {
            return $this.edgeLists;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u000f\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0001!B\u0001\u0005\f\u0011\tE\u0001\u0004\u0001\u0016\u0005\u0011\u0001\u0001\u0012A\r\u00021\u0005\t+\"C\u0002\t\u00045\tA\u0004A\u0005\u0004\u0011\ti\u0011\u0001\b\u0001R\u0007\u0005A)!J\u0004\u0005\u0007\u001eAQ!D\u0001\u001d\u0001E\u001b\u0011\u0001c\u0002&\u000f\u0011\u0019u\u0001c\u0003\u000e\u0003q\u0001\u0011kA\u0001\t\b\u0015\"BaQ\u0002\t\r5!\u0011BA\u0005\u00029\u0001A\u0002!\u0007\u0003\u0005\u0003!\rQ\"\u0001\u000f\u00013\u0011!\u0011\u0001\u0003\u0002\u000e\u0003q\u0001\u0011kA\u0001\t\u000e%ZAa\u0011\u0005\t\u00045\tA\u0004A)\u0004\u000b\u0015\t\u0001\u0002B\u0007\u0003\t\rA9!K\u0006\u0005\u0007\"A!!D\u0001\u001d\u0001E\u001bQ!B\u0001\t\t5\u0011A\u0011\u0002E\u0004"}, strings={"Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "T", "", "from", "to", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getFrom", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getTo", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;"}, moduleName="kotlin-compiler")
    private static final class ExpansiveEdge<T> {
        private final T from;
        private final T to;

        public final T getFrom() {
            return this.from;
        }

        public final T getTo() {
            return this.to;
        }

        public ExpansiveEdge(T from, T to) {
            this.from = from;
            this.to = to;
        }

        public final T component1() {
            return this.from;
        }

        public final T component2() {
            return this.to;
        }

        @NotNull
        public final ExpansiveEdge<T> copy(T from, T to) {
            return new ExpansiveEdge<T>(from, to);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ExpansiveEdge copy$default(ExpansiveEdge expansiveEdge, Object object, Object object2, int n) {
            if ((n & 1) != 0) {
                object = expansiveEdge.from;
            }
            if ((n & 2) != 0) {
                object2 = expansiveEdge.to;
            }
            return expansiveEdge.copy(object, object2);
        }

        public String toString() {
            return "ExpansiveEdge(from=" + this.from + ", to=" + this.to + ")";
        }

        public int hashCode() {
            T t = this.from;
            T t2 = this.to;
            return (t != null ? t.hashCode() : 0) * 31 + (t2 != null ? t2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ExpansiveEdge)) break block3;
                    ExpansiveEdge expansiveEdge = (ExpansiveEdge)object;
                    if (!Intrinsics.areEqual(this.from, expansiveEdge.from) || !Intrinsics.areEqual(this.to, expansiveEdge.to)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0001!\u0002\u0001\u0006\u0003!\tR!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\u001f\u0015\tA!\u0001\u00032\u0019\u0001)\"\u0001\u0002\u0001\t\u0002e\t\u0001$AS\u000e\tMAA!\u0004\u0003\n\u0005%\tA\u0004\u0001M\u00053\rAQ!D\u0001\u001d\u0001E\u001b\u0011\u0001c\u0003*\u001f\u0011\u0019\u0006\u0002c\u0001\u000e\u000f%)\u0011\u0002B\u0005\u0003\u0013\u0005a\u0002\u0001'\u0002\u0019\u0005E\u001b1!\u0004\u0002\u0005\u0007!\u001d\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$Graph;", "T", "", "expansiveEdges", "", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "getExpansiveEdges", "()Ljava/util/Set;", "getNeighbors", "", "node", "(Ljava/lang/Object;)Ljava/util/Collection;"}, moduleName="kotlin-compiler")
    private static interface Graph<T> {
        @NotNull
        public Collection<T> getNeighbors(T var1);

        @NotNull
        public Set<ExpansiveEdge<T>> getExpansiveEdges();
    }
}

