/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;

public class TemporaryVariable {
    @Nullable
    private final JsExpression assignmentExpression;
    @NotNull
    private final JsName variableName;

    static TemporaryVariable create(@NotNull JsName temporaryName, @Nullable JsExpression initExpression) {
        if (temporaryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "temporaryName", "org/jetbrains/kotlin/js/translate/context/TemporaryVariable", "create"));
        }
        return new TemporaryVariable(temporaryName, initExpression == null ? null : JsAstUtils.assignment(temporaryName.makeRef(), initExpression));
    }

    protected TemporaryVariable(@NotNull JsName temporaryName, @Nullable JsExpression assignmentExpression) {
        if (temporaryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "temporaryName", "org/jetbrains/kotlin/js/translate/context/TemporaryVariable", "<init>"));
        }
        this.variableName = temporaryName;
        this.assignmentExpression = assignmentExpression;
    }

    @NotNull
    public JsNameRef reference() {
        JsNameRef jsNameRef = this.variableName.makeRef();
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TemporaryVariable", "reference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsName name() {
        JsName jsName = this.variableName;
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TemporaryVariable", "name"));
        }
        return jsName;
    }

    @NotNull
    public JsExpression assignmentExpression() {
        assert (this.assignmentExpression != null);
        JsExpression jsExpression = this.assignmentExpression;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TemporaryVariable", "assignmentExpression"));
        }
        return jsExpression;
    }
}

