/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.SetsKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.relocated.com.google.protobuf.ByteString;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.StringTableImpl;
import org.jetbrains.kotlin.serialization.js.ClassSerializationUtil;
import org.jetbrains.kotlin.serialization.js.JsProtoBuf;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptPackageFragmentProviderKt;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtilKt;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePaths;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePathsKt;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializerExtension;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0007\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q!\u0001\u0003\u0002\u000b\u0005A\u0011\"B\u0001\u0005\u0003\u0015\t\u0001bB\u0003\u0002\t\r)\u0011\u0001\u0003\n\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"E\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\rR!\u0001C\u0003\u000b\u0005Aq\"B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rAaY\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K5Aa!D\u0001\u0019\u0005eI\u0001RB\u0007\b\u0013\tI\u0011\u0001g\u0002\n\u0005%\t\u0001D\u0001\r\bKE!9\u0001c\u0004\u000e\u00051\u0005\u0001\u0004C\r\u0004\u0011#i\u0011\u0001G\u0005\u001a\u0007!MQ\"\u0001\r\u00033\rA!\"D\u0001\u0019\u0016\u0015BA!\u0001\u0005\f\u001b\u0005A:!G\u0002\t\u00185\t\u0001\u0004D\u0013\u0012\t\u0005AI\"\u0004\u0003\n\u0005%\t\u0001t\u0001\r\u000e3%Ai!D\u0004\n\u0005%\t\u0001tA\u0005\u0003\u0013\u0005A\"\u0001G\u0004&\u0017\u0011\t\u00012D\u0007\u0005\u0013\tI\u0011\u0001\u0007\b\u0019\u001be\u0019\u0001RD\u0007\u00021%)s\u0002B\u0001\t\u001f5\t\u0001tD\r\u0004\u0011Ai\u0011\u0001'\t\u001a\r!\tR\u0002B\u0005\u0003\u0013\u0005Ab\u0002g\t&\u0017!\u0011R\"\u0001M\u00043\rA)#D\u0001\u0019\be\u0019\u0001\u0012C\u0007\u00021%)#\u0006B\u0001\t'5\t\u0001tD\r\u0004\u0011Oi\u0011\u0001\u0007\b\u001a\r!!R\u0002B\u0005\u0003\u0013\u0005AR\u0003'\u000b\u001a\u0007!-R\"\u0001\r\u00173%Ai#D\u0004\n\u0005%\t\u0001tF\u0005\u0003\u0013\u0005A\u0002\u0004G\f\u001a\u0019!ERBC\u0005\u0003\u0013\u0005A:!\u0003\u0002\n\u0003a\u0011\u0011BA\u0005\u00021?A\u0012$\n\r\t45\t\u0001tD\r\u0004\u0011;i\u0011\u0001G\u0005\u001a\u0007!\u001dR\"\u0001\r\u000f31A\t$\u0004\u0006\n\u0005%\t\u0001tA\u0005\u0003\u0013\u0005A\"!\u0003\u0002\n\u0003a}\u0001$G\u0013\u0007\t\u0005A!$D\u0001\u0019\u0005U\t\u0001$C\u0013\r\t\u0005A)$D\u0004\n\u0005%\t\u0001tA\u0005\u0003\u0013\u0005A\"\u0001G\u0004\u0016\u0003aI\u0011f\u0003\u0003B\u0011!\rQ\"\u0002I\u0003+\ta\t\u0001\u0007\u0002\u0019\u0005E\u001b\u0011!\u0002\u0001*\u0016\u0011\u0019\u0005*\u0001\u0005\u0004\u001b\u0005A:!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0003\t\n%ZA!\u0011\u0005\t\u000b5)\u0001SA\u000b\u0003\u0019\u0003A\"\u0001\u0007\u0002R\u0007\u0005)\u0001!K\u0006\u0005\u0003\"AY!D\u0003\u0011\u0006U\u0011A\u0012\u0001\r\u00031\t\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializationUtil;", "", "()V", "CLASSES_IN_PACKAGE_DEFAULT_BYTES", "", "kotlin.jvm.PlatformType", "CLASS_METADATA_FILE_EXTENSION", "", "getCLASS_METADATA_FILE_EXTENSION", "()Ljava/lang/String;", "PACKAGE_DEFAULT_BYTES", "STRING_TABLE_DEFAULT_BYTES", "contentMapToByteArray", "contentMap", "", "createPackageFragmentProvider", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "metadata", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "getFileName", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getPackages", "", "getPackagesFqNames", "Lorg/jetbrains/kotlin/name/FqName;", "module", "getSubPackagesFqNames", "", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "result", "", "metadataAsString", "moduleName", "serializeClassNamesInPackage", "fqName", "packageFragments", "", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "stringTable", "Lorg/jetbrains/kotlin/serialization/StringTableImpl;", "skip", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "", "writeFun", "Lkotlin/Function2;", "serializePackage", "toBinaryMetadata", "toContentMap"}, moduleName="kotlin-compiler")
public final class KotlinJavascriptSerializationUtil {
    @NotNull
    public static final String CLASS_METADATA_FILE_EXTENSION = "kjsm";
    private static final byte[] PACKAGE_DEFAULT_BYTES;
    private static final byte[] CLASSES_IN_PACKAGE_DEFAULT_BYTES;
    private static final byte[] STRING_TABLE_DEFAULT_BYTES;
    public static final KotlinJavascriptSerializationUtil INSTANCE;
    public static final KotlinJavascriptSerializationUtil INSTANCE$;

    @NotNull
    public final String getCLASS_METADATA_FILE_EXTENSION() {
        return CLASS_METADATA_FILE_EXTENSION;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final PackageFragmentProvider createPackageFragmentProvider(@NotNull ModuleDescriptor moduleDescriptor, @NotNull byte[] metadata, @NotNull StorageManager storageManager) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(metadata, "metadata");
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Map<String, byte[]> contentMap = KotlinJavascriptSerializationUtilKt.access$toContentMap(metadata);
        Iterable iterable = INSTANCE.getPackages(contentMap);
        void var5_5 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it2;
            String string = (String)item;
            void var10_10 = destination;
            FqName fqName2 = new FqName((String)it2);
            var10_10.add(fqName2);
        }
        Set packageFqNames = CollectionsKt.toSet((List)destination);
        if (packageFqNames.isEmpty()) {
            return null;
        }
        return KotlinJavascriptPackageFragmentProviderKt.createKotlinJavascriptPackageFragmentProvider(storageManager, moduleDescriptor, packageFqNames, (Function1<? super String, ? extends InputStream>)new Function1<String, ByteArrayInputStream>(contentMap){
            final /* synthetic */ Map $contentMap;

            @Nullable
            public final ByteArrayInputStream invoke(@NotNull String path) {
                Intrinsics.checkParameterIsNotNull(path, "path");
                return !this.$contentMap.containsKey(path) ? (KotlinJavascriptSerializedResourcePathsKt.isPackageMetadataFile(path) ? new ByteArrayInputStream(KotlinJavascriptSerializationUtil.access$getPACKAGE_DEFAULT_BYTES$p(KotlinJavascriptSerializationUtil.INSTANCE)) : (KotlinJavascriptSerializedResourcePathsKt.isStringTableFile(path) ? new ByteArrayInputStream(KotlinJavascriptSerializationUtil.access$getSTRING_TABLE_DEFAULT_BYTES$p(KotlinJavascriptSerializationUtil.INSTANCE)) : (KotlinJavascriptSerializedResourcePathsKt.isClassesInPackageFile(path) ? new ByteArrayInputStream(KotlinJavascriptSerializationUtil.access$getCLASSES_IN_PACKAGE_DEFAULT_BYTES$p(KotlinJavascriptSerializationUtil.INSTANCE)) : (ByteArrayInputStream)null))) : new ByteArrayInputStream((byte[])this.$contentMap.get(path));
            }
            {
                this.$contentMap = map2;
                super(1);
            }
        });
    }

    @NotNull
    public final byte[] contentMapToByteArray(@NotNull Map<String, ? extends byte[]> contentMap) {
        Intrinsics.checkParameterIsNotNull(contentMap, "contentMap");
        JsProtoBuf.Library.Builder contentBuilder = JsProtoBuf.Library.newBuilder();
        Map<String, ? extends byte[]> $receiver = contentMap;
        Iterator<Map.Entry<String, ? extends byte[]>> iterator2 = MapsKt.iterator($receiver);
        while (iterator2.hasNext()) {
            Map.Entry<String, ? extends byte[]> element;
            Map.Entry<String, ? extends byte[]> it2 = element = iterator2.next();
            JsProtoBuf.Library.FileEntry entry = JsProtoBuf.Library.FileEntry.newBuilder().setPath(CollectionsKt.getKey(it2)).setContent(ByteString.copyFrom(CollectionsKt.getValue(it2))).build();
            contentBuilder.addEntry(entry);
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteStream);
        contentBuilder.build().writeTo(gzipOutputStream);
        gzipOutputStream.close();
        byte[] byArray = byteStream.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "byteStream.toByteArray()");
        return byArray;
    }

    @NotNull
    public final String metadataAsString(@NotNull String moduleName, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        return KotlinJavascriptMetadataUtils.INSTANCE.formatMetadataAsString(moduleName, this.toBinaryMetadata(moduleDescriptor));
    }

    public final void serializePackage(@NotNull ModuleDescriptor module2, @NotNull FqName fqName2, @NotNull Function2<? super String, ? super byte[], ? extends Unit> writeFun) {
        ProtoBuf.Package packageProto;
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(writeFun, "writeFun");
        PackageViewDescriptor packageView = module2.getPackage(fqName2);
        Function1 skip2 = new Function1<DeclarationDescriptor, Boolean>(module2){
            final /* synthetic */ ModuleDescriptor $module;

            public final boolean invoke(@NotNull DeclarationDescriptor it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                return Intrinsics.areEqual(DescriptorUtils.getContainingModule(it2), this.$module) ^ true;
            }
            {
                this.$module = moduleDescriptor;
                super(1);
            }
        };
        KotlinJavascriptSerializerExtension serializerExtension = new KotlinJavascriptSerializerExtension();
        DescriptorSerializer serializer = DescriptorSerializer.createTopLevel(serializerExtension);
        List classifierDescriptors = DescriptorSerializer.sort(ResolutionScope.DefaultImpls.getContributedDescriptors$default(packageView.getMemberScope(), DescriptorKindFilter.CLASSIFIERS, null, 2));
        Collection collection = classifierDescriptors;
        Intrinsics.checkExpressionValueIsNotNull(collection, "classifierDescriptors");
        DescriptorSerializer descriptorSerializer = serializer;
        Intrinsics.checkExpressionValueIsNotNull(descriptorSerializer, "serializer");
        ClassSerializationUtil.INSTANCE.serializeClasses(collection, descriptorSerializer, new ClassSerializationUtil.Sink(writeFun){
            final /* synthetic */ Function2 $writeFun;

            public void writeClass(@NotNull ClassDescriptor classDescriptor, @NotNull ProtoBuf.Class classProto) {
                Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
                Intrinsics.checkParameterIsNotNull(classProto, "classProto");
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                classProto.writeTo(stream);
                String string = KotlinJavascriptSerializationUtil.access$getFileName(KotlinJavascriptSerializationUtil.INSTANCE, classDescriptor);
                byte[] byArray = stream.toByteArray();
                Intrinsics.checkExpressionValueIsNotNull(byArray, "stream.toByteArray()");
                this.$writeFun.invoke(string, byArray);
            }
            {
                this.$writeFun = $captured_local_variable$0;
            }
        }, skip2);
        ByteArrayOutputStream packageStream = new ByteArrayOutputStream();
        List<PackageFragmentDescriptor> fragments2 = packageView.getFragments();
        ProtoBuf.Package package_ = serializer.packageProto((Collection<PackageFragmentDescriptor>)fragments2, skip2).build();
        if (package_ == null) {
            package_ = packageProto = (ProtoBuf.Package)((Object)PreconditionsKt.error("Package fragments not serialized: " + fragments2));
        }
        if (packageProto.getFunctionCount() > 0 || packageProto.getPropertyCount() > 0) {
            packageProto.writeTo(packageStream);
            String string = KotlinJavascriptSerializedResourcePaths.INSTANCE.getPackageFilePath(fqName2);
            byte[] byArray = packageStream.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull(byArray, "packageStream.toByteArray()");
            writeFun.invoke(string, (byte[])byArray);
        }
        StringTableImpl strings = serializerExtension.getStringTable();
        this.serializeClassNamesInPackage(fqName2, (Collection<? extends PackageFragmentDescriptor>)fragments2, strings, skip2, writeFun);
        ByteArrayOutputStream nameStream = new ByteArrayOutputStream();
        strings.serializeTo(nameStream);
        byte[] stringBytes = nameStream.toByteArray();
        if (!ArraysKt.isEmpty(stringBytes)) {
            String string = KotlinJavascriptSerializedResourcePaths.INSTANCE.getStringTableFilePath(fqName2);
            Intrinsics.checkExpressionValueIsNotNull(stringBytes, "stringBytes");
            writeFun.invoke(string, (byte[])stringBytes);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void serializeClassNamesInPackage(FqName fqName2, Collection<? extends PackageFragmentDescriptor> packageFragments2, StringTableImpl stringTable, Function1<? super DeclarationDescriptor, ? extends Boolean> skip2, Function2<? super String, ? super byte[], ? extends Unit> writeFun) {
        void $receiver;
        Collection destination;
        void $receiver2;
        Iterable $receiver22;
        Iterable iterable = packageFragments2;
        void var7_7 = $receiver22;
        Collection collection = new ArrayList();
        for (Object element : $receiver2) {
            void destination2;
            void $receiver3;
            void $receiver4;
            PackageFragmentDescriptor it2 = (PackageFragmentDescriptor)element;
            Iterable iterable2 = ResolutionScope.DefaultImpls.getContributedDescriptors$default(it2.getMemberScope(), DescriptorKindFilter.CLASSIFIERS, null, 2);
            void var13_13 = $receiver4;
            Collection collection2 = new ArrayList();
            for (Object element2 : $receiver3) {
                if (!(element2 instanceof ClassDescriptor)) continue;
                destination2.add(element2);
            }
            Iterable list = (List)destination2;
            CollectionsKt.addAll(destination, list);
        }
        $receiver22 = (List)destination;
        $receiver2 = $receiver;
        destination = new ArrayList();
        for (Object element : $receiver2) {
            ClassDescriptor it2 = (ClassDescriptor)element;
            if (!(skip2.invoke(it2) == false)) continue;
            destination.add(element);
        }
        List classes2 = (List)destination;
        JsProtoBuf.Classes.Builder builder = JsProtoBuf.Classes.newBuilder();
        for (ClassDescriptor descriptor2 : DescriptorSerializer.sort(classes2)) {
            builder.addClassName(stringTable.getSimpleNameIndex(descriptor2.getName()));
        }
        JsProtoBuf.Classes classesProto = builder.build();
        if (classesProto.getClassNameCount() > 0) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            classesProto.writeTo(stream);
            String string = KotlinJavascriptSerializedResourcePaths.INSTANCE.getClassesInPackageFilePath(fqName2);
            byte[] byArray = stream.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull(byArray, "stream.toByteArray()");
            writeFun.invoke(string, (byte[])byArray);
        }
    }

    private final String getFileName(ClassDescriptor classDescriptor) {
        return KotlinJavascriptSerializedResourcePaths.INSTANCE.getClassMetadataPath(DescriptorUtilsKt.getClassId(classDescriptor));
    }

    private final Map<String, byte[]> toContentMap(ModuleDescriptor $receiver) {
        HashMap contentMap = MapsKt.hashMapOf(new Pair[0]);
        Iterable $receiver2 = this.getPackagesFqNames($receiver);
        for (Object element : $receiver2) {
            FqName it2 = (FqName)element;
            INSTANCE.serializePackage($receiver, it2, (Function2<? super String, ? super byte[], ? extends Unit>)new Function2<String, byte[], Unit>($receiver, contentMap){
                final /* synthetic */ ModuleDescriptor receiver$0$inlined;
                final /* synthetic */ HashMap $contentMap$inlined;

                public final void invoke(String fileName, byte[] bytes) {
                    MapsKt.set(this.$contentMap$inlined, fileName, bytes);
                }
                {
                    this.receiver$0$inlined = moduleDescriptor;
                    this.$contentMap$inlined = hashMap;
                    super(2);
                }
            });
        }
        return contentMap;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<FqName> getPackagesFqNames(ModuleDescriptor module2) {
        void var2_2;
        HashSet<FqName> $receiver = new HashSet<FqName>();
        HashSet<FqName> $receiver2 = $receiver;
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "FqName.ROOT");
        KotlinJavascriptSerializationUtil.INSTANCE.getSubPackagesFqNames(module2.getPackage(fqName2), (Set<FqName>)$receiver2);
        $receiver2.add(FqName.ROOT);
        return (Set)var2_2;
    }

    private final void getSubPackagesFqNames(PackageViewDescriptor packageView, Set<FqName> result2) {
        FqName fqName2 = packageView.getFqName();
        if (!fqName2.isRoot()) {
            result2.add(fqName2);
        }
        for (DeclarationDescriptor descriptor2 : packageView.getMemberScope().getContributedDescriptors(DescriptorKindFilter.PACKAGES, MemberScope.Companion.getALL_NAME_FILTER())) {
            if (!(descriptor2 instanceof PackageViewDescriptor)) continue;
            this.getSubPackagesFqNames((PackageViewDescriptor)descriptor2, result2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getPackages(Map<String, ? extends byte[]> contentMap) {
        void destination;
        void $receiver;
        Object element2;
        Iterable $receiver2;
        String string;
        String it2;
        void var8_8;
        Iterable destination2;
        void $receiver3;
        Object $receiver4 = contentMap;
        $receiver4 = $receiver4.keySet();
        Object $i$f$keySet = $receiver4;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver4, 10));
        for (Object item : $receiver3) {
            String string2 = (String)item;
            var8_8 = destination2;
            string = StringsKt.substringBeforeLast$default(StringsKt.startsWith$default((CharSequence)it2, '/', false, 2) ? it2 : "/" + it2, '/', null, 2);
            var8_8.add(string);
        }
        Set keys = CollectionsKt.toSet((List)destination2);
        HashSet<String> result2 = SetsKt.hashSetOf(new String[0]);
        Function1<String, Unit> addNames$ = new Function1<String, Unit>(result2){
            final /* synthetic */ HashSet $result;

            public final void invoke(@NotNull String name) {
                Intrinsics.checkParameterIsNotNull(name, "name");
                this.$result.add(name);
                if (Intrinsics.areEqual(name, "") ^ true) {
                    this.invoke(StringsKt.substringBeforeLast$default(name, '/', null, 2));
                }
            }
            {
                this.$result = hashSet;
                super(1);
            }
        };
        destination2 = keys;
        for (Object element2 : $receiver2) {
            it2 = (String)element2;
            addNames$.invoke(it2);
        }
        $receiver2 = result2;
        Iterable iterable = $receiver2;
        element2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it3;
            String $i$f$forEach = (String)item;
            var8_8 = destination;
            string = StringsKt.replace$default(StringsKt.substringAfter$default((String)it3, '/', null, 2), '/', '.', false, 4);
            var8_8.add(string);
        }
        return CollectionsKt.toSet((List)destination);
    }

    private final byte[] toBinaryMetadata(ModuleDescriptor $receiver) {
        return INSTANCE.contentMapToByteArray(this.toContentMap($receiver));
    }

    static {
        new KotlinJavascriptSerializationUtil();
    }

    private KotlinJavascriptSerializationUtil() {
        INSTANCE = this;
        INSTANCE$ = this;
        CLASS_METADATA_FILE_EXTENSION = CLASS_METADATA_FILE_EXTENSION;
        KotlinJavascriptSerializationUtil $receiver = this;
        KotlinJavascriptSerializationUtil $receiver2 = $receiver;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ProtoBuf.Package.getDefaultInstance().writeTo(stream);
        PACKAGE_DEFAULT_BYTES = stream.toByteArray();
        $receiver = this;
        $receiver2 = $receiver;
        stream = new ByteArrayOutputStream();
        JsProtoBuf.Classes.getDefaultInstance().writeTo(stream);
        CLASSES_IN_PACKAGE_DEFAULT_BYTES = stream.toByteArray();
        $receiver = this;
        $receiver2 = $receiver;
        DescriptorSerializer serializer = DescriptorSerializer.createTopLevel(new KotlinJavascriptSerializerExtension());
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
        serializer.getStringTable().serializeTo(stream2);
        STRING_TABLE_DEFAULT_BYTES = stream2.toByteArray();
    }

    public static final /* synthetic */ byte[] access$getPACKAGE_DEFAULT_BYTES$p(KotlinJavascriptSerializationUtil $this) {
        KotlinJavascriptSerializationUtil kotlinJavascriptSerializationUtil = $this;
        return PACKAGE_DEFAULT_BYTES;
    }

    public static final /* synthetic */ byte[] access$getCLASSES_IN_PACKAGE_DEFAULT_BYTES$p(KotlinJavascriptSerializationUtil $this) {
        KotlinJavascriptSerializationUtil kotlinJavascriptSerializationUtil = $this;
        return CLASSES_IN_PACKAGE_DEFAULT_BYTES;
    }

    public static final /* synthetic */ byte[] access$getSTRING_TABLE_DEFAULT_BYTES$p(KotlinJavascriptSerializationUtil $this) {
        KotlinJavascriptSerializationUtil kotlinJavascriptSerializationUtil = $this;
        return STRING_TABLE_DEFAULT_BYTES;
    }

    @NotNull
    public static final /* synthetic */ String access$getFileName(KotlinJavascriptSerializationUtil $this, @NotNull ClassDescriptor classDescriptor) {
        return $this.getFileName(classDescriptor);
    }
}

