/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.kotlinSignature;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.SignaturesPropagationData;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

class PropagationHeuristics {
    static void checkArrayInReturnType(@NotNull SignaturesPropagationData data, @NotNull KotlinType type2, @NotNull List<SignaturesPropagationData.TypeAndVariance> typesFromSuper) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/PropagationHeuristics", "checkArrayInReturnType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/PropagationHeuristics", "checkArrayInReturnType"));
        }
        if (typesFromSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesFromSuper", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/PropagationHeuristics", "checkArrayInReturnType"));
        }
        List<SignaturesPropagationData.TypeAndVariance> arrayTypesFromSuper = ContainerUtil.filter(typesFromSuper, new Condition<SignaturesPropagationData.TypeAndVariance>(){

            @Override
            public boolean value(SignaturesPropagationData.TypeAndVariance typeAndVariance) {
                return KotlinBuiltIns.isArray(typeAndVariance.type);
            }
        });
        if (KotlinBuiltIns.isArray(type2) && !arrayTypesFromSuper.isEmpty()) {
            assert (type2.getArguments().size() == 1);
            if (type2.getArguments().get(0).getProjectionKind() == Variance.INVARIANT) {
                for (SignaturesPropagationData.TypeAndVariance typeAndVariance : arrayTypesFromSuper) {
                    KotlinType arrayTypeFromSuper = typeAndVariance.type;
                    assert (arrayTypeFromSuper.getArguments().size() == 1);
                    KotlinType elementTypeInSuper = arrayTypeFromSuper.getArguments().get(0).getType();
                    KotlinType elementType = type2.getArguments().get(0).getType();
                    if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(elementType, elementTypeInSuper) || KotlinTypeChecker.DEFAULT.equalTypes(elementType, elementTypeInSuper)) continue;
                    KotlinTypeImpl betterTypeInSuper = KotlinTypeImpl.create(arrayTypeFromSuper.getAnnotations(), arrayTypeFromSuper.getConstructor(), arrayTypeFromSuper.isMarkedNullable(), Arrays.asList(new TypeProjectionImpl(Variance.OUT_VARIANCE, elementTypeInSuper)), MemberScope.Empty.INSTANCE);
                    data.reportError("Return type is not a subtype of overridden method. To fix it, add annotation with Kotlin signature to super method with type " + DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(arrayTypeFromSuper) + " replaced with " + DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(betterTypeInSuper) + " in return type");
                }
            }
        }
    }

    @Nullable
    static ClassifierDescriptor tryToFixOverridingTWithRawType(@NotNull SignaturesPropagationData data, @NotNull List<SignaturesPropagationData.TypeAndVariance> typesFromSuper) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/PropagationHeuristics", "tryToFixOverridingTWithRawType"));
        }
        if (typesFromSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesFromSuper", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/PropagationHeuristics", "tryToFixOverridingTWithRawType"));
        }
        ArrayList<TypeParameterDescriptor> typeParameterClassifiersFromSuper = Lists.newArrayList();
        for (SignaturesPropagationData.TypeAndVariance typeFromSuper : typesFromSuper) {
            ClassifierDescriptor classifierFromSuper = typeFromSuper.type.getConstructor().getDeclarationDescriptor();
            if (!(classifierFromSuper instanceof TypeParameterDescriptor)) continue;
            typeParameterClassifiersFromSuper.add((TypeParameterDescriptor)classifierFromSuper);
        }
        if (!typeParameterClassifiersFromSuper.isEmpty() && typeParameterClassifiersFromSuper.size() == typesFromSuper.size()) {
            for (TypeParameterDescriptor typeParameter : typeParameterClassifiersFromSuper) {
                if (typeParameter.getContainingDeclaration() != data.containingClass) continue;
                return typeParameter;
            }
        }
        return null;
    }

    private PropagationHeuristics() {
    }
}

