/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"?\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\u0002\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u0019\u0001IB!\u0003\u0002\n\u0003a\t\u0001\u0014AQ\u000f\u0013\rA\u0019!D\u0001\u0019\u0003%\u0019\u0001BA\u0007\u00021\u000bI1\u0001C\u0002\u000e\u0003a\u001d\u0011kA\u0001\t\t\u0015:\u0001\u0012C\u0007\u00021%I2\u0001c\u0005\u000e\u0003aIQe\u0003\u0003\f\u0011)iA!\u0003\u0002\n\u0003a\t\u0001TC\r\u0004\u0011'i\u0011\u0001G\u0005&\t\u0011Y\u0001bC\u0007\u00021/Is\u0001B!\t\u0011\ti\u0011\u0001'\u0002R\u0007\u0005)\u0001!\u000b\u0006\u0005\u0017\"A1!D\u0001\u0019\bE\u001bA!\u0002\u0001\u000e\u0005\u0011%\u0001\"B\u0015\b\t\u0005C\u00012B\u0007\u00021\u0019\t6!A\u0003\u0001S)!1\t\u0003E\u0007\u001b\u0005Ar!U\u0002\u0005\u000b\u0001i!\u0001b\u0004\t\u0011%:A!\u0011\u0005\t\u00045\t\u0001$A)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstant;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "", "value", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "parameters", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "(Ljava/lang/Number;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;)V", "getParameters", "()Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "typeConstructor", "Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstructor;", "unknownIntegerType", "Lorg/jetbrains/kotlin/types/KotlinTypeImpl;", "getUnknownIntegerType", "()Lorg/jetbrains/kotlin/types/KotlinTypeImpl;", "getType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expectedType", "toConstantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "toString", ""}, moduleName="kotlin-compiler")
public final class IntegerValueTypeConstant
implements CompileTimeConstant<Number> {
    private final IntegerValueTypeConstructor typeConstructor;
    @NotNull
    private final KotlinTypeImpl unknownIntegerType;
    private final Number value;
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final CompileTimeConstant.Parameters parameters;

    @Override
    @NotNull
    public ConstantValue<Number> toConstantValue(@NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        ConstantValueFactory factory = new ConstantValueFactory(this.builtIns);
        KotlinType type2 = this.getType(expectedType);
        return KotlinBuiltIns.isInt(type2) ? (IntegerValueConstant)factory.createIntValue(this.value.intValue()) : (KotlinBuiltIns.isByte(type2) ? (IntegerValueConstant)factory.createByteValue(this.value.byteValue()) : (KotlinBuiltIns.isShort(type2) ? (IntegerValueConstant)factory.createShortValue(this.value.shortValue()) : (IntegerValueConstant)factory.createLongValue(this.value.longValue())));
    }

    @NotNull
    public final KotlinTypeImpl getUnknownIntegerType() {
        return this.unknownIntegerType;
    }

    @NotNull
    public final KotlinType getType(@NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        KotlinType kotlinType = TypeUtils.getPrimitiveNumberType(this.typeConstructor, expectedType);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeUtils.getPrimitiveNu\u2026onstructor, expectedType)");
        return kotlinType;
    }

    @NotNull
    public String toString() {
        return this.typeConstructor.toString();
    }

    @Override
    @NotNull
    public CompileTimeConstant.Parameters getParameters() {
        return this.parameters;
    }

    public IntegerValueTypeConstant(@NotNull Number value2, @NotNull KotlinBuiltIns builtIns, @NotNull CompileTimeConstant.Parameters parameters2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        this.value = value2;
        this.builtIns = builtIns;
        this.parameters = parameters2;
        this.typeConstructor = new IntegerValueTypeConstructor(this.value.longValue(), this.builtIns);
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        TypeConstructor typeConstructor2 = this.typeConstructor;
        List list = CollectionsKt.emptyList();
        MemberScope memberScope2 = ErrorUtils.createErrorScope("Scope for number value type (" + this.typeConstructor.toString() + ")", true);
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "ErrorUtils.createErrorSc\u2026r.toString() + \")\", true)");
        this.unknownIntegerType = KotlinTypeImpl.Companion.create(annotations2, typeConstructor2, false, list, memberScope2);
    }

    @Override
    public boolean getCanBeUsedInAnnotations() {
        return CompileTimeConstant.DefaultImpls.getCanBeUsedInAnnotations(this);
    }

    @Override
    @NotNull
    public Number getValue(@NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        return (Number)CompileTimeConstant.DefaultImpls.getValue(this, expectedType);
    }

    @Override
    public boolean isError() {
        return CompileTimeConstant.DefaultImpls.isError(this);
    }

    @Override
    public boolean isPure() {
        return CompileTimeConstant.DefaultImpls.isPure(this);
    }

    @Override
    public boolean getUsesVariableAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesVariableAsConstant(this);
    }

    @Override
    public boolean getUsesNonConstValAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesNonConstValAsConstant(this);
    }
}

