/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.types.KotlinType;

public class OverloadResolutionResultsUtil {
    @NotNull
    public static <D extends CallableDescriptor> OverloadResolutionResults<D> ambiguity(OverloadResolutionResults<D> results1, OverloadResolutionResults<D> results2) {
        ArrayList resultingCalls = Lists.newArrayList();
        resultingCalls.addAll(results1.getResultingCalls());
        resultingCalls.addAll(results2.getResultingCalls());
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.ambiguity(resultingCalls);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsUtil", "ambiguity"));
        }
        return overloadResolutionResultsImpl;
    }

    @Nullable
    public static <D extends CallableDescriptor> KotlinType getResultingType(@NotNull OverloadResolutionResults<D> results, @NotNull ContextDependency contextDependency) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsUtil", "getResultingType"));
        }
        if (contextDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDependency", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsUtil", "getResultingType"));
        }
        ResolvedCall<D> resultingCall = OverloadResolutionResultsUtil.getResultingCall(results, contextDependency);
        return resultingCall != null ? resultingCall.getResultingDescriptor().getReturnType() : null;
    }

    @Nullable
    public static <D extends CallableDescriptor> ResolvedCall<D> getResultingCall(@NotNull OverloadResolutionResults<D> results, @NotNull ContextDependency contextDependency) {
        ResolvedCall<D> resultingCall;
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsUtil", "getResultingCall"));
        }
        if (contextDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDependency", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsUtil", "getResultingCall"));
        }
        if (results.isSingleResult() && contextDependency == ContextDependency.INDEPENDENT && !((MutableResolvedCall)(resultingCall = results.getResultingCall())).hasInferredReturnType()) {
            return null;
        }
        return results.isSingleResult() ? results.getResultingCall() : null;
    }
}

