/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast;

import java.util.Collection;
import java.util.Set;
import java.util.Stack;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.SetsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"9\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001\"\u0002\u0006\u0003!\tQ!\u0001\u0003\u0002\u000b\u0005AY!B\u0001\u0005\u0004\u0011YA\u0002\u0001\t\r3\u0005A\n!H\u0001\r\u001a\u0005V\u0011b\u0001\u0005\u0002\u001b\u0005A\n!C\u0002\t\u00045\t\u0001DA)\u0004\u0003!\u0015Q\u0005\u0003\u0003\f\u0011\u0019i\u0011\u0001'\u0004\u001a\u0007!9Q\"\u0001\r\u0003K!!1\u0002c\u0004\u000e\u0003a5\u0011d\u0001\u0005\b\u001b\u0005A\"!\n\u0005\u0005\u0017!AQ\"\u0001M\u00073\rA\t\"D\u0001\u0019\u0005\u0015\"Aa\u0003\u0005\n\u001b\u0005A\u001a\"J\u0005\u0005\u0017!QQB\u0001G\u00011\u001bI2\u0001#\u0005\u000e\u0003a\u0011Q\u0005\u0003\u0003\f\u0011+i\u0011\u0001G\u0006\u001a\u0007!]Q\"\u0001\r\u0003S)!\u0011\t\u0003\u0005\u0004\u001b\u0011I!!C\u0001\u0019\ta\u001d\u0011kA\u0001\u0006\u0001%ZA!\u0011\u0005\t\n5\u0011A\u0012\u0001\r\u00059\u0005\n6aA\u0007\u0003\t\u0015AY\u0001"}, strings={"Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunctionScope;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope;", "parent", "description", "", "(Lcom/google/dart/compiler/backend/js/ast/JsScope;Ljava/lang/String;)V", "labelScopes", "Ljava/util/Stack;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;", "topLabelScope", "getTopLabelScope", "()Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;", "declareName", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "identifier", "declareNameUnsafe", "enterLabel", "label", "exitLabel", "", "findLabel", "hasOwnName", "", "name", "Companion", "LabelScope"}, moduleName="kotlin-compiler")
public class JsFunctionScope
extends JsScope {
    @NotNull
    public static final Set<? extends String> RESERVED_WORDS;
    private final Stack<LabelScope> labelScopes;
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunctionScope$Companion.INSTANCE;
        RESERVED_WORDS = SetsKt.setOf("await", "break", "case", "catch", "continue", "debugger", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "class", "const", "enum", "export", "extends", "import", "super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield", "null", "true", "false", "eval", "arguments", "NaN", "Infinity", "undefined", "Kotlin");
    }

    private final LabelScope getTopLabelScope() {
        return CollectionsKt.isNotEmpty((Collection)this.labelScopes) ? this.labelScopes.peek() : (LabelScope)null;
    }

    @Override
    @NotNull
    public JsName declareName(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull(identifier, "identifier");
        JsName jsName = super.declareFreshName(identifier);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "super.declareFreshName(identifier)");
        return jsName;
    }

    @Override
    public boolean hasOwnName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return Companion.getRESERVED_WORDS().contains(name) || super.hasOwnName(name);
    }

    @NotNull
    public JsName declareNameUnsafe(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull(identifier, "identifier");
        JsName jsName = super.declareName(identifier);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "super.declareName(identifier)");
        return jsName;
    }

    @NotNull
    public JsName enterLabel(@NotNull String label) {
        Intrinsics.checkParameterIsNotNull(label, "label");
        LabelScope scope2 = new LabelScope(this.getTopLabelScope(), label);
        this.labelScopes.push(scope2);
        return scope2.getLabelName();
    }

    public void exitLabel() {
        Unit unit;
        boolean value2 = CollectionsKt.isNotEmpty((Collection)this.labelScopes);
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value2) {
                String message = "No scope to exit from";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        this.labelScopes.pop();
    }

    @Nullable
    public JsName findLabel(@NotNull String label) {
        Intrinsics.checkParameterIsNotNull(label, "label");
        LabelScope labelScope = this.getTopLabelScope();
        return labelScope != null ? labelScope.findName(label) : null;
    }

    public JsFunctionScope(@NotNull JsScope parent2, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull(parent2, "parent");
        Intrinsics.checkParameterIsNotNull(description, "description");
        super(parent2, description, null);
        this.labelScopes = new Stack();
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001\u0003\u0003\u000b\u0005a\u0011!B\u0001\u0005\u0006\u0015\t\u00012\u0002\u0003B\u00051\u0001\u0011$\u0001M\u0001C;IY\u0001C\u0001\u000e\u00051\u0005\u0001\u0004\u0001)\u0004\u0002%%\u00012A\u0007\u00021\t\u00016!A)\u0004\u0003!\u0015Q%\u0003\u0003\u000b\u0011\u0019i!\u0001$\u0001\u0019\ne\u0019\u0001RB\u0007\u00021\t)\u0003\u0002b\u0006\t\u000f5\t\u0001tB\r\u0004\u0011\u001bi\u0011\u0001\u0007\u0002*\u0015\u0011\u0019\u0005\u0002c\u0001\u000e\u0003a\u0011\u0011k\u0001\u0003\u0006\u00015\u0011Aa\u0001E\u0004S)!1\t\u0003\u0005\u0005\u001b\u0005AJ!U\u0002\u0005\u000b\u0001i!\u0001B\u0003\t\f\u0001"}, strings={"Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope;", "parent", "ident", "", "(Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;Ljava/lang/String;)V", "getIdent", "()Ljava/lang/String;", "labelName", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "getLabelName", "()Lcom/google/dart/compiler/backend/js/ast/JsName;", "findOwnName", "name", "hasOwnName", ""}, moduleName="kotlin-compiler")
    private final class LabelScope
    extends JsScope {
        @NotNull
        private final JsName labelName;
        @NotNull
        private final String ident;

        @NotNull
        public final JsName getLabelName() {
            return this.labelName;
        }

        @Override
        @Nullable
        protected JsName findOwnName(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            return Intrinsics.areEqual(name, this.ident) ? this.labelName : (JsName)null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasOwnName(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            if (Companion.getRESERVED_WORDS().contains(name)) return true;
            if (Intrinsics.areEqual(name, this.ident)) return true;
            JsName jsName = this.labelName;
            if (Intrinsics.areEqual(name, jsName != null ? jsName.getIdent() : null)) return true;
            JsScope jsScope = this.getParent();
            if (jsScope == null) return false;
            boolean bl = jsScope.hasOwnName(name);
            if (!bl) return false;
            return true;
        }

        public LabelScope(@Nullable LabelScope parent2, @NotNull String ident) {
            Intrinsics.checkParameterIsNotNull(ident, "ident");
            super(parent2, "Label scope for " + ident, null);
            this.ident = ident;
            String freshIdent = Companion.getRESERVED_WORDS().contains(this.ident) ? this.getFreshIdent(this.ident) : (parent2 != null ? parent2.getFreshIdent(this.ident) : this.ident);
            this.labelName = new JsName(JsFunctionScope.this, freshIdent);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0019\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!\tR!\u0001\u0005\b\u000b\u0005!\u0011\u0001Bb\u0002\u0019\u0001I\u0012\u0001'\u0001\"\b\u0011\t\u0011kA\u0001\t\u0003%rAa\u0011\u0005\t\u00045!\u0011BA\u0005\u00021\u000bA\"!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u0007!\u001d\u0001"}, strings={"Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunctionScope$Companion;", "", "()V", "RESERVED_WORDS", "", "", "getRESERVED_WORDS", "()Ljava/util/Set;"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final Set<String> getRESERVED_WORDS() {
            return RESERVED_WORDS;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

