/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.util.Trinity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.relocated.gnu.trove.TObjectIntHashMap;
import org.jetbrains.kotlin.relocated.gnu.trove.TObjectIntIterator;
import org.jetbrains.org.objectweb.asm.Type;

public class FrameMap {
    private final TObjectIntHashMap<DeclarationDescriptor> myVarIndex = new TObjectIntHashMap();
    private final TObjectIntHashMap<DeclarationDescriptor> myVarSizes = new TObjectIntHashMap();
    private int myMaxIndex = 0;

    public int enter(DeclarationDescriptor descriptor2, Type type2) {
        int index2 = this.myMaxIndex;
        this.myVarIndex.put(descriptor2, index2);
        this.myMaxIndex += type2.getSize();
        this.myVarSizes.put(descriptor2, type2.getSize());
        return index2;
    }

    public int leave(DeclarationDescriptor descriptor2) {
        int size = this.myVarSizes.get(descriptor2);
        this.myMaxIndex -= size;
        this.myVarSizes.remove(descriptor2);
        int oldIndex = this.myVarIndex.remove(descriptor2);
        if (oldIndex != this.myMaxIndex) {
            throw new IllegalStateException("descriptor can be left only if it is last");
        }
        return oldIndex;
    }

    public int enterTemp(Type type2) {
        int result2 = this.myMaxIndex;
        this.myMaxIndex += type2.getSize();
        return result2;
    }

    public void leaveTemp(Type type2) {
        this.myMaxIndex -= type2.getSize();
    }

    public int getIndex(DeclarationDescriptor descriptor2) {
        return this.myVarIndex.contains(descriptor2) ? this.myVarIndex.get(descriptor2) : -1;
    }

    public Mark mark() {
        return new Mark(this.myMaxIndex);
    }

    public int getCurrentSize() {
        return this.myMaxIndex;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var5_8;
        StringBuilder sb = new StringBuilder();
        if (this.myVarIndex.size() != this.myVarSizes.size()) {
            return "inconsistent";
        }
        ArrayList<Trinity<DeclarationDescriptor, Integer, Integer>> descriptors = Lists.newArrayList();
        Object[] arr$ = this.myVarIndex.keys();
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_8 < len$) {
            Object descriptor0 = arr$[var5_8];
            DeclarationDescriptor descriptor2 = (DeclarationDescriptor)descriptor0;
            int varIndex = this.myVarIndex.get(descriptor2);
            int varSize = this.myVarSizes.get(descriptor2);
            descriptors.add(Trinity.create(descriptor2, varIndex, varSize));
            ++var5_8;
        }
        Collections.sort(descriptors, new Comparator<Trinity<DeclarationDescriptor, Integer, Integer>>(){

            @Override
            public int compare(Trinity<DeclarationDescriptor, Integer, Integer> left, Trinity<DeclarationDescriptor, Integer, Integer> right) {
                return (Integer)left.second - (Integer)right.second;
            }
        });
        sb.append("size=").append(this.myMaxIndex);
        boolean first = true;
        for (Trinity trinity : descriptors) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(trinity.first).append(",i=").append(trinity.second).append(",s=").append(trinity.third);
        }
        return sb.toString();
    }

    public class Mark {
        private final int myIndex;

        public Mark(int index2) {
            this.myIndex = index2;
        }

        public void dropTo() {
            ArrayList descriptorsToDrop = new ArrayList();
            TObjectIntIterator iterator2 = FrameMap.this.myVarIndex.iterator();
            while (iterator2.hasNext()) {
                iterator2.advance();
                if (iterator2.value() < this.myIndex) continue;
                descriptorsToDrop.add(iterator2.key());
            }
            for (DeclarationDescriptor declarationDescriptor : descriptorsToDrop) {
                FrameMap.this.myVarIndex.remove(declarationDescriptor);
                FrameMap.this.myVarSizes.remove(declarationDescriptor);
            }
            FrameMap.this.myMaxIndex = this.myIndex;
        }
    }
}

