/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DelegatingType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.LazyType;
import org.jetbrains.kotlin.util.Box;
import org.jetbrains.kotlin.util.ReenteringLazyValueComputationException;

public class DeferredType
extends DelegatingType
implements LazyType {
    private static final Function1 EMPTY_CONSUMER = new Function1<Object, Void>(){

        @Override
        public Void invoke(Object t) {
            return null;
        }
    };
    private static final Function1<Boolean, KotlinType> RECURSION_PREVENTER = new Function1<Boolean, KotlinType>(){

        @Override
        public KotlinType invoke(Boolean firstTime) {
            if (firstTime.booleanValue()) {
                throw new ReenteringLazyValueComputationException();
            }
            return ErrorUtils.createErrorType("Recursive dependency");
        }
    };
    private final NotNullLazyValue<KotlinType> lazyValue;

    @NotNull
    public static DeferredType create(@NotNull StorageManager storageManager, @NotNull BindingTrace trace, @NotNull Function0<KotlinType> compute) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/kotlin/types/DeferredType", "create"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/DeferredType", "create"));
        }
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/kotlin/types/DeferredType", "create"));
        }
        DeferredType deferredType = new DeferredType(storageManager.createLazyValue(compute));
        trace.record(BindingContext.DEFERRED_TYPE, new Box<DeferredType>(deferredType));
        DeferredType deferredType2 = deferredType;
        if (deferredType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/DeferredType", "create"));
        }
        return deferredType2;
    }

    @NotNull
    public static DeferredType createRecursionIntolerant(@NotNull StorageManager storageManager, @NotNull BindingTrace trace, @NotNull Function0<KotlinType> compute) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/kotlin/types/DeferredType", "createRecursionIntolerant"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/DeferredType", "createRecursionIntolerant"));
        }
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/kotlin/types/DeferredType", "createRecursionIntolerant"));
        }
        DeferredType deferredType = new DeferredType(storageManager.createLazyValueWithPostCompute(compute, RECURSION_PREVENTER, EMPTY_CONSUMER));
        trace.record(BindingContext.DEFERRED_TYPE, new Box<DeferredType>(deferredType));
        DeferredType deferredType2 = deferredType;
        if (deferredType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/DeferredType", "createRecursionIntolerant"));
        }
        return deferredType2;
    }

    private DeferredType(@NotNull NotNullLazyValue<KotlinType> lazyValue) {
        if (lazyValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lazyValue", "org/jetbrains/kotlin/types/DeferredType", "<init>"));
        }
        this.lazyValue = lazyValue;
    }

    public boolean isComputed() {
        return this.lazyValue.isComputed();
    }

    @Override
    public KotlinType getDelegate() {
        return (KotlinType)this.lazyValue.invoke();
    }

    @Override
    public String toString() {
        try {
            if (this.lazyValue.isComputed()) {
                return this.getDelegate().toString();
            }
            return "<Not computed yet>";
        }
        catch (ReenteringLazyValueComputationException e) {
            return "<Failed to compute this type>";
        }
    }
}

