/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.rmi.service;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.TimerTask;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.PropertyMetadata;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.concurrent.TimersKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.ConsoleKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.rmi.CompileService;
import org.jetbrains.kotlin.rmi.CompilerId;
import org.jetbrains.kotlin.rmi.DaemonOptions;
import org.jetbrains.kotlin.rmi.DaemonParamsKt;
import org.jetbrains.kotlin.rmi.LoopbackNetworkInterface;
import org.jetbrains.kotlin.rmi.OptionsGroup;
import org.jetbrains.kotlin.rmi.service.CompileDaemon;
import org.jetbrains.kotlin.rmi.service.CompileDaemon$WhenMappings;
import org.jetbrains.kotlin.rmi.service.CompileDaemon$log$1;
import org.jetbrains.kotlin.rmi.service.CompileDaemon$main$compilerSelector$1$js$1;
import org.jetbrains.kotlin.rmi.service.CompileDaemon$main$compilerSelector$1$jvm$1;
import org.jetbrains.kotlin.rmi.service.CompileDaemonKt;
import org.jetbrains.kotlin.rmi.service.CompileServiceImpl;
import org.jetbrains.kotlin.rmi.service.CompileServiceImplKt;
import org.jetbrains.kotlin.rmi.service.CompilerSelector;
import org.jetbrains.kotlin.rmi.service.LogStream;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"?\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0004\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\u0003\u0006\u0003\u0011\tQ!\u0001\u0005\b\u000b\u0001)\u0011\u0001C\u0001\u0006\u0001\u0015\t\u0001\u0012C\u0003\u0001\t\r\fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!\n\b\u0005\u0003!9QbB\u0005\u0003\u0013\u0005A\u0002\"\u0003\u0002\n\u0003aE\u0001tB\r\u0004\u0011%i\u0011\u0001'\u0005&\u000b\u0011\t\u00012C\u0007\u0003\u0019\u0003A\"\"j\u0007\u0005\b!UQ\"\u0001\r\f3\u0019A9\"\u0004\u0003\n\u0005%\t\u0001D\u0003\r\r#\u000e\t\u0001\u0012D\u0015\u0012\t\rC\u00012A\u0007\u0006!\u000b)\"\u0001$\u0001\u0019\u0005a\u0011AdI)\u0004\r\u0015\u0011A\u0001\u0002E\u0005\u001b\t!1\u0001c\u0002*\u0015\u0011\u0019\u0005\u0002C\u0003\u000e\u0003a-\u0011k\u0001\u0003\u0006\u00015\u0011AA\u0002E\u0007"}, strings={"Lorg/jetbrains/kotlin/rmi/service/CompileDaemon;", "", "()V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "createRegistry", "Lkotlin/Pair;", "Ljava/rmi/registry/Registry;", "", "attempts", "loadVersionFromResource", "", "main", "", "args", "", "([Ljava/lang/String;)V"}, moduleName="kotlin-compiler")
public final class CompileDaemon {
    private static final Lazy<? extends Logger> log$delegate;
    @NotNull
    public static final Random random;
    private static final /* synthetic */ PropertyMetadata[] $delegatedProperties;
    public static final CompileDaemon INSTANCE;
    public static final CompileDaemon INSTANCE$;

    public final Logger getLog() {
        return LazyKt.getValue(log$delegate, this, (KProperty)$delegatedProperties[0]);
    }

    private final String loadVersionFromResource() {
        Unit unit;
        Object object;
        ClassLoader classLoader = CompileDaemon.class.getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            classLoader = null;
        }
        if ((object = (URLClassLoader)classLoader) != null && (object = ((URLClassLoader)object).findResource("META-INF/MANIFEST.MF")) != null) {
            Object $receiver = object;
            URL it2 = (URL)$receiver;
            try {
                String string = new Manifest(it2.openStream()).getMainAttributes().getValue("Implementation-Version");
                if (string == null) {
                    string = null;
                }
                return string;
            }
            catch (IOException iOException) {
                unit = Unit.INSTANCE;
            }
        } else {
            unit = null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        Logger logger = INSTANCE.getLog();
        StringBuilder stringBuilder = new StringBuilder().append("Kotlin compiler daemon version ");
        String string = INSTANCE.loadVersionFromResource();
        if (string == null) {
            string = "<unknown>";
        }
        logger.info(stringBuilder.append(string).toString());
        INSTANCE.getLog().info("daemon JVM args: " + CollectionsKt.joinToString$default(ManagementFactory.getRuntimeMXBean().getInputArguments(), " ", null, null, 0, null, null, 62));
        INSTANCE.getLog().info("daemon args: " + ArraysKt.joinToString$default(args, " ", null, null, 0, null, null, 62));
        CompilerId compilerId = new CompilerId(null, null, null, 7, null);
        DaemonOptions daemonOptions = new DaemonOptions(null, 0L, 0, 0L, null, false, false, 127, null);
        try {
            Unit unit;
            void registry;
            void port;
            List list;
            String destination;
            void $receiver;
            void $receiver2;
            File file;
            Object helpLine;
            OptionsGroup[] optionsGroupArray = new OptionsGroup[]{compilerId, daemonOptions};
            String string2 = DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX();
            Iterable<String> filteredArgs = DaemonParamsKt.filterExtractProps(ArraysKt.asIterable((Object[])args), optionsGroupArray, string2);
            if (CollectionsKt.any(filteredArgs)) {
                helpLine = "usage: <daemon> <compilerId options> <daemon options>";
                INSTANCE.getLog().info((String)helpLine);
                ConsoleKt.println(helpLine);
                throw (Throwable)new IllegalArgumentException("Unknown arguments: " + CollectionsKt.joinToString$default(filteredArgs, " ", null, null, 0, null, null, 62));
            }
            INSTANCE.getLog().info("starting daemon");
            Pair<Registry, Integer> pair = INSTANCE.createRegistry(DaemonParamsKt.getCOMPILE_DAEMON_FIND_PORT_ATTEMPTS());
            helpLine = pair.component1();
            int n = ((Number)pair.component2()).intValue();
            pair = null;
            File runFileDir = new File(StringsKt.isBlank(daemonOptions.getRunFilesPath()) ? DaemonParamsKt.getCOMPILE_DAEMON_DEFAULT_RUN_DIR_PATH() : daemonOptions.getRunFilesPath());
            runFileDir.mkdirs();
            Iterable iterable = compilerId.getCompilerClasspath();
            String string3 = StringsKt.format("%tFT%<tH-%<tM-%<tS.%<tLZ", Calendar.getInstance(TimeZone.getTimeZone("Z")));
            File file2 = runFileDir;
            File file3 = file;
            File file4 = file;
            void var12_19 = $receiver2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
            for (Object item : $receiver) {
                void it2;
                String string4 = (String)item;
                list = destination;
                String string5 = new File((String)it2).getAbsolutePath();
                list.add(string5);
            }
            list = (List)((Object)destination);
            file3(file2, DaemonParamsKt.makeRunFilenameString$default(string3, DaemonParamsKt.distinctStringsDigest(list), String.valueOf((int)port), null, 8));
            File runFile = file4;
            try {
                if (!runFile.createNewFile()) {
                    throw (Throwable)new Exception("createNewFile returned false");
                }
            }
            catch (Exception e) {
                throw (Throwable)new IllegalStateException("Unable to create run file '" + runFile.getAbsolutePath() + "'", e);
            }
            runFile.deleteOnExit();
            CompilerSelector compilerSelector2 = new CompilerSelector(){
                private final Lazy<? extends K2JVMCompiler> jvm$delegate;
                private final Lazy<? extends K2JSCompiler> js$delegate;
                private static final /* synthetic */ PropertyMetadata[] $delegatedProperties;

                private final K2JVMCompiler getJvm() {
                    return LazyKt.getValue(this.jvm$delegate, this, (KProperty)$delegatedProperties[0]);
                }

                private final K2JSCompiler getJs() {
                    return LazyKt.getValue(this.js$delegate, this, (KProperty)$delegatedProperties[1]);
                }

                @NotNull
                public CLICompiler<?> get(@NotNull CompileService.TargetPlatform targetPlatform) {
                    CLICompiler cLICompiler;
                    Intrinsics.checkParameterIsNotNull(targetPlatform, "targetPlatform");
                    switch (CompileDaemon$WhenMappings.$EnumSwitchMapping$0[targetPlatform.ordinal()]) {
                        case 1: {
                            cLICompiler = this.getJvm();
                            break;
                        }
                        case 2: {
                            cLICompiler = this.getJs();
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return cLICompiler;
                }

                static {
                    $delegatedProperties = new PropertyMetadata[]{CompileDaemon$main$compilerSelector$1$jvm$1.INSTANCE, CompileDaemon$main$compilerSelector$1$js$1.INSTANCE};
                }
                {
                    this.jvm$delegate = LazyKt.lazy(main.compilerSelector.jvm.2.INSTANCE);
                    this.js$delegate = LazyKt.lazy(main.compilerSelector.js.2.INSTANCE);
                }

                @NotNull
                public static final /* synthetic */ K2JVMCompiler access$getJvm$p(main.compilerSelector.1 $this) {
                    return $this.getJvm();
                }

                @NotNull
                public static final /* synthetic */ K2JSCompiler access$getJs$p(main.compilerSelector.1 $this) {
                    return $this.getJs();
                }
            };
            CompileServiceImpl compilerService = new CompileServiceImpl((Registry)registry, compilerSelector2, compilerId, daemonOptions, (int)port);
            if (StringsKt.isNotEmpty(daemonOptions.getRunFilesPath())) {
                ConsoleKt.println(daemonOptions.getRunFilesPath());
            }
            String string6 = daemonOptions.getClientAliveFlagPath();
            if (string6 != null) {
                void $receiver3;
                destination = string6;
                String it3 = (String)$receiver3;
                if (!new File(it3).exists()) {
                    INSTANCE.getLog().info("Client alive flag " + it3 + " do not exist, disable watching it");
                    daemonOptions.setClientAliveFlagPath(null);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            System.out.close();
            System.err.close();
            System.setErr(new PrintStream(new LogStream("stderr")));
            System.setOut(new PrintStream(new LogStream("stdout")));
            main.2 shutdownCondition$ = main.2.INSTANCE;
            TimersKt.timer$default(null, false, CompileDaemonKt.getDAEMON_PERIODIC_CHECK_INTERVAL_MS(), CompileDaemonKt.getDAEMON_PERIODIC_CHECK_INTERVAL_MS(), (Function1)new Function1<TimerTask, Unit>(compilerService, runFile, daemonOptions){
                final /* synthetic */ CompileServiceImpl $compilerService;
                final /* synthetic */ File $runFile;
                final /* synthetic */ DaemonOptions $daemonOptions;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(TimerTask $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                    try {
                        long idleSeconds = CompileServiceImplKt.nowSeconds() - this.$compilerService.getLastUsedSeconds();
                        if (main.2.INSTANCE.invoke((Function0<? extends Boolean>)new Function0<Boolean>(this){
                            final /* synthetic */ main.3 this$0;

                            public final boolean invoke() {
                                return !this.this$0.$runFile.exists();
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }, "Run file removed, shutting down") || main.2.INSTANCE.invoke((Function0<? extends Boolean>)new Function0<Boolean>(this, idleSeconds){
                            final /* synthetic */ main.3 this$0;
                            final /* synthetic */ long $idleSeconds;

                            public final boolean invoke() {
                                return this.this$0.$daemonOptions.getAutoshutdownIdleSeconds() != DaemonParamsKt.getCOMPILE_DAEMON_TIMEOUT_INFINITE_S() && this.$idleSeconds > (long)this.this$0.$daemonOptions.getAutoshutdownIdleSeconds();
                            }
                            {
                                this.this$0 = var1_1;
                                this.$idleSeconds = l;
                                super(0);
                            }
                        }, "Idle timeout exceeded " + this.$daemonOptions.getAutoshutdownIdleSeconds() + "s, shutting down") || main.2.INSTANCE.invoke((Function0<? extends Boolean>)new Function0<Boolean>(this){
                            final /* synthetic */ main.3 this$0;

                            public final boolean invoke() {
                                boolean bl;
                                String string = this.this$0.$daemonOptions.getClientAliveFlagPath();
                                if (string != null) {
                                    String $receiver = string;
                                    String it2 = $receiver;
                                    bl = !new File(it2).exists();
                                } else {
                                    bl = false;
                                }
                                return bl;
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }, "Client alive flag " + this.$daemonOptions.getClientAliveFlagPath() + " removed, shutting down")) {
                            $receiver.cancel();
                            this.$compilerService.shutdown();
                        }
                    }
                    catch (Exception e) {
                        void $receiver2;
                        Throwable throwable = e;
                        StringBuilder stringBuilder = new StringBuilder().append("Exception in timer thread: ");
                        PrintStream printStream = System.err;
                        String string = $receiver2.getMessage();
                        printStream.println(stringBuilder.append(string).toString());
                        Throwable throwable2 = e;
                        PrintStream printStream2 = System.err;
                        Intrinsics.checkExpressionValueIsNotNull(printStream2, "System.err");
                        ExceptionsKt.printStackTrace(throwable2, printStream2);
                    }
                }
                {
                    this.$compilerService = compileServiceImpl;
                    this.$runFile = file;
                    this.$daemonOptions = daemonOptions;
                    super(1);
                }
            }, 3);
        }
        catch (Exception e) {
            void $receiver;
            Throwable registry = e;
            StringBuilder stringBuilder2 = new StringBuilder().append("Exception: ");
            PrintStream printStream = System.err;
            String string7 = $receiver.getMessage();
            printStream.println(stringBuilder2.append(string7).toString());
            Throwable throwable = e;
            PrintStream printStream2 = System.err;
            Intrinsics.checkExpressionValueIsNotNull(printStream2, "System.err");
            ExceptionsKt.printStackTrace(throwable, printStream2);
            INSTANCE.getLog().log(Level.INFO, "Exception: ", e);
            throw (Throwable)e;
        }
    }

    @NotNull
    public final Random getRandom() {
        return random;
    }

    private final Pair<Registry, Integer> createRegistry(int attempts) {
        int i = 0;
        RemoteException lastException = null;
        while (i++ < attempts) {
            int port = random.nextInt(DaemonParamsKt.getCOMPILE_DAEMON_PORTS_RANGE_END() - DaemonParamsKt.getCOMPILE_DAEMON_PORTS_RANGE_START()) + DaemonParamsKt.getCOMPILE_DAEMON_PORTS_RANGE_START();
            try {
                return new Pair<Registry, Integer>(LocateRegistry.createRegistry(port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory()), port);
            }
            catch (RemoteException e) {
                lastException = e;
            }
        }
        throw (Throwable)new IllegalStateException("Cannot find free port in " + attempts + " attempts", lastException);
    }

    static {
        $delegatedProperties = new PropertyMetadata[]{CompileDaemon$log$1.INSTANCE};
        new CompileDaemon();
    }

    /*
     * WARNING - void declaration
     */
    private CompileDaemon() {
        void logPath;
        void fileIsGiven;
        Pair<String, Boolean> pair;
        INSTANCE = this;
        INSTANCE$ = this;
        String string = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss-SSS").format(new Date());
        Intrinsics.checkExpressionValueIsNotNull(string, "SimpleDateFormat(\"yyyy-M\u2026m-ss-SSS\").format(Date())");
        String logTime = string;
        String string2 = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_LOG_PATH_PROPERTY());
        if (string2 != null && (string2 = DaemonParamsKt.trimQuotes(string2)) != null) {
            String $receiver = string2;
            String it2 = $receiver;
            pair = new Pair<String, Boolean>(it2, new File(it2).isFile());
        } else {
            pair = new Pair<String, Boolean>("%t", false);
        }
        Pair<String, Boolean> pair2 = pair;
        String string3 = pair2.component1();
        boolean bl = pair2.component2();
        pair2 = null;
        String cfg = "handlers = java.util.logging.FileHandler\n" + "java.util.logging.FileHandler.level     = ALL\n" + "java.util.logging.FileHandler.formatter = java.util.logging.SimpleFormatter\n" + "java.util.logging.FileHandler.encoding  = UTF-8\n" + ("java.util.logging.FileHandler.limit     = " + (fileIsGiven != false ? 0 : 1 << 20) + "\n") + ("java.util.logging.FileHandler.count     = " + (fileIsGiven != false ? 1 : 3) + "\n") + ("java.util.logging.FileHandler.append    = " + (boolean)fileIsGiven + "\n") + ("java.util.logging.FileHandler.pattern   = " + (String)(fileIsGiven != false ? logPath : (String)logPath + File.separator + (DaemonParamsKt.getCOMPILE_DAEMON_DEFAULT_FILES_PREFIX() + "." + logTime + ".%u%g.log")) + "\n") + "java.util.logging.SimpleFormatter.format = %1$tF %1$tT.%1$tL [%3$s] %4$s: %5$s\\n\n";
        LogManager.getLogManager().readConfiguration(ByteStreamsKt.byteInputStream$default(cfg, null, 1));
        log$delegate = LazyKt.lazy(log.2.INSTANCE);
        random = new Random();
    }
}

