/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.JetPsiUtilKt;
import org.jetbrains.kotlin.relocated.gnu.trove.TIntArrayList;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001E\u000b\u000b\u0001)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!!Q!\u0001C\u0002\u0019\u0001IB!\u0003\u0002\n\u0003a\t\u0001\u0014AQ\u0007\u0013\rA\u0019!D\u0001\u0019\u0003E\u001b\u0011\u0001\u0003\u0002&\u0019\u0011Y\u0001rA\u0007\u00021\u0011I2\u0001#\u0003\u000e\u0003a)\u0011d\u0001E\u0006\u001b\u0005Ab!\n\u0007\u0005\u0017!5Q\"\u0001\r\b3\rAy!D\u0001\u0019\u000fe\u0019\u0001\u0012B\u0007\u00021\u0015)C\u0001B\u0006\t\u00115\t\u0001$B\u0013\u0005\t-A\t\"D\u0001\u0019\t%BA!\u0011\u000f\t\u00065\u0011A\u0012\u0001\r\u0004#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/psi/KotlinStringLiteralTextEscaper;", "Lcom/intellij/psi/LiteralTextEscaper;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "host", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;)V", "sourceOffsets", "", "decode", "", "rangeInsideHost", "Lcom/intellij/openapi/util/TextRange;", "outChars", "Ljava/lang/StringBuilder;", "getOffsetInHost", "", "offsetInDecoded", "getRelevantTextRange", "isOneLine"}, moduleName="kotlin-compiler")
public final class KotlinStringLiteralTextEscaper
extends LiteralTextEscaper<KtStringTemplateExpression> {
    private int[] sourceOffsets;

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        void sourceOffset;
        Intrinsics.checkParameterIsNotNull(rangeInsideHost, "rangeInsideHost");
        Intrinsics.checkParameterIsNotNull(outChars, "outChars");
        TIntArrayList sourceOffsetsList = new TIntArrayList();
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)this.myHost).getEntries();
        block0: for (int i = 0; i < ktStringTemplateEntryArray.length; ++i) {
            int it2;
            int index2;
            int n;
            int times;
            KtStringTemplateEntry child = ktStringTemplateEntryArray[i];
            TextRange childRange = TextRange.from(child.getStartOffsetInParent(), child.getTextLength());
            if (rangeInsideHost.getEndOffset() <= childRange.getStartOffset()) break;
            if (childRange.getEndOffset() <= rangeInsideHost.getStartOffset()) continue;
            KtStringTemplateEntry ktStringTemplateEntry = child;
            if (ktStringTemplateEntry instanceof KtLiteralStringTemplateEntry) {
                TextRange textRange = rangeInsideHost.intersection(childRange);
                if (textRange == null) {
                    Intrinsics.throwNpe();
                }
                TextRange textRange2 = textRange.shiftRight(-childRange.getStartOffset());
                outChars.append(((KtLiteralStringTemplateEntry)child).getText(), textRange2.getStartOffset(), textRange2.getEndOffset());
                int n2 = textRange2.getLength();
                int n3 = 0;
                n = times - 1;
                if (n3 > n) continue;
                while (true) {
                    it2 = ++index2;
                    sourceOffsetsList.add(sourceOffset.element++);
                    if (index2 == n) continue block0;
                }
            }
            if (ktStringTemplateEntry instanceof KtEscapeStringTemplateEntry) {
                if (!rangeInsideHost.contains(childRange)) {
                    return false;
                }
                String unescaped = ((KtEscapeStringTemplateEntry)child).getUnescapedValue();
                outChars.append(unescaped);
                times = CollectionsKt.length(unescaped);
                index2 = 0;
                n = times - 1;
                if (index2 <= n) {
                    do {
                        it2 = ++index2;
                        sourceOffsetsList.add(sourceOffset.element);
                    } while (index2 != n);
                }
                sourceOffset.element += ((KtEscapeStringTemplateEntry)child).getTextLength();
                continue;
            }
            return false;
        }
        sourceOffsetsList.add(sourceOffset.element);
        this.sourceOffsets = sourceOffsetsList.toNativeArray();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int[] offsets;
        block3: {
            block2: {
                void $receiver;
                Intrinsics.checkParameterIsNotNull(rangeInsideHost, "rangeInsideHost");
                offsets = this.sourceOffsets;
                if (offsets == null) break block2;
                int[] nArray = offsets;
                int n = offsetInDecoded;
                int n2 = ((void)$receiver).length;
                if (n < n2) break block3;
            }
            return -1;
        }
        return Math.min(offsets[offsetInDecoded], rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    @Override
    @NotNull
    public TextRange getRelevantTextRange() {
        return JetPsiUtilKt.getContentRange((KtStringTemplateExpression)this.myHost);
    }

    @Override
    public boolean isOneLine() {
        return JetPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)this.myHost);
    }

    public KotlinStringLiteralTextEscaper(@NotNull KtStringTemplateExpression host) {
        Intrinsics.checkParameterIsNotNull(host, "host");
        super((PsiLanguageInjectionHost)host);
    }
}

