/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.ImplKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.DefinitionPlace;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.DeclarationBodyVisitor;
import org.jetbrains.kotlin.js.translate.declaration.DelegationTranslator;
import org.jetbrains.kotlin.js.translate.declaration.JsDataClassGenerator;
import org.jetbrains.kotlin.js.translate.declaration.propertyTranslator.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslator;
import org.jetbrains.kotlin.js.translate.expression.LiteralFunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.initializer.ClassInitializerTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.js.translate.utils.jsAstUtils.AstUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsDocComment;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsObjectScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsReturn;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.utils.FunctionsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"e\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005AY!\u0002\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005A\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011C)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0005\u0011\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u000b)\u0011\u0001D\u0001\u0006\u0003\u0011\u001dA\u0002\u0001\t\u00173\u0005A\n!(\u0001\u0017C/!\u0011!C\u0002\t\u00035\t\u00014A\u0005\u0004\u0011\ti\u0011\u0001'\u0002R\u0007\u0005A1!\n\u0007\u0005\u0003!)Q\"\u0001M\u00063\rAa!D\u0001\u0019\u000ee\u0019\u0001bB\u0007\u00021\u001b)\u0003\u0002B\u0001\t\u00105\t\u0001TA\r\u0004\u0011\ti\u0011\u0001'\u0002&%\u0011\t\u0001\u0002C\u0007\u00021#Ib\u0001C\u0005\u000e\t%\u0011\u0011\"\u0001M\u00071'Ib\u0001\u0003\u0006\u000e\t%\u0011\u0011\"\u0001\r\f1+)3\u0002B\u0001\t\u00185\t\u0001\u0014C\r\u0007\u0011)iA!\u0003\u0002\n\u0003aY\u0001TC\u0013\f\t\u0005AA\"D\u0001\u0019\u0012e1\u0001BC\u0007\u0005\u0013\tI\u0011\u0001G\u0006\u0019\u0016\u0015ZA!\u0001E\r\u001b\u0005A\n\"\u0007\u0004\t\u00155!\u0011BA\u0005\u00021-A*\"J\u0006\u0005\u0003!iQ\u0002B\u0005\u0003\u0013\u0005Ab\u0002g\u0007\u001a\u0007!uQ\"\u0001M\u0003K!!\u0011\u0001C\b\u000e\u0003a}\u0011d\u0001\u0005\u0011\u001b\u0005AB!\n\u0005\u0005\u0003!\u0005R\"\u0001\r\u000f3\rAi\"D\u0001\u0019\u0006\u0015:A!\u0001\u0005\u0012\u001b\u0011I!!C\u0001\u0019\u001damQ\u0005\u0002\u0003\u0002\u0011Gi\u0011\u0001g\u0003&\u0013\u0011\t\u0001BE\u0007\u00021KIB\u0001B\u0001\t\u001e5\t\u0001TA\u0013\t\t\u0005A1#D\u0001\u0019\u001de\u0019\u0001rE\u0007\u00021\u000b)C\u0001B\u0001\t)5\t\u0001DD\u0013\u0010\t\u0005AI#D\u0001\u0019\u0012e\u0019\u0001\"F\u0007\u00021\u000bIb\u0001c\u000b\u000e\t%\u0011\u0011\"\u0001\r\f1+Is\u0001B!\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005)\u0001!k\u0005\u0005\u0003\"A9!d\u0002\u0019\tE\u001b\u0011\u0001\"\u0003R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/js/translate/declaration/ClassTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "classDeclaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/annotations/NotNull;", "areNamesEqual", "", "first", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "second", "fixContextForCompanionObjectAccessing", "generateBridge", "", "bridge", "Lorg/jetbrains/kotlin/backend/common/bridges/Bridge;", "properties", "", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsPropertyInitializer;", "generateBridgesToTraitImpl", "generateOtherBridges", "generatedBridgeMethods", "getClassCreateInvocationArguments", "", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "declarationContext", "getClassReference", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNameRef;", "superClassDescriptor", "getSuperclassReferences", "getSupertypesNameReferences", "isTrait", "translate", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsInvocation;", "translateObjectInsideClass", "outerClassContext", "translateObjectLiteralExpression", "translatePropertiesAsConstructorParameters", "classDeclarationContext", "result", "Companion"}, moduleName="kotlin-compiler")
public final class ClassTranslator
extends AbstractTranslator {
    private final ClassDescriptor descriptor;
    private final KtClassOrObject classDeclaration;
    public static final Companion Companion = org.jetbrains.kotlin.js.translate.declaration.ClassTranslator$Companion.INSTANCE;

    private final JsExpression translateObjectLiteralExpression() {
        if (DescriptorUtils.getContainingClass(this.descriptor) == null) {
            TranslationContext translationContext = this.context();
            Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
            return this.translate(translationContext);
        }
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        return this.translateObjectInsideClass(translationContext);
    }

    private final JsInvocation translate(TranslationContext declarationContext) {
        return new JsInvocation(this.context().namer().classCreateInvocation(this.descriptor), this.getClassCreateInvocationArguments(declarationContext));
    }

    static /* synthetic */ JsInvocation translate$default(ClassTranslator classTranslator, TranslationContext translationContext, int n) {
        if ((n & 1) != 0) {
            TranslationContext translationContext2 = classTranslator.context();
            Intrinsics.checkExpressionValueIsNotNull(translationContext2, "context()");
            translationContext = translationContext2;
        }
        return classTranslator.translate(translationContext);
    }

    private final boolean isTrait() {
        return Intrinsics.areEqual((Object)this.descriptor.getKind(), (Object)ClassKind.INTERFACE);
    }

    private final List<JsExpression> getClassCreateInvocationArguments(TranslationContext declarationContext) {
        boolean hasStaticProperties;
        TranslationContext context = declarationContext;
        ArrayList<JsExpression> invocationArguments = new ArrayList<JsExpression>();
        SmartList properties2 = new SmartList();
        SmartList staticProperties = new SmartList();
        boolean isTopLevelDeclaration = Intrinsics.areEqual(this.context(), context);
        JsNameRef qualifiedReference = null;
        if (isTopLevelDeclaration) {
            DefinitionPlace definitionPlace = null;
            if (!this.descriptor.getKind().isSingleton() && !DescriptorUtils.isAnonymousObject(this.descriptor)) {
                JsScope scope2;
                qualifiedReference = context.getQualifiedReference(this.descriptor);
                JsScope jsScope = scope2 = this.context().getScopeForDescriptor(this.descriptor);
                if (jsScope == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsObjectScope");
                }
                definitionPlace = new DefinitionPlace((JsObjectScope)jsScope, qualifiedReference, staticProperties);
            }
            TranslationContext translationContext = context.newDeclaration(this.descriptor, definitionPlace);
            Intrinsics.checkExpressionValueIsNotNull(translationContext, "context.newDeclaration(d\u2026criptor, definitionPlace)");
            context = translationContext;
        }
        context = this.fixContextForCompanionObjectAccessing(context);
        invocationArguments.add(this.getSuperclassReferences(context));
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        DelegationTranslator delegationTranslator = new DelegationTranslator(this.classDeclaration, translationContext);
        if (!this.isTrait()) {
            JsFunction initializer2 = new ClassInitializerTranslator(this.classDeclaration, context).generateInitializeMethod(delegationTranslator);
            invocationArguments.add(initializer2.getBody().getStatements().isEmpty() ? (JsLiteral)JsLiteral.NULL : (JsLiteral)initializer2);
        }
        this.translatePropertiesAsConstructorParameters(context, properties2);
        DeclarationBodyVisitor bodyVisitor = new DeclarationBodyVisitor(properties2, staticProperties);
        bodyVisitor.traverseContainer(this.classDeclaration, context);
        delegationTranslator.generateDelegated(properties2);
        if (this.descriptor.isData()) {
            new JsDataClassGenerator(this.classDeclaration, context, properties2).generate();
        }
        if (DescriptorUtils.isEnumClass(this.descriptor)) {
            JsObjectLiteral enumEntries = new JsObjectLiteral(bodyVisitor.getEnumEntryList(), true);
            JsFunction function = TranslationUtils.simpleReturnFunction(context.getScopeForDescriptor(this.descriptor), enumEntries);
            invocationArguments.add(function);
        }
        this.generatedBridgeMethods(properties2);
        boolean bl = hasStaticProperties = !staticProperties.isEmpty();
        if (!properties2.isEmpty() || hasStaticProperties) {
            if (properties2.isEmpty()) {
                invocationArguments.add(JsLiteral.NULL);
            } else {
                if (qualifiedReference != null) {
                    invocationArguments.add(new JsDocComment("lends", new JsNameRef("prototype", (JsExpression)qualifiedReference)));
                }
                invocationArguments.add(new JsObjectLiteral(properties2, true));
            }
        }
        if (hasStaticProperties) {
            invocationArguments.add(new JsDocComment("lends", qualifiedReference));
            invocationArguments.add(new JsObjectLiteral(staticProperties, true));
        }
        return invocationArguments;
    }

    private final TranslationContext fixContextForCompanionObjectAccessing(TranslationContext context) {
        ClassDescriptor companionObjectDescriptor2 = this.descriptor.getCompanionObjectDescriptor();
        if (companionObjectDescriptor2 != null) {
            JsExpression referenceToClass = ReferenceTranslator.translateAsFQReference(companionObjectDescriptor2.getContainingDeclaration(), context);
            JsExpression companionObjectAccessor = Namer.getCompanionObjectAccessor(referenceToClass);
            ReceiverParameterDescriptor companionObjectReceiver = JsDescriptorUtils.getReceiverParameterForDeclaration(companionObjectDescriptor2);
            context.aliasingContext().registerAlias(companionObjectReceiver, companionObjectAccessor);
        }
        if (DescriptorUtils.isCompanionObject(this.descriptor)) {
            TranslationContext translationContext = context.innerContextWithAliased(this.descriptor.getThisAsReceiverParameter(), JsLiteral.THIS);
            Intrinsics.checkExpressionValueIsNotNull(translationContext, "context.innerContextWith\u2026ameter(), JsLiteral.THIS)");
            return translationContext;
        }
        return context;
    }

    private final JsExpression getSuperclassReferences(TranslationContext declarationContext) {
        List<JsExpression> superClassReferences = this.getSupertypesNameReferences();
        if (superClassReferences.isEmpty()) {
            JsExpression jsExpression = JsLiteral.NULL;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "JsLiteral.NULL");
            return jsExpression;
        }
        JsExpression jsExpression = TranslationUtils.simpleReturnFunction(declarationContext.scope(), new JsArrayLiteral(superClassReferences));
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "simpleReturnFunction(dec\u2026al(superClassReferences))");
        return jsExpression;
    }

    private final List<JsExpression> getSupertypesNameReferences() {
        List<KotlinType> supertypes2 = JsDescriptorUtils.getSupertypesWithoutFakes(this.descriptor);
        if (supertypes2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Collection $receiver = supertypes2;
        if ($receiver.size() == 1) {
            ClassDescriptor supertypeDescriptor;
            KotlinType type2 = supertypes2.get(0);
            ClassDescriptor classDescriptor = supertypeDescriptor = DescriptorUtils.getClassDescriptorForType(type2);
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "supertypeDescriptor");
            return CollectionsKt.listOf(this.getClassReference(classDescriptor));
        }
        HashSet<TypeConstructor> supertypeConstructors = new HashSet<TypeConstructor>();
        for (KotlinType type3 : supertypes2) {
            supertypeConstructors.add(type3.getConstructor());
        }
        List<TypeConstructor> sortedAllSuperTypes = TypeUtils.topologicallySortSuperclassesAndRecordAllInstances(this.descriptor.getDefaultType(), new HashMap(), new HashSet());
        ArrayList<JsNameRef> supertypesRefs = new ArrayList<JsNameRef>();
        for (TypeConstructor typeConstructor2 : sortedAllSuperTypes) {
            ClassDescriptor supertypeDescriptor;
            if (!supertypeConstructors.contains(typeConstructor2)) continue;
            ClassDescriptor classDescriptor = supertypeDescriptor = DescriptorUtils.getClassDescriptorForTypeConstructor(typeConstructor2);
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "supertypeDescriptor");
            supertypesRefs.add(this.getClassReference(classDescriptor));
        }
        return supertypesRefs;
    }

    private final JsNameRef getClassReference(ClassDescriptor superClassDescriptor) {
        JsNameRef jsNameRef = this.context().getQualifiedReference(superClassDescriptor);
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "context().getQualifiedRe\u2026nce(superClassDescriptor)");
        return jsNameRef;
    }

    private final void translatePropertiesAsConstructorParameters(TranslationContext classDeclarationContext, List<JsPropertyInitializer> result2) {
        for (KtParameter parameter : PsiUtils.getPrimaryConstructorParameters(this.classDeclaration)) {
            PropertyDescriptor descriptor2 = BindingUtils.getPropertyDescriptorForConstructorParameter(this.bindingContext(), parameter);
            if (descriptor2 == null) continue;
            PropertyTranslatorKt.translateAccessors(descriptor2, result2, classDeclarationContext);
        }
    }

    private final JsExpression translateObjectInsideClass(TranslationContext outerClassContext) {
        JsFunction function = new JsFunction(outerClassContext.scope(), new JsBlock(), "initializer for " + this.descriptor.getName().asString());
        TranslationContext funContext = outerClassContext.newFunctionBodyWithUsageTracker(function, this.descriptor);
        List<JsStatement> list = function.getBody().getStatements();
        TranslationContext translationContext = funContext;
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "funContext");
        list.add(new JsReturn(this.translate(translationContext)));
        TranslationContext translationContext2 = funContext;
        Intrinsics.checkExpressionValueIsNotNull(translationContext2, "funContext");
        MemberDescriptor memberDescriptor = this.descriptor;
        Intrinsics.checkExpressionValueIsNotNull(memberDescriptor, "descriptor");
        return LiteralFunctionTranslatorKt.withCapturedParameters(function, translationContext2, outerClassContext, memberDescriptor);
    }

    private final void generatedBridgeMethods(List<JsPropertyInitializer> properties2) {
        if (this.isTrait()) {
            return;
        }
        this.generateBridgesToTraitImpl(properties2);
        this.generateOtherBridges(properties2);
    }

    private final void generateBridgesToTraitImpl(List<JsPropertyInitializer> properties2) {
        for (Map.Entry<FunctionDescriptor, FunctionDescriptor> entry : CollectionsKt.mutableEntrySet(CodegenUtil.getTraitMethods(this.descriptor))) {
            FunctionDescriptor functionDescriptor = CollectionsKt.getKey(entry);
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "entry.getKey()");
            FunctionDescriptor functionDescriptor2 = CollectionsKt.getValue(entry);
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor2, "entry.getValue()");
            if (this.areNamesEqual(functionDescriptor, functionDescriptor2)) continue;
            FunctionDescriptor functionDescriptor3 = CollectionsKt.getValue(entry);
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor3, "entry.getValue()");
            FunctionDescriptor functionDescriptor4 = CollectionsKt.getKey(entry);
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor4, "entry.getKey()");
            JsExpression jsExpression = JsLiteral.THIS;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "JsLiteral.THIS");
            TranslationContext translationContext = this.context();
            Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
            properties2.add(UtilsKt.generateDelegateCall(functionDescriptor3, functionDescriptor4, jsExpression, translationContext));
        }
    }

    private final void generateOtherBridges(List<JsPropertyInitializer> properties2) {
        for (DeclarationDescriptor memberDescriptor : this.descriptor.getDefaultType().getMemberScope().getAllDescriptors()) {
            if (!(memberDescriptor instanceof FunctionDescriptor)) continue;
            Set bridgesToGenerate = ImplKt.generateBridgesForFunctionDescriptor((FunctionDescriptor)memberDescriptor, FunctionsKt.identity());
            for (Bridge<FunctionDescriptor> bridge : bridgesToGenerate) {
                this.generateBridge(bridge, properties2);
            }
        }
    }

    private final void generateBridge(Bridge<FunctionDescriptor> bridge, List<JsPropertyInitializer> properties2) {
        FunctionDescriptor toDescriptor;
        FunctionDescriptor fromDescriptor = bridge.getFrom();
        if (this.areNamesEqual(fromDescriptor, toDescriptor = bridge.getTo())) {
            return;
        }
        if (fromDescriptor.getKind().isReal() && Intrinsics.areEqual((Object)fromDescriptor.getModality(), (Object)Modality.ABSTRACT) ^ true && !toDescriptor.getKind().isReal()) {
            return;
        }
        JsExpression jsExpression = JsLiteral.THIS;
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "JsLiteral.THIS");
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        properties2.add(UtilsKt.generateDelegateCall(fromDescriptor, toDescriptor, jsExpression, translationContext));
    }

    private final boolean areNamesEqual(FunctionDescriptor first, FunctionDescriptor second) {
        JsName firstName = this.context().getNameForDescriptor(first);
        JsName secondName = this.context().getNameForDescriptor(second);
        return Intrinsics.areEqual(firstName.getIdent(), secondName.getIdent());
    }

    private ClassTranslator(KtClassOrObject classDeclaration, TranslationContext context) {
        super(context);
        this.classDeclaration = classDeclaration;
        this.descriptor = BindingUtils.getClassDescriptor(context.bindingContext(), this.classDeclaration);
    }

    public /* synthetic */ ClassTranslator(@NotNull KtClassOrObject classDeclaration, @NotNull TranslationContext context, DefaultConstructorMarker $constructor_marker) {
        this(classDeclaration, context);
    }

    @NotNull
    public static final /* synthetic */ JsInvocation access$translate(ClassTranslator $this, @NotNull TranslationContext declarationContext) {
        return $this.translate(declarationContext);
    }

    @JvmStatic
    @NotNull
    public static final JsInvocation generateClassCreation(@NotNull KtClassOrObject classDeclaration, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(classDeclaration, "classDeclaration");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return Companion.generateClassCreation(classDeclaration, context);
    }

    @JvmStatic
    @NotNull
    public static final JsExpression generateObjectLiteral(@NotNull KtObjectDeclaration objectDeclaration, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(objectDeclaration, "objectDeclaration");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return Companion.generateObjectLiteral(objectDeclaration, context);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"?\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\u0001R!\u0001\u0007\u0002\t\r\u000fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!\n\u0007\u0005\b!\rQ\"\u0001\r\u00033\rA)!D\u0001\u0019\u0007e\u0019\u0001rA\u0007\u00021\u0011)C\u0002b\u0002\t\n5\t\u0001$B\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0004\u001a\u0007!\u001dQ\"\u0001\r\u0005K1!\u0011\u0001#\u0004\u000e\u0003a9\u0011d\u0001E\b\u001b\u0005A\u0002\"G\u0002\t\b5\t\u0001\u0004B\u0013\u000f\u0011#iA!\u0003\u0002\n\u0003a9\u0001$C\r\u0004\u0011\u000bi\u0011\u0001g\u0005\u001a\u0007!\u001dQ\"\u0001\r\u0005"}, strings={"Lorg/jetbrains/kotlin/js/translate/declaration/ClassTranslator$Companion;", "", "()V", "generateClassCreation", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsInvocation;", "classDeclaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "generateObjectLiteral", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "objectDeclaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "generateSecondaryConstructor", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsPropertyInitializer;", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "translate", "", "Lorg/jetbrains/kotlin/psi/KtClass;"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<JsPropertyInitializer> translate(@NotNull KtClass classDeclaration, @NotNull TranslationContext context) {
            void $receiver;
            Intrinsics.checkParameterIsNotNull(classDeclaration, "classDeclaration");
            Intrinsics.checkParameterIsNotNull(context, "context");
            ArrayList<JsPropertyInitializer> result2 = CollectionsKt.arrayListOf(new JsPropertyInitializer[0]);
            ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(context.bindingContext(), classDeclaration);
            JsNameRef classNameRef = context.getNameForDescriptor(classDescriptor).makeRef();
            JsInvocation classCreation = this.generateClassCreation(classDeclaration, context);
            result2.add(new JsPropertyInitializer(classNameRef, classCreation));
            Iterable iterable = classDeclaration.getSecondaryConstructors();
            for (Object element : $receiver) {
                KtSecondaryConstructor it2 = (KtSecondaryConstructor)element;
                result2.add(Companion.generateSecondaryConstructor(it2, context));
            }
            return result2;
        }

        @JvmStatic
        @NotNull
        public final JsInvocation generateClassCreation(@NotNull KtClassOrObject classDeclaration, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(classDeclaration, "classDeclaration");
            Intrinsics.checkParameterIsNotNull(context, "context");
            return ClassTranslator.translate$default(new ClassTranslator(classDeclaration, context, null), null, 1);
        }

        @JvmStatic
        @NotNull
        public final JsExpression generateObjectLiteral(@NotNull KtObjectDeclaration objectDeclaration, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(objectDeclaration, "objectDeclaration");
            Intrinsics.checkParameterIsNotNull(context, "context");
            return new ClassTranslator(objectDeclaration, context, null).translateObjectLiteralExpression();
        }

        private final JsPropertyInitializer generateSecondaryConstructor(KtSecondaryConstructor constructor, TranslationContext context) {
            boolean delegationCtorInTheSameClass;
            ClassDescriptor delegationClassDescriptor;
            List<JsStatement> receiver;
            DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement(context.bindingContext(), constructor);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ConstructorDescriptor");
            }
            ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)declarationDescriptor;
            ClassDescriptor classDescriptor = constructorDescriptor.getContainingDeclaration();
            JsScope constructorScope = context.getScopeForDescriptor(constructorDescriptor);
            JsName thisName = constructorScope.declareName("$this");
            JsNameRef thisNameRef = thisName.makeRef();
            ReceiverParameterDescriptor receiverDescriptor = JsDescriptorUtils.getReceiverParameterForDeclaration(classDescriptor);
            TranslationContext translationContext = context.innerContextWithAliased(receiverDescriptor, thisNameRef);
            JsPropertyInitializer constructorInitializer = FunctionTranslator.newInstance(constructor, translationContext).translateAsMethod();
            JsExpression jsExpression = constructorInitializer.getValueExpr();
            if (jsExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsFunction");
            }
            JsFunction constructorFunction = (JsFunction)jsExpression;
            constructorFunction.getParameters().add(new JsParameter(thisName));
            JsNameRef referenceToClass = context.getQualifiedReference(classDescriptor);
            ArrayList<JsStatement> arrayList = CollectionsKt.arrayListOf(new JsStatement[0]);
            List<Object> $receiver = (ArrayList)receiver;
            ((ArrayList)$receiver).addAll((Collection)FunctionBodyTranslator.setDefaultValueForArguments(constructorDescriptor, context));
            JsInvocation createInstance = Namer.createObjectWithPrototypeFrom(referenceToClass);
            JsStatement instanceVar = JsAstUtils.assignment(thisNameRef, JsAstUtils.or(thisNameRef, createInstance)).makeStmt();
            ((ArrayList)$receiver).add(instanceVar);
            ResolvedCall<ConstructorDescriptor> resolvedCall = BindingContextUtils.getDelegationConstructorCall(context.bindingContext(), constructorDescriptor);
            ResolvedCall<ConstructorDescriptor> resolvedCall2 = resolvedCall;
            ClassDescriptor classDescriptor2 = resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null ? resolvedCall2.getContainingDeclaration() : (delegationClassDescriptor = null);
            if (resolvedCall != null) {
                ClassDescriptor classDescriptor3 = delegationClassDescriptor;
                if (classDescriptor3 == null) {
                    Intrinsics.throwNpe();
                }
                if (!KotlinBuiltIns.isAny(classDescriptor3)) {
                    JsExpression superCall = CallTranslator.translate$default(context, resolvedCall, null, 4);
                    JsExpression jsExpression2 = thisNameRef;
                    Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "thisNameRef");
                    ((ArrayList)$receiver).add(AstUtilsKt.toInvocationWith(superCall, jsExpression2).makeStmt());
                }
            }
            if (!(delegationCtorInTheSameClass = Intrinsics.areEqual(delegationClassDescriptor, classDescriptor)) && !DescriptorUtilsKt.hasPrimaryConstructor(classDescriptor)) {
                ((ArrayList)$receiver).add(new JsInvocation((JsExpression)Namer.getFunctionCallRef(referenceToClass), thisNameRef).makeStmt());
            }
            List forAddToBeginning = $receiver;
            receiver = constructorFunction.getBody().getStatements();
            $receiver = receiver;
            $receiver.addAll(0, forAddToBeginning);
            $receiver.add(new JsReturn(thisNameRef));
            JsPropertyInitializer jsPropertyInitializer = constructorInitializer;
            Intrinsics.checkExpressionValueIsNotNull(jsPropertyInitializer, "constructorInitializer");
            return jsPropertyInitializer;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

