/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallCheckerKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallData;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallDataWithCode;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.relocated.com.google.gwt.dev.js.parserExceptions.AbortParsingException;
import org.jetbrains.kotlin.relocated.com.google.gwt.dev.js.rhino.CodePosition;
import org.jetbrains.kotlin.relocated.com.google.gwt.dev.js.rhino.ErrorReporter;
import org.jetbrains.kotlin.resolve.BindingTrace;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"=\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0005\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u0001\"A\u0003\u0002\t\u000b)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001\u0001\u0007\u00013\u0005A\n!)\b\n\u0007!\tQ\"\u0001M\u0002\u0013\rA!!D\u0001\u0019\u0006%\u0019\u0001bA\u0007\u00021\u000f\t6!\u0001\u0005\u0005KA!1\u0002C\u0004\u000e\u0003a=\u0011d\u0001\u0005\t\u001b\u0005A*!G\u0002\t\u00125\t\u00014B\r\u0004\u0011%i\u0011\u0001g\u0003&5\u0011\t\u00012C\u0007\u00021\u001fI\u0012\u0002\u0003\u0006\u000e\u000f%\u0011\u0011\"\u0001M\u0002\u0013\tI\u0011\u0001G\u0006\u0019\u0016e\u0019\u0001\u0002C\u0007\u00021\u000bI2\u0001#\u0005\u000e\u0003a-\u0011d\u0001\u0005\n\u001b\u0005AZ!\n\t\u0005\u0017!]Q\"\u0001M\b3\rA\u0001\"D\u0001\u0019\u0006e\u0019\u0001\u0012C\u0007\u00021\u0017I2\u0001C\u0005\u000e\u0003a-\u0011f\u0002\u0003B\u0011!\u0011Q\"\u0001M\u0003#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001\"A\u0007\u00021\u0007\t6!A\u0003\u0001S\u001d!\u0011\t\u0003\u0005\u0004\u001b\u0005A:!U\u0002\u0002\u000b\u0001IC\u0002B!\t\u0011\u0013i\u0011\u0001G\u0003\u0016\u0003a-A$I)\u0004\u00075\u0011AA\u0002E\u0007"}, strings={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsCodeErrorReporter;", "Lorg/jetbrains/kotlin/relocated/com/google/gwt/dev/js/rhino/ErrorReporter;", "nodeToReport", "Lorg/jetbrains/kotlin/psi/KtExpression;", "code", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/String;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "absoluteOffset", "", "Lorg/jetbrains/kotlin/relocated/com/google/gwt/dev/js/rhino/CodePosition;", "getAbsoluteOffset", "(Lcom/google/gwt/dev/js/rhino/CodePosition;)I", "error", "", "message", "startPosition", "endPosition", "report", "diagnosticFactory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsCallData;", "warning"}, moduleName="kotlin-compiler")
public final class JsCodeErrorReporter
implements ErrorReporter {
    private final KtExpression nodeToReport;
    private final String code;
    private final BindingTrace trace;

    @Override
    public void warning(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull(startPosition, "startPosition");
        Intrinsics.checkParameterIsNotNull(endPosition, "endPosition");
        DiagnosticFactory1<KtExpression, JsCallData> diagnosticFactory1 = ErrorsJs.JSCODE_WARNING;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory1, "ErrorsJs.JSCODE_WARNING");
        this.report(diagnosticFactory1, message, startPosition, endPosition);
    }

    @Override
    public void error(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull(startPosition, "startPosition");
        Intrinsics.checkParameterIsNotNull(endPosition, "endPosition");
        DiagnosticFactory1<KtExpression, JsCallData> diagnosticFactory1 = ErrorsJs.JSCODE_ERROR;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory1, "ErrorsJs.JSCODE_ERROR");
        this.report(diagnosticFactory1, message, startPosition, endPosition);
        throw (Throwable)new AbortParsingException();
    }

    private final void report(DiagnosticFactory1<KtExpression, JsCallData> diagnosticFactory, String message, CodePosition startPosition, CodePosition endPosition) {
        JsCallData jsCallData;
        TextRange reportRange;
        if (JsCallCheckerKt.access$isConstantStringLiteral$p(this.nodeToReport)) {
            reportRange = new TextRange(this.getAbsoluteOffset(startPosition), this.getAbsoluteOffset(endPosition));
            jsCallData = new JsCallData(reportRange, message);
        } else {
            reportRange = this.nodeToReport.getTextRange();
            TextRange codeRange = new TextRange(JsCallCheckerKt.access$offsetOf(this.code, startPosition), JsCallCheckerKt.access$offsetOf(this.code, endPosition));
            TextRange textRange = reportRange;
            Intrinsics.checkExpressionValueIsNotNull(textRange, "reportRange");
            jsCallData = new JsCallDataWithCode(textRange, message, this.code, codeRange);
        }
        JsCallData data = jsCallData;
        ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = diagnosticFactory.on((KtExpression)((PsiElement)this.nodeToReport), data);
        this.trace.report(parametrizedDiagnostic);
    }

    private final int getAbsoluteOffset(CodePosition $receiver) {
        int quotesLength = this.nodeToReport.getFirstChild().getTextLength();
        return this.nodeToReport.getTextOffset() + quotesLength + JsCallCheckerKt.access$offsetOf(this.code, $receiver);
    }

    public JsCodeErrorReporter(@NotNull KtExpression nodeToReport, @NotNull String code, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(nodeToReport, "nodeToReport");
        Intrinsics.checkParameterIsNotNull(code, "code");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.nodeToReport = nodeToReport;
        this.code = code;
        this.trace = trace;
    }
}

