/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUCache;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinLightPackage;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.relocated.com.google.common.base.Function;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Collections2;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;

public class JavaElementFinder
extends PsiElementFinder
implements KotlinFinderMarker {
    private final Project project;
    private final PsiManager psiManager;
    private final LightClassGenerationSupport lightClassGenerationSupport;
    private final CachedValue<SLRUCache<FindClassesRequest, PsiClass[]>> findClassesCache;

    @NotNull
    public static JavaElementFinder getInstance(@NotNull Project project) {
        PsiElementFinder[] extensions;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getInstance"));
        }
        for (PsiElementFinder extension : extensions = Extensions.getArea(project).getExtensionPoint(PsiElementFinder.EP_NAME).getExtensions()) {
            if (!(extension instanceof JavaElementFinder)) continue;
            JavaElementFinder javaElementFinder = (JavaElementFinder)extension;
            if (javaElementFinder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getInstance"));
            }
            return javaElementFinder;
        }
        throw new IllegalStateException(JavaElementFinder.class.getSimpleName() + " is not found for project " + project);
    }

    public JavaElementFinder(@NotNull Project project, @NotNull LightClassGenerationSupport lightClassGenerationSupport) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/asJava/JavaElementFinder", "<init>"));
        }
        if (lightClassGenerationSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lightClassGenerationSupport", "org/jetbrains/kotlin/asJava/JavaElementFinder", "<init>"));
        }
        this.project = project;
        this.psiManager = PsiManager.getInstance(project);
        this.lightClassGenerationSupport = lightClassGenerationSupport;
        this.findClassesCache = CachedValuesManager.getManager(project).createCachedValue(new CachedValueProvider<SLRUCache<FindClassesRequest, PsiClass[]>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<SLRUCache<FindClassesRequest, PsiClass[]>> compute() {
                return new CachedValueProvider.Result<SLRUCache<FindClassesRequest, PsiClass[]>>(new SLRUCache<FindClassesRequest, PsiClass[]>(30, 10){

                    @Override
                    @NotNull
                    public PsiClass[] createValue(FindClassesRequest key) {
                        PsiClass[] psiClassArray = JavaElementFinder.this.doFindClasses(key.fqName, key.scope);
                        if (psiClassArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder$1$1", "createValue"));
                        }
                        return psiClassArray;
                    }
                }, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
            }
        }, false);
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findClass"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findClass"));
        }
        PsiClass[] allClasses = this.findClasses(qualifiedName, scope2);
        return allClasses.length > 0 ? allClasses[0] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedNameString, @NotNull GlobalSearchScope scope2) {
        SLRUCache<FindClassesRequest, PsiClass[]> value2;
        if (qualifiedNameString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedNameString", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findClasses"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findClasses"));
        }
        SLRUCache<FindClassesRequest, PsiClass[]> sLRUCache = value2 = this.findClassesCache.getValue();
        // MONITORENTER : sLRUCache
        PsiClass[] psiClassArray = value2.get(new FindClassesRequest(qualifiedNameString, scope2));
        // MONITOREXIT : sLRUCache
        if (psiClassArray != null) return psiClassArray;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findClasses"));
    }

    private PsiClass[] doFindClasses(String qualifiedNameString, GlobalSearchScope scope2) {
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        FqName qualifiedName = new FqName(qualifiedNameString);
        this.findClassesAndObjects(qualifiedName, scope2, answer);
        answer.addAll(this.lightClassGenerationSupport.getFacadeClasses(qualifiedName, scope2));
        return JavaElementFinder.sortByClasspath(answer, scope2).toArray(new PsiClass[answer.size()]);
    }

    private void findClassesAndObjects(FqName qualifiedName, GlobalSearchScope scope2, List<PsiClass> answer) {
        this.findInterfaceDefaultImpls(qualifiedName, scope2, answer);
        Collection<KtClassOrObject> classOrObjectDeclarations = this.lightClassGenerationSupport.findClassOrObjectDeclarations(qualifiedName, scope2);
        for (KtClassOrObject declaration : classOrObjectDeclarations) {
            PsiClass lightClass;
            if (declaration instanceof KtEnumEntry || (lightClass = LightClassUtil.INSTANCE$.getPsiClass(declaration)) == null) continue;
            answer.add(lightClass);
        }
    }

    private void findInterfaceDefaultImpls(FqName qualifiedName, GlobalSearchScope scope2, List<PsiClass> answer) {
        if (qualifiedName.isRoot()) {
            return;
        }
        if (!qualifiedName.shortName().asString().equals("DefaultImpls")) {
            return;
        }
        for (KtClassOrObject classOrObject : this.lightClassGenerationSupport.findClassOrObjectDeclarations(qualifiedName.parent(), scope2)) {
            PsiClass implsClass;
            PsiClass interfaceClass;
            if (!LightClassUtilsKt.getHasInterfaceDefaultImpls(classOrObject) || (interfaceClass = LightClassUtil.INSTANCE$.getPsiClass(classOrObject)) == null || (implsClass = interfaceClass.findInnerClassByName("DefaultImpls", false)) == null) continue;
            answer.add(implsClass);
        }
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClassNames"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClassNames"));
        }
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<KtClassOrObject> declarations = this.lightClassGenerationSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope2);
        HashSet<String> answer = Sets.newHashSet();
        answer.addAll(this.lightClassGenerationSupport.getFacadeNames(packageFQN, scope2));
        for (KtClassOrObject declaration : declarations) {
            String name = declaration.getName();
            if (name == null) continue;
            answer.add(name);
        }
        HashSet<String> hashSet = answer;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClassNames"));
        }
        return hashSet;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedNameString) {
        if (qualifiedNameString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedNameString", "org/jetbrains/kotlin/asJava/JavaElementFinder", "findPackage"));
        }
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            return null;
        }
        FqName fqName2 = new FqName(qualifiedNameString);
        GlobalSearchScope allScope = GlobalSearchScope.allScope(this.project);
        if (this.lightClassGenerationSupport.packageExists(fqName2, allScope)) {
            return new KotlinLightPackage(this.psiManager, fqName2, allScope);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getSubPackages"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getSubPackages"));
        }
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<FqName> subpackages = this.lightClassGenerationSupport.getSubPackages(packageFQN, scope2);
        Collection<PsiPackage> answer = Collections2.transform(subpackages, new Function<FqName, PsiPackage>(){

            @Override
            public PsiPackage apply(@Nullable FqName input) {
                return new KotlinLightPackage(JavaElementFinder.this.psiManager, input, scope2);
            }
        });
        PsiPackage[] psiPackageArray = answer.toArray(new PsiPackage[answer.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getSubPackages"));
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClasses"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClasses"));
        }
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        answer.addAll(this.lightClassGenerationSupport.getFacadeClassesInPackage(packageFQN, scope2));
        Collection<KtClassOrObject> declarations = this.lightClassGenerationSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope2);
        for (KtClassOrObject declaration : declarations) {
            PsiClass aClass = LightClassUtil.INSTANCE$.getPsiClass(declaration);
            if (aClass == null) continue;
            answer.add(aClass);
        }
        PsiClass[] psiClassArray = JavaElementFinder.sortByClasspath(answer, scope2).toArray(new PsiClass[answer.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiFile[] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getPackageFiles"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getPackageFiles"));
        }
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<KtFile> result2 = this.lightClassGenerationSupport.findFilesForPackage(packageFQN, scope2);
        PsiFile[] psiFileArray = result2.toArray(new PsiFile[result2.size()]);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getPackageFiles"));
        }
        return psiFileArray;
    }

    @Override
    @Nullable
    public Condition<PsiFile> getPackageFilesFilter(final @NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getPackageFilesFilter"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "getPackageFilesFilter"));
        }
        return new Condition<PsiFile>(){

            @Override
            public boolean value(PsiFile input) {
                if (!(input instanceof KtFile)) {
                    return true;
                }
                return psiPackage.getQualifiedName().equals(((KtFile)input).getPackageFqName().asString());
            }
        };
    }

    @NotNull
    public static Comparator<PsiElement> byClasspathComparator(final @NotNull GlobalSearchScope searchScope) {
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "byClasspathComparator"));
        }
        Comparator<PsiElement> comparator2 = new Comparator<PsiElement>(){

            @Override
            public int compare(@NotNull PsiElement o1, @NotNull PsiElement o2) {
                VirtualFile f2;
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "org/jetbrains/kotlin/asJava/JavaElementFinder$4", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "org/jetbrains/kotlin/asJava/JavaElementFinder$4", "compare"));
                }
                VirtualFile f1 = PsiUtilCore.getVirtualFile(o1);
                if (f1 == (f2 = PsiUtilCore.getVirtualFile(o2))) {
                    return 0;
                }
                if (f1 == null) {
                    return -1;
                }
                if (f2 == null) {
                    return 1;
                }
                return searchScope.compare(f2, f1);
            }
        };
        if (comparator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/JavaElementFinder", "byClasspathComparator"));
        }
        return comparator2;
    }

    private static Collection<PsiClass> sortByClasspath(@NotNull List<PsiClass> classes2, @NotNull GlobalSearchScope searchScope) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "org/jetbrains/kotlin/asJava/JavaElementFinder", "sortByClasspath"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/kotlin/asJava/JavaElementFinder", "sortByClasspath"));
        }
        if (classes2.size() > 1) {
            ContainerUtil.quickSort(classes2, JavaElementFinder.byClasspathComparator(searchScope));
        }
        return classes2;
    }

    private static class FindClassesRequest {
        private final String fqName;
        private final GlobalSearchScope scope;

        private FindClassesRequest(@NotNull String fqName2, @NotNull GlobalSearchScope scope2) {
            if (fqName2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/asJava/JavaElementFinder$FindClassesRequest", "<init>"));
            }
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/asJava/JavaElementFinder$FindClassesRequest", "<init>"));
            }
            this.fqName = fqName2;
            this.scope = scope2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FindClassesRequest request = (FindClassesRequest)o;
            if (!this.fqName.equals(request.fqName)) {
                return false;
            }
            return this.scope.equals(request.scope);
        }

        public int hashCode() {
            int result2 = this.fqName.hashCode();
            result2 = 31 * result2 + this.scope.hashCode();
            return result2;
        }

        public String toString() {
            return this.fqName + " in " + this.scope;
        }
    }
}

