/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CompressionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.FileChunkKey;
import com.intellij.util.io.LimitedInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.gnu.trove.TLongArrayList;

public class CompressedAppendableFile {
    private final File myBaseFile;
    private byte[] myNextChunkBuffer;
    private int myBufferPosition;
    private boolean myDirty;
    private short[] myChunkLengthTable;
    private int myChunkTableLength;
    private long[] myChunkOffsetTable;
    private static final boolean doDebug = SystemProperties.getBooleanProperty("idea.compressed.file.self.check", true);
    private TLongArrayList myCompressedChunksFileOffsets;
    private long myFileLength;
    private long myUncompressedFileLength;
    protected final int myAppendBufferLength;
    private static final FileChunkReadCache ourDecompressedCache = new FileChunkReadCache();

    protected File getChunkLengthFile() {
        return new File(this.myBaseFile.getPath() + ".s");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initChunkLengthTable() throws IOException {
        if (this.myChunkLengthTable != null) {
            return;
        }
        File chunkLengthFile = this.getChunkLengthFile();
        if (chunkLengthFile.exists()) {
            DataInputStream chunkLengthStream = new DataInputStream(new BufferedInputStream(new LimitedInputStream(new FileInputStream(chunkLengthFile), (int)chunkLengthFile.length()){

                @Override
                public int available() throws IOException {
                    return this.remainingLimit();
                }
            }, 32768));
            try {
                short[] chunkLengthTable = new short[(int)(chunkLengthFile.length() / 2L)];
                int chunkLengthTableLength = 0;
                long o = 0L;
                while (chunkLengthStream.available() != 0) {
                    int chunkLength = DataInputOutputUtil.readINT(chunkLengthStream);
                    o += (long)chunkLength;
                    if (chunkLengthTableLength == chunkLengthTable.length) {
                        chunkLengthTable = CompressedAppendableFile.reallocShortTable(chunkLengthTable);
                    }
                    chunkLengthTable[chunkLengthTableLength++] = (short)chunkLength;
                    if (!doDebug) continue;
                    this.myCompressedChunksFileOffsets.add(o);
                }
                this.myChunkLengthTable = chunkLengthTable;
                this.myChunkTableLength = chunkLengthTableLength;
                if (this.myChunkTableLength >= 32) {
                    int i;
                    long[] chunkOffsetTable = new long[this.myChunkTableLength / 32];
                    long offset = 0L;
                    for (i = 0; i < chunkOffsetTable.length; ++i) {
                        int start = i * 32;
                        for (int j = 0; j < 32; ++j) {
                            offset += (long)(chunkLengthTable[start + j] & 0xFFFF);
                        }
                        chunkOffsetTable[i] = offset;
                    }
                    this.myChunkOffsetTable = chunkOffsetTable;
                    if (doDebug) {
                        for (i = 0; i < chunkLengthTableLength; ++i) {
                            this.calcOffsetOfPage(i);
                        }
                    }
                } else {
                    this.myChunkOffsetTable = ArrayUtil.EMPTY_LONG_ARRAY;
                }
                this.myFileLength = this.calcOffsetOfPage(this.myChunkTableLength - 1);
            }
            finally {
                try {
                    chunkLengthStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.myChunkLengthTable = ArrayUtil.EMPTY_SHORT_ARRAY;
        this.myChunkTableLength = 0;
        this.myChunkOffsetTable = ArrayUtil.EMPTY_LONG_ARRAY;
        this.myFileLength = 0L;
        if (this.myUncompressedFileLength == -1L) {
            long tempFileLength = this.getIncompleteChunkFile().length();
            this.myUncompressedFileLength = (long)this.myChunkTableLength * (long)this.myAppendBufferLength + tempFileLength;
            if (this.myUncompressedFileLength != this.myFileLength + tempFileLength && CompressionUtil.DUMP_COMPRESSION_STATS) {
                System.out.println(this.myUncompressedFileLength + "->" + (this.myFileLength + tempFileLength) + " for " + this.myBaseFile);
            }
        }
    }

    private long calcOffsetOfPage(int pageNumber) {
        int calculatedOffset = (pageNumber + 1) / 32;
        long offset = calculatedOffset > 0 ? this.myChunkOffsetTable[calculatedOffset - 1] : 0L;
        int baseOffset = calculatedOffset * 32;
        int len = (pageNumber + 1) % 32;
        for (int index2 = 0; index2 < len; ++index2) {
            offset += (long)(this.myChunkLengthTable[baseOffset + index2] & 0xFFFF);
        }
        if (doDebug) assert (this.myCompressedChunksFileOffsets.get(pageNumber) == offset);
        return offset;
    }

    private void saveNextChunkIfNeeded() throws IOException {
        if (this.myBufferPosition == this.myNextChunkBuffer.length) {
            BufferExposingByteArrayOutputStream compressedOut = new BufferExposingByteArrayOutputStream();
            DataOutputStream compressedDataOut = new DataOutputStream(compressedOut);
            this.compress(compressedDataOut, this.myNextChunkBuffer);
            compressedDataOut.close();
            assert (compressedDataOut.size() <= 65535);
            this.saveChunk(compressedOut, this.myFileLength);
            this.myBufferPosition = 0;
            this.initChunkLengthTable();
            this.myFileLength += (long)compressedOut.size();
            if (doDebug) {
                this.myCompressedChunksFileOffsets.add(this.myFileLength);
            }
            if (this.myChunkLengthTable.length == this.myChunkTableLength) {
                this.myChunkLengthTable = CompressedAppendableFile.reallocShortTable(this.myChunkLengthTable);
            }
            this.myChunkLengthTable[this.myChunkTableLength++] = (short)compressedOut.size();
            if (this.myChunkTableLength / 32 > this.myChunkOffsetTable.length) {
                long[] newChunkOffsetTable = new long[this.myChunkOffsetTable.length + 1];
                System.arraycopy(this.myChunkOffsetTable, 0, newChunkOffsetTable, 0, this.myChunkOffsetTable.length);
                newChunkOffsetTable[this.myChunkOffsetTable.length] = this.myFileLength;
                this.myChunkOffsetTable = newChunkOffsetTable;
            }
            byte[] bytes = new byte[this.myAppendBufferLength];
            System.arraycopy(this.myNextChunkBuffer, 0, bytes, 0, this.myAppendBufferLength);
            ourDecompressedCache.put(this, this.myChunkTableLength - 1, bytes);
        }
    }

    private static short[] reallocShortTable(short[] table) {
        short[] newTable = new short[Math.max(table.length * 8 / 5, table.length + 1)];
        System.arraycopy(table, 0, newTable, 0, table.length);
        return newTable;
    }

    protected int compress(DataOutputStream compressedDataOut, byte[] buffer) throws IOException {
        return CompressionUtil.writeCompressedWithoutOriginalBufferLength(compressedDataOut, buffer, this.myAppendBufferLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveChunk(BufferExposingByteArrayOutputStream compressedChunk, long endOfFileOffset) throws IOException {
        DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getChunksFile(), true)));
        try {
            stream.write(compressedChunk.getInternalBuffer(), 0, compressedChunk.size());
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        DataOutputStream chunkLengthStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getChunkLengthFile(), true)));
        try {
            DataInputOutputUtil.writeINT(chunkLengthStream, compressedChunk.size());
        }
        finally {
            try {
                chunkLengthStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @NotNull
    protected File getChunksFile() {
        File file = new File(this.myBaseFile.getPath() + ".a");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/CompressedAppendableFile", "getChunksFile"));
        }
        return file;
    }

    private void saveIncompleteChunk() {
        if (this.myNextChunkBuffer != null && this.myBufferPosition != 0 && this.myDirty) {
            block10: {
                try {
                    this.saveNextChunkIfNeeded();
                    if (this.myBufferPosition == 0) break block10;
                    BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(this.getIncompleteChunkFile()));
                    try {
                        stream.write(this.myNextChunkBuffer, 0, this.myBufferPosition);
                    }
                    finally {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.myDirty = false;
        }
    }

    @NotNull
    private File getIncompleteChunkFile() {
        File file = new File(this.myBaseFile.getPath() + ".at");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/CompressedAppendableFile", "getIncompleteChunkFile"));
        }
        return file;
    }

    public synchronized void force() {
        this.saveIncompleteChunk();
    }

    public synchronized void dispose() {
        this.force();
    }

    private static class FileChunkReadCache
    extends SLRUMap<FileChunkKey<CompressedAppendableFile>, byte[]> {
        private final LowMemoryWatcher myLowMemoryWatcher = LowMemoryWatcher.register(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileChunkReadCache fileChunkReadCache = FileChunkReadCache.this;
                synchronized (fileChunkReadCache) {
                    FileChunkReadCache.this.clear();
                }
            }
        });
        private final FileChunkKey<CompressedAppendableFile> myKey = new FileChunkKey<Object>(null, 0L);

        public FileChunkReadCache() {
            super(64, 64);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(CompressedAppendableFile file, long page, byte[] bytes) {
            FileChunkReadCache fileChunkReadCache = this;
            synchronized (fileChunkReadCache) {
                this.myKey.setup(file, page);
                this.put(this.myKey, bytes);
            }
        }
    }
}

