/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.gnu.trove.THashMap;

public class MostlySingularMultiMap<K, V>
implements Serializable {
    protected final Map<K, Object> myMap = this.createMap();
    private static final MostlySingularMultiMap EMPTY = new EmptyMap();

    @NotNull
    protected Map<K, Object> createMap() {
        THashMap tHashMap = new THashMap();
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MostlySingularMultiMap", "createMap"));
        }
        return tHashMap;
    }

    public void add(@NotNull K key, @NotNull V value2) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/MostlySingularMultiMap", "add"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/MostlySingularMultiMap", "add"));
        }
        Object current = this.myMap.get(key);
        if (current == null) {
            this.myMap.put(key, value2);
        } else if (current instanceof Object[]) {
            Object[] curArr = (Object[])current;
            Object[] newArr = ArrayUtil.append(curArr, value2, ArrayUtil.OBJECT_ARRAY_FACTORY);
            this.myMap.put(key, newArr);
        } else {
            this.myMap.put(key, new Object[]{current, value2});
        }
    }

    public boolean processForKey(@NotNull K key, @NotNull Processor<? super V> p) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/MostlySingularMultiMap", "processForKey"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/util/containers/MostlySingularMultiMap", "processForKey"));
        }
        return this.processValue(p, this.myMap.get(key));
    }

    private boolean processValue(@NotNull Processor<? super V> p, Object v) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/util/containers/MostlySingularMultiMap", "processValue"));
        }
        if (v instanceof Object[]) {
            for (Object o : (Object[])v) {
                if (p.process(o)) continue;
                return false;
            }
        } else if (v != null) {
            return p.process(v);
        }
        return true;
    }

    public boolean processAllValues(@NotNull Processor<? super V> p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/util/containers/MostlySingularMultiMap", "processAllValues"));
        }
        for (Object v : this.myMap.values()) {
            if (this.processValue(p, v)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "{" + StringUtil.join(this.myMap.entrySet(), new Function<Map.Entry<K, Object>, String>(){

            @Override
            public String fun(Map.Entry<K, Object> entry) {
                Object value2 = entry.getValue();
                String s = (value2 instanceof Object[] ? Arrays.asList((Object[])value2) : Arrays.asList(value2)).toString();
                return entry.getKey() + ": " + s;
            }
        }, "; ") + "}";
    }

    private static class EmptyMap
    extends MostlySingularMultiMap {
        private EmptyMap() {
        }

        public void add(@NotNull Object key, @NotNull Object value2) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/MostlySingularMultiMap$EmptyMap", "add"));
            }
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/MostlySingularMultiMap$EmptyMap", "add"));
            }
            throw new IncorrectOperationException();
        }

        public boolean processForKey(@NotNull Object key, @NotNull Processor p) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/MostlySingularMultiMap$EmptyMap", "processForKey"));
            }
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/util/containers/MostlySingularMultiMap$EmptyMap", "processForKey"));
            }
            return true;
        }

        public boolean processAllValues(@NotNull Processor p) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/util/containers/MostlySingularMultiMap$EmptyMap", "processAllValues"));
            }
            return true;
        }
    }
}

