/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.CollectionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.CounterWithExclude;
import org.jetbrains.kotlin.util.ReenterableCounter;
import org.jetbrains.kotlin.util.SimpleCounter;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"E\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\tA!A\u0003\u0002\u0011\u0011)\u0001!B\u0001\t\"\u0015\tA\"A\u0003\u0002\t\u000b)\u0011\u0001#\u0003\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0005'1\u0001\u0001cD\r\u00021\u0003i\naDQ\b\t\tI1\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005\u0015\u0006BA\u0005\u0005\t\u001b\u0005!\u000b\"\u0005\u0002\u0005\u0001!E\u0011D\u0002\u0005\n\u001b\u0011I!!C\u0001%\u0012aM\u0011kA\u0001\t\u0015\u0015\u001a\u0001RC\u0007\u00021-)\u0003\u0002\u0002\u0002\t\u00185\t\u0001dC\r\u0004\u00111i\u0011\u0001g\u0004&\u001b!eQ\"\u0001\r\f3%AQ\"D\u0004\n\u0005%\t\u00014A\u0005\u0003\u0013\u0005A2\u0002g\u0007&\u0007!qQ\"\u0001\r\fK?Ai\"D\u0001%\u0012E\u0011A\u0001\u0001E\t3\u0019A\u0011\"\u0004\u0003\n\u0005%\tA\u0015\u0003M\n#\u000e\t\u0001BC\u0015\b\t\u0005c\u0002RA\u0007\u00021\r\t6!A\u0003\u0001S5!!\t\u0003E\u0004\u001b\u0011I!!C\u0001\u0019\na!\u0011k\u0001\u0003\u0006\u00015\u0011A!\u0002E\u0006S)!1\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0004\t\u000e%:A!\u0011\u000f\t\u000f5\t\u0001tB)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/util/PerformanceCounter;", "", "name", "", "(Ljava/lang/String;)V", "count", "", "excludedFrom", "", "Lorg/jetbrains/kotlin/util/CounterWithExclude;", "getExcludedFrom", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "totalTimeNanos", "", "countTime", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "increment", "", "incrementTime", "delta", "report", "consumer", "Lkotlin/Function1;", "reset", "time", "Companion"}, moduleName="kotlin-compiler")
public abstract class PerformanceCounter {
    private static final ArrayList<PerformanceCounter> allCounters;
    private static boolean enabled;
    @NotNull
    private final List<CounterWithExclude> excludedFrom;
    private int count;
    private long totalTimeNanos;
    @NotNull
    private final String name;
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.kotlin.util.PerformanceCounter$Companion.INSTANCE;
        allCounters = CollectionsKt.arrayListOf(new PerformanceCounter[0]);
    }

    @NotNull
    protected final List<CounterWithExclude> getExcludedFrom() {
        return this.excludedFrom;
    }

    public final void increment() {
        int n = this.count++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T time(@NotNull Function0<? extends T> block) {
        Intrinsics.checkParameterIsNotNull(block, "block");
        int n = this.count++;
        if (!org.jetbrains.kotlin.util.PerformanceCounter$Companion.INSTANCE.getEnabled()) {
            return block.invoke();
        }
        Iterable $receiver = this.excludedFrom;
        for (Object element : $receiver) {
            CounterWithExclude it2 = (CounterWithExclude)element;
            it2.enterExcludedMethod();
        }
        try {
            T t = this.countTime(block);
            return t;
        }
        finally {
            Iterable $receiver2 = this.excludedFrom;
            for (Object element : $receiver2) {
                CounterWithExclude it3 = (CounterWithExclude)element;
                it3.exitExcludedMethod();
            }
        }
    }

    public final void reset() {
        this.count = 0;
        this.totalTimeNanos = 0L;
    }

    protected final void incrementTime(long delta) {
        this.totalTimeNanos += delta;
    }

    protected abstract <T> T countTime(@NotNull Function0<? extends T> var1);

    public final void report(@NotNull Function1<? super String, ? extends Unit> consumer) {
        Intrinsics.checkParameterIsNotNull(consumer, "consumer");
        if (this.totalTimeNanos == 0L) {
            consumer.invoke(this.name + " performed " + this.count + " times");
        } else {
            long millis = TimeUnit.NANOSECONDS.toMillis(this.totalTimeNanos);
            consumer.invoke(this.name + " performed " + this.count + " times, total time " + millis + " ms");
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PerformanceCounter(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        this.name = name;
        this.excludedFrom = new ArrayList();
        ArrayList<PerformanceCounter> lock = org.jetbrains.kotlin.util.PerformanceCounter$Companion.INSTANCE.getAllCounters();
        synchronized (lock) {
            boolean bl = org.jetbrains.kotlin.util.PerformanceCounter$Companion.INSTANCE.getAllCounters().add(this);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"S\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\f\u0015\tAaA\u0003\u0002\u0011\u001d)\u0001!B\u0001\t\u0012\u0015\tA1A\u0003\u0002\u0011\u0013)\u0011\u0001b\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0005\u0007\ba\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQu\u0005\u0005\b\u001b\u0005A*!G\u0002\t\u00105\t\u0001\u0004C\r\n\u0011#iQ!C\u0002\u0005\u0002%\t\u0001T\u0001\r\n#\u0005A*!U\u0002\u0002\u0011')S\u0002b\u0002\t\u000f5\t\u0001TA\r\u0004\u0011\u001fi\u0011\u0001\u0007\u0005\u001a\t\u0011\t\u0001BC\u0007\u00021\u0013)3\u0001#\u0006\u000e\u0003aYQ%\u0007\u0003A!!]Q\"\u0001\u0013\r#\t!\u0001\u0001\u0003\u0007\u001a\r!eQ\u0002B\u0005\u0003\u0013\u0005!C\u0002G\u0007\u001a\r!mQ\u0002B\u0005\u0003\u0013\u0005!C\u0002\u0007\bR\u0007\t!i\u0002C\b&\u001b!}Q\"\u0001\r\u00113%A\t#D\u0004\n\u0005%\t\u0001\u0004C\u0005\u0003\u0013\u0005A\u0002\u0003G\t&\u0007!\rR\"\u0001\r\u0011K\u001dA!#D\u0001\u0019!e\u0019\u0001RE\u0007\u00021\u0013Ic\u0002B!\t\u0011\u0007iA!\u0003\u0002\n\u0003a\u0015\u0001DA)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t\rA9!\u000b\b\u0005\u0003rAA!D\u0001\u0019\nE\u001b\u0001\"B\u0001\r\u00025\u0011A!\u0002E\u0006#\t!a\u0001#\u0004"}, strings={"Lorg/jetbrains/kotlin/util/PerformanceCounter$Companion;", "", "()V", "allCounters", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/util/PerformanceCounter;", "getAllCounters", "()Ljava/util/ArrayList;", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "create", "name", "", "excluded", "", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/util/PerformanceCounter;)Lorg/jetbrains/kotlin/util/PerformanceCounter;", "reenterable", "currentTime", "", "getOrPut", "T", "threadLocal", "Ljava/lang/ThreadLocal;", "default", "Lkotlin/Function0;", "getOrPut$kotlin_compiler", "(Ljava/lang/ThreadLocal;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "report", "", "consumer", "Lkotlin/Function1;", "resetAllCounters", "setTimeCounterEnabled", "enable"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final ArrayList<PerformanceCounter> getAllCounters() {
            return allCounters;
        }

        private final boolean getEnabled() {
            return enabled;
        }

        private final void setEnabled(boolean bl) {
            enabled = bl;
        }

        public final long currentTime() {
            return System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void report(@NotNull Function1<? super String, ? extends Unit> consumer) {
            PerformanceCounter[] performanceCounterArray;
            Intrinsics.checkParameterIsNotNull(consumer, "consumer");
            ArrayList<PerformanceCounter> lock = this.getAllCounters();
            synchronized (lock) {
                Collection $receiver = org.jetbrains.kotlin.util.PerformanceCounter$Companion.INSTANCE.getAllCounters();
                Collection collection = $receiver;
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection = collection;
                PerformanceCounter[] performanceCounterArray2 = thisCollection.toArray(new PerformanceCounter[thisCollection.size()]);
                if (performanceCounterArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                performanceCounterArray = (PerformanceCounter[])((Object[])performanceCounterArray2);
            }
            PerformanceCounter[] countersCopy = performanceCounterArray;
            Object[] $receiver = countersCopy;
            for (int i = 0; i < $receiver.length; ++i) {
                Object element = $receiver[i];
                PerformanceCounter it2 = (PerformanceCounter)element;
                it2.report(consumer);
            }
        }

        public final void setTimeCounterEnabled(boolean enable) {
            this.setEnabled(enable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void resetAllCounters() {
            ArrayList<PerformanceCounter> lock = this.getAllCounters();
            synchronized (lock) {
                Iterable $receiver = org.jetbrains.kotlin.util.PerformanceCounter$Companion.INSTANCE.getAllCounters();
                for (Object element : $receiver) {
                    PerformanceCounter it2 = (PerformanceCounter)element;
                    it2.reset();
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @JvmOverloads
        @NotNull
        public final PerformanceCounter create(@NotNull String name, boolean reenterable) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            return reenterable ? (PerformanceCounter)new ReenterableCounter(name) : (PerformanceCounter)new SimpleCounter(name);
        }

        @JvmOverloads
        @NotNull
        public static /* synthetic */ PerformanceCounter create$default(Companion companion, String string, boolean bl, int n) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.create(string, bl);
        }

        @JvmOverloads
        @NotNull
        public PerformanceCounter create(@NotNull String string) {
            return org.jetbrains.kotlin.util.PerformanceCounter$Companion.create$default(this, string, false, 2);
        }

        @NotNull
        public final PerformanceCounter create(@NotNull String name, PerformanceCounter ... excluded) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(excluded, "excluded");
            return new CounterWithExclude(name, Arrays.copyOf(excluded, excluded.length));
        }

        public final <T> T getOrPut$kotlin_compiler(@NotNull ThreadLocal<T> threadLocal, @NotNull Function0<? extends T> function0) {
            Intrinsics.checkParameterIsNotNull(threadLocal, "threadLocal");
            Intrinsics.checkParameterIsNotNull(function0, "default");
            T value2 = threadLocal.get();
            if (value2 == null) {
                value2 = function0.invoke();
                threadLocal.set(value2);
            }
            return value2;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }

        public static final /* synthetic */ void access$setEnabled$p(Companion $this, boolean bl) {
            $this.setEnabled(bl);
        }
    }
}

