/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.typeUtil;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.types.DelegatingType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeCapabilitiesKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeNullability;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"i\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005AY!B\u0001\u0005\u0003\u0015\t\u0001\u0002E\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u0001bD\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAAB\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u001bGA1!D\u0001\u0019\be\u0019\u0001\u0002B\u0007\u00021\u0005I2\u0001#\u0003\u000e\u0003a)\u0011\u0004\u0002E\u0006\u001b\ta\t\u0001\u0007\u0004U\u0007\u000bii\u0001#\u0004\u000e\u0003a9Q#\u0001\r\u0002)\u000e\u0015QR\u0002E\b\u001b\u0005Ar!F\u0001\u0019\u0003Q\u001b)!$\u0007\t\u00115!\u0011BA\u0005\u00021\u000fA\n\"\u0006\u0003\n\u0005%\t\u0001$\u0001M\t)\u000e\u0015Qr\u0005\u0005\n\u001b\u0005Ar!F\u0001\u0019\u0014e-\u0001BC\u0007\u0003\u0019\u0003A\u0012\u0001UB\u00013\u0017A)\"\u0004\u0002\r\u0002a\t\u0001kA\u0001U\u0007\u000bi\u0019\u0002C\u0006\u000e\t%\u0011\u0011\"\u0001\r\u00071/)\u0012\u0001\u0007\u0007U\u0007\u000bi\u0019\u0002#\u0007\u000e\t%\u0011\u0011\"\u0001\r\u000e1/)\u0012\u0001G\u0001U\u0007\u000bi)\u0002B\u0001\t\u001c5!\u0011BA\u0005\u00021\u0019A:\"F\u0001\u0019\u0003Q\u001b)!d\u0005\t\u001d5!\u0011BA\u0005\u00021\u000fA\n\"F\u0001\u0019\u0003Q\u001b)!d\u0005\t\u001e5!\u0011BA\u0005\u00021\u0005A:\"F\u0001\u0019\u0003Q\u001b)!$\u0004\t\u001f5\t\u0001dB\u000b\u00021\u0005!6QAG\u0007\u0011?i\u0011\u0001G\u0004\u0016\u0003a\tAk!\u0002\u000e\u000e!\u0001R\"\u0001\r\b+\u0005A\u0012\u0001VB\u0003\u001b\u001bA\t#D\u0001\u0019\u000fU\t\u0001$\u0001+\u0004\u000655\u0001\"E\u0007\u00021\u001d)\u0012\u0001G\u0001U\u0007\u000biA\u0002c\t\u000e\u0003a9Q#\u0001\r\u00023\u0013A!#D\u0001\u0019\u0003A\u001b\t\u0001VB\u0003\u001b\u001bA)#D\u0001\u0019\u000fU\t\u0001$\u0001+\u0004\u00065I\u0001bEG\u00041\u0005\t6!\u0001C\u0014+\u0005A\u0012\u0001VB\u0003\u001b%AA#d\u0002\u0019\u0003E\u001b\u0011\u0001b\n\u0016\u0003a\tAk!\u0002\u000e\u000e!%R\"\u0001\r\u0016+\u0005A\u0012\u0001VB\u0003\u001b1AY#D\u0001\u0019\u0003U\t\u0001$AM\u0005\u0011Yi\u0011\u0001'\fQ\u0007\u0003!6QA\u0007\u0013\u0011]i\u0011\u0001g\u0002\u0016\u0003a\u001d\u0011T\u0003E\u0018\u001b\u001dI!!C\u0001\u0019\u0003%\u0011\u0011\"\u0001\r\u00021a\u00016\u0011\u0001+\u0004\u00065M\u0001\u0012G\u0007\u0005\u0013\tI\u0011\u0001G\u0001\u0019\u0018U\t\u0001$\u0001+\u0004\u0006EmAa\u0011\u0005\t\u00015\t\u0001\u0014A\u000b\u00021\u0005a2%U\u0002\u0004\u001b\t!\u0019\u0001\u0003\u0002U\u0007\u000b\u0001"}, strings={"builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getBuiltIns", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "TypeUtilsKt", "createProjection", "Lorg/jetbrains/kotlin/types/TypeProjection;", "type", "projectionKind", "Lorg/jetbrains/kotlin/types/Variance;", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "cannotBeReified", "", "containsError", "defaultProjections", "", "equalTypesOrNulls", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;", "type1", "type2", "getCapturedTypeParameters", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getContainedAndCapturedTypeParameterConstructors", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "getContainedTypeParameters", "getNestedArguments", "immediateSupertypes", "isAnyOrNullableAny", "isBoolean", "isBooleanOrNullableBoolean", "isDefaultBound", "isNothing", "isSubtypeOf", "superType", "isUnit", "makeNotNullable", "Lorg/jetbrains/annotations/NotNull;", "makeNullable", "nullability", "Lorg/jetbrains/kotlin/types/typeUtil/TypeNullability;", "replaceAnnotations", "newAnnotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "substitute", "doSubstitute", "Lkotlin/Function1;", "supertypes"}, moduleName="kotlin-compiler")
public final class TypeUtilsKt {
    @NotNull
    public static final TypeNullability nullability(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FlexibleTypesKt.isNullabilityFlexible($receiver) ? TypeNullability.FLEXIBLE : (TypeUtils.isNullableType($receiver) ? TypeNullability.NULLABLE : TypeNullability.NOT_NULL);
    }

    @NotNull
    public static final KotlinBuiltIns getBuiltIns(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        KotlinBuiltIns kotlinBuiltIns = $receiver.getConstructor().getBuiltIns();
        Intrinsics.checkExpressionValueIsNotNull(kotlinBuiltIns, "constructor.builtIns");
        return kotlinBuiltIns;
    }

    @NotNull
    public static final KotlinType makeNullable(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TypeUtils.makeNullable($receiver);
    }

    @NotNull
    public static final KotlinType makeNotNullable(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TypeUtils.makeNotNullable($receiver);
    }

    @NotNull
    public static final Collection<KotlinType> immediateSupertypes(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Collection collection = TypeUtils.getImmediateSupertypes($receiver);
        Intrinsics.checkExpressionValueIsNotNull(collection, "TypeUtils.getImmediateSupertypes(this)");
        return collection;
    }

    @NotNull
    public static final Collection<KotlinType> supertypes(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Collection collection = TypeUtils.getAllSupertypes($receiver);
        Intrinsics.checkExpressionValueIsNotNull(collection, "TypeUtils.getAllSupertypes(this)");
        return collection;
    }

    public static final boolean isNothing(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isNothing($receiver);
    }

    public static final boolean isUnit(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isUnit($receiver);
    }

    public static final boolean isAnyOrNullableAny(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isAnyOrNullableAny($receiver);
    }

    public static final boolean isBoolean(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isBoolean($receiver);
    }

    public static final boolean isBooleanOrNullableBoolean(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isBooleanOrNullableBoolean($receiver);
    }

    private static final Collection<TypeParameterDescriptor> getContainedTypeParameters(KotlinType $receiver) {
        Collection destination;
        Object it2;
        Iterable $receiver2;
        ClassifierDescriptor declarationDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof TypeParameterDescriptor) {
            return kotlin.CollectionsKt.listOf(declarationDescriptor);
        }
        Flexibility flexibility = $receiver.getCapability(Flexibility.class);
        if (flexibility != null) {
            return kotlin.CollectionsKt.plus(TypeUtilsKt.getContainedTypeParameters(flexibility.getLowerBound()), (Iterable)TypeUtilsKt.getContainedTypeParameters(flexibility.getUpperBound()));
        }
        Iterable $receiver3 = $receiver.getArguments();
        Iterable iterable = $receiver3;
        Collection collection = new ArrayList();
        for (Object element : $receiver2) {
            it2 = (TypeProjection)element;
            if (!(!it2.isStarProjection())) continue;
            destination.add(element);
        }
        $receiver3 = (List)destination;
        $receiver2 = $receiver3;
        destination = new ArrayList(kotlin.CollectionsKt.collectionSizeOrDefault($receiver3, 10));
        for (Object item : $receiver2) {
            it2 = (TypeProjection)item;
            Collection collection2 = destination;
            KotlinType kotlinType = it2.getType();
            collection2.add(kotlinType);
        }
        $receiver3 = (List)destination;
        $receiver2 = $receiver3;
        destination = new ArrayList();
        for (Object element : $receiver2) {
            it2 = (KotlinType)element;
            Iterable list = TypeUtilsKt.getContainedTypeParameters((KotlinType)it2);
            kotlin.CollectionsKt.addAll(destination, list);
        }
        return (List)destination;
    }

    @NotNull
    public static final Collection<TypeParameterDescriptor> getCapturedTypeParameters(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        LinkedHashSet<TypeParameterDescriptor> result2 = new LinkedHashSet<TypeParameterDescriptor>();
        DeclarationDescriptor containingDeclaration = $receiver.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            result2.addAll(TypeUtilsKt.getContainedTypeParameters(((ClassDescriptor)containingDeclaration).getDefaultType()));
        } else if (containingDeclaration instanceof CallableDescriptor) {
            Collection collection = ((CallableDescriptor)containingDeclaration).getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(collection, "containingDeclaration.getTypeParameters()");
            result2.addAll(collection);
        }
        if (containingDeclaration != null) {
            result2.addAll(TypeUtilsKt.getCapturedTypeParameters(containingDeclaration));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<TypeConstructor> getContainedAndCapturedTypeParameterConstructors(KotlinType $receiver) {
        void destination;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Object object = $receiver.getConstructor().getDeclarationDescriptor();
        if (object == null || (object = TypeUtilsKt.getCapturedTypeParameters((DeclarationDescriptor)object)) == null) {
            object = kotlin.CollectionsKt.emptyList();
        }
        Object capturedTypeParameters = object;
        List<TypeParameterDescriptor> typeParameters = kotlin.CollectionsKt.plus(TypeUtilsKt.getContainedTypeParameters($receiver), (Iterable)capturedTypeParameters);
        Iterable $receiver3 = typeParameters;
        Iterable iterable = $receiver3;
        Collection collection = new ArrayList(kotlin.CollectionsKt.collectionSizeOrDefault($receiver3, 10));
        for (Object item : $receiver2) {
            void it2;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item;
            void var9_9 = destination;
            TypeConstructor typeConstructor2 = it2.getTypeConstructor();
            var9_9.add(typeConstructor2);
        }
        return CollectionsKt.toReadOnlyList((List)destination);
    }

    public static final boolean isSubtypeOf(KotlinType $receiver, @NotNull KotlinType superType) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(superType, "superType");
        return KotlinTypeChecker.DEFAULT.isSubtypeOf($receiver, superType);
    }

    public static final boolean cannotBeReified(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isNothingOrNullableNothing($receiver) || DynamicTypesKt.isDynamic($receiver);
    }

    @NotNull
    public static final TypeProjection substitute(TypeProjection $receiver, @NotNull Function1<? super KotlinType, ? extends KotlinType> doSubstitute) {
        TypeProjection typeProjection;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(doSubstitute, "doSubstitute");
        if ($receiver.isStarProjection()) {
            typeProjection = $receiver;
        } else {
            Variance variance = $receiver.getProjectionKind();
            KotlinType kotlinType = $receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "getType()");
            typeProjection = new TypeProjectionImpl(variance, doSubstitute.invoke(kotlinType));
        }
        return typeProjection;
    }

    @NotNull
    public static final KotlinType replaceAnnotations(KotlinType $receiver, @NotNull Annotations newAnnotations) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(newAnnotations, "newAnnotations");
        if (newAnnotations.isEmpty()) {
            return $receiver;
        }
        return new DelegatingType($receiver, newAnnotations){
            final /* synthetic */ KotlinType receiver$0;
            final /* synthetic */ Annotations $newAnnotations;

            @NotNull
            protected KotlinType getDelegate() {
                return this.receiver$0;
            }

            @NotNull
            public Annotations getAnnotations() {
                return this.$newAnnotations;
            }
            {
                this.receiver$0 = $receiver;
                this.$newAnnotations = $captured_local_variable$1;
            }
        };
    }

    public static final boolean equalTypesOrNulls(KotlinTypeChecker $receiver, @Nullable KotlinType type1, @Nullable KotlinType type2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return $receiver.equalTypes(type1, type2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeProjection> getNestedArguments(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ArrayList<TypeProjection> result2 = new ArrayList<TypeProjection>();
        ArrayDeque<TypeProjection> stack = new ArrayDeque<TypeProjection>();
        stack.push(new TypeProjectionImpl($receiver));
        while (!stack.isEmpty()) {
            void $receiver2;
            TypeProjection typeProjection = (TypeProjection)stack.pop();
            if (typeProjection.isStarProjection()) continue;
            result2.add(typeProjection);
            Iterable iterable = typeProjection.getType().getArguments();
            for (Object element : $receiver2) {
                TypeProjection it2 = (TypeProjection)element;
                stack.add(it2);
            }
        }
        return result2;
    }

    public static final boolean containsError(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return ErrorUtils.containsErrorType($receiver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeProjection> defaultProjections(List<? extends KotlinType> $receiver) {
        void var3_3;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterable $receiver3 = $receiver;
        Iterable iterable = $receiver3;
        Collection destination = new ArrayList(kotlin.CollectionsKt.collectionSizeOrDefault($receiver3, 10));
        for (Object item : $receiver2) {
            void it2;
            KotlinType kotlinType = (KotlinType)item;
            Collection collection = destination;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl((KotlinType)it2);
            collection.add(typeProjectionImpl);
        }
        return (List)var3_3;
    }

    public static final boolean isDefaultBound(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isDefaultBound(TypeCapabilitiesKt.getSupertypeRepresentative($receiver));
    }

    @NotNull
    public static final TypeProjection createProjection(@NotNull KotlinType type2, @NotNull Variance projectionKind, @Nullable TypeParameterDescriptor typeParameterDescriptor) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull((Object)projectionKind, "projectionKind");
        TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
        return new TypeProjectionImpl(Intrinsics.areEqual((Object)(typeParameterDescriptor2 != null ? typeParameterDescriptor2.getVariance() : null), (Object)projectionKind) ? Variance.INVARIANT : projectionKind, type2);
    }
}

