/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions.unqualifiedSuper;

import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"O\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005Aq!B\u0001\t\t\u0015\tA!A\u0003\u0002\u0011=)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005AY!\u0002\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\n\u0015\tA\"A\u0003\u0002\t\riI\u0003B\u0001\t\u00065!\u0011BA\u0005\u00021\u000fA2!G\u0002\t\t5\t\u0001\u0014B\r\u0004\u0011\u0015i\u0011\u0001g\u0003\u001a\u0007!1Q\"\u0001M\u0007)\u000e\u0011Q\u0012\u0006\u0003\u0002\u0011\u001diA!\u0003\u0002\n\u0003a\u001d\u0001dA\r\u0004\u0011\u0011i\u0011\u0001'\u0003\u001a\u0007!)Q\"\u0001M\u00063\rAa!D\u0001\u0019\u000eQ\u001b!!d\u0007\u0005\u0003!=Q\"\u0001\r\t3\rA\t\"D\u0001\u0019\u0013e\u0019\u00012C\u0007\u00021\u0017!6AAG\n\t\u0005A!\"D\u0001\u0019\u0011e\u0019\u0001RC\u0007\u00021-!6AAG\u000e\t\u0005A9\"D\u0001\u0019\u0011e\u0019\u0001\u0002D\u0007\u00021\u0013I2\u0001#\u0007\u000e\u0003a\u001dAk\u0001\u0002\u000e !iQ\"\u0001\r\t3\rA)\"D\u0001\u0019\u0017e1\u00012D\u0007\u0005\u0013\tI\u0011\u0001'\u0003\u0019\u0007Q\u001b!!d\f\u0005\u0003!qQ\u0002B\u0005\u0003\u0013\u0005AJ\u0001G\u0002\u001a\r!mQ\u0002B\u0005\u0003\u0013\u0005AJ\u0001G\u0002\u001a\u0007!MQ\"\u0001M\u00063\rAa!D\u0001\u0019\u000eQ\u001b!!D\u0011\u0005\u0003BAi\"\u0004\u0003\n\u0005%\t\u0001\u0014\u0002\r\u00043\u0019AY\"\u0004\u0003\n\u0005%\t\u0001\u0014\u0002\r\u00043\rAq\"D\u0001\u0019\u0011ea\u0001rD\u0007\u000b\u0013\tI\u0011\u0001'\u0003\n\u000b%!\u0011BA\u0005\u00021\u000fA2\u0001\u0007\tU\u0007\tiy\u0003B\u0001\t\"5!\u0011BA\u0005\u00021\u0013A2!\u0007\u0004\t\u001c5!\u0011BA\u0005\u00021\u0013A2!G\u0002\t#5\t\u00014B\r\u0004\u0011\u0019i\u0011\u0001'\u0004U\u0007\ti9\u0004B\u0001\t$5!\u0011BA\u0005\u00021\u0013A2!\u0007\u0004\t\u001c5!\u0011BA\u0005\u00021\u0013A2!G\u0002\t\u00145\t\u00014B\r\u0004\u0011\u0019i\u0011\u0001'\u0004\u001a\u0007!\u0011R\"\u0001M\u0005)\u000e\u0011QR\u0006E\u0013\u001b\u0011I!!C\u0001\u0019\na\u0019\u0011d\u0001E\u000b\u001b\u0005A2\"\u0007\u0004\t\u001c5!\u0011BA\u0005\u00021\u0013A2!G\u0002\t%5\t\u0001\u0014\u0002+\u0004\u00055=A!\u0001\u0005\u0014\u001b\u0005A\u0002\"F\u0001\u0019\nQ\u001b!!%\b\u0005\u0003\"A\u0001!D\u0004\n\u0005%\t\u0001$A\u0005\u0003\u0013\u0005A\u001a\u0001'\u0001R\u0007\u0005)\u0001\u0001V\u0002\u0003"}, strings={"ARITY_OF_METHODS_OF_ANY", "Ljava/util/HashMap;", "", "", "UnqualifiedSuperKt", "getFunctionMembers", "", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "name", "Lorg/jetbrains/kotlin/name/Name;", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getPropertyMembers", "isCallingMethodOfAny", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "calleeName", "isCallingMethodOfAnyWithSuper", "superExpression", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "isConcreteMember", "supertype", "memberDescriptor", "isPossiblyAmbiguousUnqualifiedSuper", "supertypes", "resolveSupertypesByCalleeName", "resolveSupertypesByMembers", "allowArbitraryMembers", "getMembers", "Lkotlin/Function1;", "resolveSupertypesByPropertyName", "propertyName", "resolveSupertypesForMethodOfAny", "anyType", "resolveUnqualifiedSuperFromExpressionContext", "isInterface"}, moduleName="kotlin-compiler")
public final class UnqualifiedSuperKt {
    private static final HashMap<String, Integer> ARITY_OF_METHODS_OF_ANY = MapsKt.hashMapOf(TuplesKt.to("hashCode", 0), TuplesKt.to("equals", 1), TuplesKt.to("toString", 0));

    @NotNull
    public static final Collection<KotlinType> resolveUnqualifiedSuperFromExpressionContext(@NotNull KtSuperExpression superExpression, @NotNull Collection<? extends KotlinType> supertypes2, @NotNull KotlinType anyType) {
        Intrinsics.checkParameterIsNotNull(superExpression, "superExpression");
        Intrinsics.checkParameterIsNotNull(supertypes2, "supertypes");
        Intrinsics.checkParameterIsNotNull(anyType, "anyType");
        PsiElement parentElement = superExpression.getParent();
        if (parentElement instanceof KtDotQualifiedExpression) {
            KtExpression selectorExpression = ((KtDotQualifiedExpression)parentElement).getSelectorExpression();
            KtExpression ktExpression = selectorExpression;
            if (ktExpression instanceof KtCallExpression) {
                KtExpression calleeExpression = ((KtCallExpression)selectorExpression).getCalleeExpression();
                if (calleeExpression instanceof KtSimpleNameExpression) {
                    Name calleeName = ((KtSimpleNameExpression)calleeExpression).getReferencedNameAsName();
                    NoLookupLocation location = NoLookupLocation.WHEN_TYPING;
                    if (UnqualifiedSuperKt.isCallingMethodOfAny((KtCallExpression)selectorExpression, calleeName)) {
                        return UnqualifiedSuperKt.resolveSupertypesForMethodOfAny(supertypes2, calleeName, location, anyType);
                    }
                    return UnqualifiedSuperKt.resolveSupertypesByCalleeName(supertypes2, calleeName, location);
                }
            } else if (ktExpression instanceof KtSimpleNameExpression) {
                return UnqualifiedSuperKt.resolveSupertypesByPropertyName(supertypes2, ((KtSimpleNameExpression)selectorExpression).getReferencedNameAsName(), NoLookupLocation.WHEN_TYPING);
            }
        }
        return CollectionsKt.emptyList();
    }

    private static final boolean isCallingMethodOfAny(KtCallExpression callExpression, Name calleeName) {
        Collection $receiver;
        Map map2 = ARITY_OF_METHODS_OF_ANY;
        String string = calleeName.asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "calleeName.asString()");
        String key = string;
        Object value2 = $receiver.get(key);
        Object object = value2 == null && !$receiver.containsKey(key) ? Integer.valueOf(-1) : value2;
        $receiver = callExpression.getValueArguments();
        int n = ((Number)object).intValue();
        int n2 = $receiver.size();
        return n == n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPossiblyAmbiguousUnqualifiedSuper(@NotNull KtSuperExpression superExpression, @NotNull Collection<? extends KotlinType> supertypes2) {
        Intrinsics.checkParameterIsNotNull(superExpression, "superExpression");
        Intrinsics.checkParameterIsNotNull(supertypes2, "supertypes");
        Collection<? extends KotlinType> $receiver = supertypes2;
        if ($receiver.size() > 1) return true;
        $receiver = supertypes2;
        if ($receiver.size() != 1) return false;
        if (!UnqualifiedSuperKt.isInterface((KotlinType)CollectionsKt.single((Iterable)supertypes2))) return false;
        if (!UnqualifiedSuperKt.isCallingMethodOfAnyWithSuper(superExpression)) return false;
        return true;
    }

    private static final boolean isCallingMethodOfAnyWithSuper(KtSuperExpression superExpression) {
        KtExpression calleeExpression;
        KtExpression selectorExpression;
        PsiElement parent2 = superExpression.getParent();
        if (parent2 instanceof KtDotQualifiedExpression && (selectorExpression = ((KtDotQualifiedExpression)parent2).getSelectorExpression()) instanceof KtCallExpression && (calleeExpression = ((KtCallExpression)selectorExpression).getCalleeExpression()) instanceof KtSimpleNameExpression) {
            Name calleeName = ((KtSimpleNameExpression)calleeExpression).getReferencedNameAsName();
            return UnqualifiedSuperKt.isCallingMethodOfAny((KtCallExpression)selectorExpression, calleeName);
        }
        return false;
    }

    private static final boolean isInterface(KotlinType $receiver) {
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor($receiver);
        return Intrinsics.areEqual((Object)(classDescriptor != null ? classDescriptor.getKind() : null), (Object)ClassKind.INTERFACE);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<KotlinType> resolveSupertypesForMethodOfAny(Collection<? extends KotlinType> supertypes2, Name calleeName, LookupLocation location, KotlinType anyType) {
        void allowArbitraryMembers;
        boolean bl = false;
        SmartList<KotlinType> typesWithConcreteMembers = new SmartList<KotlinType>();
        SmartList<KotlinType> typesWithArbitraryMembers = new SmartList<KotlinType>();
        for (KotlinType kotlinType : supertypes2) {
            boolean bl2;
            block2: {
                void $receiver;
                KotlinType it2 = kotlinType;
                Collection<MemberDescriptor> members = UnqualifiedSuperKt.getFunctionMembers(it2, calleeName, location);
                if (!CollectionsKt.isNotEmpty(members)) continue;
                typesWithArbitraryMembers.add(kotlinType);
                Iterable iterable = members;
                for (Object element : $receiver) {
                    MemberDescriptor it3 = (MemberDescriptor)element;
                    if (!UnqualifiedSuperKt.isConcreteMember(kotlinType, it3)) continue;
                    bl2 = true;
                    break block2;
                }
                bl2 = false;
            }
            if (!bl2) continue;
            typesWithConcreteMembers.add(kotlinType);
        }
        Collection typesWithConcreteOverride = CollectionsKt.isNotEmpty((Collection)typesWithConcreteMembers) ? (List)typesWithConcreteMembers : (allowArbitraryMembers != false ? (List)typesWithArbitraryMembers : CollectionsKt.emptyList());
        return CollectionsKt.isNotEmpty(typesWithConcreteOverride) ? typesWithConcreteOverride : (Collection)AddToStdlibKt.singletonList(anyType);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<KotlinType> resolveSupertypesByCalleeName(Collection<? extends KotlinType> supertypes2, Name calleeName, LookupLocation location) {
        boolean allowArbitraryMembers = true;
        SmartList<KotlinType> typesWithConcreteMembers = new SmartList<KotlinType>();
        SmartList<KotlinType> typesWithArbitraryMembers = new SmartList<KotlinType>();
        for (KotlinType kotlinType : supertypes2) {
            boolean bl;
            block2: {
                void $receiver;
                KotlinType it2 = kotlinType;
                Collection members = CollectionsKt.plus(UnqualifiedSuperKt.getFunctionMembers(it2, calleeName, location), (Iterable)UnqualifiedSuperKt.getPropertyMembers(it2, calleeName, location));
                if (!CollectionsKt.isNotEmpty(members)) continue;
                typesWithArbitraryMembers.add(kotlinType);
                Iterable iterable = members;
                for (Object element : $receiver) {
                    MemberDescriptor it3 = (MemberDescriptor)element;
                    if (!UnqualifiedSuperKt.isConcreteMember(kotlinType, it3)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            typesWithConcreteMembers.add(kotlinType);
        }
        return CollectionsKt.isNotEmpty((Collection)typesWithConcreteMembers) ? (List)typesWithConcreteMembers : (allowArbitraryMembers ? (List)typesWithArbitraryMembers : CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<KotlinType> resolveSupertypesByPropertyName(Collection<? extends KotlinType> supertypes2, Name propertyName, LookupLocation location) {
        boolean allowArbitraryMembers = true;
        SmartList<KotlinType> typesWithConcreteMembers = new SmartList<KotlinType>();
        SmartList<KotlinType> typesWithArbitraryMembers = new SmartList<KotlinType>();
        for (KotlinType kotlinType : supertypes2) {
            boolean bl;
            block2: {
                void $receiver;
                KotlinType it2 = kotlinType;
                Collection<MemberDescriptor> members = UnqualifiedSuperKt.getPropertyMembers(it2, propertyName, location);
                if (!CollectionsKt.isNotEmpty(members)) continue;
                typesWithArbitraryMembers.add(kotlinType);
                Iterable iterable = members;
                for (Object element : $receiver) {
                    MemberDescriptor it3 = (MemberDescriptor)element;
                    if (!UnqualifiedSuperKt.isConcreteMember(kotlinType, it3)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            typesWithConcreteMembers.add(kotlinType);
        }
        return CollectionsKt.isNotEmpty((Collection)typesWithConcreteMembers) ? (List)typesWithConcreteMembers : (allowArbitraryMembers ? (List)typesWithArbitraryMembers : CollectionsKt.emptyList());
    }

    private static final Collection<MemberDescriptor> getFunctionMembers(KotlinType type2, Name name, LookupLocation location) {
        return type2.getMemberScope().getFunctions(name, location);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<MemberDescriptor> getPropertyMembers(KotlinType type2, Name name, LookupLocation location) {
        void destination;
        void $receiver;
        Iterable iterable = type2.getMemberScope().getProperties(name, location);
        Collection collection = new SmartList();
        for (Object element : $receiver) {
            if (!(element instanceof MemberDescriptor)) continue;
            destination.add(element);
        }
        return destination;
    }

    private static final boolean isConcreteMember(KotlinType supertype, MemberDescriptor memberDescriptor) {
        if (Intrinsics.areEqual((Object)memberDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
            return false;
        }
        ClassDescriptor classDescriptorForSupertype = TypeUtils.getClassDescriptor(supertype);
        MemberDescriptor memberDescriptor2 = memberDescriptor;
        if (memberDescriptor2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
        }
        CallableMemberDescriptor.Kind memberKind = ((CallableMemberDescriptor)memberDescriptor2).getKind();
        ClassDescriptor classDescriptor = classDescriptorForSupertype;
        if (Intrinsics.areEqual((Object)(classDescriptor != null ? classDescriptor.getKind() : null), (Object)ClassKind.INTERFACE) && Intrinsics.areEqual((Object)memberKind, (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE)) {
            Annotated annotated = ((CallableMemberDescriptor)memberDescriptor).getDispatchReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                return false;
            }
            Annotated dispatchReceiverType = annotated;
            ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor((KotlinType)dispatchReceiverType);
            if (classDescriptor2 == null) {
                return false;
            }
            ClassDescriptor dispatchReceiverClass = classDescriptor2;
            return !KotlinBuiltIns.isAny(dispatchReceiverClass);
        }
        return true;
    }
}

