/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImplKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.scopes.ChainedScope;
import org.jetbrains.kotlin.resolve.scopes.KtScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class TypeIntersector {
    public static boolean isIntersectionEmpty(@NotNull KotlinType typeA, @NotNull KotlinType typeB) {
        if (typeA == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeA", "org/jetbrains/kotlin/types/TypeIntersector", "isIntersectionEmpty"));
        }
        if (typeB == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeB", "org/jetbrains/kotlin/types/TypeIntersector", "isIntersectionEmpty"));
        }
        return TypeIntersector.intersectTypes(KotlinTypeChecker.DEFAULT, new LinkedHashSet<KotlinType>(Arrays.asList(typeA, typeB))) == null;
    }

    @Nullable
    public static KotlinType intersectTypes(@NotNull KotlinTypeChecker typeChecker, @NotNull Set<KotlinType> types2) {
        if (typeChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeChecker", "org/jetbrains/kotlin/types/TypeIntersector", "intersectTypes"));
        }
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/TypeIntersector", "intersectTypes"));
        }
        assert (!types2.isEmpty()) : "Attempting to intersect empty set of types, this case should be dealt with on the call site.";
        if (types2.size() == 1) {
            return types2.iterator().next();
        }
        KotlinType nothingOrNullableNothing = null;
        boolean allNullable = true;
        ArrayList<KotlinType> nullabilityStripped = new ArrayList<KotlinType>(types2.size());
        for (KotlinType type2 : types2) {
            if (type2.isError()) continue;
            if (KotlinBuiltIns.isNothingOrNullableNothing(type2)) {
                nothingOrNullableNothing = type2;
            }
            allNullable &= type2.isMarkedNullable();
            nullabilityStripped.add(TypeUtils.makeNotNullable(type2));
        }
        if (nothingOrNullableNothing != null) {
            return TypeUtils.makeNullableAsSpecified(nothingOrNullableNothing, allNullable);
        }
        if (nullabilityStripped.isEmpty()) {
            return ErrorUtils.createErrorType("Intersection of errors types: " + types2);
        }
        ArrayList<KotlinType> resultingTypes = new ArrayList<KotlinType>();
        block1: for (KotlinType type3 : nullabilityStripped) {
            if (!TypeUtils.canHaveSubtypes(typeChecker, type3)) {
                for (KotlinType other : nullabilityStripped) {
                    if (TypeUnifier.mayBeEqual(type3, other) || typeChecker.isSubtypeOf(type3, other) || typeChecker.isSubtypeOf(other, type3)) continue;
                    return null;
                }
                return TypeUtils.makeNullableAsSpecified(type3, allNullable);
            }
            for (KotlinType other : nullabilityStripped) {
                if (((Object)type3).equals(other) || !typeChecker.isSubtypeOf(other, type3)) continue;
                continue block1;
            }
            for (KotlinType other : resultingTypes) {
                if (!typeChecker.equalTypes(other, type3)) continue;
                continue block1;
            }
            resultingTypes.add(type3);
        }
        if (resultingTypes.isEmpty()) {
            KotlinType bestRepresentative = FlexibleTypesKt.singleBestRepresentative(nullabilityStripped);
            if (bestRepresentative == null) {
                throw new AssertionError((Object)("Empty intersection for types " + types2));
            }
            return TypeUtils.makeNullableAsSpecified(bestRepresentative, allNullable);
        }
        if (resultingTypes.size() == 1) {
            return TypeUtils.makeNullableAsSpecified((KotlinType)resultingTypes.get(0), allNullable);
        }
        IntersectionTypeConstructor constructor = new IntersectionTypeConstructor(Annotations.Companion.getEMPTY(), resultingTypes);
        KtScope[] scopes = new KtScope[resultingTypes.size()];
        int i = 0;
        for (KotlinType type4 : resultingTypes) {
            scopes[i] = type4.getMemberScope();
            ++i;
        }
        return KotlinTypeImpl.create(Annotations.Companion.getEMPTY(), constructor, allNullable, Collections.emptyList(), new IntersectionScope(constructor, scopes));
    }

    private static class TypeUnifier {
        private TypeUnifier() {
        }

        public static boolean mayBeEqual(@NotNull KotlinType type2, @NotNull KotlinType other) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeIntersector$TypeUnifier", "mayBeEqual"));
            }
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/types/TypeIntersector$TypeUnifier", "mayBeEqual"));
            }
            return TypeUnifier.unify(type2, other);
        }

        private static boolean unify(KotlinType withParameters, KotlinType expected) {
            final HashMap parameters2 = new HashMap();
            Function1<TypeParameterUsage, Unit> processor = new Function1<TypeParameterUsage, Unit>(){

                @Override
                public Unit invoke(TypeParameterUsage parameterUsage) {
                    Variance howTheTypeIsUsedBefore = (Variance)((Object)parameters2.get(parameterUsage.typeParameterDescriptor));
                    if (howTheTypeIsUsedBefore == null) {
                        howTheTypeIsUsedBefore = Variance.INVARIANT;
                    }
                    parameters2.put(parameterUsage.typeParameterDescriptor, parameterUsage.howTheTypeParameterIsUsed.superpose(howTheTypeIsUsedBefore));
                    return Unit.INSTANCE;
                }
            };
            TypeUnifier.processAllTypeParameters(withParameters, Variance.INVARIANT, processor);
            TypeUnifier.processAllTypeParameters(expected, Variance.INVARIANT, processor);
            ConstraintSystemImpl constraintSystem = new ConstraintSystemImpl();
            ConstraintSystemImplKt.registerTypeVariables(constraintSystem, parameters2);
            constraintSystem.addSubtypeConstraint(withParameters, expected, ConstraintPositionKind.SPECIAL.position());
            return constraintSystem.getStatus().isSuccessful();
        }

        private static void processAllTypeParameters(KotlinType type2, Variance howThisTypeIsUsed, Function1<TypeParameterUsage, Unit> result2) {
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (descriptor2 instanceof TypeParameterDescriptor) {
                result2.invoke(new TypeParameterUsage((TypeParameterDescriptor)descriptor2, howThisTypeIsUsed));
            }
            for (TypeProjection projection : type2.getArguments()) {
                if (projection.isStarProjection()) continue;
                TypeUnifier.processAllTypeParameters(projection.getType(), projection.getProjectionKind(), result2);
            }
        }

        private static class TypeParameterUsage {
            private final TypeParameterDescriptor typeParameterDescriptor;
            private final Variance howTheTypeParameterIsUsed;

            public TypeParameterUsage(TypeParameterDescriptor typeParameterDescriptor, Variance howTheTypeParameterIsUsed) {
                this.typeParameterDescriptor = typeParameterDescriptor;
                this.howTheTypeParameterIsUsed = howTheTypeParameterIsUsed;
            }
        }
    }

    private static class IntersectionScope
    extends ChainedScope {
        public IntersectionScope(@NotNull TypeConstructor constructor, @NotNull KtScope[] scopes) {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/types/TypeIntersector$IntersectionScope", "<init>"));
            }
            if (scopes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopes", "org/jetbrains/kotlin/types/TypeIntersector$IntersectionScope", "<init>"));
            }
            super(null, "member scope for intersection type " + constructor, scopes);
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            throw new UnsupportedOperationException("Should not call getContainingDeclaration on intersection scope " + this);
        }
    }
}

