/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.jvm;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.StringsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.load.kotlin.JvmNameResolver;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.relocated.com.google.protobuf.ExtensionRegistryLite;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"k\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005Aq!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!EQ!\u0001C\u0002\u000b\u0005A\u0011\"B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0007!1-\u0001\u0007\u00013\u0005A\n!(A\u0014C\u000f!\u0011!U\u0002\u0002\u0011\u0005)\u0003\u0003c\u0002\u000e\u00051\u0005\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001G\u0003\u001a\u0007!-Q\"\u0001\r\u00073\rAi!D\u0001\u0019\u000f\u0015\u0002\u0002rB\u0007\u0003\u0019\u0003A\u0002\"G\u0002\t\n5\t\u0001\u0014C\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0004\u001a\u0007!5Q\"\u0001\r\bKAA\u0011\"\u0004\u0002\r\u0002a!\u0011d\u0001E\u0005\u001b\u0005A\u001a\"G\u0002\t\f5\t\u0001DB\r\u0004\u0011\u001bi\u0011\u0001G\u0004&\u0011\u0011\u001d\u0001BC\u0007\u00021\u0011I2\u0001#\u0006\u000e\u0003aYQ%\u0004\u0003\u0002\u0011/i!\u0001$\u0001\u0019\te\u0019\u0001\u0002D\u0007\u000213I2\u0001c\u0003\u000e\u0003a1Q\u0015\u0006C\u0004\u00115i\u0011\u0001g\u0007\u001a\r!qQ\u0002B\u0005\u0003\u0013\u0005AB\u0001'\b\u001a\r!yQ\u0002B\u0005\u0003\u0013\u0005AB\u0001'\bR\u0007\u0005Ay\"j\t\u0005\b!iQ\"\u0001M\u000e3\rA\u0001#D\u0001\u0019\"e1\u0001bD\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0003\u0019\u001eE\u001b\u0011\u0001C\t&*\u0011\u001d\u00012E\u0007\u00021IIb\u0001\u0003\b\u000e\t%\u0011\u0011\"\u0001\r\u00051;Ib\u0001C\b\u000e\t%\u0011\u0011\"\u0001\r\u00051;\t6!\u0001E\u0013KG!9\u0001c\t\u000e\u0003a\u0011\u0012d\u0001\u0005\u0011\u001b\u0005A\n#\u0007\u0004\t\u001f5!\u0011BA\u0005\u00021\u0011Aj\"U\u0002\u0002\u0011MI#\u0002B\"\t\u0011\u0007i\u0011\u0001\u0007\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0006!\u0019\u0001"}, strings={"Lorg/jetbrains/kotlin/serialization/jvm/JvmProtoBufUtil;", "", "()V", "EXTENSION_REGISTRY", "Lorg/jetbrains/kotlin/relocated/com/google/protobuf/ExtensionRegistryLite;", "getEXTENSION_REGISTRY", "()Lcom/google/protobuf/ExtensionRegistryLite;", "getJvmConstructorSignature", "", "proto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Constructor;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "typeTable", "Lorg/jetbrains/kotlin/serialization/deserialization/TypeTable;", "getJvmFieldSignature", "Lorg/jetbrains/kotlin/serialization/jvm/JvmProtoBufUtil$PropertySignature;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Property;", "getJvmMethodSignature", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Function;", "mapClassIdDefault", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "mapTypeDefault", "type", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type;", "readClassDataFrom", "Lorg/jetbrains/kotlin/serialization/ClassData;", "data", "", "strings", "([Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/kotlin/serialization/ClassData;", "bytes", "", "([B[Ljava/lang/String;)Lorg/jetbrains/kotlin/serialization/ClassData;", "readPackageDataFrom", "Lorg/jetbrains/kotlin/serialization/PackageData;", "([Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/kotlin/serialization/PackageData;", "([B[Ljava/lang/String;)Lorg/jetbrains/kotlin/serialization/PackageData;", "PropertySignature"}, moduleName="kotlin-compiler")
public final class JvmProtoBufUtil {
    @NotNull
    public static final ExtensionRegistryLite EXTENSION_REGISTRY;
    public static final JvmProtoBufUtil INSTANCE;
    public static final JvmProtoBufUtil INSTANCE$;

    @NotNull
    public final ExtensionRegistryLite getEXTENSION_REGISTRY() {
        return EXTENSION_REGISTRY;
    }

    @JvmStatic
    @NotNull
    public static final ClassData readClassDataFrom(@NotNull String[] data, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(strings, "strings");
        byte[] byArray = BitEncoding.decodeBytes(data);
        Intrinsics.checkExpressionValueIsNotNull(byArray, "BitEncoding.decodeBytes(data)");
        return JvmProtoBufUtil.readClassDataFrom(byArray, strings);
    }

    @JvmStatic
    @NotNull
    public static final ClassData readClassDataFrom(@NotNull byte[] bytes, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull(bytes, "bytes");
        Intrinsics.checkParameterIsNotNull(strings, "strings");
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        JvmProtoBuf.StringTableTypes stringTableTypes = JvmProtoBuf.StringTableTypes.parseDelimitedFrom(input, EXTENSION_REGISTRY);
        Intrinsics.checkExpressionValueIsNotNull(stringTableTypes, "JvmProtoBuf.StringTableT\u2026nput, EXTENSION_REGISTRY)");
        JvmNameResolver nameResolver = new JvmNameResolver(stringTableTypes, strings);
        ProtoBuf.Class classProto = ProtoBuf.Class.parseFrom(input, EXTENSION_REGISTRY);
        NameResolver nameResolver2 = nameResolver;
        ProtoBuf.Class clazz = classProto;
        Intrinsics.checkExpressionValueIsNotNull(clazz, "classProto");
        return new ClassData(nameResolver2, clazz);
    }

    @JvmStatic
    @NotNull
    public static final PackageData readPackageDataFrom(@NotNull String[] data, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(strings, "strings");
        byte[] byArray = BitEncoding.decodeBytes(data);
        Intrinsics.checkExpressionValueIsNotNull(byArray, "BitEncoding.decodeBytes(data)");
        return JvmProtoBufUtil.readPackageDataFrom(byArray, strings);
    }

    @JvmStatic
    @NotNull
    public static final PackageData readPackageDataFrom(@NotNull byte[] bytes, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull(bytes, "bytes");
        Intrinsics.checkParameterIsNotNull(strings, "strings");
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        JvmProtoBuf.StringTableTypes stringTableTypes = JvmProtoBuf.StringTableTypes.parseDelimitedFrom(input, EXTENSION_REGISTRY);
        Intrinsics.checkExpressionValueIsNotNull(stringTableTypes, "JvmProtoBuf.StringTableT\u2026nput, EXTENSION_REGISTRY)");
        JvmNameResolver nameResolver = new JvmNameResolver(stringTableTypes, strings);
        ProtoBuf.Package packageProto = ProtoBuf.Package.parseFrom(input, EXTENSION_REGISTRY);
        NameResolver nameResolver2 = nameResolver;
        ProtoBuf.Package package_ = packageProto;
        Intrinsics.checkExpressionValueIsNotNull(package_, "packageProto");
        return new PackageData(nameResolver2, package_);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getJvmMethodSignature(@NotNull ProtoBuf.Function proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        int name;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull(typeTable, "typeTable");
        JvmProtoBuf.JvmMethodSignature signature = proto.hasExtension(JvmProtoBuf.methodSignature) ? proto.getExtension(JvmProtoBuf.methodSignature) : (JvmProtoBuf.JvmMethodSignature)null;
        int n = name = signature != null && signature.hasName() ? signature.getName() : proto.getName();
        if (signature != null && signature.hasDesc()) {
            string = nameResolver.getString(signature.getDesc());
        } else {
            void destination;
            void $receiver;
            Object object;
            Iterable destination2;
            Iterable $receiver2;
            void $receiver3;
            Iterable iterable = proto.getValueParameterList();
            Collection collection = CollectionsKt.singletonOrEmptyList(ProtoTypeTableUtilKt.receiverType(proto, typeTable));
            void var8_8 = $receiver3;
            Collection collection2 = new ArrayList(kotlin.CollectionsKt.collectionSizeOrDefault($receiver3, 10));
            for (Object item : $receiver2) {
                void it2;
                ProtoBuf.ValueParameter valueParameter = (ProtoBuf.ValueParameter)item;
                object = destination2;
                ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type((ProtoBuf.ValueParameter)it2, typeTable);
                object.add(type2);
            }
            object = (List)destination2;
            List parameterTypes = kotlin.CollectionsKt.plus(collection, (Iterable)object);
            $receiver2 = parameterTypes;
            destination2 = $receiver2;
            Collection collection3 = new ArrayList(kotlin.CollectionsKt.collectionSizeOrDefault($receiver2, 10));
            for (Object item : $receiver) {
                void it3;
                ProtoBuf.Type $i$a$1 = (ProtoBuf.Type)item;
                collection = destination;
                if (JvmProtoBufUtil.INSTANCE.mapTypeDefault((ProtoBuf.Type)it3, nameResolver) == null) {
                    return null;
                }
                collection.add(object);
            }
            List parametersDesc = (List)destination;
            String string2 = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType(proto, typeTable), nameResolver);
            if (string2 == null) {
                return null;
            }
            String returnTypeDesc = string2;
            string = kotlin.CollectionsKt.joinToString$default(parametersDesc, "", "(", ")", 0, null, null, 56) + returnTypeDesc;
        }
        String desc = string;
        return nameResolver.getString(name) + desc;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getJvmConstructorSignature(@NotNull ProtoBuf.Constructor proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        JvmProtoBuf.JvmMethodSignature signature;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull(typeTable, "typeTable");
        JvmProtoBuf.JvmMethodSignature jvmMethodSignature = signature = proto.hasExtension(JvmProtoBuf.constructorSignature) ? proto.getExtension(JvmProtoBuf.constructorSignature) : (JvmProtoBuf.JvmMethodSignature)null;
        if (signature != null && signature.hasDesc()) {
            string = nameResolver.getString(signature.getDesc());
        } else {
            void destination;
            void $receiver;
            void $receiver2;
            Iterable iterable = proto.getValueParameterList();
            void var6_6 = $receiver2;
            Collection collection = new ArrayList(kotlin.CollectionsKt.collectionSizeOrDefault($receiver2, 10));
            for (Object item : $receiver) {
                String string2;
                void it2;
                ProtoBuf.ValueParameter valueParameter = (ProtoBuf.ValueParameter)item;
                void var11_11 = destination;
                if (JvmProtoBufUtil.INSTANCE.mapTypeDefault(ProtoTypeTableUtilKt.type((ProtoBuf.ValueParameter)it2, typeTable), nameResolver) == null) {
                    return null;
                }
                var11_11.add(string2);
            }
            string = kotlin.CollectionsKt.joinToString$default((List)destination, "", "(", ")V", 0, null, null, 56);
        }
        String desc = string;
        return "<init>" + desc;
    }

    @Nullable
    public final PropertySignature getJvmFieldSignature(@NotNull ProtoBuf.Property proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        int name;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull(typeTable, "typeTable");
        if (!proto.hasExtension(JvmProtoBuf.propertySignature)) {
            return null;
        }
        JvmProtoBuf.JvmPropertySignature signature = proto.getExtension(JvmProtoBuf.propertySignature);
        JvmProtoBuf.JvmFieldSignature field = signature.hasField() ? signature.getField() : (JvmProtoBuf.JvmFieldSignature)null;
        int n = name = field != null && field.hasName() ? field.getName() : proto.getName();
        if (field != null && field.hasDesc()) {
            string = nameResolver.getString(field.getDesc());
        } else {
            string = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType(proto, typeTable), nameResolver);
            if (string == null) {
                return null;
            }
        }
        String desc = string;
        String string2 = nameResolver.getString(name);
        Intrinsics.checkExpressionValueIsNotNull(string2, "nameResolver.getString(name)");
        String string3 = desc;
        Intrinsics.checkExpressionValueIsNotNull(string3, "desc");
        return new PropertySignature(string2, string3);
    }

    private final String mapTypeDefault(ProtoBuf.Type type2, NameResolver nameResolver) {
        String string;
        if (type2.hasClassName()) {
            ClassId classId = nameResolver.getClassId(type2.getClassName());
            Intrinsics.checkExpressionValueIsNotNull(classId, "nameResolver.getClassId(type.className)");
            string = JvmProtoBufUtil.mapClassIdDefault(classId);
        } else {
            string = null;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String mapClassIdDefault(@NotNull ClassId classId) {
        ClassId javaClassId;
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        String internalName = StringsKt.replace$default(classId.asString(), '.', '$', false, 4);
        String simpleName = StringsKt.removePrefix(internalName, "kotlin/");
        if (Intrinsics.areEqual(simpleName, internalName) ^ true) {
            JvmPrimitiveType[] jvmPrimitiveTypeArray = JvmPrimitiveType.values();
            for (int i = 0; i < jvmPrimitiveTypeArray.length; ++i) {
                JvmPrimitiveType jvmPrimitive = jvmPrimitiveTypeArray[i];
                PrimitiveType primitiveType = jvmPrimitive.getPrimitiveType();
                if (Intrinsics.areEqual(simpleName, primitiveType.getTypeName().asString())) {
                    String string = jvmPrimitive.getDesc();
                    Intrinsics.checkExpressionValueIsNotNull(string, "jvmPrimitive.desc");
                    return string;
                }
                if (!Intrinsics.areEqual(simpleName, primitiveType.getArrayTypeName().asString())) continue;
                return "[" + jvmPrimitive.getDesc();
            }
            if (Intrinsics.areEqual(simpleName, KotlinBuiltIns.FQ_NAMES.unit.shortName().asString())) {
                return "V";
            }
        }
        if ((javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(classId.asSingleFqName().toUnsafe())) != null) {
            return "L" + StringsKt.replace$default(javaClassId.asString(), '.', '$', false, 4) + ";";
        }
        return "L" + internalName + ";";
    }

    static {
        new JvmProtoBufUtil();
    }

    /*
     * WARNING - void declaration
     */
    private JvmProtoBufUtil() {
        void var3_3;
        INSTANCE = this;
        INSTANCE$ = this;
        JvmProtoBufUtil $receiver = this;
        JvmProtoBufUtil $receiver2 = $receiver;
        ExtensionRegistryLite registry = ExtensionRegistryLite.newInstance();
        JvmProtoBuf.registerAllExtensions(registry);
        void v0 = var3_3;
        Intrinsics.checkExpressionValueIsNotNull(v0, "run {\n        val regist\u2026y)\n        registry\n    }");
        EXTENSION_REGISTRY = (ExtensionRegistryLite)v0;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0013\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\tA\u0001\u0002\u0003D\t1\u0001\u0011$\u0001M\u0001C+I1\u0001C\u0001\u000e\u0003a\r\u0011b\u0001\u0005\u0003\u001b\u0005A\u001a!U\u0002\u0002\u0011\u000b)K\u0001B\"\b\u0011\u0013i\u0011\u0001g\u0001&\n\u0011\u0019u\u0001C\u0003\u000e\u0003a\rQU\u0004\u0003D\u0007!-Q\"\u0001\r\u00013\u0011!\u0011\u0001C\u0001\u000e\u0003a\r\u0011\u0004\u0002\u0003\u0002\u0011\ti\u0011\u0001g\u0001*\u0015\u0011\u0019\u0005\u0002\u0003\u0002\u000e\u0003a\r\u0011k\u0001\u0003\u0006\u00015\u0011Aa\u0001E\u0004S)!1\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0003\t\b\u0001"}, strings={"Lorg/jetbrains/kotlin/serialization/jvm/JvmProtoBufUtil$PropertySignature;", "", "name", "", "desc", "(Ljava/lang/String;Ljava/lang/String;)V", "getDesc", "()Ljava/lang/String;", "getName", "component1", "component2", "copy"}, moduleName="kotlin-compiler")
    public static final class PropertySignature {
        @NotNull
        private final String name;
        @NotNull
        private final String desc;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDesc() {
            return this.desc;
        }

        public PropertySignature(@NotNull String name, @NotNull String desc) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(desc, "desc");
            this.name = name;
            this.desc = desc;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.desc;
        }

        @NotNull
        public final PropertySignature copy(@NotNull String name, @NotNull String desc) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(desc, "desc");
            return new PropertySignature(name, desc);
        }

        @NotNull
        public static /* synthetic */ PropertySignature copy$default(PropertySignature propertySignature, String string, String string2, int n) {
            if ((n & 1) != 0) {
                string = propertySignature.name;
            }
            if ((n & 2) != 0) {
                string2 = propertySignature.desc;
            }
            return propertySignature.copy(string, string2);
        }

        public String toString() {
            return "PropertySignature(name=" + this.name + ", desc=" + this.desc + ")";
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.desc;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PropertySignature)) break block3;
                    PropertySignature propertySignature = (PropertySignature)object;
                    if (!Intrinsics.areEqual(this.name, propertySignature.name) || !Intrinsics.areEqual(this.desc, propertySignature.desc)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

