/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.rmi.service;

import java.io.BufferedOutputStream;
import java.io.PrintStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import kotlin.ArraysKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.MapsKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.PropertyMetadata;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.concurrent.TimersKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.rmi.CompileService;
import org.jetbrains.kotlin.rmi.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.rmi.CompilerId;
import org.jetbrains.kotlin.rmi.DaemonOptions;
import org.jetbrains.kotlin.rmi.DaemonParamsKt;
import org.jetbrains.kotlin.rmi.DummyProfiler;
import org.jetbrains.kotlin.rmi.LoopbackNetworkInterface;
import org.jetbrains.kotlin.rmi.PerfCounters;
import org.jetbrains.kotlin.rmi.Profiler;
import org.jetbrains.kotlin.rmi.RemoteOutputStream;
import org.jetbrains.kotlin.rmi.WallAndThreadAndMemoryTotalProfiler;
import org.jetbrains.kotlin.rmi.WallAndThreadTotalProfiler;
import org.jetbrains.kotlin.rmi.service.CompileServiceImpl;
import org.jetbrains.kotlin.rmi.service.CompileServiceImpl$WhenMappings;
import org.jetbrains.kotlin.rmi.service.CompileServiceImpl$log$1;
import org.jetbrains.kotlin.rmi.service.CompileServiceImplKt;
import org.jetbrains.kotlin.rmi.service.CompilerSelector;
import org.jetbrains.kotlin.rmi.service.RemoteCompilationCanceledStatusClient;
import org.jetbrains.kotlin.rmi.service.RemoteIncrementalCompilationComponentsClient;
import org.jetbrains.kotlin.rmi.service.RemoteOutputStreamClient;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001b\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002B\u0003\u0002\t\u0005)\u0011\u0001#\u0003\u0006\u0001\u0015\t\u00012B\u0003\u0002\t\u0011)\u0011\u0001D\u0001\u0006\u0003\u0011!Q!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\t\u0012\u0015\t\u0001bB\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011!Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tAQA\u0003\u0002\u0011\u0005a\u0001!G\u0001\u0019\u0002\u00056\u0012b\u0001\u0005\u0002\u001b\u0005A\u001a!C\u0002\t\u00055\t\u0001TA\u0005\u0004\u0011\ri\u0011\u0001g\u0002\n\u0007!!Q\"\u0001M\u0005\u0013\rAQ!D\u0001\u0019\fE\u001b\u0011\u0001\u0003\u0004&@!\u0015R\"\u0001\u0013\u0014#\t!\u0001\u0001C\n\u001a\u000f!\u001dR\"B\u0005\u0004\t\u0003I\u0011\u0001'\u000b\u0019)e\u0019\u0001\"F\u0007\u00021WI2\u0001\u0003\f\u000e\u0003a5\u0012D\u0002\u0005\u0018\u001b\u0011I!!C\u0001%'a=\u0012kA\u0001\t1\u0015bA!\u0001E\u0019\u001b\u0005A\u0012$G\u0002\t45\t\u0001DG\r\u0004\u0011Yi\u0011\u0001'\f&H\u0011\t\u0001RG\u0007\u00021\u0017Ir\u0001c\n\u000e\u000b%\u0019A\u0011A\u0005\u00021SAB#G\u0002\t75\t\u0001tG\r\u0004\u0011qi\u0011\u0001g\u000e\u001a\u0019!9RBC\u0005\u0003\u0013\u0005AZ#\u0003\u0002\n\u0003a5\u0012BA\u0005\u00021uAJ$U\u0002\u0002\u0011w)C\u0001B\u0006\t=5\t\u0001tA\u0013\u0005\t-Ai$D\u0001\u0019\u000f\u0015~\u0001bH\u0007\u0002IM\t\"\u0001\u0002\u0001\t'e1\u0001bF\u0007\u0005\u0013\tI\u0011\u0001J\n\u00190E\u001b\u0011\u0001c\u0010& !\u0001S\"\u0001\u0013\u0014#\t!\u0001\u0001C\n\u001a\r!9R\u0002B\u0005\u0003\u0013\u0005!3\u0003g\fR\u0007\u0005Ay$*\u0012\u0005\u0017!\u0005S\"\u0001M\u00063\rA\u0011%D\u0001\u0019De9\u0001rE\u0007\u0006\u0013\r!\t!C\u0001\u0019*a!\u0012d\u0001\u0005#\u001b\u0005A\"$G\u0002\tF5\t\u0001tG\r\u0004\u0011\rj\u0011\u0001g\u0012\u001a\u0007!!S\"\u0001M\u001c#\u000e\t\u0001\u0012JS#\t-AQ%D\u0001\u0019\fe\u0019\u0001\"I\u0007\u00021\u0007Jr\u0001c\n\u000e\u000b%\u0019A\u0011A\u0005\u00021SAB#G\u0002\tE5\t\u0001DG\r\u0004\u0011\u000bj\u0011\u0001g\u000e\u001a\u0007!-S\"\u0001M$3\rAA%D\u0001\u00198E\u001b\u0011\u0001#\u0013&\t\u0011Y\u0001BJ\u0007\u00021\u001bJ\u0013\u0002b!\u001d\u0011\u001bi\u0011\u0001G\u0004\u001d\u0003\u0001\n\u0011kA\u0001\u0006\u0001%:A!\u0011\u000f\t\u00105\t\u0001\u0004C)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003D\u0011!\u0011Q\"\u0001M\u0003#\u000e!Q\u0001A\u0007\u0003\t#A\u0011\"\u000b\u0006\u0005\u0007\"AA!D\u0001\u0019\nE\u001bA!\u0002\u0001\u000e\u0005\u0011M\u0001BC\u0015\u000b\t\rC\u0001RC\u0007\u00021\u001da2%U\u0002\u0004\u001b\t!1\u0002c\u0006*#\u0011\u0019\u0005\u0002\u0003\u0007\u000e\u000bAiQC\u0001G\u000113AJ\u0002H\u0012R\u0007\u0019)!\u0001\"\b\t\u001f5\u0011A1\u0004\u0005\u000fS)!1\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0005\u000b\u0001i!\u0001b\b\t!%:A!\u0011\u0005\t\"5\t\u0001$E)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003D\u0011!\u0019Q\"\u0001M\u0004#\u000e!Q\u0001A\u0007\u0003\tGA!\u0003"}, strings={"Lorg/jetbrains/kotlin/rmi/service/CompileServiceImpl;", "Lorg/jetbrains/kotlin/rmi/CompileService;", "registry", "Ljava/rmi/registry/Registry;", "compiler", "Lorg/jetbrains/kotlin/rmi/service/CompilerSelector;", "selfCompilerId", "Lorg/jetbrains/kotlin/rmi/CompilerId;", "daemonOptions", "Lorg/jetbrains/kotlin/rmi/DaemonOptions;", "port", "", "(Ljava/rmi/registry/Registry;Lorg/jetbrains/kotlin/rmi/service/CompilerSelector;Lorg/jetbrains/kotlin/rmi/CompilerId;Lorg/jetbrains/kotlin/rmi/DaemonOptions;I)V", "_lastUsedSeconds", "", "alive", "", "getCompiler", "()Lorg/jetbrains/kotlin/rmi/service/CompilerSelector;", "getDaemonOptions", "()Lorg/jetbrains/kotlin/rmi/DaemonOptions;", "lastUsedSeconds", "getLastUsedSeconds", "()J", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "getRegistry", "()Ljava/rmi/registry/Registry;", "rwlock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getSelfCompilerId", "()Lorg/jetbrains/kotlin/rmi/CompilerId;", "checkedCompile", "R", "args", "", "", "serviceOut", "Ljava/io/PrintStream;", "rpcProfiler", "Lorg/jetbrains/kotlin/rmi/Profiler;", "body", "Lkotlin/Function0;", "([Ljava/lang/String;Ljava/io/PrintStream;Lorg/jetbrains/kotlin/rmi/Profiler;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "createCompileServices", "Lorg/jetbrains/kotlin/config/Services;", "facade", "Lorg/jetbrains/kotlin/rmi/CompilerCallbackServicesFacade;", "doCompile", "compilerMessagesStreamProxy", "Lorg/jetbrains/kotlin/rmi/RemoteOutputStream;", "serviceOutputStreamProxy", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "([Ljava/lang/String;Lorg/jetbrains/kotlin/rmi/RemoteOutputStream;Lorg/jetbrains/kotlin/rmi/RemoteOutputStream;Lkotlin/jvm/functions/Function2;)I", "getCompilerId", "getUsedMemory", "ifAlive", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "ifAliveExclusive", "remoteCompile", "targetPlatform", "Lorg/jetbrains/kotlin/rmi/CompileService$TargetPlatform;", "servicesFacade", "compilerOutputStream", "outputFormat", "Lorg/jetbrains/kotlin/rmi/CompileService$OutputFormat;", "serviceOutputStream", "(Lorg/jetbrains/kotlin/rmi/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/rmi/CompilerCallbackServicesFacade;Lorg/jetbrains/kotlin/rmi/RemoteOutputStream;Lorg/jetbrains/kotlin/rmi/CompileService$OutputFormat;Lorg/jetbrains/kotlin/rmi/RemoteOutputStream;)I", "remoteIncrementalCompile", "compilerOutputFormat", "shutdown", ""}, moduleName="kotlin-compiler")
public final class CompileServiceImpl
implements CompileService {
    private volatile long _lastUsedSeconds;
    private final Lazy<? extends Logger> log$delegate;
    private final ReentrantReadWriteLock rwlock;
    private boolean alive;
    @NotNull
    private final Registry registry;
    @NotNull
    private final CompilerSelector compiler;
    @NotNull
    private final CompilerId selfCompilerId;
    @NotNull
    private final DaemonOptions daemonOptions;
    private static final /* synthetic */ PropertyMetadata[] $delegatedProperties;

    @Override
    @NotNull
    public CompilerId getCompilerId() {
        return (CompilerId)this.ifAlive((Function0)new Function0<CompilerId>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            @NotNull
            public final CompilerId invoke() {
                return this.this$0.getSelfCompilerId();
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        });
    }

    @Override
    public long getUsedMemory() {
        return ((Number)this.ifAlive(getUsedMemory.1.INSTANCE)).longValue();
    }

    @Override
    public void shutdown() {
        this.ifAliveExclusive((Function0)new Function0<Unit>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            public final void invoke() {
                this.this$0.getLog().info("Shutdown started");
                CompileServiceImpl.access$setAlive$p(this.this$0, false);
                UnicastRemoteObject.unexportObject(this.this$0, true);
                this.this$0.getLog().info("Shutdown complete");
                if (System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_FORCE_SHUTDOWN_PROPERTY()) != null) {
                    TimersKt.schedule(new Timer(true), CompileServiceImplKt.getDAEMON_SHUTDOWN_DELAY_MS(), (Function1<? super TimerTask, ? extends Unit>)new Function1<TimerTask, Unit>(this){
                        final /* synthetic */ shutdown.1 this$0;

                        public final void invoke(TimerTask $receiver) {
                            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                            this.this$0.this$0.getLog().info("force JVM shutdown");
                            System.exit(0);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    });
                }
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        });
    }

    @Override
    public int remoteCompile(@NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilerCallbackServicesFacade servicesFacade, @NotNull RemoteOutputStream compilerOutputStream, @NotNull CompileService.OutputFormat outputFormat, @NotNull RemoteOutputStream serviceOutputStream) {
        Intrinsics.checkParameterIsNotNull(targetPlatform, "targetPlatform");
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(servicesFacade, "servicesFacade");
        Intrinsics.checkParameterIsNotNull(compilerOutputStream, "compilerOutputStream");
        Intrinsics.checkParameterIsNotNull(outputFormat, "outputFormat");
        Intrinsics.checkParameterIsNotNull(serviceOutputStream, "serviceOutputStream");
        return this.doCompile(args, compilerOutputStream, serviceOutputStream, (Function2<? super PrintStream, ? super Profiler, ? extends ExitCode>)new Function2<PrintStream, Profiler, ExitCode>(this, outputFormat, targetPlatform, args, servicesFacade){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ CompileService.OutputFormat $outputFormat;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ String[] $args;
            final /* synthetic */ CompilerCallbackServicesFacade $servicesFacade;

            @NotNull
            public final ExitCode invoke(@NotNull PrintStream printStream, @NotNull Profiler profiler) {
                ExitCode exitCode;
                Intrinsics.checkParameterIsNotNull(printStream, "printStream");
                Intrinsics.checkParameterIsNotNull(profiler, "profiler");
                switch (CompileServiceImpl$WhenMappings.$EnumSwitchMapping$0[this.$outputFormat.ordinal()]) {
                    case 1: {
                        ExitCode exitCode2 = this.this$0.getCompiler().get(this.$targetPlatform).exec(printStream, Arrays.copyOf(this.$args, this.$args.length));
                        exitCode = exitCode2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode2), "compiler[targetPlatform].exec(printStream, *args)");
                        break;
                    }
                    case 2: {
                        ExitCode exitCode3 = this.this$0.getCompiler().get(this.$targetPlatform).execAndOutputXml(printStream, CompileServiceImpl.access$createCompileServices(this.this$0, this.$servicesFacade, profiler), Arrays.copyOf(this.$args, this.$args.length));
                        exitCode = exitCode3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode3), "compiler[targetPlatform]\u2026Facade, profiler), *args)");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode), "when (outputFormat) {\n  \u2026 *args)\n                }");
                return exitCode;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$outputFormat = outputFormat;
                this.$targetPlatform = targetPlatform;
                this.$args = stringArray;
                this.$servicesFacade = compilerCallbackServicesFacade;
                super(2);
            }
        });
    }

    @Override
    public int remoteIncrementalCompile(@NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilerCallbackServicesFacade servicesFacade, @NotNull RemoteOutputStream compilerOutputStream, @NotNull CompileService.OutputFormat compilerOutputFormat, @NotNull RemoteOutputStream serviceOutputStream) {
        Intrinsics.checkParameterIsNotNull(targetPlatform, "targetPlatform");
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(servicesFacade, "servicesFacade");
        Intrinsics.checkParameterIsNotNull(compilerOutputStream, "compilerOutputStream");
        Intrinsics.checkParameterIsNotNull(compilerOutputFormat, "compilerOutputFormat");
        Intrinsics.checkParameterIsNotNull(serviceOutputStream, "serviceOutputStream");
        return this.doCompile(args, compilerOutputStream, serviceOutputStream, (Function2<? super PrintStream, ? super Profiler, ? extends ExitCode>)new Function2<PrintStream, Profiler, ExitCode>(this, compilerOutputFormat, targetPlatform, servicesFacade, args){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ CompileService.OutputFormat $compilerOutputFormat;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ CompilerCallbackServicesFacade $servicesFacade;
            final /* synthetic */ String[] $args;

            @NotNull
            public final ExitCode invoke(@NotNull PrintStream printStream, @NotNull Profiler profiler) {
                ExitCode exitCode;
                Intrinsics.checkParameterIsNotNull(printStream, "printStream");
                Intrinsics.checkParameterIsNotNull(profiler, "profiler");
                switch (CompileServiceImpl$WhenMappings.$EnumSwitchMapping$1[this.$compilerOutputFormat.ordinal()]) {
                    case 1: {
                        throw (Throwable)new NotImplementedError("Only XML output is supported in remote incremental compilation");
                    }
                    case 2: {
                        exitCode = this.this$0.getCompiler().get(this.$targetPlatform).execAndOutputXml(printStream, CompileServiceImpl.access$createCompileServices(this.this$0, this.$servicesFacade, profiler), Arrays.copyOf(this.$args, this.$args.length));
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode), "compiler[targetPlatform]\u2026Facade, profiler), *args)");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode), "when (compilerOutputForm\u2026 *args)\n                }");
                return exitCode;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$compilerOutputFormat = outputFormat;
                this.$targetPlatform = targetPlatform;
                this.$servicesFacade = compilerCallbackServicesFacade;
                this.$args = stringArray;
                super(2);
            }
        });
    }

    public final long getLastUsedSeconds() {
        return this.rwlock.isWriteLocked() || this.rwlock.getReadLockCount() - this.rwlock.getReadHoldCount() > 0 ? CompileServiceImplKt.nowSeconds() : this._lastUsedSeconds;
    }

    public final Logger getLog() {
        return LazyKt.getValue(this.log$delegate, this, (KProperty)$delegatedProperties[0]);
    }

    private final int doCompile(String[] args, RemoteOutputStream compilerMessagesStreamProxy, RemoteOutputStream serviceOutputStreamProxy, Function2<? super PrintStream, ? super Profiler, ? extends ExitCode> body) {
        return ((Number)this.ifAlive((Function0)new Function0<Integer>(this, compilerMessagesStreamProxy, serviceOutputStreamProxy, args, body){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ RemoteOutputStream $compilerMessagesStreamProxy;
            final /* synthetic */ RemoteOutputStream $serviceOutputStreamProxy;
            final /* synthetic */ String[] $args;
            final /* synthetic */ Function2 $body;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final int invoke() {
                int n;
                Profiler rpcProfiler = this.this$0.getDaemonOptions().getReportPerf() ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                PrintStream compilerMessagesStream = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(this.$compilerMessagesStreamProxy, rpcProfiler), 4096));
                PrintStream serviceOutputStream = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(this.$serviceOutputStreamProxy, rpcProfiler), 4096));
                try {
                    n = ((Number)this.this$0.checkedCompile(this.$args, serviceOutputStream, rpcProfiler, (Function0)new Function0<Integer>(this, compilerMessagesStream, rpcProfiler){
                        final /* synthetic */ doCompile.1 this$0;
                        final /* synthetic */ PrintStream $compilerMessagesStream;
                        final /* synthetic */ Profiler $rpcProfiler;

                        /*
                         * WARNING - void declaration
                         */
                        public final int invoke() {
                            void var1_1;
                            int res = ((ExitCode)((Object)this.this$0.$body.invoke(this.$compilerMessagesStream, this.$rpcProfiler))).getCode();
                            CompileServiceImpl.access$set_lastUsedSeconds$p(this.this$0.this$0, CompileServiceImplKt.nowSeconds());
                            return (int)var1_1;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$compilerMessagesStream = printStream;
                            this.$rpcProfiler = profiler;
                            super(0);
                        }
                    })).intValue();
                }
                finally {
                    serviceOutputStream.flush();
                    compilerMessagesStream.flush();
                }
                return n;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$compilerMessagesStreamProxy = remoteOutputStream;
                this.$serviceOutputStreamProxy = remoteOutputStream2;
                this.$args = stringArray;
                this.$body = function2;
                super(0);
            }
        })).intValue();
    }

    private final Services createCompileServices(CompilerCallbackServicesFacade facade, Profiler rpcProfiler) {
        Services.Builder builder = new Services.Builder();
        if (facade.hasIncrementalCaches() || facade.hasLookupTracker()) {
            builder.register(IncrementalCompilationComponents.class, new RemoteIncrementalCompilationComponentsClient(facade, rpcProfiler));
        }
        if (facade.hasCompilationCanceledStatus()) {
            builder.register(CompilationCanceledStatus.class, new RemoteCompilationCanceledStatusClient(facade, rpcProfiler));
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public final <R> R checkedCompile(@NotNull String[] args, @NotNull PrintStream serviceOut, @NotNull Profiler rpcProfiler, @NotNull Function0<? extends R> body) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(serviceOut, "serviceOut");
        Intrinsics.checkParameterIsNotNull(rpcProfiler, "rpcProfiler");
        Intrinsics.checkParameterIsNotNull(body, "body");
        try {
            long l;
            if (ArraysKt.none((Object[])args)) {
                throw (Throwable)new IllegalArgumentException("Error: empty arguments list.");
            }
            this.getLog().info("Starting compilation with args: " + ArraysKt.joinToString$default(args, " ", null, null, 0, null, null, 62));
            Profiler profiler = this.daemonOptions.getReportPerf() ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
            R res = profiler.withMeasure(null, body);
            if (this.daemonOptions.getReportPerf()) {
                void withGC;
                boolean bl = false;
                if (withGC != false) {
                    System.gc();
                }
                Runtime rt = Runtime.getRuntime();
                l = rt.totalMemory() - rt.freeMemory();
            } else {
                l = 0L;
            }
            long endMem = l;
            this.getLog().info("Done with result " + String.valueOf(res));
            if (this.daemonOptions.getReportPerf()) {
                void $receiver;
                checkedCompile.1 ms$ = checkedCompile.1.INSTANCE;
                checkedCompile.2 kb$ = checkedCompile.2.INSTANCE;
                PerfCounters pc = profiler.getTotalCounters();
                PerfCounters rpc = rpcProfiler.getTotalCounters();
                Object object = "PERF: Compile on daemon: " + ms$.invoke(pc.getTime()) + " ms; thread: user " + ms$.invoke(pc.getThreadUserTime()) + " ms, sys " + ms$.invoke(pc.getThreadTime() - pc.getThreadUserTime()) + " ms; rpc: " + rpc.getCount() + " calls, " + ms$.invoke(rpc.getTime()) + " ms, thread " + ms$.invoke(rpc.getThreadTime()) + " ms; memory: " + kb$.invoke(endMem) + " kb (" + StringsKt.format("%+d", kb$.invoke(pc.getMemory())) + " kb)";
                String it2 = (String)$receiver;
                serviceOut.println(it2);
                this.getLog().info(it2);
                Iterator<Map.Entry<Object, PerfCounters>> iterator2 = MapsKt.iterator(rpcProfiler.getCounters());
                while (iterator2.hasNext()) {
                    String $receiver2;
                    void $receiver3;
                    Object counters = object = iterator2.next();
                    Object obj = $receiver3.getKey();
                    Object $i$f$component1 = object;
                    PerfCounters perfCounters = (PerfCounters)$receiver2.getValue();
                    $receiver2 = "PERF: rpc by " + obj + ": " + perfCounters.getCount() + " calls, " + ms$.invoke(perfCounters.getTime()) + " ms, thread " + ms$.invoke(perfCounters.getThreadTime()) + " ms";
                    String it3 = $receiver2;
                    serviceOut.println(it3);
                    this.getLog().info(it3);
                }
            }
            return res;
        }
        catch (Exception e) {
            this.getLog().info("Error: " + e);
            throw (Throwable)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R ifAlive(@NotNull Function0<? extends R> body) {
        R r;
        Intrinsics.checkParameterIsNotNull(body, "body");
        ReentrantReadWriteLock $receiver = this.rwlock;
        ReentrantReadWriteLock.ReadLock rl = $receiver.readLock();
        rl.lock();
        try {
            if (!this.alive) {
                throw (Throwable)new IllegalStateException("Kotlin Compiler Service is not in alive state");
            }
            r = body.invoke();
        }
        finally {
            rl.unlock();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final <R> R ifAliveExclusive(@NotNull Function0<? extends R> body) {
        int index2;
        R r;
        int it2;
        Intrinsics.checkParameterIsNotNull(body, "body");
        ReentrantReadWriteLock $receiver = this.rwlock;
        ReentrantReadWriteLock.ReadLock rl = $receiver.readLock();
        int readCount = $receiver.getWriteHoldCount() == 0 ? $receiver.getReadHoldCount() : 0;
        int n = 0;
        int n2 = readCount - 1;
        if (n <= n2) {
            void index3;
            do {
                it2 = ++index3;
                rl.unlock();
            } while (index3 != n2);
        }
        ReentrantReadWriteLock.WriteLock wl = $receiver.writeLock();
        wl.lock();
        try {
            if (!this.alive) {
                throw (Throwable)new IllegalStateException("Kotlin Compiler Service is not in alive state");
            }
            r = body.invoke();
        }
        catch (Throwable throwable) {
            index2 = 0;
            int n3 = readCount - 1;
            if (index2 <= n3) {
                do {
                    int it3 = ++index2;
                    rl.lock();
                } while (index2 != n3);
            }
            wl.unlock();
            throw throwable;
        }
        it2 = 0;
        int n4 = readCount - 1;
        if (it2 <= n4) {
            do {
                int it4 = ++index2;
                rl.lock();
            } while (index2 != n4);
        }
        wl.unlock();
        return r;
    }

    @NotNull
    public final Registry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final CompilerSelector getCompiler() {
        return this.compiler;
    }

    @NotNull
    public final CompilerId getSelfCompilerId() {
        return this.selfCompilerId;
    }

    @NotNull
    public final DaemonOptions getDaemonOptions() {
        return this.daemonOptions;
    }

    static {
        $delegatedProperties = new PropertyMetadata[]{CompileServiceImpl$log$1.INSTANCE};
    }

    public CompileServiceImpl(@NotNull Registry registry, @NotNull CompilerSelector compiler, @NotNull CompilerId selfCompilerId, @NotNull DaemonOptions daemonOptions, int port) {
        Intrinsics.checkParameterIsNotNull(registry, "registry");
        Intrinsics.checkParameterIsNotNull(compiler, "compiler");
        Intrinsics.checkParameterIsNotNull(selfCompilerId, "selfCompilerId");
        Intrinsics.checkParameterIsNotNull(daemonOptions, "daemonOptions");
        this.registry = registry;
        this.compiler = compiler;
        this.selfCompilerId = selfCompilerId;
        this.daemonOptions = daemonOptions;
        this._lastUsedSeconds = CompileServiceImplKt.nowSeconds();
        this.log$delegate = LazyKt.lazy(log.2.INSTANCE);
        this.rwlock = new ReentrantReadWriteLock();
        try {
            UnicastRemoteObject.unexportObject(this, false);
        }
        catch (NoSuchObjectException e) {
            // empty catch block
        }
        Remote remote = UnicastRemoteObject.exportObject(this, port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        if (remote == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.rmi.CompileService");
        }
        CompileService stub = (CompileService)remote;
        this.registry.rebind(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME(), stub);
        this.alive = true;
    }

    public static final /* synthetic */ void access$setAlive$p(CompileServiceImpl $this, boolean bl) {
        $this.alive = bl;
    }

    @NotNull
    public static final /* synthetic */ Services access$createCompileServices(CompileServiceImpl $this, @NotNull CompilerCallbackServicesFacade facade, @NotNull Profiler rpcProfiler) {
        return $this.createCompileServices(facade, rpcProfiler);
    }

    public static final /* synthetic */ long access$get_lastUsedSeconds$p(CompileServiceImpl $this) {
        return $this._lastUsedSeconds;
    }

    public static final /* synthetic */ void access$set_lastUsedSeconds$p(CompileServiceImpl $this, long l) {
        $this._lastUsedSeconds = l;
    }
}

