/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.inline;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;

public class InlineUtil {
    public static boolean isInlineLambdaParameter(@NotNull ParameterDescriptor valueParameterOrReceiver) {
        if (valueParameterOrReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterOrReceiver", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "isInlineLambdaParameter"));
        }
        return (!(valueParameterOrReceiver instanceof ValueParameterDescriptor) || !((ValueParameterDescriptor)valueParameterOrReceiver).isNoinline()) && KotlinBuiltIns.isExactFunctionOrExtensionFunctionType(valueParameterOrReceiver.getOriginal().getType());
    }

    public static boolean isInline(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof SimpleFunctionDescriptor && InlineUtil.getInlineStrategy(descriptor2).isInline();
    }

    @NotNull
    public static InlineStrategy getInlineStrategy(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "getInlineStrategy"));
        }
        if (descriptor2 instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor2).isInline()) {
            InlineStrategy inlineStrategy2 = InlineStrategy.AS_FUNCTION;
            if (inlineStrategy2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "getInlineStrategy"));
            }
            return inlineStrategy2;
        }
        InlineStrategy inlineStrategy3 = InlineStrategy.NOT_INLINE;
        if (inlineStrategy3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "getInlineStrategy"));
        }
        return inlineStrategy3;
    }

    public static boolean checkNonLocalReturnUsage(@NotNull DeclarationDescriptor fromFunction, @NotNull KtExpression startExpression, @NotNull BindingTrace trace) {
        if (fromFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromFunction", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "checkNonLocalReturnUsage"));
        }
        if (startExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startExpression", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "checkNonLocalReturnUsage"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "checkNonLocalReturnUsage"));
        }
        Object containingFunction = PsiTreeUtil.getParentOfType((PsiElement)startExpression, KtClassOrObject.class, KtDeclarationWithBody.class);
        if (containingFunction == null) {
            return false;
        }
        DeclarationDescriptor containingFunctionDescriptor = trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, containingFunction);
        if (containingFunctionDescriptor == null) {
            return false;
        }
        BindingContext bindingContext2 = trace.getBindingContext();
        while (InlineUtil.canBeInlineArgument(containingFunction) && fromFunction != containingFunctionDescriptor) {
            if (!InlineUtil.isInlinedArgument((KtFunction)containingFunction, bindingContext2, true)) {
                return false;
            }
            containingFunction = (containingFunctionDescriptor = InlineUtil.getContainingClassOrFunctionDescriptor(containingFunctionDescriptor, true)) != null ? DescriptorToSourceUtils.descriptorToDeclaration(containingFunctionDescriptor) : null;
        }
        return fromFunction == containingFunctionDescriptor;
    }

    public static boolean isInlinedArgument(@NotNull KtFunction argument, @NotNull BindingContext bindingContext2, boolean checkNonLocalReturn) {
        ValueParameterDescriptor parameter;
        ArgumentMapping mapping;
        ValueArgument valueArgument;
        ResolvedCall<? extends CallableDescriptor> resolvedCall;
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "isInlinedArgument"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "isInlinedArgument"));
        }
        if (!InlineUtil.canBeInlineArgument(argument)) {
            return false;
        }
        KtExpression call = KtPsiUtil.getParentCallIfPresent(argument);
        if (call != null && (resolvedCall = CallUtilKt.getResolvedCall(call, bindingContext2)) != null && InlineUtil.isInline(resolvedCall.getResultingDescriptor()) && (valueArgument = CallUtilKt.getValueArgumentForExpression(resolvedCall.getCall(), argument)) != null && (mapping = resolvedCall.getArgumentMapping(valueArgument)) instanceof ArgumentMatch && InlineUtil.isInlineLambdaParameter(parameter = ((ArgumentMatch)mapping).getValueParameter())) {
            return !checkNonLocalReturn || InlineUtil.allowsNonLocalReturns(parameter);
        }
        return false;
    }

    public static boolean canBeInlineArgument(@Nullable PsiElement functionalExpression) {
        return functionalExpression instanceof KtFunctionLiteral || functionalExpression instanceof KtNamedFunction;
    }

    @Nullable
    public static DeclarationDescriptor getContainingClassOrFunctionDescriptor(@NotNull DeclarationDescriptor descriptor2, boolean strict) {
        DeclarationDescriptor current;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "getContainingClassOrFunctionDescriptor"));
        }
        DeclarationDescriptor declarationDescriptor = current = strict ? descriptor2.getContainingDeclaration() : descriptor2;
        while (current != null) {
            if (current instanceof FunctionDescriptor || current instanceof ClassDescriptor) {
                return current;
            }
            current = current.getContainingDeclaration();
        }
        return null;
    }

    public static boolean allowsNonLocalReturns(@NotNull CallableDescriptor lambda2) {
        if (lambda2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "org/jetbrains/kotlin/resolve/inline/InlineUtil", "allowsNonLocalReturns"));
        }
        return !(lambda2 instanceof ValueParameterDescriptor) || !((ValueParameterDescriptor)lambda2).isCrossinline();
    }
}

