/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;
import org.jetbrains.kotlin.psi.KtElementImpl;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u001d)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001E\t\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"\u0001\u0007\u00013\u0005A\n!)\u0004\n\u0007!\tQ\"\u0001M\u0002#\u000e\t\u0001BA\u0013\u0004\u0011\u000bi\u0011\u0001G\u0002&\u0007!\u001dQ\"\u0001\r\u0005K+!1\u0002#\u0003\u000e\u000b%\u0019A\u0011A\u0005\u00021\u0017AR!U\u0002\u0002\u0011\u0019)C\u0001#\u0004\u000e\u00051\u0005\u0001d\u0002"}, strings={"Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocLink;", "Lorg/jetbrains/kotlin/psi/KtElementImpl;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "getLinkText", "", "getLinkTextRange", "Lcom/intellij/openapi/util/TextRange;", "getReferences", "", "Lcom/intellij/psi/PsiReference;", "()[Lcom/intellij/psi/PsiReference;", "getTagIfSubject", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocTag;"}, moduleName="kotlin-compiler")
public final class KDocLink
extends KtElementImpl {
    @NotNull
    public final String getLinkText() {
        String string = this.getLinkTextRange().substring(this.getText());
        Intrinsics.checkExpressionValueIsNotNull(string, "getLinkTextRange().substring(getText())");
        return string;
    }

    @NotNull
    public final TextRange getLinkTextRange() {
        String text = this.getText();
        if (StringsKt.startsWith$default(text, '[', false, 2) && StringsKt.endsWith$default(text, ']', false, 2)) {
            return new TextRange(1, CollectionsKt.length(text) - 1);
        }
        return new TextRange(0, CollectionsKt.length(text));
    }

    @Nullable
    public final KDocTag getTagIfSubject() {
        KDocLink $receiver = this;
        KDocTag tag = PsiTreeUtil.getParentOfType((PsiElement)$receiver, KDocTag.class, true);
        return tag != null && Intrinsics.areEqual(tag.getSubjectLink(), this) ? tag : (KDocTag)null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders(this);
        Intrinsics.checkExpressionValueIsNotNull(psiReferenceArray, "ReferenceProvidersRegist\u2026rencesFromProviders(this)");
        return psiReferenceArray;
    }

    public KDocLink(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        super(node);
    }
}

