/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.util.ExpressionDecomposer;
import org.jetbrains.kotlin.js.inline.util.ExpressionDecomposer$WhenMappings;
import org.jetbrains.kotlin.js.inline.util.ExpressionDecomposerKt;
import org.jetbrains.kotlin.js.inline.util.JsExpressionVisitor;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.jsAstUtils.AstUtilsKt;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.HasArguments;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBreak;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsConditional;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsDoWhile;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsIf;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNew;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsWhile;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u000b\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t#\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001#\t\u0006\u00031\tQ\u0001A\u0003\u0002\u0011Q)\u0011\u0001\u0003\u0003\u0006\u0003!\u0001R!\u0001C\u0002\u000b\u0005AY!B\u0001\u0005\u0006\u0015\t\u0001\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u00031\tQ!\u0001\u0003\u0004\u0019\u0001\u0001:$G\u0001\u0019\u0002u\u0015!TGN\u001c9\u0005.B!A\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001\n\r!\u0011Q\u0002B\u0005\u0003\u0013\u0005A2\u0001'\u0002\n\r!\u001dQ\u0002B\u0005\u0003\u0013\u0005A2\u0001'\u0002R\u0007\u0005AA!\n\u0005\u0005\u0003!IQ\"\u0001M\n3\rA!\"D\u0001\u0019\f\u0015zA!\u0001E\u000b\u001b\u0005A\u001a\"G\u0002\t\u00175\t\u0001dB\r\u0007\u0011/iA!\u0003\u0002\n\u0003a-\u0001tB\u0013\f\t\u0005A)\"D\u0001\u0019\u0014e1\u0001rC\u0007\u0005\u0013\tI\u0011\u0001g\u0003\u0019\u0010\u0015\u0012B!\u0001\u0005\r\u001b\u0005AJ\"\u0007\u0004\t\u001b5!\u0011BA\u0005\u000217AR!\u0007\u0004\t\u001d5!\u0011BA\u0005\u00021\u001dAj!\n\b\u0005\u0017!uQ\"\u0001M\n3\rAq\"D\u0001\u0019 e)\u0001\u0002E\u0007\u0004\u0013\u0005!\u0019\u0001'\t&\u001d\u0011Y\u0001RD\u0007\u00021'I2\u0001C\b\u000e\u0003a\t\u0012$\u0002\u0005\u0011\u001b\rI\u0011\u0001b\u0001\u0019\"\u0015rAa\u0003E\u000f\u001b\u0005A\u001a\"G\u0002\t\u001f5\t\u00014E\r\u0006\u0011Ai1!C\u0001\u0005\u0004a\u0005RE\u0004\u0003\f\u0011;i\u0011\u0001g\u0005\u001a\u0007!yQ\"\u0001\r\u00133\u0015A\u0001#D\u0002\n\u0003\u0011\r\u0001\u0014E\u0013\u000f\t-Ai\"D\u0001\u0019\u0014e\u0019\u0001bD\u0007\u00021KIR\u0001\u0003\t\u000e\u0007%\tA1\u0001M\u0011K9!1\u0002#\b\u000e\u0003aM\u0011d\u0001\u0005\u0010\u001b\u0005A2#G\u0003\t!5\u0019\u0011\"\u0001C\u00021C)c\u0002B\u0006\t\u001e5\t\u00014C\r\u0004\u0011=i\u0011\u0001g\n\u001a\u000b!\u0001RbA\u0005\u0002\t\u0007A\n#\n\b\u0005\u0017!uQ\"\u0001M\n3\rAq\"D\u0001\u0019)e)\u0001\u0002E\u0007\u0004\u0013\u0005!\u0019\u0001'\t&\u001d\u0011Y\u0001RD\u0007\u00021'I2\u0001C\b\u000e\u0003a%\u0012$\u0002\u0005\u0011\u001b\rI\u0011\u0001b\u0001\u0019\"\u0015\nB!\u0011\t\t+5\tA5F\t\u0003\t\u0001AY#\u0007\u0004\t-5!\u0011BA\u0005\u0002IWAj#U\u0002\u0002\u0011])c\u0001B\u0001\t05\t\u00014D\u000b\u000217)c\u0001B\u0001\t15\t\u0001\u0014D\u000b\u00021?)c\u0001B\u0001\t15\t\u0001\u0014D\u000b\u00021G)[\u0002B\u0001\t15\t\u0001\u0014D\u000b\u00021IIj\u0001\u0003\t\u000e\u0007%\tA1\u0001M\u0011!\u000e\u0005Qu\u0003\u0003\u0002\u0011ai\u0011\u0001'\u0007\u0016\u0003a%\u0012\u0014\u0002E\u0019\u001b\u0005A\u001a\u0002UB\u0001K\u0019!\u0011\u0001\u0003\r\u000e\u0003aeQ#\u0001\r\u001aK7!\u0011\u0001c\r\u000e\u0003aeQ#\u0001M\u00123\u001bA\u0001#D\u0002\n\u0003\u0011\r\u0001\u0014\u0005)\u0004\u0002%RA!\u0011\u000f\t\n5!\u0011BA\u0005\u00021\u0017AR!U\u0002\u0002\u000b\u0001I#\u0002B!\t\u0011\tiA!\u0003\u0002\n\u0003a\u0019\u0001TA)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003B\u0011!\u001dQ\u0002B\u0005\u0003\u0013\u0005A2\u0001'\u0002R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A\u0011!D\u0001\u0019\u0004E\u001b\u0011!\u0002\u0001*%\u0011\t\u0005\u0002\u0003\u0004\u000e\t%\u0011\u0011\"\u0001\r\b1\u001b)B!\u0003\u0002\n\u0003a\u0019\u0001t\u0002\u000f\"#\u000e\u0019QB\u0001\u0003\t\u0011#\u0001"}, strings={"Lorg/jetbrains/kotlin/js/inline/util/ExpressionDecomposer;", "Lorg/jetbrains/kotlin/js/inline/util/JsExpressionVisitor;", "scope", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope;", "containsExtractable", "", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNode;", "containsNodeWithSideEffect", "(Lcom/google/dart/compiler/backend/js/ast/JsScope;Ljava/util/Set;Ljava/util/Set;)V", "additionalStatements", "", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;", "indicesOfExtractable", "", "", "", "getIndicesOfExtractable", "(Ljava/util/List;)Ljava/util/Iterator;", "addStatement", "", "statement", "addStatements", "index", "statements", "processByIndices", "", "elements", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "matchedIndices", "visit", "x", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsArrayAccess;", "ctx", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsContext;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsArrayLiteral;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsBinaryOperation;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsConditional;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsDoWhile;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsInvocation;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNew;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsVars;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsWhile;", "withNewAdditionalStatements", "T", "fn", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "extractToTemporary", "process", "addBreakToBegin", "Lorg/jetbrains/kotlin/js/inline/util/ExpressionDecomposer$Callable;", "processOrAnd", "Callable", "CallableInvocationAdapter", "CallableNewAdapter", "Companion", "Temporary"}, moduleName="kotlin-compiler")
public final class ExpressionDecomposer
extends JsExpressionVisitor {
    private List<JsStatement> additionalStatements;
    private final JsScope scope;
    private final Set<? extends JsNode> containsExtractable;
    private final Set<? extends JsNode> containsNodeWithSideEffect;
    public static final Companion Companion = org.jetbrains.kotlin.js.inline.util.ExpressionDecomposer$Companion.INSTANCE;

    @Override
    public boolean visit(@NotNull JsVars x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        List<JsVars.JsVar> vars = x.getVars();
        SmartList<JsVars.JsVar> prevVars = new SmartList<JsVars.JsVar>();
        for (JsVars.JsVar jsVar : vars) {
            if (this.containsExtractable.contains(jsVar) && CollectionsKt.isNotEmpty((Collection)prevVars)) {
                this.addStatement(new JsVars((List<JsVars.JsVar>)prevVars, x.isMultiline()));
                prevVars = new SmartList();
            }
            jsVar.setInitExpression((JsExpression)this.accept((JsNode)jsVar.getInitExpression()));
            prevVars.add(jsVar);
        }
        vars.clear();
        vars.addAll((Collection<JsVars.JsVar>)prevVars);
        return false;
    }

    @Override
    public boolean visit(@NotNull JsWhile x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        this.process(x, true);
        return false;
    }

    @Override
    public boolean visit(@NotNull JsDoWhile x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        this.process(x, false);
        return false;
    }

    private final void process(JsWhile $receiver, boolean addBreakToBegin) {
        if (this.containsExtractable.contains(AstUtilsKt.getTest($receiver)) ^ true) {
            return;
        }
        ExpressionDecomposer expressionDecomposer = this;
        List<JsStatement> backup = expressionDecomposer.additionalStatements;
        expressionDecomposer.additionalStatements = new SmartList();
        JsNode jsNode = this.accept((JsNode)AstUtilsKt.getTest($receiver));
        Intrinsics.checkExpressionValueIsNotNull(jsNode, "accept(test)");
        AstUtilsKt.setTest($receiver, (JsExpression)jsNode);
        JsIf breakIfNotTest = new JsIf(JsAstUtils.not(AstUtilsKt.getTest($receiver)), new JsBreak());
        List<JsStatement> bodyStatements = JsAstUtils.flattenStatement($receiver.getBody());
        if (addBreakToBegin) {
            this.addStatement(breakIfNotTest);
            List<JsStatement> list = bodyStatements;
            Intrinsics.checkExpressionValueIsNotNull(list, "bodyStatements");
            this.addStatements(list);
        } else {
            List<JsStatement> list = bodyStatements;
            Intrinsics.checkExpressionValueIsNotNull(list, "bodyStatements");
            this.addStatements(0, list);
            this.addStatement(breakIfNotTest);
        }
        $receiver.setBody(ExpressionDecomposerKt.access$toStatement(this.additionalStatements));
        JsLiteral.JsBooleanLiteral jsBooleanLiteral = JsLiteral.TRUE;
        Intrinsics.checkExpressionValueIsNotNull(jsBooleanLiteral, "JsLiteral.TRUE");
        AstUtilsKt.setTest($receiver, (JsExpression)jsBooleanLiteral);
        Unit result2 = Unit.INSTANCE;
        expressionDecomposer.additionalStatements = backup;
    }

    @Override
    public boolean visit(@NotNull JsBinaryOperation x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        x.setArg1((JsExpression)this.accept((JsNode)x.getArg1()));
        switch (ExpressionDecomposer$WhenMappings.$EnumSwitchMapping$0[x.getOperator().ordinal()]) {
            case 1: 
            case 2: {
                this.processOrAnd(x, ctx);
                break;
            }
            default: {
                this.process(x);
            }
        }
        return false;
    }

    private final void processOrAnd(JsBinaryOperation $receiver, JsContext<?> ctx) {
        JsExpression jsExpression;
        if (this.containsExtractable.contains($receiver.getArg2()) ^ true) {
            return;
        }
        Temporary tmp = new Temporary(this, $receiver.getArg1());
        this.addStatement(tmp.getVariable());
        if (Intrinsics.areEqual($receiver.getOperator(), JsBinaryOperator.OR)) {
            JsExpression jsExpression2 = JsAstUtils.not(tmp.getNameRef());
            jsExpression = jsExpression2;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "not(tmp.nameRef)");
        } else {
            jsExpression = tmp.getNameRef();
        }
        JsExpression test = jsExpression;
        ExpressionDecomposer expressionDecomposer = this;
        List<JsStatement> backup = expressionDecomposer.additionalStatements;
        expressionDecomposer.additionalStatements = new SmartList();
        $receiver.setArg2((JsExpression)this.accept((JsNode)$receiver.getArg2()));
        JsExpression jsExpression3 = $receiver.getArg2();
        Intrinsics.checkExpressionValueIsNotNull(jsExpression3, "arg2");
        this.addStatement(tmp.assign(jsExpression3));
        JsStatement result2 = ExpressionDecomposerKt.access$toStatement(this.additionalStatements);
        expressionDecomposer.additionalStatements = backup;
        JsStatement arg2Eval = result2;
        this.addStatement(new JsIf(test, arg2Eval));
        ctx.replaceMe((JsNode)tmp.getNameRef());
    }

    private final void process(JsBinaryOperation $receiver) {
        if (this.containsNodeWithSideEffect.contains($receiver.getArg1()) ^ true || this.containsExtractable.contains($receiver.getArg2()) ^ true) {
            $receiver.setArg2((JsExpression)this.accept((JsNode)$receiver.getArg2()));
            return;
        }
        if ($receiver.getOperator().isAssignment()) {
            boolean value2 = $receiver.getArg1() instanceof JsNameRef;
            if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
                String message = "Valid JavaScript left-hand side must be JsNameRef, got: " + $receiver;
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            JsExpression jsExpression = $receiver.getArg1();
            if (jsExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsNameRef");
            }
            JsNameRef arg1AsRef = (JsNameRef)jsExpression;
            JsExpression jsExpression2 = arg1AsRef.getQualifier();
            if (jsExpression2 == null) {
                Intrinsics.throwNpe();
            }
            arg1AsRef.setQualifier(this.extractToTemporary(jsExpression2));
        } else {
            $receiver.setArg1(this.extractToTemporary($receiver.getArg1()));
        }
        $receiver.setArg2((JsExpression)this.accept((JsNode)$receiver.getArg2()));
    }

    @Override
    public boolean visit(@NotNull JsArrayLiteral x, @NotNull JsContext<?> ctx) {
        List<JsExpression> elements;
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        List<JsExpression> list = elements = x.getExpressions();
        Intrinsics.checkExpressionValueIsNotNull(list, "elements");
        this.processByIndices(list, this.getIndicesOfExtractable(elements));
        return false;
    }

    @Override
    public boolean visit(@NotNull JsArrayAccess x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        this.process(x);
        return false;
    }

    private final void process(JsArrayAccess $receiver) {
        JsNode jsNode = this.accept((JsNode)AstUtilsKt.getArray($receiver));
        Intrinsics.checkExpressionValueIsNotNull(jsNode, "accept(array)");
        AstUtilsKt.setArray($receiver, (JsExpression)jsNode);
        if (this.containsNodeWithSideEffect.contains(AstUtilsKt.getArray($receiver)) && this.containsExtractable.contains(AstUtilsKt.getIndex($receiver))) {
            AstUtilsKt.setArray($receiver, this.extractToTemporary(AstUtilsKt.getArray($receiver)));
        }
        JsNode jsNode2 = this.accept((JsNode)AstUtilsKt.getIndex($receiver));
        Intrinsics.checkExpressionValueIsNotNull(jsNode2, "accept(index)");
        AstUtilsKt.setIndex($receiver, (JsExpression)jsNode2);
    }

    @Override
    public boolean visit(@NotNull JsConditional x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        this.process(x, ctx);
        return false;
    }

    private final void process(JsConditional $receiver, JsContext<?> ctx) {
        JsNode jsNode = this.accept((JsNode)AstUtilsKt.getTest($receiver));
        Intrinsics.checkExpressionValueIsNotNull(jsNode, "accept(test)");
        AstUtilsKt.setTest($receiver, (JsExpression)jsNode);
        if (this.containsExtractable.contains(AstUtilsKt.getThen($receiver)) ^ true && this.containsExtractable.contains(AstUtilsKt.getOtherwise($receiver)) ^ true) {
            return;
        }
        Temporary tmp = new Temporary(this, null, 1, null);
        this.addStatement(tmp.getVariable());
        ExpressionDecomposer expressionDecomposer = this;
        Object backup = expressionDecomposer.additionalStatements;
        expressionDecomposer.additionalStatements = new SmartList();
        JsNode jsNode2 = this.accept((JsNode)AstUtilsKt.getThen($receiver));
        Intrinsics.checkExpressionValueIsNotNull(jsNode2, "accept(then)");
        AstUtilsKt.setThen($receiver, (JsExpression)jsNode2);
        this.addStatement(tmp.assign(AstUtilsKt.getThen($receiver)));
        JsStatement result2 = ExpressionDecomposerKt.access$toStatement(this.additionalStatements);
        expressionDecomposer.additionalStatements = backup;
        JsStatement thenBlock = result2;
        backup = this;
        List<JsStatement> backup2 = ((ExpressionDecomposer)backup).additionalStatements;
        ((ExpressionDecomposer)backup).additionalStatements = new SmartList();
        JsNode jsNode3 = this.accept((JsNode)AstUtilsKt.getOtherwise($receiver));
        Intrinsics.checkExpressionValueIsNotNull(jsNode3, "accept(otherwise)");
        AstUtilsKt.setOtherwise($receiver, (JsExpression)jsNode3);
        this.addStatement(tmp.assign(AstUtilsKt.getOtherwise($receiver)));
        JsStatement result3 = ExpressionDecomposerKt.access$toStatement(this.additionalStatements);
        ((ExpressionDecomposer)backup).additionalStatements = backup2;
        JsStatement elseBlock = result3;
        JsIf lazyEval = new JsIf(AstUtilsKt.getTest($receiver), thenBlock, elseBlock);
        this.addStatement(lazyEval);
        ctx.replaceMe((JsNode)tmp.getNameRef());
    }

    @Override
    public boolean visit(@NotNull JsInvocation x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        this.process(new CallableInvocationAdapter(x));
        return false;
    }

    @Override
    public boolean visit(@NotNull JsNew x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        this.process(new CallableNewAdapter(x));
        return false;
    }

    private final void process(Callable $receiver) {
        JsNode jsNode = this.accept((JsNode)$receiver.getQualifier());
        Intrinsics.checkExpressionValueIsNotNull(jsNode, "accept(qualifier)");
        $receiver.setQualifier((JsExpression)jsNode);
        Iterator<Integer> matchedIndices = this.getIndicesOfExtractable($receiver.getArguments());
        if (!matchedIndices.hasNext()) {
            return;
        }
        if (this.containsNodeWithSideEffect.contains($receiver.getQualifier())) {
            JsExpression receiver;
            JsNameRef callee;
            JsExpression jsExpression = $receiver.getQualifier();
            if (!(jsExpression instanceof JsNameRef)) {
                jsExpression = null;
            }
            JsNameRef jsNameRef = callee = (JsNameRef)jsExpression;
            JsExpression jsExpression2 = receiver = jsNameRef != null ? jsNameRef.getQualifier() : null;
            if (callee != null && receiver != null && this.containsNodeWithSideEffect.contains(receiver)) {
                JsExpression receiverTmp = this.extractToTemporary(receiver);
                callee.setQualifier(receiverTmp);
            } else {
                $receiver.setQualifier(this.extractToTemporary($receiver.getQualifier()));
            }
        }
        List<JsExpression> list = $receiver.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list, "arguments");
        this.processByIndices(list, matchedIndices);
    }

    /*
     * WARNING - void declaration
     */
    private final void processByIndices(List<JsExpression> elements, Iterator<? extends Integer> matchedIndices) {
        int prev = 0;
        while (matchedIndices.hasNext()) {
            int n = prev;
            int curr = ((Number)matchedIndices.next()).intValue();
            int n2 = curr - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    JsExpression arg;
                    if (!(this.containsNodeWithSideEffect.contains(arg = elements.get((int)i)) ^ true)) {
                        elements.set((int)i, this.extractToTemporary(arg));
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            JsNode jsNode = this.accept((JsNode)elements.get(curr));
            Intrinsics.checkExpressionValueIsNotNull(jsNode, "accept(elements[curr])");
            elements.set(curr, (JsExpression)jsNode);
            prev = curr;
        }
    }

    private final boolean addStatement(JsStatement statement) {
        return this.additionalStatements.add(statement);
    }

    private final boolean addStatements(List<? extends JsStatement> statements) {
        return this.additionalStatements.addAll((Collection<JsStatement>)statements);
    }

    private final boolean addStatements(int index2, List<? extends JsStatement> statements) {
        return this.additionalStatements.addAll(index2, (Collection<JsStatement>)statements);
    }

    private final JsExpression extractToTemporary(JsExpression $receiver) {
        Temporary tmp = new Temporary(this, $receiver);
        this.addStatement(tmp.getVariable());
        return tmp.getNameRef();
    }

    /*
     * WARNING - void declaration
     */
    private final Iterator<Integer> getIndicesOfExtractable(List<? extends JsNode> $receiver) {
        void destination;
        void $receiver2;
        Iterable $receiver3 = CollectionsKt.getIndices((Collection)$receiver);
        Iterable iterable = $receiver3;
        Collection collection = new ArrayList();
        for (Object element : $receiver2) {
            int it2 = ((Number)element).intValue();
            if (!this.containsExtractable.contains($receiver.get(it2))) continue;
            destination.add(element);
        }
        return ((List)destination).iterator();
    }

    private ExpressionDecomposer(JsScope scope2, Set<? extends JsNode> containsExtractable, Set<? extends JsNode> containsNodeWithSideEffect) {
        this.scope = scope2;
        this.containsExtractable = containsExtractable;
        this.containsNodeWithSideEffect = containsNodeWithSideEffect;
        this.additionalStatements = new SmartList();
    }

    public /* synthetic */ ExpressionDecomposer(@NotNull JsScope scope2, @NotNull Set<? extends JsNode> containsExtractable, @NotNull Set<? extends JsNode> containsNodeWithSideEffect, DefaultConstructorMarker $constructor_marker) {
        this(scope2, containsExtractable, containsNodeWithSideEffect);
    }

    @JvmStatic
    @NotNull
    public static final List<JsStatement> preserveEvaluationOrder(@NotNull JsScope scope2, @NotNull JsStatement statement, @NotNull Function1<? super JsNode, ? extends Boolean> canBeExtractedByInliner) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(statement, "statement");
        Intrinsics.checkParameterIsNotNull(canBeExtractedByInliner, "canBeExtractedByInliner");
        return org.jetbrains.kotlin.js.inline.util.ExpressionDecomposer$Companion.INSTANCE.preserveEvaluationOrder(scope2, statement, canBeExtractedByInliner);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!\u0001R!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\t\f\u0011\u0019\u001d\u0001\u0004\u0001\u001a\u0003a\u0005\u0011u\u0001\u0003\u0002#\u000e\t\u0001\"A\u0013\u001a\t\u000fA\u0019!\u0004\u0003\n\u0005%\t\u0001T\u0001\r\u00033\rA1!D\u0001\u0019\be\u0019\u0001\u0002B\u0007\u00021\u000bI\u0012\u0002#\u0003\u000e\u000f%\u0011\u0011\"\u0001M\u0006\u0013\tI\u0011\u0001\u0007\u0004\u0019\u000b\u0001"}, strings={"Lorg/jetbrains/kotlin/js/inline/util/ExpressionDecomposer$Companion;", "", "()V", "preserveEvaluationOrder", "", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;", "scope", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope;", "statement", "canBeExtractedByInliner", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNode;", ""}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        @JvmStatic
        @NotNull
        public final List<JsStatement> preserveEvaluationOrder(@NotNull JsScope scope2, @NotNull JsStatement statement, @NotNull Function1<? super JsNode, ? extends Boolean> canBeExtractedByInliner) {
            Intrinsics.checkParameterIsNotNull(scope2, "scope");
            Intrinsics.checkParameterIsNotNull(statement, "statement");
            Intrinsics.checkParameterIsNotNull(canBeExtractedByInliner, "canBeExtractedByInliner");
            JsStatement $receiver = statement;
            Set<JsNode> extractable = ExpressionDecomposerKt.access$match($receiver, canBeExtractedByInliner);
            Set<JsNode> containsExtractable = ExpressionDecomposerKt.access$withParentsOfNodes($receiver, extractable);
            Set<JsNode> nodesWithSideEffect2 = ExpressionDecomposerKt.access$match($receiver, preserveEvaluationOrder.decomposer.1.nodesWithSideEffect.1.INSTANCE);
            Set<JsNode> containsNodeWithSideEffect = ExpressionDecomposerKt.access$withParentsOfNodes($receiver, nodesWithSideEffect2);
            ExpressionDecomposer decomposer2 = new ExpressionDecomposer(scope2, containsExtractable, containsNodeWithSideEffect, null);
            decomposer2.accept((JsNode)statement);
            return decomposer2.additionalStatements;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011C)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002E\u0003\u0002\t\u000f!\u0011\u0003\u0004\u0001\u001a\u0003a\u0005\u0011UB\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005A!!\u000b\u000f\u0005\u0007\"A)!D\n\n\r%)\u0001\u0003B\u000b\u0003\u0019\u0003A:\u0001g\u0002\u0011\tUI\u0011BB\u0005\u0006!\u0011)\"\u0001$\u0001\u0019\ba\u001dA\u0012\u0001M\u00051\r\t6\u0001B\u0003\u0001\u001b\t!Q\u0001c\u0003*\u0019\u0011\u0019F\u0004\u0003\u0004\u000e\u0003a\u001d\u0011k\u0001\u0004\u000e\u0005\u00115\u0001bB\t\u0003\t\u001fA\u0001\u0002"}, strings={"Lorg/jetbrains/kotlin/js/inline/util/ExpressionDecomposer$Callable;", "", "hasArguments", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/HasArguments;", "(Lcom/google/dart/compiler/backend/js/ast/HasArguments;)V", "arguments", "", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "kotlin.jvm.PlatformType", "", "getArguments", "()Ljava/util/List;", "qualifier", "getQualifier", "()Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "setQualifier", "(Lcom/google/dart/compiler/backend/js/ast/JsExpression;)V"}, moduleName="kotlin-compiler")
    private static abstract class Callable {
        private final List<JsExpression> arguments;

        @NotNull
        public abstract JsExpression getQualifier();

        public abstract void setQualifier(@NotNull JsExpression var1);

        public final List<JsExpression> getArguments() {
            return this.arguments;
        }

        public Callable(@NotNull HasArguments hasArguments) {
            Intrinsics.checkParameterIsNotNull(hasArguments, "hasArguments");
            this.arguments = hasArguments.getArguments();
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001b\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001\"\u0002\u0005\u00031\u0001\u0011$\u0001M\u0001C\u001bI1\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005%RAa\u0011\u0005\t\u00035\t\u00014A)\u0004\t\u0015\u0001QB\u0001C\u0003\u0011\rI#\u0003B&\u001d\u0011\u0013i\u0011\u0001\u0007\u0003\u001a\u0007!\u001dQ\"\u0001\r\u00059-\u00023&U\u0002\u0007\u001b\t!Q\u0001c\u0003\u0012\u0005\u00111\u0001R\u0002"}, strings={"Lorg/jetbrains/kotlin/js/inline/util/ExpressionDecomposer$CallableInvocationAdapter;", "Lorg/jetbrains/kotlin/js/inline/util/ExpressionDecomposer$Callable;", "invocation", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsInvocation;", "(Lcom/google/dart/compiler/backend/js/ast/JsInvocation;)V", "getInvocation", "()Lcom/google/dart/compiler/backend/js/ast/JsInvocation;", "value", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "qualifier", "getQualifier", "()Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "setQualifier", "(Lcom/google/dart/compiler/backend/js/ast/JsExpression;)V"}, moduleName="kotlin-compiler")
    private static final class CallableInvocationAdapter
    extends Callable {
        @NotNull
        private final JsInvocation invocation;

        @Override
        @NotNull
        public JsExpression getQualifier() {
            JsExpression jsExpression = this.invocation.getQualifier();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "invocation.getQualifier()");
            return jsExpression;
        }

        @Override
        public void setQualifier(@NotNull JsExpression value2) {
            Intrinsics.checkParameterIsNotNull(value2, "value");
            this.invocation.setQualifier(value2);
        }

        @NotNull
        public final JsInvocation getInvocation() {
            return this.invocation;
        }

        public CallableInvocationAdapter(@NotNull JsInvocation invocation) {
            Intrinsics.checkParameterIsNotNull(invocation, "invocation");
            super(invocation);
            this.invocation = invocation;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001b\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001\"\u0002\u0005\u00031\u0001\u0011$\u0001M\u0001C\u001bI1\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005%RAa\u0011\u0005\t\u00035\t\u00014A)\u0004\t\u0015\u0001QB\u0001C\u0003\u0011\rI#\u0003B&\u001d\u0011\u0013i\u0011\u0001\u0007\u0003\u001a\u0007!\u001dQ\"\u0001\r\u00059-\u00023&U\u0002\u0007\u001b\t!Q\u0001c\u0003\u0012\u0005\u00111\u0001R\u0002"}, strings={"Lorg/jetbrains/kotlin/js/inline/util/ExpressionDecomposer$CallableNewAdapter;", "Lorg/jetbrains/kotlin/js/inline/util/ExpressionDecomposer$Callable;", "jsnew", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNew;", "(Lcom/google/dart/compiler/backend/js/ast/JsNew;)V", "getJsnew", "()Lcom/google/dart/compiler/backend/js/ast/JsNew;", "value", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "qualifier", "getQualifier", "()Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "setQualifier", "(Lcom/google/dart/compiler/backend/js/ast/JsExpression;)V"}, moduleName="kotlin-compiler")
    private static final class CallableNewAdapter
    extends Callable {
        @NotNull
        private final JsNew jsnew;

        @Override
        @NotNull
        public JsExpression getQualifier() {
            JsExpression jsExpression = this.jsnew.getConstructorExpression();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "jsnew.getConstructorExpression()");
            return jsExpression;
        }

        @Override
        public void setQualifier(@NotNull JsExpression value2) {
            Intrinsics.checkParameterIsNotNull(value2, "value");
            this.jsnew.setConstructorExpression(value2);
        }

        @NotNull
        public final JsNew getJsnew() {
            return this.jsnew;
        }

        public CallableNewAdapter(@NotNull JsNew jsnew) {
            Intrinsics.checkParameterIsNotNull(jsnew, "jsnew");
            super(jsnew);
            this.jsnew = jsnew;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0002\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011\u0001B!\u0003\u0019\u0001I\u0012\u0001'\u0001\"\u0015%5A!\u0001\u0005\u0002\u001b\ta\t\u0001g\u0001Q\u0007\u0003\t6!\u0001\u0005\u0003K\u001dA\t\"D\u0001\u0019\u0013e\u0019\u0001\"A\u0007\u00021\u0007I#\u0002B\"\t\u0011\u000bi\u0011\u0001G\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\b!!\u0011F\u0003\u0003D\u0011!%Q\"\u0001M\u00029\r\n6aA\u0007\u0003\t\u0015AY!K\u0006\u0005\u0007\"A\u0011!\u0004\u0002\r\u0002a\r\u0011k\u0001\u0003\u0006\u00015\u0011AA\u0002E\u0006S)!1\t\u0003E\u0007\u001b\u0005Ar!U\u0002\u0005\u000b\u0001i!\u0001b\u0004\t\u0011\u0001"}, strings={"Lorg/jetbrains/kotlin/js/inline/util/ExpressionDecomposer$Temporary;", "", "value", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "(Lorg/jetbrains/kotlin/js/inline/util/ExpressionDecomposer;Lcom/google/dart/compiler/backend/js/ast/JsExpression;)V", "name", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "getName", "()Lcom/google/dart/compiler/backend/js/ast/JsName;", "nameRef", "getNameRef", "()Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "getValue", "variable", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsVars;", "getVariable", "()Lcom/google/dart/compiler/backend/js/ast/JsVars;", "assign", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;"}, moduleName="kotlin-compiler")
    private final class Temporary {
        @NotNull
        private final JsName name;
        @NotNull
        private final JsVars variable;
        @Nullable
        private final JsExpression value;
        final /* synthetic */ ExpressionDecomposer this$0;

        @NotNull
        public final JsName getName() {
            return this.name;
        }

        @NotNull
        public final JsVars getVariable() {
            return this.variable;
        }

        @NotNull
        public final JsExpression getNameRef() {
            JsExpression jsExpression = this.name.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "name.makeRef()");
            return jsExpression;
        }

        @NotNull
        public final JsStatement assign(@NotNull JsExpression value2) {
            Intrinsics.checkParameterIsNotNull(value2, "value");
            JsStatement jsStatement = JsAstUtils.assignment(this.getNameRef(), value2).makeStmt();
            Intrinsics.checkExpressionValueIsNotNull(jsStatement, "assignment(nameRef, value).makeStmt()");
            return jsStatement;
        }

        @Nullable
        public final JsExpression getValue() {
            return this.value;
        }

        public Temporary(ExpressionDecomposer $outer, @Nullable JsExpression value2) {
            this.this$0 = $outer;
            this.value = value2;
            JsName jsName = $outer.scope.declareTemporary();
            Intrinsics.checkExpressionValueIsNotNull(jsName, "scope.declareTemporary()");
            this.name = jsName;
            JsVars jsVars = JsAstUtils.newVar(this.name, this.value);
            Intrinsics.checkExpressionValueIsNotNull(jsVars, "newVar(name, value)");
            this.variable = jsVars;
        }

        public /* synthetic */ Temporary(ExpressionDecomposer expressionDecomposer, JsExpression jsExpression, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                jsExpression = null;
            }
            this(expressionDecomposer, jsExpression);
        }
    }
}

