/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.incremental.components.ScopeKind;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.KtScope;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Qb\u0006\u0005\u0001\u001b\u0005A\n!F\u0001\u0019\u0003e%\u00012A\u0007\u00021\t\u00016\u0011AM\u0005\u0011\u000bi\u0011\u0001G\u0002Q\u0007\u0005IJ\u0001c\u0002\u000e\u0003a!\u0001ka\u0001U\u0007\u0013\u0001"}, strings={"record", "", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "from", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "inScope", "Lorg/jetbrains/kotlin/resolve/scopes/KtScope;", "name", "Lorg/jetbrains/kotlin/name/Name;", "UtilsKt"}, moduleName="kotlin-compiler")
public final class UtilsKt {
    public static final void record(LookupTracker $receiver, @NotNull LookupLocation from, @NotNull KtScope inScope, @NotNull Name name) {
        ScopeKind scopeKind;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(inScope, "inScope");
        Intrinsics.checkParameterIsNotNull(name, "name");
        if (Intrinsics.areEqual($receiver, LookupTracker.Companion.INSTANCE.getDO_NOTHING()) || from instanceof NoLookupLocation) {
            return;
        }
        if (!(from instanceof KotlinLookupLocation)) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected location type: " + from.getClass())));
        }
        KtFile containingJetFile = ((KotlinLookupLocation)from).getElement().getContainingJetFile();
        if (KtPsiFactoryKt.getDoNotAnalyze(containingJetFile) != null) {
            return;
        }
        String containingFilePath = containingJetFile.getVirtualFile().getPath();
        DiagnosticUtils.LineAndColumn lineAndColumn = $receiver.getRequiresLookupLineAndColumn() ? DiagnosticUtils.getLineAndColumnInPsiFile(containingJetFile, ((KotlinLookupLocation)from).getElement().getTextRange()) : (DiagnosticUtils.LineAndColumn)null;
        DeclarationDescriptor scopeContainingDeclaration = inScope.getContainingDeclaration();
        DeclarationDescriptor declarationDescriptor = scopeContainingDeclaration;
        if (declarationDescriptor instanceof ClassifierDescriptor) {
            scopeKind = ScopeKind.CLASSIFIER;
        } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            scopeKind = ScopeKind.PACKAGE;
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected containing declaration type: " + scopeContainingDeclaration.getClass())));
        }
        ScopeKind scopeKind2 = scopeKind;
        String string = containingFilePath;
        Intrinsics.checkExpressionValueIsNotNull(string, "containingFilePath");
        DiagnosticUtils.LineAndColumn lineAndColumn2 = lineAndColumn;
        Integer n = lineAndColumn2 != null ? Integer.valueOf(lineAndColumn2.getLine()) : null;
        DiagnosticUtils.LineAndColumn lineAndColumn3 = lineAndColumn;
        Integer n2 = lineAndColumn3 != null ? Integer.valueOf(lineAndColumn3.getColumn()) : null;
        String string2 = DescriptorUtilsKt.getFqNameUnsafe(scopeContainingDeclaration).asString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "scopeContainingDeclaration.fqNameUnsafe.asString()");
        String string3 = name.asString();
        Intrinsics.checkExpressionValueIsNotNull(string3, "name.asString()");
        $receiver.record(string, n, n2, string2, scopeKind2, string3);
    }
}

