/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.io.File;
import kotlin.io.FilesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.PlainTextMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.XmlMessageRenderer;

public interface MessageRenderer {
    public static final MessageRenderer XML = new XmlMessageRenderer();
    public static final MessageRenderer WITHOUT_PATHS = new PlainTextMessageRenderer(){

        @Override
        @Nullable
        protected String getPath(@NotNull CompilerMessageLocation location) {
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$1", "getPath"));
            }
            return null;
        }
    };
    public static final MessageRenderer PLAIN_FULL_PATHS = new PlainTextMessageRenderer(){

        @Override
        @Nullable
        protected String getPath(@NotNull CompilerMessageLocation location) {
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$2", "getPath"));
            }
            return location.getPath();
        }
    };
    public static final MessageRenderer PLAIN_RELATIVE_PATHS = new PlainTextMessageRenderer(){
        private final File cwd = new File(".").getAbsoluteFile();

        @Override
        @Nullable
        protected String getPath(@NotNull CompilerMessageLocation location) {
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$3", "getPath"));
            }
            String path = location.getPath();
            return this.cwd == null || path == null ? path : FilesKt.relativePath(this.cwd, new File(path));
        }
    };

    public String renderPreamble();

    public String render(@NotNull CompilerMessageSeverity var1, @NotNull String var2, @NotNull CompilerMessageLocation var3);

    public String renderConclusion();
}

