/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.HashSet;
import kotlin.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypesKt;
import kotlin.reflect.jvm.internal.impl.types.Dynamicity;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeDelegation;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.NullAwareness;
import kotlin.reflect.jvm.internal.impl.types.Specificity;
import kotlin.reflect.jvm.internal.impl.types.TypeCapability;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DynamicTypeCapabilities
implements FlexibleTypeCapabilities {
    public static final DynamicTypeCapabilities INSTANCE;
    public static final DynamicTypeCapabilities INSTANCE$;

    @Override
    @NotNull
    public String getId() {
        return "kotlin.DynamicType";
    }

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass, @NotNull KotlinType jetType, @NotNull Flexibility flexibility) {
        Intrinsics.checkParameterIsNotNull(capabilityClass, "capabilityClass");
        Intrinsics.checkParameterIsNotNull(jetType, "jetType");
        Intrinsics.checkParameterIsNotNull(flexibility, "flexibility");
        return (T)(Impl.Companion.INSTANCE.getCapabilityClasses$kotlin_core().contains(capabilityClass) ? (TypeCapability)new Impl(flexibility) : (TypeCapability)null);
    }

    static {
        new DynamicTypeCapabilities();
    }

    private DynamicTypeCapabilities() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    private static final class Impl
    implements Dynamicity,
    Specificity,
    NullAwareness,
    FlexibleTypeDelegation {
        @NotNull
        public static final HashSet<Class<? extends TypeCapability>> capabilityClasses;
        @NotNull
        private final KotlinType delegateType;
        public static final Companion Companion;

        static {
            Companion = Companion.INSTANCE;
            capabilityClasses = SetsKt.hashSetOf(Dynamicity.class, Specificity.class, NullAwareness.class, FlexibleTypeDelegation.class);
        }

        @Override
        @NotNull
        public KotlinType getDelegateType() {
            return this.delegateType;
        }

        @Override
        @NotNull
        public Specificity.Relation getSpecificityRelationTo(@NotNull KotlinType otherType) {
            Intrinsics.checkParameterIsNotNull(otherType, "otherType");
            return !DynamicTypesKt.isDynamic(otherType) ? Specificity.Relation.LESS_SPECIFIC : Specificity.Relation.DONT_KNOW;
        }

        @Override
        @NotNull
        public KotlinType makeNullableAsSpecified(boolean nullable2) {
            return DynamicTypesKt.createDynamicType(TypeUtilsKt.getBuiltIns(this.getDelegateType()));
        }

        @Override
        public boolean computeIsNullable() {
            return false;
        }

        public Impl(@NotNull Flexibility flexibility) {
            Intrinsics.checkParameterIsNotNull(flexibility, "flexibility");
            this.delegateType = flexibility.getUpperBound();
        }

        public static final class Companion {
            public static final Companion INSTANCE;

            @NotNull
            public final HashSet<Class<? extends TypeCapability>> getCapabilityClasses$kotlin_core() {
                return capabilityClasses;
            }

            static {
                new Companion();
            }

            private Companion() {
                INSTANCE = this;
            }
        }
    }
}

