/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiForStatementImpl
extends CompositePsiElement
implements PsiForStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiForStatementImpl");

    public PsiForStatementImpl() {
        super(FOR_STATEMENT);
    }

    @Override
    public PsiStatement getInitialization() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(39);
    }

    @Override
    public PsiExpression getCondition() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(32);
    }

    @Override
    public PsiStatement getUpdate() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(40);
    }

    @Override
    public PsiStatement getBody() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(38);
    }

    @Override
    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
    }

    @Override
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        ASTNode rparenth;
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 37: {
                return this.findChildByType(FOR_KEYWORD);
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 39: {
                ASTNode paren;
                ASTNode initialization = PsiImplUtil.findStatementChild(this);
                for (ASTNode child = paren = this.findChildByRole(24); child != null; child = child.getTreeNext()) {
                    if (child == initialization) {
                        return initialization;
                    }
                    if (child.getElementType() != RPARENTH) continue;
                    return null;
                }
                return null;
            }
            case 32: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 41: {
                return this.findChildByType(SEMICOLON);
            }
            case 40: {
                ASTNode semicolon;
                for (ASTNode child = semicolon = this.findChildByRole(41); child != null; child = child.getTreeNext()) {
                    if (child.getPsi() instanceof PsiStatement) {
                        return child;
                    }
                    if (child.getElementType() == RPARENTH) break;
                }
                return null;
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 38: 
        }
        for (ASTNode child = rparenth = this.findChildByRole(25); child != null; child = child.getTreeNext()) {
            if (!(child.getPsi() instanceof PsiStatement)) continue;
            return child;
        }
        return null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == FOR_KEYWORD) {
            return 37;
        }
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (i == SEMICOLON) {
            return 41;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 32;
        }
        if (child.getPsi() instanceof PsiStatement) {
            int role = this.getChildRole(child, 39);
            if (role != 0) {
                return role;
            }
            role = this.getChildRole(child, 40);
            if (role != 0) {
                return role;
            }
            return 38;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiForStatementImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitForStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiForStatement";
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        boolean isForInitialization;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/java/PsiForStatementImpl", "deleteChildInternal"));
        }
        boolean bl = isForInitialization = this.getChildRole(child) == 39;
        if (isForInitialization) {
            try {
                PsiStatement emptyStatement = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createStatementFromText(";", null);
                super.replaceChildInternal(child, (TreeElement)SourceTreeToPsiMap.psiElementToTree(emptyStatement));
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        } else {
            super.deleteChildInternal(child);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/tree/java/PsiForStatementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/tree/java/PsiForStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/tree/java/PsiForStatementImpl", "processDeclarations"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        if (lastParent == null || lastParent.getParent() != this) {
            return true;
        }
        return PsiScopesUtil.walkChildrenScopes(this, processor, state, lastParent, place);
    }
}

