/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CoroutineSuspendCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "ALLOWED_SCOPE_KINDS", "", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class CoroutineSuspendCallChecker
implements CallChecker {
    private static final Set<LexicalScopeKind> ALLOWED_SCOPE_KINDS;
    public static final CoroutineSuspendCallChecker INSTANCE;

    /*
     * Unable to fully structure code
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        block26: {
            Intrinsics.checkParameterIsNotNull(resolvedCall, (String)"resolvedCall");
            Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            var5_5 = descriptor = resolvedCall.getCandidateDescriptor();
            if (var5_5 instanceof FunctionDescriptor) {
                if (!((FunctionDescriptor)descriptor).isSuspend()) {
                    return;
                }
            } else if (var5_5 instanceof PropertyDescriptor) {
                var6_6 /* !! */  = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)descriptor);
                if (!(Intrinsics.areEqual(var6_6 /* !! */ , (Object)CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_1_2_20_FQ_NAME()) || Intrinsics.areEqual(var6_6 /* !! */ , (Object)CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_1_2_30_FQ_NAME()) || Intrinsics.areEqual(var6_6 /* !! */ , (Object)CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_1_3_FQ_NAME()))) {
                    return;
                }
            } else {
                return;
            }
            var6_6 /* !! */  = ScopeUtilsKt.getParentsWithSelf(context.getScope());
            var7_7 = $receiver$iv.iterator();
            while (var7_7.hasNext()) {
                element$iv = var7_7.next();
                it = (HierarchicalScope)element$iv;
                if (!(it instanceof LexicalScope) || !CoroutineSuspendCallChecker.ALLOWED_SCOPE_KINDS.contains((Object)((LexicalScope)it).getKind())) ** GOTO lbl-1000
                $receiver$iv = ((LexicalScope)it).getOwnerDescriptor();
                v0 = $receiver$iv;
                if (!(v0 instanceof FunctionDescriptor)) {
                    v0 = null;
                }
                v1 = (FunctionDescriptor)v0;
                if (v1 == null) ** GOTO lbl-1000
                if (v1.isSuspend()) {
                    v2 = true;
                } else lbl-1000:
                // 3 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v3 = element$iv;
                break block26;
            }
            v3 = null;
        }
        if ((v4 = (HierarchicalScope)v3) == null) ** GOTO lbl-1000
        $receiver$iv = v4;
        v5 = $receiver$iv;
        if (v5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.LexicalScope");
        }
        v4 = (LexicalScope)v5;
        if (v4 != null && (v4 = v4.getOwnerDescriptor()) != null) {
            $receiver$iv = v4;
            v6 = $receiver$iv;
            if (v6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            v7 = (FunctionDescriptor)v6;
        } else lbl-1000:
        // 2 sources

        {
            v7 = enclosingSuspendFunction = null;
        }
        if (enclosingSuspendFunction != null) {
            v8 = resolvedCall.getCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"resolvedCall.call");
            v9 = v8.getCallElement();
            if (v9 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            callElement = (KtExpression)v9;
            if (!InlineUtil.checkNonLocalReturnUsage(enclosingSuspendFunction, callElement, context.getResolutionContext())) {
                context.getTrace().report(Errors.NON_LOCAL_SUSPENSION_POINT.on(reportOn));
            } else {
                block27: {
                    $receiver$iv = ScopeUtilsKt.getParentsWithSelf(context.getScope());
                    for (E element$iv : $receiver$iv) {
                        it = (HierarchicalScope)element$iv;
                        if (!CoroutineCallCheckerKt.access$isScopeForDefaultParameterValuesOf(it, enclosingSuspendFunction)) continue;
                        v10 = true;
                        break block27;
                    }
                    v10 = false;
                }
                if (v10) {
                    context.getTrace().report(Errors.UNSUPPORTED.on(reportOn, "suspend function calls in a context of default parameter value"));
                }
            }
            if ((Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)descriptor), (Object)CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_1_2_20_FQ_NAME()) || Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)descriptor), (Object)CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_1_2_30_FQ_NAME())) && context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ReleaseCoroutines)) {
                context.getTrace().report(Errors.UNSUPPORTED.on(reportOn, "experimental coroutineContext of release coroutine: use kotlin.coroutines.coroutineContext instead"));
            }
            context.getTrace().record(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall.getCall(), enclosingSuspendFunction);
            CoroutineCallCheckerKt.access$checkRestrictsSuspension(enclosingSuspendFunction, resolvedCall, reportOn, context);
        } else {
            v11 = resolvedCall.getCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"resolvedCall.call");
            if (!CallUtilKt.isCallableReference(v11)) {
                var6_6 /* !! */  = descriptor;
                if (var6_6 /* !! */  instanceof FunctionDescriptor) {
                    context.getTrace().report(Errors.ILLEGAL_SUSPEND_FUNCTION_CALL.on(reportOn, (CallableDescriptor)resolvedCall.getCandidateDescriptor()));
                } else if (var6_6 /* !! */  instanceof PropertyDescriptor) {
                    context.getTrace().report(Errors.ILLEGAL_SUSPEND_PROPERTY_ACCESS.on(reportOn, (CallableDescriptor)resolvedCall.getCandidateDescriptor()));
                }
            }
        }
    }

    private CoroutineSuspendCallChecker() {
    }

    static {
        CoroutineSuspendCallChecker coroutineSuspendCallChecker;
        INSTANCE = coroutineSuspendCallChecker = new CoroutineSuspendCallChecker();
        ALLOWED_SCOPE_KINDS = SetsKt.setOf((Object[])new LexicalScopeKind[]{LexicalScopeKind.FUNCTION_INNER_SCOPE, LexicalScopeKind.FUNCTION_HEADER_FOR_DESTRUCTURING});
    }
}

